/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.rdbms.security;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.Vector;
import oracle.aurora.rdbms.security.FilteredCacheRowsIterator;
import oracle.aurora.rdbms.security.PolicyTable;
import oracle.aurora.rdbms.security.PolicyTableManager;
import oracle.aurora.rdbms.security.PolicyTableRow;
import oracle.aurora.rdbms.security.RowInCache;
import oracle.aurora.rdbms.security.SchemaComparator;
import oracle.aurora.rdbms.security.SchemaInCache;
import oracle.aurora.vm.IdNotFoundException;

class RowCache {
    private SchemaInCache[] schemas;
    private static final Comparator comparator = new SchemaComparator();
    private static final RowInCache[] noRows = new RowInCache[0];

    public RowCache(Iterator rows) {
        SortedMap schemaMap = this.buildMap(rows);
        this.schemas = this.buildArray(schemaMap);
    }

    public Iterator rows(long number) {
        int xSchema = Arrays.binarySearch(this.schemas, new Long(number), comparator);
        RowInCache[] rArray = xSchema >= 0 ? this.schemas[xSchema].rows : noRows;
        return Arrays.asList(rArray).iterator();
    }

    public Iterator rows(long number, Class permissionClass) {
        return new FilteredCacheRowsIterator(this.rows(number), number, permissionClass);
    }

    SortedMap buildMap(Iterator rows) {
        TreeMap<Long, Vector<RowInCache>> schemaMap = new TreeMap<Long, Vector<RowInCache>>(comparator);
        while (rows.hasNext()) {
            PolicyTableRow row = (PolicyTableRow)rows.next();
            if (row.status == 3) continue;
            Long schema = new Long(row.schema);
            Vector<RowInCache> rowV = (Vector<RowInCache>)schemaMap.get(schema);
            if (rowV == null) {
                rowV = new Vector<RowInCache>();
                schemaMap.put(schema, rowV);
            }
            try {
                rowV.add(new RowInCache(row));
            }
            catch (ClassNotFoundException ignore) {
            }
            catch (IdNotFoundException ignore) {}
        }
        return schemaMap;
    }

    SchemaInCache[] buildArray(SortedMap schemaMap) {
        int nSchema = schemaMap.size();
        SchemaInCache[] array = new SchemaInCache[nSchema];
        Iterator schemas = schemaMap.keySet().iterator();
        for (int xSchema = 0; xSchema < nSchema; ++xSchema) {
            Long sNumber = (Long)schemas.next();
            Vector rowV = (Vector)schemaMap.get(sNumber);
            SchemaInCache sInCache = new SchemaInCache();
            sInCache.schemaNumber = sNumber;
            sInCache.rows = new RowInCache[rowV.size()];
            sInCache.rows = rowV.toArray(sInCache.rows);
            array[xSchema] = sInCache;
        }
        return array;
    }

    String toMultiLineString(String prefix) {
        StringBuffer buf = new StringBuffer();
        for (int xSchema = 0; xSchema < this.schemas.length; ++xSchema) {
            buf.append(this.schemas[xSchema].toMultiLineString(prefix));
        }
        return buf.toString();
    }

    public static void main(String[] argv) {
        PolicyTable t = PolicyTableManager.getTable();
        RowCache c = new RowCache(t.allRows());
        System.out.println(c.toMultiLineString(""));
        Class<RuntimePermission> p = RuntimePermission.class;
        for (int x = 0; x < 30; ++x) {
            Iterator rows = c.rows(x, p);
            System.out.println();
            System.out.println("rows(" + x + ")");
            while (rows.hasNext()) {
                System.out.println("    " + (RowInCache)rows.next());
            }
        }
    }
}

