/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.rdbms;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Member;
import java.math.BigInteger;
import java.util.Hashtable;
import oracle.aurora.rdbms.ClassHandle;
import oracle.aurora.rdbms.DbmsJava;
import oracle.aurora.rdbms.DynamicSchema;
import oracle.aurora.rdbms.EditionHandle;
import oracle.aurora.rdbms.HandleHolder;
import oracle.aurora.rdbms.HandleInput;
import oracle.aurora.rdbms.InvalidResolverPatternException;
import oracle.aurora.rdbms.KGEException;
import oracle.aurora.rdbms.KeyHandle;
import oracle.aurora.rdbms.ModifyPermissionException;
import oracle.aurora.rdbms.ObjectDoesNotExistException;
import oracle.aurora.rdbms.ObjectInUseException;
import oracle.aurora.rdbms.ObjectTypeChangedException;
import oracle.aurora.rdbms.Resolver;
import oracle.aurora.rdbms.ResolverTerm;
import oracle.aurora.rdbms.ResolverWalker;
import oracle.aurora.rdbms.ResourceHandle;
import oracle.aurora.rdbms.Schema;
import oracle.aurora.rdbms.SchemaNotFoundException;
import oracle.aurora.rdbms.SecurityManagerImpl;
import oracle.aurora.rdbms.SharedDataHandle;
import oracle.aurora.rdbms.SourceHandle;
import oracle.aurora.rdbms.SynonymHandle;
import oracle.aurora.rdbms.url.jserver.JserverURLHandle;
import oracle.aurora.util.SeekableBufferedInputStream;
import oracle.aurora.vm.IUHandle;
import oracle.sql.CHAR;

public abstract class Handle
extends IUHandle
implements JserverURLHandle {
    public static final int SYNONYM = 5;
    public static final int NONEXISTENT = 10;
    public static final int SOURCE = 28;
    public static final int CLASS = 29;
    public static final int RESOURCE = 30;
    public static final int JAR = 31;
    public static final int SHARED_DATA = 56;
    public static final int EDITION = 57;
    public static final int STUB = 88;
    public static final int VALID = 1;
    public static final int UNAUTHORIZED = 4;
    public static final int INVALID = 5;
    protected static final int OPERATION_SUCCEEDED = 0;
    protected static final int OBJECT_ALREADY_EXISTS = 1;
    protected static final int OBJECT_WOULD_BE_REPLACED = 2;
    protected static final int PRIVILEGE_VIOLATION = 3;
    protected static final int OBJECT_IN_USE = 4;
    protected static final int OBJECT_DOES_NOT_EXIST = 5;
    protected static final int OBJECT_TYPE_CHANGED = 6;
    private static Hashtable byName = new Hashtable();
    private static KeyHandle key = new KeyHandle();
    protected String name;
    protected Schema schema;
    protected int objectNumber;
    protected byte[] timestamp;
    public static final int TIMESTAMP_SIZE = 7;
    protected byte[] data;
    private String pureName;
    public static final int DEFINERS = 1;
    public static final int BCD_SEGM = 2;
    public static final int ACC_SEGM = 4;
    public static final int ALLOW_NCOMP = 8;
    public static final int ENABLE_NCOMP = 16;
    public static final int FROM_CJSYS = 32;
    public static final int FROM_TCJSYS = 64;
    public static final int FIXED_IN_SESSION = 128;
    public static final int FIXED_IN_INSTANCE = 256;
    public static final int PREDIGESTED = 512;
    public static final int PDD_SEGM = 1024;
    public static final int UNLOADABLE = 2048;
    public static final int DOES_NOT_EXIST = 1;
    public static final int IN_USE = 2;
    public static final int INSUFFICIENT_PRIVILEGES = 4;

    protected Handle(String name_, Schema schema_, long index_, byte[] timestamp_) {
        this.name = name_;
        this.schema = schema_;
        this.index = index_;
        this.timestamp = timestamp_;
        this.objectNumber = -1;
        if (this.index != 0L) {
            Handle other;
            key.init(this.name, this.schema, this.type());
            while ((other = (Handle)byName.get(key)) != null) {
                if (other == this) {
                    byName.remove(other);
                    continue;
                }
                other.remove();
            }
            this.put();
        }
    }

    private static native long lookup(String[] var0, CHAR[] var1, int var2, boolean var3, String var4, byte[] var5) throws KGEException;

    public static Handle lookup(String name, Schema schema, int type, long index, boolean privCheck, byte[] timestamp) {
        Handle h = null;
        switch (type) {
            case 28: 
            case 29: {
                int jarSepPos = name.lastIndexOf("///");
                if (jarSepPos == -1) {
                    name = name.replace('.', '/');
                    break;
                }
                name = name.substring(0, jarSepPos + 3) + name.substring(jarSepPos + 3).replace('.', '/');
                break;
            }
            case 5: 
            case 30: 
            case 56: 
            case 57: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Bad type: " + type);
            }
        }
        if (index == 0L) {
            int ownerNumber;
            if (schema == null || schema instanceof DynamicSchema) {
                schema = Schema.currentSchema();
            }
            if ((ownerNumber = schema.ownerNumber()) < 0) {
                return null;
            }
            h = Handle.get(name, schema, type);
            if (h != null) {
                return h;
            }
            String[] nameHolder = new String[1];
            CHAR[] schemaHolder = new CHAR[1];
            nameHolder[0] = name;
            schemaHolder[0] = schema.name();
            timestamp = new byte[7];
            try {
                index = Handle.lookup(nameHolder, schemaHolder, type, privCheck, null, timestamp);
            }
            catch (KGEException e) {
                e.amendMessageAndRethrow(Handle.typeString(type) + " Handle.lookup of " + schema + "." + name);
            }
            if (index == 0L) {
                return null;
            }
            if (nameHolder[0] != name) {
                name = nameHolder[0];
            }
            if (schemaHolder[0] != schema.name() && (schema = Schema.lookup(schemaHolder[0])) == null) {
                throw new InternalError("translated Schema not found: " + schemaHolder[0]);
            }
        }
        switch (type) {
            case 28: {
                return new SourceHandle(name, schema, index, timestamp);
            }
            case 29: {
                return new ClassHandle(name, schema, index, timestamp);
            }
            case 30: {
                return new ResourceHandle(name, schema, index, timestamp);
            }
            case 5: {
                return new SynonymHandle(name, schema, index, timestamp);
            }
            case 56: {
                return new SharedDataHandle(name, schema, index, timestamp);
            }
            case 57: {
                return new EditionHandle(name, schema, index, timestamp);
            }
        }
        return null;
    }

    public static Handle lookup(String name, Schema schema, int type, long index, byte[] timestamp) {
        return Handle.lookup(name, schema, type, index, false, timestamp);
    }

    public static Handle lookup(String name, Schema schema, int type) {
        return Handle.lookup(name, schema, type, 0L, null);
    }

    public static Handle lookup(String name, Schema schema, int type, boolean privCheck) {
        return Handle.lookup(name, schema, type, 0L, privCheck, null);
    }

    public static Handle lookup(HandleHolder holder) {
        if (holder.index == 0L || holder.name == null) {
            return null;
        }
        Schema schema = Schema.lookupFixed(holder.schemaNumber);
        if (schema == null) {
            return null;
        }
        return Handle.lookup(holder.name, schema, holder.type, holder.index, holder.timestamp);
    }

    public static Handle lookup(String name, Resolver resolver, int type, boolean privCheck) {
        Schema schema;
        if (type == 57) {
            return Handle.lookup(name, Schema.systemSchema, type, privCheck);
        }
        ResolverWalker walker = new ResolverWalker(resolver, name);
        while ((schema = walker.next()) != null) {
            String jarPrefix = walker.jarPrefix();
            String lookupName = jarPrefix == null ? name : jarPrefix + name;
            Handle handle = Handle.lookup(lookupName, schema, type, privCheck);
            if (handle == null) continue;
            return handle;
        }
        return null;
    }

    public static Handle lookup(String name, Resolver resolver, int type) {
        return Handle.lookup(name, resolver, type, false);
    }

    public static Handle lookup(String name, int type) {
        return Handle.lookup(name, Resolver.defaultResolver(), type);
    }

    public static Handle lookup(String name, int type, boolean privCheck) {
        return Handle.lookup(name, Resolver.defaultResolver(), type, privCheck);
    }

    public static SourceHandle lookupSource(String name, Schema schema) {
        return (SourceHandle)Handle.lookup(name, schema, 28);
    }

    public static SourceHandle lookupSource(String name, Resolver resolver) {
        return (SourceHandle)Handle.lookup(name, resolver, 28);
    }

    public static SourceHandle lookupSource(String name) {
        return (SourceHandle)Handle.lookup(name, 28);
    }

    public static ClassHandle lookupClass(String name, Schema schema) {
        return (ClassHandle)Handle.lookup(name, schema, 29);
    }

    public static ClassHandle lookupClass(String name, Resolver resolver) {
        return (ClassHandle)Handle.lookup(name, resolver, 29);
    }

    public static ClassHandle lookupClass(String name) {
        return (ClassHandle)Handle.lookup(name, 29);
    }

    public static ResourceHandle lookupResource(String name, Schema schema) {
        return (ResourceHandle)Handle.lookup(name, schema, 30);
    }

    public static ResourceHandle lookupResource(String name, Resolver resolver) {
        return (ResourceHandle)Handle.lookup(name, resolver, 30);
    }

    public static ResourceHandle lookupResource(String name) {
        return (ResourceHandle)Handle.lookup(name, 30);
    }

    public static SynonymHandle lookupSynonym(String name, Schema schema) {
        return (SynonymHandle)Handle.lookup(name, schema, 5);
    }

    public static SynonymHandle lookupSynonym(String name, Resolver resolver) {
        return (SynonymHandle)Handle.lookup(name, resolver, 5);
    }

    public static SynonymHandle lookupSynonym(String name) {
        return (SynonymHandle)Handle.lookup(name, 5);
    }

    public static SharedDataHandle lookupSharedData(String name, Schema schema) {
        return (SharedDataHandle)Handle.lookup(name, schema, 56);
    }

    public static SharedDataHandle lookupSharedData(String name, Resolver resolver) {
        return (SharedDataHandle)Handle.lookup(name, resolver, 56);
    }

    public static SharedDataHandle lookupSharedData(String name) {
        return (SharedDataHandle)Handle.lookup(name, 56);
    }

    public static EditionHandle lookupEdition(String name) {
        return (EditionHandle)Handle.lookup(name, Schema.systemSchema, 57);
    }

    public static SourceHandle lookupSource(String name, Schema schema, boolean privCheck) {
        return (SourceHandle)Handle.lookup(name, schema, 28, privCheck);
    }

    public static SourceHandle lookupSource(String name, Resolver resolver, boolean privCheck) {
        return (SourceHandle)Handle.lookup(name, resolver, 28, privCheck);
    }

    public static SourceHandle lookupSource(String name, boolean privCheck) {
        return (SourceHandle)Handle.lookup(name, 28, privCheck);
    }

    public static ClassHandle lookupClass(String name, Schema schema, boolean privCheck) {
        return (ClassHandle)Handle.lookup(name, schema, 29, privCheck);
    }

    public static ClassHandle lookupClass(String name, Resolver resolver, boolean privCheck) {
        return (ClassHandle)Handle.lookup(name, resolver, 29, privCheck);
    }

    public static ClassHandle lookupClass(String name, boolean privCheck) {
        return (ClassHandle)Handle.lookup(name, 29, privCheck);
    }

    public static ResourceHandle lookupResource(String name, Schema schema, boolean privCheck) {
        return (ResourceHandle)Handle.lookup(name, schema, 30, privCheck);
    }

    public static ResourceHandle lookupResource(String name, Resolver resolver, boolean privCheck) {
        return (ResourceHandle)Handle.lookup(name, resolver, 30, privCheck);
    }

    public static ResourceHandle lookupResource(String name, boolean privCheck) {
        return (ResourceHandle)Handle.lookup(name, 30, privCheck);
    }

    public static SharedDataHandle lookupSharedData(String name, Schema schema, boolean privCheck) {
        return (SharedDataHandle)Handle.lookup(name, schema, 56, privCheck);
    }

    public static SharedDataHandle lookupSharedData(String name, Resolver resolver, boolean privCheck) {
        return (SharedDataHandle)Handle.lookup(name, resolver, 56, privCheck);
    }

    public static SharedDataHandle lookupSharedData(String name, boolean privCheck) {
        return (SharedDataHandle)Handle.lookup(name, 56, privCheck);
    }

    public static Handle lookup(String name, CHAR schemaName, String typeName) {
        if (name == null || schemaName == null || typeName == null) {
            return null;
        }
        Schema schema = Schema.lookup(schemaName);
        if (schema == null) {
            return null;
        }
        String up = typeName.toUpperCase();
        int type = 10;
        if (up.indexOf("CLASS") != -1) {
            type = 29;
        } else if (up.indexOf("RESOURCE") != -1) {
            type = 30;
        } else if (up.indexOf("SOURCE") != -1) {
            type = 28;
        } else if (up.indexOf("SHARED_DATA") != -1) {
            type = 56;
        } else if (up.indexOf("SYNONYM") != -1) {
            type = 5;
        } else if (up.indexOf("EDITION") != -1) {
            type = 57;
        } else {
            return null;
        }
        return Handle.lookup(name, schema, type);
    }

    private static native int lookupForCompiler(String var0, boolean var1, boolean var2, Handle var3, HandleHolder var4);

    protected static int lookupHandleForCompiler(String fullName, boolean derivedp, boolean sourcep, Handle refFromHandle, IUHandle[] foundHandle) {
        HandleHolder holder;
        int status;
        if (refFromHandle != null) {
            int pureNameLen;
            String longName = refFromHandle.name(true);
            String pureName = refFromHandle.pureName();
            int longNameLen = longName.length();
            if (longNameLen != (pureNameLen = pureName.length()) && derivedp) {
                fullName = longName.substring(0, longNameLen - pureNameLen) + fullName;
            }
        }
        if ((status = Handle.lookupForCompiler(fullName, derivedp, sourcep, refFromHandle, holder = new HandleHolder())) > 0) {
            foundHandle[0] = holder.handle;
            if (foundHandle[0] == null && holder.name != null) {
                foundHandle[0] = Handle.lookup(holder);
            }
        }
        return status;
    }

    public static int typeFromName(String typeName) {
        int type;
        String up = typeName.toUpperCase();
        if (up.indexOf("SOURCE") != -1) {
            type = 28;
        } else if (up.indexOf("CLASS") != -1) {
            type = 29;
        } else if (up.indexOf("RESOURCE") != -1) {
            type = 30;
        } else if (up.indexOf("SYNONYM") != -1) {
            type = 5;
        } else if (up.indexOf("SHARED_DATA") != -1) {
            type = 56;
        } else if (up.indexOf("EDITION") != -1) {
            type = 57;
        } else {
            return -1;
        }
        return type;
    }

    public String name() {
        return this.name;
    }

    public String pureName() {
        if (this.pureName == null) {
            String perhapsImpureName = this.name(true);
            int start = perhapsImpureName.lastIndexOf("///");
            this.pureName = start == -1 ? perhapsImpureName : perhapsImpureName.substring(start + 3);
        }
        return this.pureName;
    }

    public String name(boolean longp) {
        String n = this.name();
        return longp && n != null && n.charAt(0) == '/' ? DbmsJava.longName(n) : n;
    }

    public Schema schema() {
        return this.schema;
    }

    public long index() {
        return this.index;
    }

    private native int resolver(String[][] var1, int[][] var2, String var3) throws ObjectTypeChangedException;

    public Resolver resolver() throws ObjectTypeChangedException {
        SourceHandle srcHd = null;
        Resolver resolver_ = null;
        String[][] patternsHolder = new String[1][];
        int[][] ownerNumbersHolder = new int[1][];
        int length = 0;
        try {
            length = this.resolver(patternsHolder, ownerNumbersHolder, null);
        }
        catch (KGEException e) {
            e.amendMessageAndRethrow(this + ".resolver");
        }
        if (length == 0) {
            resolver_ = this.type() == 29 && (srcHd = this.derivedFrom()) != null ? srcHd.resolver() : Resolver.defaultResolver();
        } else {
            Schema[] schemas = new Schema[length];
            for (int i = 0; i < length; ++i) {
                schemas[i] = Schema.lookup(ownerNumbersHolder[0][i]);
            }
            try {
                resolver_ = new Resolver(patternsHolder[0], schemas);
            }
            catch (SchemaNotFoundException e) {
            }
            catch (InvalidResolverPatternException e) {
                // empty catch block
            }
        }
        return resolver_;
    }

    public Object resolverObject() {
        Resolver r = null;
        try {
            r = this.resolver();
        }
        catch (ObjectTypeChangedException e) {
            r = new Resolver(new ResolverTerm[0]);
            e.printStackTrace();
        }
        return r;
    }

    private native boolean sourceHandle(boolean var1, HandleHolder var2);

    public IUHandle sourceHandle(boolean onlyIfNewer) {
        HandleHolder holder = new HandleHolder();
        if (!this.sourceHandle(onlyIfNewer, holder)) {
            return null;
        }
        return SourceHandle.intern(holder);
    }

    private static native int getMethodToJit(int var0, HandleHolder var1, Member[] var2);

    public static IUHandle getMethodToJit(int methodNumber, int[] methodIndices, Member[] methodObjects) {
        HandleHolder holder = new HandleHolder();
        methodIndices[methodNumber] = Handle.getMethodToJit(methodNumber, holder, methodObjects);
        return ClassHandle.intern(holder);
    }

    public abstract int type();

    private native int status(String var1) throws ObjectTypeChangedException;

    public int status() {
        int x = 0;
        try {
            x = this.status(null);
        }
        catch (ObjectTypeChangedException ehe) {
            return 5;
        }
        catch (KGEException e) {
            e.amendMessageAndRethrow(this + ".status");
        }
        return x;
    }

    private native int objn(String var1) throws ObjectTypeChangedException;

    protected int objn() throws ObjectTypeChangedException {
        int x = 0;
        try {
            x = this.objn(null);
        }
        catch (KGEException e) {
            e.amendMessageAndRethrow(this + ".objn");
        }
        return x;
    }

    public int objectNumber() throws ObjectTypeChangedException {
        if (this.objectNumber < 0) {
            this.objectNumber = this.objn();
        }
        return this.objectNumber;
    }

    private native int flags(int var1, boolean var2, int var3, String var4) throws ModifyPermissionException, ObjectTypeChangedException;

    public boolean definers() throws ObjectTypeChangedException {
        boolean x = false;
        try {
            x = this.flags(1, false, 0, null) != 0;
        }
        catch (KGEException e) {
            e.amendMessageAndRethrow(this + ".definers");
        }
        return x;
    }

    public void setDefiners(boolean newDefiners) throws ModifyPermissionException, ObjectTypeChangedException {
        try {
            this.flags(1, true, newDefiners ? 1 : 0, null);
        }
        catch (KGEException e) {
            e.amendMessageAndRethrow(this + ".setDefiners");
        }
    }

    public boolean fixedInInstance() throws ObjectTypeChangedException {
        boolean x = false;
        try {
            x = this.flags(256, false, 0, null) != 0;
        }
        catch (KGEException e) {
            e.amendMessageAndRethrow(this + ".fixedInInstance");
        }
        return x;
    }

    public void setFixedInInstance(boolean newFixedInInstance) throws ModifyPermissionException, ObjectTypeChangedException {
        try {
            this.flags(256, true, newFixedInInstance ? 256 : 0, null);
        }
        catch (KGEException e) {
            e.amendMessageAndRethrow(this + ".setFixedInInstance");
        }
    }

    public boolean predigested() throws ObjectTypeChangedException {
        boolean x = false;
        try {
            x = this.flags(512, false, 0, null) != 0;
        }
        catch (KGEException e) {
            e.amendMessageAndRethrow(this + ".predigested");
        }
        return x;
    }

    public void setPredigestionOff() throws ModifyPermissionException, ObjectTypeChangedException {
        try {
            this.flags(512, true, 0, null);
        }
        catch (KGEException e) {
            e.amendMessageAndRethrow(this + ".setPredigestionOff");
        }
    }

    public boolean classesBinP() throws ObjectTypeChangedException {
        boolean x = false;
        int mask = 96;
        try {
            x = (this.flags(mask, false, 0, null) & mask) != 0;
        }
        catch (KGEException e) {
            e.amendMessageAndRethrow(this + ".classesBinP");
        }
        return x;
    }

    public String[] errors() {
        return null;
    }

    private native boolean derivedFrom(HandleHolder var1, String var2) throws ObjectTypeChangedException;

    protected SourceHandle doDerivedFrom() throws ObjectTypeChangedException {
        HandleHolder holder = new HandleHolder();
        try {
            if (!this.derivedFrom(holder, null)) {
                return null;
            }
        }
        catch (KGEException e) {
            e.amendMessageAndRethrow(this + ".derivedFrom");
        }
        return SourceHandle.intern(holder);
    }

    protected SourceHandle derivedFrom() throws ObjectTypeChangedException {
        return null;
    }

    private native void setResolver(String[] var1, int[] var2, String var3) throws ObjectTypeChangedException;

    protected void doSetResolver(Resolver newResolver) throws ObjectTypeChangedException {
        try {
            this.setResolver(newResolver.patterns(), newResolver.ownerNumbers(), null);
        }
        catch (KGEException e) {
            e.amendMessageAndRethrow(this + ".setResolver");
        }
    }

    public void setResolver(Resolver newResolver) throws ObjectTypeChangedException {
    }

    private native void drop(boolean var1, String var2) throws ModifyPermissionException, ObjectInUseException, ObjectDoesNotExistException, ObjectTypeChangedException;

    public void drop() throws ModifyPermissionException, ObjectInUseException, ObjectDoesNotExistException, ObjectTypeChangedException {
        this.drop(false);
    }

    public void drop(boolean onlyIfNotInUse) throws ModifyPermissionException, ObjectInUseException, ObjectDoesNotExistException, ObjectTypeChangedException {
        try {
            this.drop(onlyIfNotInUse, null);
            this.remove();
        }
        catch (KGEException e) {
            e.amendMessageAndRethrow(this + ".drop");
        }
    }

    private native int resolve(String var1) throws ModifyPermissionException, ObjectTypeChangedException;

    public int resolve() throws ModifyPermissionException, ObjectTypeChangedException {
        int x = 0;
        try {
            x = this.resolve(null);
        }
        catch (KGEException e) {
            e.amendMessageAndRethrow(this + ".resolve");
        }
        return x;
    }

    private native boolean hasExecutePrivilege(int var1, boolean[] var2, String var3) throws ObjectTypeChangedException;

    public boolean hasExecutePrivilege(int ownerNumber, boolean[] withGrant) throws ObjectTypeChangedException {
        boolean x = false;
        try {
            x = this.hasExecutePrivilege(ownerNumber, withGrant, null);
        }
        catch (KGEException e) {
            e.amendMessageAndRethrow(this + ".hasExecutePrivilege");
        }
        return x;
    }

    public boolean hasExecutePrivilege(Schema schema) throws ObjectTypeChangedException {
        return this.hasExecutePrivilege(schema.ownerNumber(), null);
    }

    private native void setExecutePrivilege(int var1, boolean var2, boolean var3, String var4) throws ModifyPermissionException, ObjectTypeChangedException;

    private void setExecutePrivilege(int ownerNumber, boolean grant, boolean withGrant) throws ModifyPermissionException, ObjectTypeChangedException {
        try {
            this.setExecutePrivilege(ownerNumber, grant, withGrant, null);
        }
        catch (KGEException e) {
            e.amendMessageAndRethrow(this + ".setExecutePrivilege");
        }
    }

    public void grantExecutePrivilege(Schema schema) throws ModifyPermissionException, ObjectTypeChangedException {
        this.grantExecutePrivilege(schema, false);
    }

    public void grantExecutePrivilege(Schema schema, boolean withGrant) throws ModifyPermissionException, ObjectTypeChangedException {
        this.setExecutePrivilege(schema.ownerNumber(), true, withGrant);
    }

    public void revokeExecutePrivilege(Schema schema) throws ModifyPermissionException, ObjectTypeChangedException {
        this.setExecutePrivilege(schema.ownerNumber(), false, false);
    }

    private native byte[] data_(String var1) throws ObjectTypeChangedException;

    public byte[] data() throws ObjectTypeChangedException {
        if (this.data == null && (this.type() == 29 || this.type() == 28 || this.type() == 30)) {
            try {
                this.data = this.data_(null);
            }
            catch (KGEException e) {
                e.amendMessageAndRethrow(this + ".data");
            }
        }
        return this.data;
    }

    private native byte[] getMD5(String var1) throws ObjectTypeChangedException;

    public byte[] getMD5() throws ObjectTypeChangedException {
        byte[] x = null;
        try {
            x = this.getMD5(null);
        }
        catch (KGEException e) {
            e.amendMessageAndRethrow(this + ".getMD5");
        }
        return x;
    }

    public byte[] getMD5BitArray() throws ObjectTypeChangedException {
        byte[] bytes = this.getMD5();
        byte[] bits = new byte[128];
        byte b = 0;
        for (int i = 0; i < 8; ++i) {
            b = bytes[i];
            for (int j = 0; j < 16; ++j) {
                bits[(i + 1) * 16 - j - 1] = (byte)(b & 1);
                b = (byte)(b >> 1);
            }
        }
        return bits;
    }

    public BigInteger getMD5BigInt() throws ObjectTypeChangedException {
        return new BigInteger(this.getMD5BitArray());
    }

    public int hashCode() {
        return this.name.hashCode() ^ this.schema.hashCode();
    }

    public boolean equals(Object obj) {
        boolean result = false;
        if (obj == this) {
            result = true;
        } else if (obj instanceof Handle) {
            Handle h = (Handle)obj;
            boolean bl = result = this.schema.equals(h.schema) && this.name.equals(h.name) && this.type() == h.type();
            if (result && this.timestamp != null && h.timestamp != null) {
                if (this.timestamp.length != h.timestamp.length) {
                    result = false;
                } else {
                    for (int i = 0; i < this.timestamp.length; ++i) {
                        if (this.timestamp[i] == h.timestamp[i]) continue;
                        result = false;
                        break;
                    }
                }
            }
        }
        return result;
    }

    native boolean checkTimestamp();

    protected static Handle get(String name, Schema schema, int type) {
        key.init(name, schema, type);
        Handle h = (Handle)byName.get(key);
        if (h != null && !h.checkTimestamp()) {
            h.remove();
            h = null;
        }
        return h;
    }

    native void put__();

    protected void put() {
        this.put__();
        byName.put(this, this);
    }

    native void remove__();

    protected void remove() {
        this.remove__();
        byName.remove(this);
    }

    public Class loadClass() throws ClassNotFoundException, ObjectTypeChangedException {
        return null;
    }

    public InputStream inputStream() throws IOException {
        return this.inputStream(false);
    }

    public InputStream inputStream(boolean forCompiler) throws IOException {
        SecurityManager security = System.getSecurityManager();
        if (security != null && security instanceof SecurityManagerImpl) {
            ((SecurityManagerImpl)security).checkRead(this);
        }
        return new SeekableBufferedInputStream(new HandleInput(this, forCompiler), 4000);
    }

    public String toString(String prefix) {
        return prefix + this.name + "|" + this.schema + "|" + this.index + ">";
    }

    public String toString() {
        String prefix = "<" + Handle.typeString(this.type()) + " Handle: ";
        return this.toString(prefix);
    }

    static String typeString(int type) {
        switch (type) {
            case 5: {
                return "Synonym";
            }
            case 28: {
                return "Source";
            }
            case 29: {
                return "Class";
            }
            case 30: {
                return "Resource";
            }
            case 56: {
                return "SharedData";
            }
            case 57: {
                return "Edition";
            }
        }
        return "Bogus (type = " + type + ")";
    }

    static HandleHolder[] holders(int n) {
        HandleHolder[] result = new HandleHolder[n];
        for (int i = 0; i < n; ++i) {
            result[i] = new HandleHolder();
        }
        return result;
    }

    private native int jarNameFromHandle(String[] var1);

    public String jarName() {
        String[] jarNameHolder = new String[]{null};
        String jarName = null;
        int status = this.jarNameFromHandle(jarNameHolder);
        jarName = jarNameHolder[0];
        if (status == 0) {
            return jarName;
        }
        if (status == 7) {
            return null;
        }
        if (status == 4) {
            throw new InternalError("Rdbms Error determining jar name: " + jarName);
        }
        throw new InternalError("Invalid stus retrieving jar name: " + status);
    }
}

