/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.rdbms;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.sql.SQLException;
import oracle.aurora.rdbms.ClassHandle;
import oracle.aurora.rdbms.Handle;
import oracle.aurora.rdbms.ResourceHandle;
import oracle.aurora.rdbms.Schema;
import oracle.aurora.rdbms.SourceHandle;
import oracle.sql.BLOB;
import oracle.sql.CLOB;

public class ExportSchemaObjects {
    public static void exportSource(String name, String schema, BLOB blob) throws Exception, SQLException, IOException {
        try {
            SourceHandle h = Handle.lookupSource(name, Schema.lookup(schema));
            ExportSchemaObjects.copy(h, blob);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw ex;
        }
    }

    public static void exportSource(String name, BLOB blob) throws SQLException, IOException {
        SourceHandle h = Handle.lookupSource(name, Schema.currentSchema());
        ExportSchemaObjects.copy(h, blob);
    }

    public static void exportSource(String name, String schema, CLOB clob) throws SQLException, IOException {
        SourceHandle h = Handle.lookupSource(name, Schema.lookup(schema));
        ExportSchemaObjects.copy(h, "UTF8", clob);
    }

    public static void exportSource(String name, CLOB clob) throws SQLException, IOException {
        SourceHandle h = Handle.lookupSource(name, Schema.currentSchema());
        ExportSchemaObjects.copy(h, "UTF8", clob);
    }

    public static void exportClass(String name, String schema, BLOB blob) throws SQLException, IOException {
        ClassHandle h = Handle.lookupClass(name, Schema.lookup(schema));
        ExportSchemaObjects.copy(h, blob);
    }

    public static void exportClass(String name, BLOB blob) throws SQLException, IOException {
        ClassHandle h = Handle.lookupClass(name, Schema.currentSchema());
        ExportSchemaObjects.copy(h, blob);
    }

    public static void exportResource(String name, String schema, BLOB blob) throws SQLException, IOException {
        ResourceHandle h = Handle.lookupResource(name, Schema.lookup(schema));
        ExportSchemaObjects.copy(h, blob);
    }

    public static void exportResource(String name, BLOB blob) throws SQLException, IOException {
        ResourceHandle h = Handle.lookupResource(name, Schema.currentSchema());
        ExportSchemaObjects.copy(h, blob);
    }

    public static void exportResource(String name, String schema, CLOB clob) throws SQLException, IOException {
        ResourceHandle h = Handle.lookupResource(name, Schema.lookup(schema));
        ExportSchemaObjects.copy(h, null, clob);
    }

    public static void exportResource(String name, CLOB clob) throws SQLException, IOException {
        ResourceHandle h = Handle.lookupResource(name, Schema.currentSchema());
        ExportSchemaObjects.copy(h, null, clob);
    }

    static void copy(Handle h, String encoding, CLOB clob) throws IOException, SQLException {
        if (h == null) {
            throw new SQLException("no such java schema object");
        }
        InputStream in = h.inputStream();
        in = new BufferedInputStream(in);
        InputStreamReader reader = encoding == null ? new InputStreamReader(in) : new InputStreamReader(in, encoding);
        Writer out = clob.getCharacterOutputStream();
        ExportSchemaObjects.copy(reader, out);
    }

    static void copy(Handle h, BLOB blob) throws IOException, SQLException {
        if (h == null) {
            throw new SQLException("no such java schema object");
        }
        InputStream in = h.inputStream();
        OutputStream out = blob.getBinaryOutputStream();
        ExportSchemaObjects.copy(in, out);
    }

    static void copy(InputStream in, OutputStream out) throws IOException {
        byte[] buffer = new byte[8192];
        int n = in.read(buffer);
        while (n > 0) {
            out.write(buffer, 0, n);
            n = in.read(buffer);
        }
        out.close();
    }

    static void copy(Reader in, Writer out) throws IOException {
        char[] buffer = new char[8192];
        int n = in.read(buffer);
        while (n > 0) {
            out.write(buffer, 0, n);
            n = in.read(buffer);
        }
        out.close();
    }
}

