/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.rdbms;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.TimeZone;
import java.util.Vector;
import oracle.OracleRaw;
import oracle.OracleString;
import oracle.aurora.compiler.CompilerInterface;
import oracle.aurora.compiler.Db;
import oracle.aurora.compiler.ErrorPosition;
import oracle.aurora.compiler.ErrorReporter;
import oracle.aurora.compiler.ExternalEntity;
import oracle.aurora.compiler.FwdInterface;
import oracle.aurora.compiler.TooManyErrorsException;
import oracle.aurora.jdkcompiler.CompilerOptions;
import oracle.aurora.jdkcompiler.JdkDriver;
import oracle.aurora.jdkcompiler.SqljInterface;
import oracle.aurora.perf.OracleBTL;
import oracle.aurora.rdbms.DbmsJava;
import oracle.aurora.rdbms.OracleLocatorInterface;
import oracle.aurora.rdbms.Schema;
import oracle.aurora.rdbms.VerifierClassLoader;
import oracle.aurora.security.JServerPermission;
import oracle.aurora.sqljdecl.SqljDecl;
import oracle.aurora.vm.EnvironmentError;
import oracle.aurora.vm.OracleRuntime;
import sqlj.framework.ide.aurora.AuroraCustomizer;

public class Compiler {
    private static boolean printStack = true;
    private static Enumeration theNames = null;
    private static int theCount = 0;
    private static OracleRaw utf8Source = null;
    private static OracleRaw resourceBits = null;
    private static String errorString = null;
    private static boolean btlInitialized = false;
    private static String btlPrefix;
    static int countInSession;
    private static VerifierClassLoader[] verifierState;
    public static final int DB_CHAR = 0;
    public static final int COMPILER_GENERATED = 1;
    public static final int NCHAR = 2;
    public static final int BINARY = 3;
    public static final int UTF8 = 4;
    public static final int VERIFIER_IN_SESSION = 1;
    public static final int VERIFIER_IN_DATABASE = 2;
    private static final int QUERY_CONTROLLED_OPTION = 1;
    private static final int ENABLE_CONTROLLED_OPTION = 2;
    private static final int DISABLE_CONTROLLED_OPTION = 3;

    private static void reset(OracleString classname) {
        theNames = null;
        theCount = 0;
        utf8Source = null;
        resourceBits = null;
        errorString = null;
        Compiler.beg(classname == null ? null : classname.toString());
    }

    private static void reset() {
        Compiler.reset(null);
    }

    private static void beg(String name) {
        if (btlPrefix != null && btlPrefix.length() > 0 && !btlInitialized) {
            Db.output("BTL initializing <" + btlPrefix + ">");
            OracleBTL.initBTL(btlPrefix, 0, 0L, false);
            btlInitialized = true;
        }
        if (btlPrefix != null) {
            OracleBTL.startBTL();
        }
    }

    private static void end() {
        if (btlInitialized) {
            OracleBTL.stopBTL();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean createSource(OracleString className, int schemaNumber, int kind, OracleRaw contents) {
        Compiler.reset(className);
        try {
            Compiler.doCreateSource(className, schemaNumber, kind, contents);
        }
        catch (EnvironmentError ee) {
            Compiler.noteThrow(ee);
            throw ee;
        }
        catch (Throwable ex) {
            Compiler.noteThrow(ex);
        }
        finally {
            Compiler.end();
        }
        return Compiler.ok();
    }

    public static OracleRaw getNextName() {
        String result = null;
        if (theNames != null) {
            if (theNames.hasMoreElements()) {
                result = (String)theNames.nextElement();
            } else {
                theNames = null;
            }
        }
        OracleRaw raw = null;
        if (result != null) {
            try {
                raw = new OracleRaw(result.getBytes("UTF8"));
            }
            catch (UnsupportedEncodingException ex) {
                raw = new OracleRaw(result.getBytes());
            }
        }
        return raw;
    }

    public static int getParseCount() {
        return theCount;
    }

    public static OracleRaw getSource() {
        return utf8Source;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean createClassfile(OracleString className, int schemaNumber, OracleRaw bits) {
        Compiler.reset(className);
        try {
            Compiler.doCreateClassfile(className, schemaNumber, bits);
        }
        catch (Throwable ex) {
            Compiler.noteThrow(ex);
        }
        finally {
            Compiler.end();
        }
        return Compiler.ok();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean createResource(OracleString resourceName, int schemaNumber, int kind, OracleRaw bits) {
        Compiler.reset(resourceName);
        resourceBits = bits;
        try {
            String name = resourceName.toString();
            name = name.replace('/', '.').replace(File.separatorChar, '.');
            if (Compiler.isProfileName(name)) {
                resourceBits = Compiler.customizeProfile(name, bits);
            }
        }
        catch (EnvironmentError ee) {
            Compiler.noteThrow(ee);
            throw ee;
        }
        catch (Throwable ex) {
            Compiler.noteThrow(ex);
            ex.printStackTrace();
        }
        finally {
            Compiler.end();
        }
        return Compiler.ok();
    }

    public static OracleRaw getResource() {
        return resourceBits;
    }

    public static boolean dropSource(OracleString className, int schemaNumber) {
        Compiler.reset(className);
        Compiler.end();
        return Compiler.ok();
    }

    public static boolean dropClassfile(OracleString className, int schemaNumber) {
        Compiler.reset(className);
        return Compiler.ok();
    }

    public static boolean dropResource(OracleString resourceName, int schemaNumber) {
        Compiler.reset(resourceName);
        Compiler.end();
        return Compiler.ok();
    }

    public static boolean dropSharedData(OracleString sharedDataName, int schemaNumber) {
        Compiler.reset(sharedDataName);
        Compiler.end();
        return Compiler.ok();
    }

    public static OracleString getNextError() {
        OracleString result = errorString == null ? null : new OracleString(errorString);
        errorString = null;
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean compile(final OracleString sourceClassName, int schemaNumber) {
        Compiler.reset(sourceClassName);
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    Compiler.doCompile(sourceClassName);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException pe) {
            Compiler.noteThrow(pe.getException());
        }
        catch (EnvironmentError ee) {
            Compiler.noteThrow(ee);
            throw ee;
        }
        catch (Throwable ex) {
            Compiler.noteThrow(ex);
        }
        finally {
            Compiler.end();
        }
        return Compiler.ok();
    }

    private static void dumpArray(String name, byte[] bytes) {
        Db.output(name);
        Db.push();
        for (int x = 0; x < bytes.length; x += 16) {
            StringBuffer accum = new StringBuffer();
            for (int y = 0; y < 16 && x + y < bytes.length; ++y) {
                accum.append(Integer.toHexString(bytes[x + y] & 0xFF));
                accum.append(' ');
            }
            Db.output(accum.toString());
        }
        Db.pop();
    }

    private static void dumpString(String name, String what) {
        Db.output(name);
        char[] chars = new char[what.length()];
        what.getChars(0, chars.length, chars, 0);
        Db.push();
        for (int x = 0; x < chars.length; x += 16) {
            StringBuffer accum = new StringBuffer();
            for (int y = 0; y < 16 && x + y < chars.length; ++y) {
                accum.append(Integer.toHexString(chars[x + y] & 0xFF));
                accum.append(' ');
            }
            Db.output(accum.toString());
        }
        Db.pop();
    }

    public static void setNumberOfClassesResolved(int numberResolved) {
        if (numberResolved > 0) {
            verifierState = new VerifierClassLoader[numberResolved];
        }
    }

    public static void classResolved(final OracleString className, final int schemaNumber, int index, final boolean derivedp, OracleRaw oldByteCodes) {
        Compiler.verifierState[index] = (VerifierClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new VerifierClassLoader(className.toString(), Schema.lookup(schemaNumber), derivedp);
            }
        });
    }

    public static int verificationStatus(final int index) {
        Integer r = (Integer)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new Integer(verifierState[index].verify());
            }
        });
        return r;
    }

    public static OracleRaw getClassBytes(int index) {
        byte[] bytes = verifierState[index].getClassBytes();
        return bytes == null ? null : new OracleRaw(bytes);
    }

    public static OracleString getNextError(int index) {
        String s = verifierState[index].getNextError();
        return s == null ? null : new OracleString(s + "\n");
    }

    public static OracleString getNextWarning(int index) {
        String s = verifierState[index].getNextWarning();
        return s == null ? null : new OracleString(s + "\n");
    }

    public static void endResolution() {
    }

    private static void doCreateSource(OracleString className, int schemaNumber, int kind, OracleRaw contents) {
        switch (kind) {
            case 0: {
                utf8Source = DbmsJava.convertDatabaseCharsToUtf8(contents);
                break;
            }
            case 2: {
                utf8Source = DbmsJava.convertNCharsToUtf8(contents);
                break;
            }
            case 3: {
                String enc = Compiler.getEncoding(className.toString());
                try {
                    InputStream in = contents.getOracleStream();
                    InputStreamReader r = enc == null ? new InputStreamReader(in) : new InputStreamReader(in, enc);
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    OutputStreamWriter w = new OutputStreamWriter((OutputStream)out, "UTF8");
                    Compiler.copyIO(w, r);
                    ((Writer)w).close();
                    utf8Source = new OracleRaw(out.toByteArray());
                }
                catch (IOException ex) {
                    Compiler.noteThrow(ex);
                }
                break;
            }
            default: {
                utf8Source = contents;
            }
        }
        try {
            char[] buf = new char[2048];
            InputStream utf8Stream = utf8Source.getOracleStream();
            InputStreamReader readerForParser = new InputStreamReader(utf8Stream, "UTF8");
            String filename = className.toString();
            SqljDecl parser = Compiler.doScan(filename, readerForParser);
            if (parser != null) {
                theNames = parser.getClassDecls();
                theCount = parser.getClassDeclsSize();
                Schema s = Schema.lookup(schemaNumber);
                Enumeration forCheck = parser.getClassDecls();
                while (forCheck.hasMoreElements()) {
                    Compiler.checkLoadPermission((String)forCheck.nextElement(), s);
                }
            }
        }
        catch (Exception ex) {
            Compiler.noteThrow(ex);
        }
    }

    private static SqljDecl doScan(String name, Reader r) {
        SqljDecl scanner = null;
        try {
            int x = name.lastIndexOf("/");
            if (x > 0) {
                name = name.substring(x + 1);
            }
            scanner = SqljDecl.run_and_create_new_parser(name, r);
        }
        catch (Exception e) {
            Compiler.noteError(e.getMessage());
        }
        return scanner;
    }

    private static void doCreateClassfile(OracleString className, int schemaNumber, OracleRaw bits) {
        Schema s = Schema.lookup(schemaNumber);
        Compiler.checkLoadPermission(className.toString(), s);
    }

    private static void doCompile(OracleString sourceClassName) throws IOException {
        boolean ok;
        Compiler.setMemory();
        OracleLocatorInterface locatorInterface = new OracleLocatorInterface();
        Object face = locatorInterface;
        ExternalEntity[] sources = new ExternalEntity[]{locatorInterface.getTopLevelSource(sourceClassName.toString())};
        face = new FwdInterface((CompilerInterface)((Object)locatorInterface)){
            protected ErrorReporter _nonRepeatingReporter = null;

            public ErrorReporter getReporter() {
                if (this._nonRepeatingReporter == null) {
                    final ErrorReporter farReporter = this.farInterface.getReporter();
                    this._nonRepeatingReporter = new ErrorReporter(){
                        private final int LINESHIFT = 10;
                        Hashtable _errors = new Hashtable();

                        public void report(ErrorPosition position, int level, String message) throws TooManyErrorsException {
                            int pos = (position.getLine() << 10) + position.getColumn();
                            Pair pair = new Pair(new Integer(pos), new Integer(message.hashCode()));
                            if (this._errors.get(pair) == null) {
                                this._errors.put(pair, pair);
                                farReporter.report(position, level, message);
                            }
                        }

                        public void close() {
                            farReporter.close();
                        }

                        public int getErrorCount() {
                            return farReporter.getErrorCount();
                        }

                        public int getWarningCount() {
                            return farReporter.getWarningCount();
                        }

                        class Pair {
                            private final Object _null = new Object();
                            Object _car;
                            Object _cdr;

                            public Pair(Object car, Object cdr) {
                                this._car = car == null ? this._null : car;
                                this._cdr = cdr == null ? this._null : cdr;
                            }

                            public boolean equals(Object o) {
                                if (o instanceof Pair) {
                                    Pair pair = (Pair)o;
                                    return pair._car.equals(this._car) && pair._cdr.equals(this._cdr);
                                }
                                return false;
                            }

                            public int hashCode() {
                                return this._car.hashCode() * 37 + this._cdr.hashCode();
                            }

                            public String toString() {
                                return "<Pair " + this._car + ", " + this._cdr + ">";
                            }
                        }
                    };
                }
                return this._nonRepeatingReporter;
            }
        };
        face = new SqljInterface((CompilerInterface)face);
        String[] options = Compiler.compileOptions(sourceClassName.toString(), true);
        JdkDriver compiler = new JdkDriver((CompilerInterface)face, "Aurora Compiler In Server");
        boolean bl = ok = compiler.compile(options, sources) == 0 && face.getReporter().getErrorCount() == 0;
        if (!ok) {
            Compiler.noteError("Compilation of " + sourceClassName + " failed");
        }
        locatorInterface.setOk(ok);
        face.close();
    }

    private static boolean ok() {
        return errorString == null;
    }

    private static void noteError(String e) {
        errorString = e;
    }

    private static void noteThrow(Throwable ex) {
        errorString = ex.toString();
        if (printStack) {
            ex.printStackTrace();
        }
    }

    private static String getEncoding(String className) {
        String enc = null;
        try {
            enc = CompilerOptions.get((String)className.replace('/', '.'), (String)"encoding");
        }
        catch (SQLException ex) {
            Compiler.noteError(ex.getMessage());
        }
        return enc;
    }

    private static void copyIO(Writer w, Reader r) throws IOException {
        char[] buf = new char[4096];
        int count = 0;
        while (count >= 0) {
            count = r.read(buf);
            if (count <= 0) continue;
            w.write(buf, 0, count);
        }
    }

    private static boolean isProfileName(String name) {
        int x;
        boolean ok = true;
        if (!name.endsWith(".ser")) {
            ok = false;
        }
        if ((x = name.lastIndexOf("_SJProfile")) < 0) {
            ok = false;
        }
        return ok;
    }

    private static OracleRaw customizeProfile(String name, OracleRaw ser) {
        byte[] originalBytes;
        byte[] resultBytes = originalBytes = ser.getOracleBytes();
        try {
            resultBytes = AuroraCustomizer.customize((String)name, (byte[])originalBytes, (int)Schema.currentSchema().ownerNumber());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Compiler.noteError(ex.getMessage());
        }
        OracleRaw result = ser;
        if (originalBytes != resultBytes) {
            result = new OracleRaw(resultBytes);
        }
        return result;
    }

    private static String[] compileOptions(String sourcefileName, boolean sqljOptions) {
        Vector<String> argv = new Vector<String>();
        if (sqljOptions) {
            argv.addElement("-checkfilename=false");
            String online = null;
            try {
                online = CompilerOptions.get((String)sourcefileName, (String)"online");
            }
            catch (SQLException ex) {
                // empty catch block
            }
            if (online != null && online.equals("true")) {
                argv.addElement("-sqlj.url=jdbc:oracle:kprb:@");
                argv.addElement("-sqlj.user=kprb");
                argv.addElement("-sqlj.password=none");
            }
            argv.addElement("-sqlj.warn=all,noportable,noverbose");
        }
        String locator = null;
        try {
            locator = CompilerOptions.get((String)sourcefileName, (String)"locator");
        }
        catch (SQLException ex) {
            // empty catch block
        }
        if (locator != null && locator.equals("false")) {
            argv.addElement("-nolocator");
        }
        String debug = null;
        try {
            debug = CompilerOptions.get((String)sourcefileName, (String)"debug");
        }
        catch (SQLException ex) {
            // empty catch block
        }
        if (debug != null && debug.equals("true")) {
            argv.addElement("-g");
        }
        String source = null;
        try {
            source = CompilerOptions.get((String)sourcefileName, (String)"source");
            if (!source.equals("1.5")) {
                source = "1.5";
            }
        }
        catch (SQLException ex) {
            // empty catch block
        }
        if (source != null) {
            argv.addElement("-source");
            argv.addElement(source);
        }
        argv.add("-encoding");
        argv.add("UTF8");
        Object[] argvStrings = new String[argv.size()];
        argv.copyInto(argvStrings);
        return argvStrings;
    }

    private static void checkLoadPermission(String name, Schema schema) {
        name = name.replace('/', '.');
        String what = "LoadClassInPackage." + name;
        try {
            JServerPermission.check((String)what);
        }
        catch (SecurityException ex) {
            Compiler.noteError("User has attempted to load a class (" + name + ") into a restricted package." + " Permission can be granted using " + " dbms_java.grant_permission(<user>, LoadClassInPackage...");
        }
    }

    private static void setMemory() {
        try {
            System.getProperty("file.encoding");
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    long current = OracleRuntime.getMaxMemorySize();
                    if (current < 0x20000000L) {
                        OracleRuntime.setMaxMemorySize(0x20000000L);
                    }
                    return null;
                }
            });
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    private static native boolean optionController_(int var0, int var1);

    public static boolean optionController(int option_id, int action) {
        JServerPermission.check((String)"Verifier");
        return Compiler.optionController_(option_id, action);
    }

    public static int sessionOptionController(int flag) {
        int action = flag != 0 ? 2 : 3;
        boolean previous = Compiler.optionController(1, action);
        return previous ? 1 : 0;
    }

    public static void updateTimeZone() {
        TimeZone.setDefault(null);
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                System.setProperty("user.timezone", "");
                return null;
            }
        });
        TimeZone.getDefault();
    }
}

