/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.dbUI.viewBuilder.swing;

import java.awt.Component;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetContext;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.IOException;
import javax.swing.JComponent;
import oracle.bali.dbUI.db.Column;
import oracle.bali.dbUI.db.Table;
import oracle.bali.dbUI.dnd.DBUIDataFlavors;
import oracle.bali.dbUI.dnd.DBUIDnDSupport;
import oracle.bali.dbUI.dnd.DBUITransferableProvider;
import oracle.bali.dbUI.laf.DBUILookAndFeel;
import oracle.bali.dbUI.viewBuilder.ViewBuilder;
import oracle.bali.dbUI.viewBuilder.swing.JInternalFrameViewBuilderCanvas;
import oracle.bali.share.datatransfer.TransferUtils;

class VBJDKDropSupport
implements DropTargetListener {
    private JInternalFrameViewBuilderCanvas _canvas;

    public VBJDKDropSupport(JInternalFrameViewBuilderCanvas canvas) {
        this._canvas = canvas;
    }

    public void addDropTarget(JComponent comp) {
        if (comp.getDropTarget() == null) {
            DropTarget dropTarget = new DropTarget(comp, this);
        }
        int count = comp.getComponentCount();
        for (int i = 0; i < count; ++i) {
            Component child = comp.getComponent(i);
            if (!(child instanceof JComponent)) continue;
            this.addDropTarget((JComponent)child);
        }
    }

    public void removeDropTarget(JComponent comp) {
        DropTarget drop = comp.getDropTarget();
        if (drop != null) {
            try {
                drop.removeDropTargetListener(this);
                comp.setDropTarget(null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        int count = comp.getComponentCount();
        for (int i = 0; i < count; ++i) {
            Component child = comp.getComponent(i);
            if (!(child instanceof JComponent)) continue;
            this.removeDropTarget((JComponent)child);
        }
    }

    public void dragEnter(DropTargetDragEvent dtde) {
        this._dragProcessing(dtde);
    }

    public void dragOver(DropTargetDragEvent dtde) {
        this._dragProcessing(dtde);
    }

    public void dropActionChanged(DropTargetDragEvent dtde) {
        this._dragProcessing(dtde);
    }

    public void dragExit(DropTargetEvent dtde) {
    }

    public void drop(DropTargetDropEvent dtde) {
        DBUITransferableProvider[] providers;
        Object data2;
        DropTargetContext context = dtde.getDropTargetContext();
        if (!this._canvas.isEnabled()) {
            dtde.rejectDrop();
            context.dropComplete(false);
            return;
        }
        dtde.acceptDrop(2);
        Transferable transfer = dtde.getTransferable();
        Table table = null;
        Column column = null;
        if (transfer.isDataFlavorSupported(DBUIDataFlavors.COLUMN_FLAVOR)) {
            try {
                data2 = transfer.getTransferData(DBUIDataFlavors.COLUMN_FLAVOR);
                if (data2 instanceof Column) {
                    table = column.getTable();
                }
            }
            catch (IOException data2) {
            }
            catch (UnsupportedFlavorException data2) {
                // empty catch block
            }
        }
        if (table == null && transfer.isDataFlavorSupported(DBUIDataFlavors.TABLE_FLAVOR)) {
            try {
                data2 = transfer.getTransferData(DBUIDataFlavors.TABLE_FLAVOR);
                if (data2 instanceof Table) {
                    table = (Table)data2;
                }
            }
            catch (IOException data3) {
            }
            catch (UnsupportedFlavorException data3) {
                // empty catch block
            }
        }
        if (table == null && (providers = DBUIDnDSupport.getDBUITransferableProviders()) != null) {
            for (int i = 0; table == null && i < providers.length; ++i) {
                Object data4 = providers[i].getDBUITransferData(transfer, DBUIDataFlavors.COLUMN_FLAVOR);
                if (data4 instanceof Column) {
                    column = (Column)data4;
                    table = column.getTable();
                    continue;
                }
                data4 = providers[i].getDBUITransferData(transfer, DBUIDataFlavors.TABLE_FLAVOR);
                if (!(data4 instanceof Table)) continue;
                table = (Table)data4;
            }
        }
        ViewBuilder builder = this._canvas.getViewBuilder();
        if (table != null) {
            Point p = dtde.getLocation();
            for (Component c = context.getComponent(); c != builder && c != null; c = c.getParent()) {
                p.x += c.getX();
                p.y += c.getY();
            }
            DBUILookAndFeel.getLookAndFeel().setCursor(this._canvas, true);
            builder.addTable(table, p.x, p.y, true);
            DBUILookAndFeel.getLookAndFeel().setCursor(this._canvas, false);
            if (column != null) {
                builder.setColumnSelected(column, true);
            }
            builder.repaint();
        }
        context.dropComplete(table != null);
    }

    private void _dragProcessing(DropTargetDragEvent dtde) {
        if (this._acceptDrag(dtde)) {
            dtde.acceptDrag(dtde.getDropAction());
        } else {
            dtde.rejectDrag();
        }
    }

    private boolean _acceptDrag(DropTargetDragEvent dtde) {
        DataFlavor[] flavors;
        if (this._canvas.isEnabled() && (flavors = dtde.getCurrentDataFlavors()) != null) {
            DBUITransferableProvider[] providers = DBUIDnDSupport.getDBUITransferableProviders();
            for (int i = 0; i < flavors.length; ++i) {
                if (TransferUtils.supportsDataFlavor((DataFlavor)flavors[i], (DataFlavor)DBUIDataFlavors.TABLE_FLAVOR) || TransferUtils.supportsDataFlavor((DataFlavor)flavors[i], (DataFlavor)DBUIDataFlavors.COLUMN_FLAVOR)) {
                    return true;
                }
                if (providers == null) continue;
                for (int j = 0; j < providers.length; ++j) {
                    if (!providers[j].isDBUIDataFlavorSupported(flavors[i], DBUIDataFlavors.TABLE_FLAVOR) && !providers[j].isDBUIDataFlavorSupported(flavors[i], DBUIDataFlavors.COLUMN_FLAVOR)) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

