/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.dbUI.viewBuilder;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import oracle.bali.dbUI.viewBuilder.ViewBuilderLinkPort;

public class ViewBuilderLink {
    public static final String PROPERTY_SELECTED = "selected";
    public static final String PROPERTY_ACTIVE = "active";
    private ViewBuilderLinkPort _source;
    private ViewBuilderLinkPort _destination;
    private ViewBuilderLinkPort[] _sources;
    private ViewBuilderLinkPort[] _destinations;
    private boolean _selected;
    private boolean _active;
    private PropertyChangeSupport _support;

    public ViewBuilderLink(ViewBuilderLinkPort source, ViewBuilderLinkPort destination) {
        if (source == null || destination == null) {
            throw new IllegalArgumentException();
        }
        this._source = source;
        this._destination = destination;
    }

    public ViewBuilderLink(ViewBuilderLinkPort[] sources, ViewBuilderLinkPort[] destinations) {
        if (sources == null || destinations == null || sources.length != destinations.length || sources.length == 0) {
            throw new IllegalArgumentException();
        }
        int count = sources.length;
        if (count == 1) {
            this._source = sources[0];
            this._destination = destinations[0];
        } else {
            this._sources = new ViewBuilderLinkPort[count];
            this._destinations = new ViewBuilderLinkPort[count];
            System.arraycopy(sources, 0, this._sources, 0, count);
            System.arraycopy(destinations, 0, this._destinations, 0, count);
        }
    }

    public int getPortCount() {
        return this._sources == null ? 1 : this._sources.length;
    }

    public ViewBuilderLinkPort getSourcePort(int index) {
        return this._sources == null ? this._source : this._sources[index];
    }

    public ViewBuilderLinkPort getDestinationPort(int index) {
        return this._destinations == null ? this._destination : this._destinations[index];
    }

    public void setSelected(boolean selected) {
        if (this._selected != selected) {
            this._selected = selected;
            this.fireBooleanPropertyChange(PROPERTY_SELECTED, this._selected);
        }
    }

    public boolean isSelected() {
        return this._selected;
    }

    public void setActive(boolean active) {
        if (this._active != active) {
            this._active = active;
            this.fireBooleanPropertyChange(PROPERTY_ACTIVE, this._active);
        }
    }

    public boolean isActive() {
        return this._active;
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        if (this._support == null) {
            this._support = new PropertyChangeSupport(this);
        }
        this._support.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        if (this._support != null) {
            this._support.removePropertyChangeListener(l);
        }
    }

    protected void fireBooleanPropertyChange(String propertyName, boolean newValue) {
        if (newValue) {
            this.firePropertyChange(propertyName, Boolean.FALSE, Boolean.TRUE);
        } else {
            this.firePropertyChange(propertyName, Boolean.TRUE, Boolean.FALSE);
        }
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (this._support != null) {
            this._support.firePropertyChange(propertyName, oldValue, newValue);
        }
    }
}

