/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.dbUI.viewBuilder;

import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import oracle.bali.dbUI.db.Column;
import oracle.bali.dbUI.db.DynamicRelationship;
import oracle.bali.dbUI.db.DynamicTable;
import oracle.bali.dbUI.db.OuterJoin;
import oracle.bali.dbUI.db.Relationship;
import oracle.bali.dbUI.db.Table;
import oracle.bali.dbUI.db.TableAlias;
import oracle.bali.dbUI.db.event.DynamicRelationshipEvent;
import oracle.bali.dbUI.db.event.DynamicRelationshipListener;
import oracle.bali.dbUI.db.event.DynamicTableAdapter;
import oracle.bali.dbUI.db.event.DynamicTableEvent;
import oracle.bali.dbUI.db.impl.DynamicRelationshipImpl;
import oracle.bali.dbUI.laf.DBUILookAndFeel;
import oracle.bali.dbUI.tableComponent.TableComponent;
import oracle.bali.dbUI.viewBuilder.AliasManager;
import oracle.bali.dbUI.viewBuilder.ColumnLinkPort;
import oracle.bali.dbUI.viewBuilder.JoinMaker;
import oracle.bali.dbUI.viewBuilder.RelationshipLink;
import oracle.bali.dbUI.viewBuilder.TableViewBuilderComponent;
import oracle.bali.dbUI.viewBuilder.VBOuterJoinListener;
import oracle.bali.dbUI.viewBuilder.VBRelationshipListener;
import oracle.bali.dbUI.viewBuilder.VBTableListener;
import oracle.bali.dbUI.viewBuilder.ViewBuilderCanvas;
import oracle.bali.dbUI.viewBuilder.ViewBuilderComponent;
import oracle.bali.dbUI.viewBuilder.ViewBuilderCustomizer;
import oracle.bali.dbUI.viewBuilder.ViewBuilderEvent;
import oracle.bali.dbUI.viewBuilder.ViewBuilderLink;
import oracle.bali.dbUI.viewBuilder.ViewBuilderLinkPort;
import oracle.bali.dbUI.viewBuilder.ViewBuilderValidateEvent;
import oracle.bali.dbUI.viewBuilder.swing.JInternalFrameTableComponent;
import oracle.bali.dbUI.viewBuilder.swing.JInternalFrameViewBuilderCanvas;
import oracle.bali.ewt.LWComponent;
import oracle.bali.ewt.grid.CellInputHandler;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.util.StringUtils;
import oracle.bali.share.event.ListenerManager;
import oracle.bali.share.nls.LocaleUtils;
import oracle.bali.share.thread.Task;
import oracle.bali.share.thread.TaskEvent;

public class ViewBuilder
extends LWComponent
implements Accessible {
    public static final String PROPERTY_SELECTED_COLUMNS = "selectedColumns";
    public static final String PROPERTY_SELECTED_TABLES = "selectedTables";
    public static final String PROPERTY_SELECTED_RELATIONSHIPS = "selectedRelationships";
    public static final String PROPERTY_INCLUDED_RELATIONSHIPS = "includedRelationships";
    private static final String _KEY_EQUAL = "VIEWBUILDER.EQUAL";
    private static final String _KEY_NOT_EQUAL = "VIEWBUILDER.NOT_EQUAL";
    private static final String _KEY_GREATER = "VIEWBUILDER.GREATER";
    private static final String _KEY_LESS = "VIEWBUILDER.LESS";
    private static final String _KEY_LESSEQUAL = "VIEWBUILDER.LESSEQUAL";
    private static final String _KEY_GREATEREQUAL = "VIEWBUILDER.GREATEREQUAL";
    private static final String _OPTIONS_KEY = "OPTIONS";
    private static final String _SHOW_RELATED_TABLES_KEY = "SHOW_RELATED_TABLES";
    private static final String _HIDE_RELATED_TABLES_KEY = "HIDE_RELATED_TABLES";
    private static final String _CREATE_OUTER_JOIN_KEY = "VIEWBUILDER.CREATE_OUTER_JOIN";
    private static final String _DELETE_OUTER_JOIN_KEY = "VIEWBUILDER.DELETE_OUTER_JOIN";
    private static final String _EQUAL_KEY = "EQUAL";
    private static final String _NOT_EQUAL_KEY = "NOT_EQUAL";
    private static final String _GREATER_KEY = "GREATER";
    private static final String _LESS_KEY = "LESS";
    private static final String _GREATER_OR_EQUAL_KEY = "GREATER_OR_EQUAL";
    private static final String _LESS_OR_EQUAL_KEY = "LESS_OR_EQUAL";
    private static final String _KEY_LINKTO = "VIEWBUILDER.LINK_TO";
    private static final String _KEY_DELETELINK = "VIEWBUILDER.DELETE_LINK";
    static final String TABLES_COMMAND = "tables";
    static final String HIDE_TABLES_COMMAND = "hide_tables";
    static final String EQUAL_COMMAND = "EQUAL";
    static final String NOT_EQUAL_COMMAND = "NOT_EQUAL";
    static final String GREATER_COMMAND = "GREATER";
    static final String LESS_COMMAND = "LESS";
    static final String GREATER_OR_EQUAL_COMMAND = "GREATER_OR_EQUAL";
    static final String LESS_OR_EQUAL_COMMAND = "LESS_OR_EQUAL";
    static final String COMMAND_LINK = "LINK";
    static final String COMMAND_DELETE_LINK = "DELETE_LINK";
    static final String COMMAND_CREATE_OUTER_JOIN = "CREATE_OUTER_JOIN";
    static final String COMMAND_DELETE_OUTER_JOIN = "DELETE_OUTER_JOIN";
    static final String COMMAND_LEFT = "LEFT";
    static final String COMMAND_RIGHT = "RIGHT";
    static final String COMMAND_DELETE = "DELETE";
    static final String COMMAND_TAB = "TAB";
    static final String COMMAND_SELECT = "SELECT";
    private static final String _KEY_CANVAS_NAME = "VIEWBUILDER_CANVAS_NAME";
    private static final String _ALL = "UPDATE_ALL";
    private static final String _COLUMNS = "UPDATE_COLUMNS";
    private ViewBuilderCanvas _canvas;
    private JScrollPane _scrollBox;
    private Listener _listener;
    private ViewBuilderCustomizer _customizer;
    private Vector _links;
    private Vector _tableInfo;
    private Vector _customComponents;
    private ListenerManager _tableListeners;
    private ListenerManager _columnListeners;
    private ListenerManager _relationshipListeners;
    private ListenerManager _outerJoinListeners;
    private Relationship _menuRelationship;
    private JPopupMenu _menu;
    private ViewBuilderLinkPort _startPort;
    private ViewBuilderLinkPort _lastPort;
    private int _anchorX;
    private int _anchorY;
    private int _joinX;
    private int _joinY;
    private Column _menuColumn;
    private boolean _linkCreationAllowed;
    private boolean _linkDeletionAllowed;
    private boolean _outerJoinCreationAllowed;
    private Vector _outerJoins;
    private AliasManager _aliasManager;
    private static final String _KEY_TABLE_ALIAS = "QUERYBUILDER.TABLE_ALIAS";
    private boolean _isTableAliasAllowed = false;

    public ViewBuilder() {
        this(null);
    }

    public ViewBuilder(Table[] tables) {
        this.setBackground(Color.white);
        this._tableInfo = new Vector();
        this._customComponents = new Vector();
        this._links = new Vector();
        this._listener = new Listener();
        this._linkCreationAllowed = true;
        this._linkDeletionAllowed = true;
        this._outerJoinCreationAllowed = true;
        this.setLayout(new BorderLayout());
        this._canvas = this.createViewBuilderCanvas();
        this._canvas.setViewBuilder(this);
        this._scrollBox = new JScrollPane(this._canvas.getComponent());
        this.add("Center", this._scrollBox);
        if (tables != null) {
            this.setTables(tables);
        }
        this.enableEvents(12L);
        KeyStroke s = KeyStroke.getKeyStroke(9, 0);
        this.registerKeyboardAction(this._listener, COMMAND_TAB, s, 1);
        s = KeyStroke.getKeyStroke(127, 0);
        this.registerKeyboardAction(this._listener, COMMAND_DELETE, s, 1);
        s = KeyStroke.getKeyStroke(8, 0);
        this.registerKeyboardAction(this._listener, COMMAND_DELETE, s, 1);
        s = KeyStroke.getKeyStroke(37, 0);
        this.registerKeyboardAction(this._listener, COMMAND_LEFT, s, 0);
        s = KeyStroke.getKeyStroke(32, 0);
        this.registerKeyboardAction(this._listener, COMMAND_SELECT, s, 0);
        s = KeyStroke.getKeyStroke(39, 0);
        this.registerKeyboardAction(this._listener, COMMAND_RIGHT, s, 0);
    }

    public boolean isTableVisible(Table table) {
        return this._getTableInfo(table) != null;
    }

    public void addTable(Table table) {
        this._addTable(table, -1, -1, false, true);
    }

    public boolean addTable(Table table, boolean sendTableEvents) {
        return this._addTable(table, -1, -1, sendTableEvents, true);
    }

    public void addTable(Table table, int x, int y) {
        this._addTable(table, x, y, false, true);
    }

    public boolean addTable(Table table, int x, int y, boolean sendTableEvents) {
        return this._addTable(table, x, y, sendTableEvents, true);
    }

    public void removeTable(Table table) {
        TableInfo info = this._getTableInfo(table);
        if (info == null) {
            return;
        }
        table = info.getTable();
        if (table instanceof DynamicTable) {
            DynamicTable dt = (DynamicTable)table;
            dt.removePropertyChangeListener(this._listener);
            dt.removeTableListener(this._listener);
        }
        this._removeLinks(info);
        TableComponent comp = info.getTableComponent();
        boolean selectionChanged = comp.getSelectedColumnCount() != 0;
        comp.setAllColumnsSelected(false);
        comp.removePropertyChangeListener(this._listener);
        comp.setTable(null);
        TableViewBuilderComponent component = info.getViewBuilderComponent();
        component.removePropertyChangeListener(this._listener);
        component.removeVetoableChangeListener(this._listener);
        this._tableInfo.removeElement(info);
        info.clear();
        component.close();
        component.setTableComponent(null);
        this.invalidate();
    }

    public void setTables(Table[] tables) {
        this.removeAll();
        if (tables != null) {
            for (int i = 0; i < tables.length; ++i) {
                Table table = tables[i];
                if (this._getTableInfo(table) != null) continue;
                this._createUI(table, -1, -1);
                this._checkForJoins(table, true);
            }
        }
    }

    public Table[] getTables() {
        int count = this._tableInfo.size();
        Table[] table = new Table[count];
        for (int i = 0; i < count; ++i) {
            table[i] = ((TableInfo)this._tableInfo.elementAt(i)).getTable();
        }
        return table;
    }

    public void addRelatedTables(Table table) {
        this._addRelatedTables(table, false);
    }

    public void setTableSelected(Table table, boolean selected) {
        TableInfo info = this._getTableInfo(table);
        if (info != null) {
            info.getViewBuilderComponent().setComponentSelected(selected);
        }
    }

    public boolean isTableSelected(Table table) {
        TableInfo info = this._getTableInfo(table);
        return info == null ? false : info.getViewBuilderComponent().isComponentSelected();
    }

    public Table[] getSelectedTables() {
        Vector<Table> tables = new Vector<Table>();
        int count = this._tableInfo.size();
        for (int i = 0; i < count; ++i) {
            TableInfo info = (TableInfo)this._tableInfo.elementAt(i);
            if (!info.getViewBuilderComponent().isComponentSelected()) continue;
            tables.addElement(info.getTable());
        }
        Object[] selected = new Table[tables.size()];
        if (tables.size() != 0) {
            tables.copyInto(selected);
        }
        return selected;
    }

    public Rectangle getTableBounds(Table table) {
        TableViewBuilderComponent frame = this.getComponent(table);
        return frame == null ? null : frame.getComponentBounds();
    }

    public void setTableBounds(Table table, Rectangle bounds) {
        TableViewBuilderComponent frame = this.getComponent(table);
        if (frame != null) {
            frame.setComponentBounds(bounds);
        }
    }

    public boolean isColumnSelected(Column column) {
        boolean selected = false;
        TableInfo info = this._getTableInfo(column.getTable());
        return info == null ? false : info.getTableComponent().isColumnSelected(column);
    }

    public void setColumnSelected(Column column, boolean selected) {
        Table table = column.getTable();
        TableInfo info = this._getTableInfo(table);
        if (info != null) {
            info.getTableComponent().setColumnSelected(column, selected);
        }
    }

    public Column[] getSelectedColumns() {
        Vector<Column> columns = new Vector<Column>();
        int tableCount = this._tableInfo.size();
        for (int i = 0; i < tableCount; ++i) {
            TableInfo info = (TableInfo)this._tableInfo.elementAt(i);
            TableComponent table = info.getTableComponent();
            Column[] temp = table.getSelectedColumns();
            if (temp == null || temp.length == 0) continue;
            columns.addAll(Arrays.asList(temp));
        }
        int size = columns.size();
        Object[] toReturn = new Column[size];
        if (size != 0) {
            columns.copyInto(toReturn);
        }
        return toReturn;
    }

    public void addRelationship(Relationship relationship) {
        if (this._getLink(relationship) != null) {
            return;
        }
        int count = relationship.getColumnCount();
        if (count <= 0) {
            throw new IllegalArgumentException("relationship is invalid");
        }
        Table childTable = relationship.getColumn(0).getTable();
        TableInfo childInfo = this._getTableInfo(childTable);
        if (childInfo == null) {
            throw new IllegalArgumentException(childTable + " must be added");
        }
        Table parentTable = relationship.getReferencedColumn(0).getTable();
        TableInfo parentInfo = this._getTableInfo(parentTable);
        if (parentInfo == null) {
            throw new IllegalArgumentException(parentTable + " table must be added");
        }
        if (relationship instanceof DynamicRelationship) {
            DynamicRelationship dr = (DynamicRelationship)relationship;
            dr.addPropertyChangeListener(this._listener);
            dr.addRelationshipListener(this._listener);
        }
        TableViewBuilderComponent childFrame = childInfo.getViewBuilderComponent();
        TableViewBuilderComponent parentFrame = parentInfo.getViewBuilderComponent();
        TableComponent childTableComponent = childInfo.getTableComponent();
        TableComponent parentTableComponent = parentInfo.getTableComponent();
        ColumnLinkPort[] sources = new ColumnLinkPort[count];
        ColumnLinkPort[] destinations = new ColumnLinkPort[count];
        for (int i = 0; i < count; ++i) {
            sources[i] = childFrame.getColumnLinkPort(relationship.getColumn(i));
            destinations[i] = parentFrame.getColumnLinkPort(relationship.getReferencedColumn(i));
        }
        RelationshipLink item = new RelationshipLink(sources, destinations, relationship);
        this._links.addElement(item);
        this.getCanvas().addViewBuilderLink(item);
        this._clearLinks();
        this._checkForOuterJoin(item, childInfo, parentInfo);
    }

    public void removeRelationship(Relationship relationship) {
        RelationshipLink link = this._getLink(relationship);
        if (link == null) {
            return;
        }
        if (relationship instanceof DynamicRelationship) {
            DynamicRelationship dr = (DynamicRelationship)relationship;
            dr.removePropertyChangeListener(this._listener);
            dr.removeRelationshipListener(this._listener);
        }
        if (this.isRelationshipSelected(relationship)) {
            this.setRelationshipSelected(relationship, false);
            this.firePropertyChange(PROPERTY_SELECTED_RELATIONSHIPS, null, this.getSelectedRelationships());
        }
        if (this.isRelationshipIncluded(relationship)) {
            this.setRelationshipIncluded(relationship, false);
        }
        this._links.removeElement(link);
        this.getCanvas().removeViewBuilderLink(link);
        this._clearLinks();
    }

    public Relationship[] getRelationships() {
        Vector<Relationship> found = new Vector<Relationship>();
        int count = this._links.size();
        for (int i = 0; i < count; ++i) {
            ViewBuilderLink link = (ViewBuilderLink)this._links.elementAt(i);
            if (!(link instanceof RelationshipLink)) continue;
            RelationshipLink rLink = (RelationshipLink)link;
            found.addElement(rLink.getRelationship());
        }
        count = found.size();
        Object[] relationships = new Relationship[count];
        if (count != 0) {
            found.copyInto(relationships);
        }
        return relationships;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRelationships(Relationship[] relationships) {
        this.freezeRepaints();
        try {
            int i;
            Relationship[] old = this.getRelationships();
            int count = old.length;
            for (i = 0; i < count; ++i) {
                this.removeRelationship(old[i]);
            }
            count = relationships == null ? 0 : relationships.length;
            for (i = 0; i < count; ++i) {
                this.addRelationship(relationships[i]);
            }
        }
        finally {
            this.unfreezeRepaints();
        }
    }

    public void setRelationshipSelected(Relationship relationship, boolean selected) {
        RelationshipLink link;
        AccessibleContext ac = this.accessibleContext;
        String oldName = null;
        if (ac != null) {
            oldName = ac.getAccessibleName();
        }
        if ((link = this._getLink(relationship)) == null) {
            return;
        }
        link.setSelected(selected);
        this._highlightJoin(relationship, selected);
        if (ac != null) {
            String newName = ac.getAccessibleName();
            ac.firePropertyChange("AccessibleName", oldName, newName);
        }
    }

    public boolean isRelationshipSelected(Relationship relationship) {
        RelationshipLink link = this._getLink(relationship);
        return link == null ? false : link.isSelected();
    }

    public Relationship[] getSelectedRelationships() {
        Vector<Relationship> temp = new Vector<Relationship>();
        int size = this._links.size();
        for (int i = 0; i < size; ++i) {
            ViewBuilderLink link = (ViewBuilderLink)this._links.elementAt(i);
            if (!link.isSelected() || !(link instanceof RelationshipLink)) continue;
            RelationshipLink rLink = (RelationshipLink)link;
            temp.addElement(rLink.getRelationship());
        }
        Object[] selected = new Relationship[temp.size()];
        if (temp.size() != 0) {
            temp.copyInto(selected);
        }
        return selected;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAllRelationshipsSelected(boolean selected) {
        Relationship[] relationships = this.getRelationships();
        this.freezeRepaints();
        try {
            int count = relationships.length;
            for (int i = 0; i < count; ++i) {
                this.setRelationshipSelected(relationships[i], selected);
            }
        }
        finally {
            this.unfreezeRepaints();
        }
    }

    public void setRelationshipIncluded(Relationship relationship, boolean included) {
        RelationshipLink link = this._getLink(relationship);
        if (link != null) {
            link.setIncluded(included);
            this.firePropertyChange(PROPERTY_INCLUDED_RELATIONSHIPS, null, this.getIncludedRelationships());
        }
    }

    public boolean isRelationshipIncluded(Relationship relationship) {
        RelationshipLink link = this._getLink(relationship);
        return link == null ? false : link.isIncluded();
    }

    public Relationship[] getIncludedRelationships() {
        Vector<Relationship> temp = new Vector<Relationship>();
        int size = this._links.size();
        for (int i = 0; i < size; ++i) {
            RelationshipLink rLink;
            ViewBuilderLink link = (ViewBuilderLink)this._links.elementAt(i);
            if (!(link instanceof RelationshipLink) || !(rLink = (RelationshipLink)link).isIncluded()) continue;
            temp.addElement(rLink.getRelationship());
        }
        Object[] included = new Relationship[temp.size()];
        if (temp.size() != 0) {
            temp.copyInto(included);
        }
        return included;
    }

    public final OuterJoin createOuterJoin(Table sourceTable, Table destinationTable) {
        OuterJoin j = new OuterJoin(sourceTable, destinationTable);
        this.addOuterJoin(j);
        return j;
    }

    public boolean isOuterJoinCreationAllowed() {
        return this._outerJoinCreationAllowed;
    }

    public void setOuterJoinCreationAllowed(boolean creationAllowed) {
        this._outerJoinCreationAllowed = creationAllowed;
    }

    public void addOuterJoin(OuterJoin outerJoin) {
        if (this._outerJoins == null) {
            this._outerJoins = new Vector(2);
        }
        if (this._indexOf(outerJoin) == -1) {
            this._outerJoins.addElement(outerJoin);
            TableInfo dest = this._getTableInfo(outerJoin.getDestination());
            TableInfo source = this._getTableInfo(outerJoin.getSource());
            if (dest != null && source != null) {
                ViewBuilderLink[] links = this._getLinks(dest);
                int count = links == null ? 0 : links.length;
                for (int i = 0; i < count; ++i) {
                    if (!(links[i] instanceof RelationshipLink)) continue;
                    RelationshipLink link = (RelationshipLink)links[i];
                    if (link.getDestinationPort(0).getViewBuilderComponent() == source.getViewBuilderComponent()) {
                        link.setDestinationOuterJoin(true);
                        continue;
                    }
                    if (link.getSourcePort(0).getViewBuilderComponent() != source.getViewBuilderComponent()) continue;
                    link.setSourceOuterJoin(true);
                }
            }
            this._sendOuterJoinEvent(outerJoin, 2008);
        }
    }

    public void removeOuterJoin(OuterJoin outerJoin) {
        int index;
        if (this._outerJoins != null && (index = this._indexOf(outerJoin)) != -1) {
            this._outerJoins.removeElementAt(index);
            TableInfo dest = this._getTableInfo(outerJoin.getDestination());
            TableInfo source = this._getTableInfo(outerJoin.getSource());
            if (dest != null) {
                ViewBuilderLink[] links = this._getLinks(dest);
                int count = links == null ? 0 : links.length;
                for (int i = 0; i < count; ++i) {
                    if (!(links[i] instanceof RelationshipLink)) continue;
                    RelationshipLink link = (RelationshipLink)links[i];
                    if (link.getDestinationPort(0).getViewBuilderComponent() == source.getViewBuilderComponent()) {
                        link.setDestinationOuterJoin(false);
                        continue;
                    }
                    if (link.getSourcePort(0).getViewBuilderComponent() != source.getViewBuilderComponent()) continue;
                    link.setSourceOuterJoin(false);
                }
            }
            this._sendOuterJoinEvent(outerJoin, 2009);
        }
    }

    public OuterJoin[] getOuterJoins() {
        if (this._outerJoins == null || this._outerJoins.size() == 0) {
            return null;
        }
        Object[] joins = new OuterJoin[this._outerJoins.size()];
        this._outerJoins.copyInto(joins);
        return joins;
    }

    public ViewBuilderCustomizer getCustomizer() {
        return this._customizer;
    }

    public void setCustomizer(ViewBuilderCustomizer customizer) {
        this._customizer = customizer;
    }

    public void setLinkCreationAllowed(boolean allowLinkCreation) {
        this._linkCreationAllowed = allowLinkCreation;
    }

    public boolean isLinkCreationAllowed() {
        return this._linkCreationAllowed;
    }

    public void setLinkDeletionAllowed(boolean allowLinkDeletion) {
        this._linkDeletionAllowed = allowLinkDeletion;
    }

    public boolean isLinkDeletionAllowed() {
        return this._linkDeletionAllowed;
    }

    public void addTableListener(VBTableListener listener) {
        if (this._tableListeners == null) {
            this._tableListeners = new ListenerManager();
        }
        this._tableListeners.addListener((EventListener)listener);
    }

    public void removeTableListener(VBTableListener listener) {
        if (this._tableListeners != null) {
            this._tableListeners.removeListener((EventListener)listener);
        }
    }

    public void addRelationshipListener(VBRelationshipListener listener) {
        if (this._relationshipListeners == null) {
            this._relationshipListeners = new ListenerManager();
        }
        this._relationshipListeners.addListener((EventListener)listener);
    }

    public void removeRelationshipListener(VBRelationshipListener listener) {
        if (this._relationshipListeners != null) {
            this._relationshipListeners.removeListener((EventListener)listener);
        }
    }

    public void addOuterJoinListener(VBOuterJoinListener listener) {
        if (this._outerJoinListeners == null) {
            this._outerJoinListeners = new ListenerManager();
        }
        this._outerJoinListeners.addListener((EventListener)listener);
    }

    public void removeOuterJoinListener(VBOuterJoinListener listener) {
        if (this._outerJoinListeners != null) {
            this._outerJoinListeners.removeListener((EventListener)listener);
        }
    }

    public ViewBuilderCanvas getCanvas() {
        return this._canvas;
    }

    public TableViewBuilderComponent getComponent(Table table) {
        TableInfo info = this._getTableInfo(table);
        return info == null ? null : info.getViewBuilderComponent();
    }

    public void addViewBuilderComponent(ViewBuilderComponent component) {
        if (this._customComponents.indexOf(component) == -1) {
            this.getCanvas().addComponent(component);
            component.addPropertyChangeListener(this._listener);
            component.addVetoableChangeListener(this._listener);
            this._customComponents.addElement(component);
        }
    }

    public void removeViewBuilderComponent(ViewBuilderComponent component) {
        int index = this._customComponents.indexOf(component);
        if (index != -1) {
            component.removePropertyChangeListener(this._listener);
            component.removeVetoableChangeListener(this._listener);
            this._removeCustomLinks(component);
            component.close();
            this._customComponents.removeElementAt(index);
        }
    }

    public void addViewBuilderLink(ViewBuilderLink link) {
        if (this._links.indexOf(link) == -1) {
            this._clearLinks();
            this._links.addElement(link);
            this.getCanvas().addViewBuilderLink(link);
        }
    }

    public void removeViewBuilderLink(ViewBuilderLink link) {
        int index = this._links.indexOf(link);
        if (index != -1) {
            this._clearLinks();
            this._links.removeElementAt(index);
            this.getCanvas().removeViewBuilderLink(link);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAllLinksSelected(boolean selected) {
        this.freezeRepaints();
        try {
            int count = this._links.size();
            for (int i = 0; i < count; ++i) {
                this.setLinkSelected((ViewBuilderLink)this._links.elementAt(i), selected);
            }
        }
        finally {
            this.unfreezeRepaints();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLinkSelected(ViewBuilderLink link, boolean selected) {
        if (link.isSelected() == selected) {
            return;
        }
        AccessibleContext ac = this.accessibleContext;
        String oldName = null;
        if (ac != null) {
            oldName = ac.getAccessibleName();
        }
        this.freezeRepaints();
        try {
            link.setSelected(selected);
            if (link instanceof RelationshipLink) {
                RelationshipLink rLink = (RelationshipLink)link;
                this._highlightJoin(rLink.getRelationship(), selected);
                this.firePropertyChange(PROPERTY_SELECTED_RELATIONSHIPS, null, this.getSelectedRelationships());
            }
            if (ac != null) {
                String newName = ac.getAccessibleName();
                ac.firePropertyChange("AccessibleName", oldName, newName);
            }
        }
        finally {
            this.unfreezeRepaints();
        }
    }

    public ViewBuilderLink[] getSelectedLinks() {
        Vector<ViewBuilderLink> temp = new Vector<ViewBuilderLink>();
        int size = this._links.size();
        for (int i = 0; i < size; ++i) {
            ViewBuilderLink link = (ViewBuilderLink)this._links.elementAt(i);
            if (!link.isSelected()) continue;
            temp.addElement(link);
        }
        Object[] selected = new ViewBuilderLink[temp.size()];
        if (temp.size() != 0) {
            temp.copyInto(selected);
        }
        return selected;
    }

    public ViewBuilderLink[] getLinks(ViewBuilderComponent comp) {
        Vector<ViewBuilderLink> links = new Vector<ViewBuilderLink>();
        int size = this._links.size();
        for (int i = 0; i < size; ++i) {
            ViewBuilderLink link = (ViewBuilderLink)this._links.elementAt(i);
            ViewBuilderLinkPort source = link.getSourcePort(0);
            ViewBuilderLinkPort dest = link.getDestinationPort(0);
            if (source.getViewBuilderComponent() != comp && dest.getViewBuilderComponent() != comp) continue;
            links.addElement(link);
        }
        Object[] array = null;
        size = links.size();
        if (size != 0) {
            array = new ViewBuilderLink[size];
            links.copyInto(array);
        }
        return array;
    }

    public void startLinkCreation(ViewBuilderLinkPort linkPort, int x, int y) {
        this._lastPort = null;
        this._startPort = linkPort;
        this._anchorX = x;
        this._anchorY = y;
        this._joinX = x;
        this._joinY = y;
        this._repaintFeedback();
    }

    public void continueLinkCreation(int x, int y) {
        ViewBuilderLinkPort linkPort = this._getLinkPortAt(x, y);
        if (linkPort != this._lastPort) {
            if (this._lastPort != null && this._lastPort != this._startPort) {
                this._lastPort.setHighlighted(false);
            }
            if (linkPort != null && linkPort != this._startPort && linkPort.getViewBuilderComponent() != this._startPort.getViewBuilderComponent()) {
                linkPort.setHighlighted(true);
            }
            this._lastPort = linkPort;
        }
        this._joinX = x;
        this._joinY = y;
        this._repaintFeedback();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finishLinkCreation(int x, int y) {
        this._anchorX = -1;
        this._anchorY = -1;
        if (this._lastPort != null) {
            this._lastPort.setHighlighted(false);
        }
        ViewBuilderLinkPort linkPort = this._getLinkPortAt(x, y);
        try {
            ViewBuilderLink link;
            if (linkPort != null && linkPort != this._startPort && linkPort.getViewBuilderComponent() != this._startPort.getViewBuilderComponent() && (link = this.createLink(this._startPort, linkPort)) != null) {
                this.addViewBuilderLink(link);
            }
        }
        finally {
            this._startPort = null;
            this._lastPort = null;
        }
        this.repaint();
    }

    public void showMenu(ViewBuilderLink link, int x, int y) {
        if (!(link instanceof RelationshipLink)) {
            return;
        }
        this._menuRelationship = ((RelationshipLink)link).getRelationship();
        this._createMenu();
        DBUILookAndFeel.getLookAndFeel().popupMenu((Component)((Object)this), this._menu, x, y);
    }

    public void displayPopupForColumn(Column column, int x, int y) {
        JMenuItem item;
        String menuName;
        MessageFormat form;
        String text;
        boolean allowCreate = this.isLinkCreationAllowed();
        boolean allowDelete = this.isLinkDeletionAllowed();
        if (!allowCreate && !allowDelete) {
            return;
        }
        Locale locale = this.getLocale();
        ResourceBundle b = ResourceBundle.getBundle("oracle.bali.dbUI.resource.DBUIBundle", locale);
        Table[] tables = this.getTables();
        this._menuColumn = column;
        JPopupMenu menu = new JPopupMenu();
        if (allowCreate) {
            text = b.getString(_KEY_LINKTO);
            form = new MessageFormat(text);
            Object[] args = new Object[]{column.getDisplayName(locale)};
            menuName = form.format(args);
            JMenu linkTo = new JMenu(menuName);
            menu.add(linkTo);
            if (tables.length > 1) {
                for (int i = 0; i < tables.length; ++i) {
                    Table table = tables[i];
                    if (this._tablesEqual(table, column.getTable())) continue;
                    JMenu tableMenu = new JMenu(table.getDisplayName(locale));
                    for (int j = 0; j < table.getColumnCount(); ++j) {
                        Column tempColumn = table.getColumn(j);
                        if (tempColumn == column) continue;
                        item = new JMenuItem(tempColumn.getDisplayName(locale));
                        item.setActionCommand(COMMAND_LINK + table.getSchema().getName() + "." + table.getName() + "." + tempColumn.getName());
                        item.addActionListener(this._listener);
                        tableMenu.add(item);
                    }
                    linkTo.add(tableMenu);
                }
            }
            linkTo.setEnabled(linkTo.getMenuComponentCount() != 0);
        }
        JMenu deleteMenu = null;
        if (allowDelete) {
            text = b.getString(_KEY_DELETELINK);
            form = new MessageFormat(text);
            Object[] args2 = new Object[]{column.getDisplayName(locale)};
            menuName = form.format(args2);
            deleteMenu = new JMenu(menuName);
            Relationship[] relationships = this.getRelationships();
            for (int i = 0; i < relationships.length; ++i) {
                Column match = null;
                Relationship r = relationships[i];
                for (int j = 0; j < r.getColumnCount(); ++j) {
                    Column child = r.getColumn(j);
                    Column parent = r.getReferencedColumn(j);
                    if (this._columnsEqual(column, child)) {
                        match = parent;
                    }
                    if (this._columnsEqual(column, parent)) {
                        match = child;
                    }
                    if (match == null || !this._isJoinRemovable(r)) continue;
                    item = new JMenuItem(match.getTable().getDisplayName(locale) + "." + match.getDisplayName(locale));
                    item.setActionCommand(COMMAND_DELETE_LINK + match.getTable().getSchema().getName() + "." + match.getTable().getName() + "." + match.getName());
                    item.addActionListener(this._listener);
                    deleteMenu.add(item);
                }
            }
        }
        if (allowDelete) {
            menu.add(deleteMenu);
            deleteMenu.setEnabled(deleteMenu.getMenuComponentCount() > 0);
        }
        DBUILookAndFeel.getLookAndFeel().popupMenu((Component)((Object)this), menu, x, y);
    }

    private boolean _columnsEqual(Column c1, Column c2) {
        if (c1 == c2) {
            return true;
        }
        return c1.getName().equals(c2.getName()) && c1.getTable().getName().equals(c2.getTable().getName()) && c1.getTable().getSchema().getName().equals(c2.getTable().getSchema().getName()) && c1.getTable().getSchema().getDatabase().getName().equals(c2.getTable().getSchema().getDatabase().getName());
    }

    private boolean _tablesEqual(Table t1, Table t2) {
        return t1.equals(t2);
    }

    public Dimension getDocumentSize(PaintContext context, Dictionary printProperties) {
        return this.getCanvas().getDocumentSize(context, printProperties);
    }

    public void printPage(PaintContext context, Dictionary printProperties, Graphics g) {
        this.getCanvas().printPage(context, printProperties, g);
    }

    public Rectangle getPageBounds(PaintContext context, Dictionary printProperties, int pageXOrigin, int pageYOrigin, int pageWidth, int pageHeight) {
        return this.getCanvas().getPageBounds(context, printProperties, pageXOrigin, pageYOrigin, pageWidth, pageHeight);
    }

    public void removeAll() {
        int i;
        int count = this._tableInfo.size();
        if (count != 0) {
            Object[] tables = new TableInfo[count];
            this._tableInfo.copyInto(tables);
            for (i = 0; i < count; ++i) {
                this.removeTable(((TableInfo)tables[i]).getTable());
            }
        }
        if ((count = this._customComponents.size()) != 0) {
            Object[] components = new ViewBuilderComponent[count];
            this._customComponents.copyInto(components);
            for (i = 0; i < count; ++i) {
                this.removeViewBuilderComponent((ViewBuilderComponent)components[i]);
            }
        }
    }

    public boolean isFocusTraversable() {
        return true;
    }

    public void doLayout() {
        Rectangle rect;
        ViewBuilderComponent component;
        int i;
        int count = this._tableInfo.size();
        for (i = 0; i < count; ++i) {
            TableInfo info = (TableInfo)this._tableInfo.elementAt(i);
            component = info.getViewBuilderComponent();
            rect = component.getComponentBounds();
            if (rect.width > 0 && rect.height > 0) continue;
            this._setComponentBounds(component, -1, -1);
        }
        count = this._customComponents.size();
        for (i = 0; i < count; ++i) {
            component = (ViewBuilderComponent)this._customComponents.elementAt(i);
            rect = component.getComponentBounds();
            if (rect.width > 0 && rect.height > 0) continue;
            this._setComponentBounds(component, -1, -1);
        }
        super.doLayout();
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this._scrollBox.setEnabled(enabled);
        this.getCanvas().setEnabled(enabled);
        if (enabled) {
            this.setBackground(Color.white);
        } else {
            this.setBackground(this.getUIDefaults().getColor("lightIntensity"));
        }
    }

    public void paintOverChildren(Graphics g) {
        super.paintOverChildren(g);
        this._paintFeedback(g);
    }

    public void scrollTableToView(Table table) {
        ViewBuilderCanvas canvas;
        Rectangle rect = this.getTableBounds(table);
        if (rect != null && (canvas = this.getCanvas()) instanceof JComponent) {
            ((JComponent)((Object)canvas)).scrollRectToVisible(rect);
        }
    }

    public void setTableAliasAllowed(boolean alias) {
        this._isTableAliasAllowed = alias;
    }

    public boolean isTableAliasAllowed() {
        return this._isTableAliasAllowed;
    }

    protected void processFocusEvent(FocusEvent e) {
        super.processFocusEvent(e);
        if (!this.isEnabled()) {
            return;
        }
        if (e.getID() == 1004) {
            if (this.getSelectedRelationships().length == 0) {
                Table[] tables = this.getSelectedTables();
                TableInfo info = null;
                if (tables.length != 0) {
                    info = this._getTableInfo(tables[0]);
                } else if (this._tableInfo.size() != 0) {
                    info = (TableInfo)this._tableInfo.firstElement();
                    this.setTableSelected(info.getTable(), true);
                }
                if (info != null) {
                    info.getTableComponent().getSpreadTable().requestFocus();
                }
            }
        } else {
            this.setAllRelationshipsSelected(false);
        }
    }

    protected void processEventImpl(AWTEvent event) {
        if (event instanceof ViewBuilderEvent) {
            switch (event.getID()) {
                case 2000: 
                case 2001: 
                case 2002: 
                case 2003: {
                    this.processTableEvent((ViewBuilderEvent)event);
                    break;
                }
                case 2004: 
                case 2005: 
                case 2006: 
                case 2007: {
                    this.processRelationshipEvent((ViewBuilderEvent)event);
                    break;
                }
                case 2008: 
                case 2009: {
                    this.processOuterJoinEvent((ViewBuilderEvent)event);
                    break;
                }
            }
        } else {
            super.processEventImpl(event);
        }
    }

    protected void processTableEvent(ViewBuilderEvent e) {
        if (this._tableListeners == null) {
            return;
        }
        Enumeration listeners = this._tableListeners.getListeners();
        if (listeners == null) {
            return;
        }
        switch (e.getID()) {
            case 2000: {
                while (listeners.hasMoreElements()) {
                    ((VBTableListener)listeners.nextElement()).tableAdding(e);
                }
                break;
            }
            case 2001: {
                while (listeners.hasMoreElements()) {
                    ((VBTableListener)listeners.nextElement()).tableAdded(e);
                }
                break;
            }
            case 2002: {
                while (listeners.hasMoreElements()) {
                    ((VBTableListener)listeners.nextElement()).tableRemoving(e);
                }
                break;
            }
            case 2003: {
                Table t = e.getTable();
                if (t instanceof TableAlias && this._aliasManager != null) {
                    this._aliasManager.removeAlias((TableAlias)t);
                }
                while (listeners.hasMoreElements()) {
                    ((VBTableListener)listeners.nextElement()).tableRemoved(e);
                }
                break;
            }
        }
    }

    protected void processRelationshipEvent(ViewBuilderEvent e) {
        if (this._relationshipListeners == null) {
            return;
        }
        Enumeration listeners = this._relationshipListeners.getListeners();
        if (listeners == null) {
            return;
        }
        switch (e.getID()) {
            case 2004: {
                while (listeners.hasMoreElements()) {
                    ((VBRelationshipListener)listeners.nextElement()).relationshipAdding(e);
                }
                break;
            }
            case 2005: {
                while (listeners.hasMoreElements()) {
                    ((VBRelationshipListener)listeners.nextElement()).relationshipAdded(e);
                }
                break;
            }
            case 2006: {
                while (listeners.hasMoreElements()) {
                    ((VBRelationshipListener)listeners.nextElement()).relationshipRemoving(e);
                }
                break;
            }
            case 2007: {
                while (listeners.hasMoreElements()) {
                    ((VBRelationshipListener)listeners.nextElement()).relationshipRemoved(e);
                }
                break;
            }
        }
    }

    protected void processOuterJoinEvent(ViewBuilderEvent e) {
        if (this._outerJoinListeners == null) {
            return;
        }
        Enumeration listeners = this._outerJoinListeners.getListeners();
        if (listeners == null) {
            return;
        }
        switch (e.getID()) {
            case 2008: {
                while (listeners.hasMoreElements()) {
                    ((VBOuterJoinListener)listeners.nextElement()).outerJoinAdded(e);
                }
                break;
            }
            case 2009: {
                while (listeners.hasMoreElements()) {
                    ((VBOuterJoinListener)listeners.nextElement()).outerJoinRemoved(e);
                }
                break;
            }
        }
    }

    protected JMenuBar getDefaultMenuBar(Table table, Locale locale) {
        ResourceBundle b = ResourceBundle.getBundle("oracle.bali.dbUI.resource.DBUIBundle", locale);
        TableAction action = new TableAction(table);
        String text = b.getString(_OPTIONS_KEY);
        JMenu optionsMenu = new JMenu(StringUtils.stripMnemonic((String)text));
        optionsMenu.setMnemonic(StringUtils.getMnemonicKeyCode((String)text));
        JMenuItem item = new JMenuItem(b.getString(_SHOW_RELATED_TABLES_KEY));
        item.setActionCommand(TABLES_COMMAND);
        item.addActionListener(action);
        optionsMenu.add(item);
        item = new JMenuItem(b.getString(_HIDE_RELATED_TABLES_KEY));
        item.setActionCommand(HIDE_TABLES_COMMAND);
        item.addActionListener(action);
        optionsMenu.add(item);
        if (this.isOuterJoinCreationAllowed()) {
            optionsMenu.getPopupMenu().addPopupMenuListener(action);
            text = b.getString(_CREATE_OUTER_JOIN_KEY);
            MessageFormat form = new MessageFormat(text);
            Object[] args = new Object[]{table.getDisplayName(locale)};
            String menuName = form.format(args);
            JMenu createOuterJoinMenu = new JMenu(menuName);
            createOuterJoinMenu.setActionCommand(COMMAND_CREATE_OUTER_JOIN);
            optionsMenu.add(createOuterJoinMenu);
            text = b.getString(_DELETE_OUTER_JOIN_KEY);
            form = new MessageFormat(text);
            Object[] args2 = new Object[]{table.getDisplayName(locale)};
            menuName = form.format(args2);
            JMenu deleteOuterJoinMenu = new JMenu(menuName);
            deleteOuterJoinMenu.setActionCommand(COMMAND_DELETE_OUTER_JOIN);
            optionsMenu.add(deleteOuterJoinMenu);
        }
        JMenuBar bar = new JMenuBar();
        bar.add(optionsMenu);
        return bar;
    }

    protected ViewBuilderCanvas createViewBuilderCanvas() {
        return new JInternalFrameViewBuilderCanvas();
    }

    protected TableViewBuilderComponent createViewBuilderComponent() {
        return new JInternalFrameTableComponent();
    }

    protected ViewBuilderLink createLink(ViewBuilderLinkPort source, ViewBuilderLinkPort destination) {
        if (!(source instanceof ColumnLinkPort) || !(destination instanceof ColumnLinkPort)) {
            return this.createCustomLink(source, destination);
        }
        Column sourceColumn = ((ColumnLinkPort)source).getColumn();
        Column destColumn = ((ColumnLinkPort)destination).getColumn();
        this._createRelationship(sourceColumn, destColumn);
        return null;
    }

    protected ViewBuilderLink createCustomLink(ViewBuilderLinkPort source, ViewBuilderLinkPort dest) {
        return new ViewBuilderLink(source, dest);
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleViewBuilder();
        }
        return this.accessibleContext;
    }

    private void _selectionChanged(Table table, Object oldColumns, Object newColumns) {
        boolean sendEvent = this._updateIncludedJoins(table);
        this.firePropertyChange(PROPERTY_SELECTED_COLUMNS, oldColumns, newColumns);
        if (sendEvent) {
            this.firePropertyChange(PROPERTY_INCLUDED_RELATIONSHIPS, null, this.getIncludedRelationships());
        }
    }

    private void _deleteSelectedComponents() {
        Table[] tables = this.getSelectedTables();
        for (int i = 0; i < tables.length; ++i) {
            Table table = tables[i];
            if (!this._sendTableValidateEvent(table, 2002)) continue;
            this.removeTable(table);
            this._sendTableEvent(table, 2003);
        }
        int count = this._customComponents.size();
        Object[] comps = new ViewBuilderComponent[count];
        this._customComponents.copyInto(comps);
        for (int i = 0; i < count; ++i) {
            if (!comps[i].isComponentSelected()) continue;
            this.removeViewBuilderComponent((ViewBuilderComponent)comps[i]);
        }
    }

    private TableInfo _getTableInfo(ViewBuilderComponent source) {
        int count = this._tableInfo.size();
        for (int i = 0; i < count; ++i) {
            TableInfo info = (TableInfo)this._tableInfo.elementAt(i);
            if (info.getViewBuilderComponent() != source) continue;
            return info;
        }
        return null;
    }

    private TableInfo _getTableInfo(TableComponent source) {
        int count = this._tableInfo.size();
        for (int i = 0; i < count; ++i) {
            TableInfo info = (TableInfo)this._tableInfo.elementAt(i);
            if (info.getTableComponent() != source) continue;
            return info;
        }
        return null;
    }

    private TableInfo _getTableInfo(Table source) {
        int count = this._tableInfo.size();
        String name = source.getName();
        for (int i = 0; i < count; ++i) {
            TableInfo info = (TableInfo)this._tableInfo.elementAt(i);
            if (info.getTable() == source) {
                return info;
            }
            if (!this._tablesEqual(info.getTable(), source)) continue;
            return info;
        }
        return null;
    }

    private void _closeComponent(ViewBuilderComponent source) {
        TableInfo info = this._getTableInfo(source);
        if (info != null) {
            Table table = info.getTable();
            this.removeTable(table);
            this._sendTableEvent(table, 2003);
        } else {
            this.removeViewBuilderComponent(source);
        }
        this.validate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _activateJoins(ViewBuilderComponent source, Boolean active) {
        TableInfo info = this._getTableInfo(source);
        ViewBuilderLink[] links = info == null ? this.getLinks(source) : this._getLinks(info);
        this.freezeRepaints();
        boolean sendJoinEvent = false;
        try {
            if (Boolean.TRUE.equals(active)) {
                sendJoinEvent = this.getSelectedRelationships().length != 0;
                this.setAllLinksSelected(false);
            }
            int count = links == null ? 0 : links.length;
            for (int i = 0; i < count; ++i) {
                ViewBuilderLink link = links[i];
                ViewBuilderComponent parent = link.getSourcePort(0).getViewBuilderComponent();
                ViewBuilderComponent child = link.getDestinationPort(0).getViewBuilderComponent();
                boolean reallyActive = parent.isComponentSelected() || child.isComponentSelected();
                link.setActive(reallyActive);
            }
        }
        finally {
            this.unfreezeRepaints();
        }
        if (sendJoinEvent) {
            this.firePropertyChange(PROPERTY_SELECTED_RELATIONSHIPS, null, this.getSelectedRelationships());
        }
        this.firePropertyChange(PROPERTY_SELECTED_TABLES, null, this.getSelectedTables());
    }

    private boolean _tryClose(ViewBuilderComponent source) {
        TableInfo info = this._getTableInfo(source);
        if (info == null) {
            return true;
        }
        return this._sendTableValidateEvent(info.getTable(), 2002);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _createUI(Table table, int x, int y) {
        this.freezeRepaints();
        try {
            TableComponent c = new TableComponent(table);
            c.addPropertyChangeListener(this._listener);
            if (table instanceof DynamicTable) {
                DynamicTable dt = (DynamicTable)table;
                dt.addPropertyChangeListener(this._listener);
                dt.addTableListener(this._listener);
            }
            TableViewBuilderComponent component = this.createViewBuilderComponent();
            component.addPropertyChangeListener(this._listener);
            component.addVetoableChangeListener(this._listener);
            component.setTableComponent(c);
            c.setCellInputHandler((CellInputHandler)new JoinMaker(this, component));
            TableInfo info = new TableInfo(table, c, component);
            this._tableInfo.addElement(info);
            this._customizeTable(table, c, component, _ALL);
            ViewBuilderCanvas canvas = this.getCanvas();
            canvas.addComponent(component);
            this._setComponentBounds(component, x, y);
            component.setVisible(true);
            component.setComponentSelected(true);
            component.setEnabled(this.isEnabled());
            c.invalidate();
            c.validate();
            c.getSpreadTable().requestFocus();
            canvas.setSelectedComponent(component);
        }
        finally {
            this.unfreezeRepaints();
        }
    }

    private void _validateScrollBox() {
        this.getCanvas().getComponent().invalidate();
        this._scrollBox.validate();
    }

    private void _checkForJoins(Table newTable, boolean sendEvent) {
        Table parentTable;
        int columnCount;
        Relationship key;
        int keyCount;
        String name = newTable.getName();
        int count = this._tableInfo.size();
        for (int j = 0; j < count; ++j) {
            TableInfo info = (TableInfo)this._tableInfo.elementAt(j);
            Table table = info.getTable();
            if (table.getName().equals(name) || (keyCount = table.getForeignKeyCount()) == 0) continue;
            for (int i = 0; i < keyCount; ++i) {
                key = table.getForeignKey(i);
                if (this._getLink(key) != null) continue;
                columnCount = key.getColumnCount();
                parentTable = key.getReferencedColumn(0).getTable();
                if (!parentTable.getName().equals(name) || sendEvent && !this._sendJoinValidateEvent(key, 2004)) continue;
                this.addRelationship(key);
                if (!sendEvent) continue;
                this._sendJoinEvent(key, 2005);
            }
        }
        keyCount = newTable.getForeignKeyCount();
        if (keyCount != 0) {
            for (int i = 0; i < keyCount; ++i) {
                key = newTable.getForeignKey(i);
                if (this._getLink(key) != null) continue;
                columnCount = key.getColumnCount();
                parentTable = key.getReferencedColumn(0).getTable();
                if (this._getTableInfo(parentTable) == null || sendEvent && !this._sendJoinValidateEvent(key, 2004)) continue;
                this.addRelationship(key);
                if (!sendEvent) continue;
                this._sendJoinEvent(key, 2005);
            }
        }
    }

    private void _setMenuJoinType(int type) {
        if (this._menuRelationship instanceof DynamicRelationship) {
            ((DynamicRelationship)this._menuRelationship).setRelationshipType(type);
            this.repaint();
        }
    }

    private void _customizeTable(Table table, String type) {
        TableInfo info = this._getTableInfo(table);
        this._customizeTable(table, info.getTableComponent(), info.getViewBuilderComponent(), type);
    }

    private void _updateRelationship(Relationship relationship) {
        this.repaint();
    }

    private void _updateRelationships(Table table, Relationship key, boolean added) {
        TableInfo info = this._getTableInfo(table);
        if (info == null) {
            return;
        }
        if (added) {
            this.addRelationship(key);
        } else {
            this.removeRelationship(key);
        }
    }

    private void _updateRelationships(Table table, Column column) {
        TableInfo info = this._getTableInfo(table);
        if (info == null) {
            return;
        }
        ViewBuilderLink[] links = this._getLinks(info);
        int count = links == null ? 0 : links.length;
        for (int i = 0; i < count; ++i) {
            boolean remove = false;
            ViewBuilderLink link = links[i];
            int portCount = link.getPortCount();
            for (int j = 0; j < count; ++j) {
                ColumnLinkPort columnPort;
                ViewBuilderLinkPort sourcePort = link.getSourcePort(j);
                ViewBuilderLinkPort destPort = link.getDestinationPort(j);
                if (sourcePort instanceof ColumnLinkPort && (columnPort = (ColumnLinkPort)sourcePort).getColumn() == column) {
                    remove = true;
                    break;
                }
                if (!(destPort instanceof ColumnLinkPort) || (columnPort = (ColumnLinkPort)destPort).getColumn() != column) continue;
                remove = true;
                break;
            }
            if (!remove) continue;
            if (link instanceof RelationshipLink) {
                RelationshipLink rLink = (RelationshipLink)link;
                this.removeRelationship(rLink.getRelationship());
                continue;
            }
            this.removeViewBuilderLink(link);
        }
    }

    private void _addRelatedTables(Table original, boolean sendEvents) {
        this.freezeRepaints();
        try {
            this._addTable(original, -1, -1, sendEvents, false);
            this._tryAddForeignKeys(original, sendEvents);
            this._tryAddExportedKeys(original, sendEvents);
            this.validate();
            this.repaint();
        }
        finally {
            this.unfreezeRepaints();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _hideRelatedTables(Table original) {
        this.freezeRepaints();
        try {
            Table table;
            Relationship key;
            int i;
            int keyCount = original.getForeignKeyCount();
            for (i = 0; i < keyCount; ++i) {
                key = original.getForeignKey(i);
                table = key.getReferencedColumn(0).getTable();
                if (this._tablesEqual(table, original)) continue;
                this.removeTable(table);
            }
            keyCount = original.getExportedKeyCount();
            for (i = 0; i < keyCount; ++i) {
                key = original.getExportedKey(i);
                table = key.getColumn(0).getTable();
                if (this._tablesEqual(table, original)) continue;
                this.removeTable(table);
            }
            this.validate();
            this.repaint();
        }
        finally {
            this.unfreezeRepaints();
        }
    }

    private void _tryAddForeignKeys(Table original, boolean sendEvents) {
        int keyCount = original.getForeignKeyCount();
        if (keyCount == 0) {
            return;
        }
        for (int i = 0; i < keyCount; ++i) {
            Relationship key = original.getForeignKey(i);
            Table table = key.getReferencedColumn(0).getTable();
            if (!this._addTable(table, -1, -1, sendEvents, false) || sendEvents && !this._sendJoinValidateEvent(key, 2004)) continue;
            this.addRelationship(key);
            if (!sendEvents) continue;
            this._sendJoinEvent(key, 2005);
        }
    }

    private void _tryAddExportedKeys(Table original, boolean sendEvents) {
        int keyCount = original.getExportedKeyCount();
        if (keyCount == 0) {
            return;
        }
        for (int i = 0; i < keyCount; ++i) {
            Relationship key = original.getExportedKey(i);
            Table table = key.getColumn(0).getTable();
            if (!this._addTable(table, -1, -1, sendEvents, false) || sendEvents && !this._sendJoinValidateEvent(key, 2004)) continue;
            this.addRelationship(key);
            if (!sendEvents) continue;
            this._sendJoinEvent(key, 2005);
        }
    }

    private boolean _addTable(Table table, int x, int y, boolean sendTableEvents, boolean scrollTable) {
        boolean isTableExist;
        boolean bl = isTableExist = this._getTableInfo(table) != null;
        if (isTableExist && this.isTableAliasAllowed() && !(table instanceof TableAlias)) {
            if (this._aliasManager == null) {
                this._aliasManager = new AliasManager();
            }
            String name = this._aliasManager.getAliasName(table);
            Locale l = LocaleUtils.getDefaultableLocale((Component)((Object)this));
            ResourceBundle b = ResourceBundle.getBundle("oracle.bali.dbUI.resource.DBUIBundle", l);
            String text = b.getString(_KEY_TABLE_ALIAS);
            MessageFormat form = new MessageFormat(text);
            Object[] args = new Object[]{table.getDisplayName(l), name};
            String displayName = form.format(args);
            table = new TableAlias(table, name, displayName);
            isTableExist = false;
        }
        if (!isTableExist) {
            if (sendTableEvents && !this._sendTableValidateEvent(table, 2000)) {
                return false;
            }
            this._createUI(table, x, y);
            this._checkForJoins(table, true);
            if (sendTableEvents) {
                this._sendTableEvent(table, 2001);
            }
        }
        if (scrollTable) {
            this.scrollTableToView(table);
        }
        return true;
    }

    private RelationshipLink _getLink(Relationship r) {
        int count = this._links.size();
        for (int i = 0; i < count; ++i) {
            RelationshipLink rLink;
            ViewBuilderLink link = (ViewBuilderLink)this._links.elementAt(i);
            if (!(link instanceof RelationshipLink) || !this._keysEqual((rLink = (RelationshipLink)link).getRelationship(), r)) continue;
            return rLink;
        }
        return null;
    }

    private boolean _keysEqual(Relationship key1, Relationship key2) {
        int count2;
        int count1 = key1.getColumnCount();
        if (count1 != (count2 = key2.getColumnCount())) {
            return false;
        }
        for (int i = 0; i < count1; ++i) {
            Column column2;
            Column column1 = key1.getColumn(i);
            if (!this._columnsEqual(column1, column2 = key2.getColumn(i))) {
                return false;
            }
            column1 = key1.getReferencedColumn(i);
            if (this._columnsEqual(column1, column2 = key2.getReferencedColumn(i))) continue;
            return false;
        }
        return true;
    }

    private void _includeLinks(ViewBuilderLink[] links) {
        for (int i = 0; i < links.length; ++i) {
            ViewBuilderLink link = links[i];
            if (!(link instanceof RelationshipLink)) continue;
            RelationshipLink rLink = (RelationshipLink)link;
            boolean included = !rLink.isIncluded();
            this.setRelationshipIncluded(rLink.getRelationship(), included);
        }
    }

    private void _deleteLinks(ViewBuilderLink[] links) {
        for (int i = 0; i < links.length; ++i) {
            ViewBuilderLink link = links[i];
            if (!(link instanceof RelationshipLink)) {
                this.removeViewBuilderLink(link);
                continue;
            }
            RelationshipLink rLink = (RelationshipLink)link;
            Relationship relationship = rLink.getRelationship();
            this._deleteRelationship(relationship);
        }
    }

    private void _deleteRelationship(Relationship relationship) {
        if (this._isJoinRemovable(relationship) && this._sendJoinValidateEvent(relationship, 2006)) {
            this.removeRelationship(relationship);
            this._sendJoinEvent(relationship, 2007);
            Table table = this._getTableFromForeignKey(relationship);
            if (table != null && table instanceof DynamicTable) {
                ((DynamicTable)table).removeForeignKey(relationship);
            }
        }
    }

    private boolean _isJoinRemovable(Relationship relationship) {
        Table table = this._getTableFromForeignKey(relationship);
        return table == null ? true : table instanceof DynamicTable;
    }

    private Table _getTableFromForeignKey(Relationship r) {
        int count = this._tableInfo.size();
        for (int i = 0; i < count; ++i) {
            TableInfo info = (TableInfo)this._tableInfo.elementAt(i);
            Table table = info.getTable();
            int keyCount = table.getForeignKeyCount();
            if (keyCount == 0) continue;
            for (int j = 0; j < keyCount; ++j) {
                if (!this._keysEqual(r, table.getForeignKey(j))) continue;
                return table;
            }
        }
        return null;
    }

    private ViewBuilderLinkPort _getLinkPortAt(int x, int y) {
        ViewBuilderCanvas canvas = this.getCanvas();
        Point p = SwingUtilities.convertPoint((Component)((Object)this), x, y, canvas.getComponent());
        ViewBuilderComponent component = canvas.getViewBuilderComponentAt(p.x, p.y);
        if (component == null) {
            return null;
        }
        Rectangle rect = component.getComponentBounds();
        return component.getLinkPortAt(p.x - rect.x, p.y - rect.y);
    }

    private void _repaintFeedback() {
        if (this._anchorX == -1 || this._anchorY == -1) {
            return;
        }
        this.paintImmediately(0, 0, this.getWidth(), this.getHeight());
    }

    private void _paintFeedback(Graphics g) {
        if (this._anchorX == -1 || this._anchorY == -1) {
            return;
        }
        g.setColor(Color.black);
        g.drawLine(this._anchorX, this._anchorY, this._joinX, this._joinY);
    }

    private void _highlightJoin(Relationship key, boolean highlight) {
        int columnCount = key.getColumnCount();
        for (int i = 0; i < columnCount; ++i) {
            Column column = key.getColumn(i);
            TableInfo info = this._getTableInfo(column.getTable());
            TableComponent component = info.getTableComponent();
            component.setColumnHighlighted(column, highlight);
            column = key.getReferencedColumn(i);
            info = this._getTableInfo(column.getTable());
            component = info.getTableComponent();
            component.setColumnHighlighted(column, highlight);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _removeLinks(TableInfo info) {
        ViewBuilderLink[] links = this._getLinks(info);
        if (links == null) {
            return;
        }
        this.freezeRepaints();
        try {
            for (int i = 0; i < links.length; ++i) {
                ViewBuilderLink link = links[i];
                if (link instanceof RelationshipLink) {
                    RelationshipLink rLink = (RelationshipLink)link;
                    Relationship r = rLink.getRelationship();
                    this.removeRelationship(r);
                    this._sendJoinEvent(r, 2007);
                    continue;
                }
                this.removeViewBuilderLink(link);
            }
        }
        finally {
            this.unfreezeRepaints();
        }
    }

    private void _clearLinks() {
        int count = this._tableInfo.size();
        for (int i = 0; i < count; ++i) {
            TableInfo info = (TableInfo)this._tableInfo.elementAt(i);
            info.setLinks(null);
        }
    }

    private ViewBuilderLink[] _getLinks(TableInfo info) {
        ViewBuilderLink[] array = info.getLinks();
        if (array == null) {
            array = this.getLinks(info.getViewBuilderComponent());
            info.setLinks(array);
        }
        return array;
    }

    private void _setComponentBounds(ViewBuilderComponent component, int x, int y) {
        if (!this.isDisplayable()) {
            return;
        }
        component.pack();
        Container canvas = (Container)this.getCanvas().getComponent();
        Rectangle compRect = component.getComponentBounds();
        if (x >= 0 && y >= 0) {
            compRect.setLocation(SwingUtilities.convertPoint((Component)((Object)this), x, y, canvas));
        } else {
            boolean done = false;
            int minHeight = 0;
            int maxWidth = canvas.getWidth();
            Component[] comps = canvas.getComponents();
            compRect.x = 10;
            compRect.y = 10;
            block0: while (!done) {
                done = true;
                for (int i = 0; i < comps.length; ++i) {
                    Rectangle currBounds = comps[i].getBounds();
                    if (component == comps[i] || !compRect.intersects(currBounds)) continue;
                    done = false;
                    minHeight = minHeight == 0 ? currBounds.y + currBounds.height : Math.min(minHeight, currBounds.y + currBounds.height);
                    compRect.x += currBounds.width + 20;
                    if (compRect.x + compRect.width <= maxWidth) continue block0;
                    compRect.x = 10;
                    compRect.y = minHeight + 20;
                    minHeight = 0;
                    continue block0;
                }
            }
        }
        component.setComponentBounds(compRect);
    }

    private void _sendTableEvent(Table table, int id) {
        ViewBuilderEvent e = new ViewBuilderEvent(this, id, table);
        this.processEvent(e);
    }

    private boolean _sendTableValidateEvent(Table table, int id) {
        ViewBuilderValidateEvent e = new ViewBuilderValidateEvent(this, id, table);
        this.processEvent(e);
        return !e.isCancelled();
    }

    private void _sendJoinEvent(Relationship join, int id) {
        ViewBuilderEvent e = new ViewBuilderEvent(this, id, join);
        this.processEvent(e);
    }

    private void _sendOuterJoinEvent(OuterJoin join, int id) {
        ViewBuilderEvent e = new ViewBuilderEvent(this, id, join);
        this.processEvent(e);
    }

    private boolean _sendJoinValidateEvent(Relationship join, int id) {
        ViewBuilderValidateEvent e = new ViewBuilderValidateEvent(this, id, join);
        this.processEvent(e);
        return !e.isCancelled();
    }

    private void _deleteRelationship(Column sourceColumn, Column destColumn) {
        Relationship[] relationships = this.getRelationships();
        for (int i = 0; i < relationships.length; ++i) {
            Relationship r = relationships[i];
            for (int j = 0; j < r.getColumnCount(); ++j) {
                Column child = r.getColumn(j);
                Column parent = r.getReferencedColumn(j);
                if (!this._columnsEqual(sourceColumn, child) || !this._columnsEqual(destColumn, parent)) continue;
                this._deleteRelationship(r);
            }
        }
    }

    private void _createRelationship(Column sourceColumn, Column destColumn) {
        Table sourceTable = sourceColumn.getTable();
        DynamicRelationshipImpl key = new DynamicRelationshipImpl(sourceColumn, destColumn, null);
        if (this._getLink(key) != null) {
            return;
        }
        DynamicRelationshipImpl inverse = new DynamicRelationshipImpl(destColumn, sourceColumn, null);
        if (this._getLink(inverse) != null) {
            return;
        }
        if (this._sendJoinValidateEvent(key, 2004)) {
            if (sourceTable instanceof DynamicTable) {
                DynamicTable dt = (DynamicTable)sourceTable;
                dt.addForeignKey(key, dt.getForeignKeyCount());
            } else {
                this.addRelationship(key);
            }
            this._sendJoinEvent(key, 2005);
        }
        if (this._updateIncludedJoins(destColumn.getTable()) || this._updateIncludedJoins(sourceTable)) {
            this.firePropertyChange(PROPERTY_INCLUDED_RELATIONSHIPS, null, this.getIncludedRelationships());
        }
    }

    private void _createMenu() {
        this._menu = new JPopupMenu();
        ResourceBundle b = ResourceBundle.getBundle("oracle.bali.dbUI.resource.DBUIBundle", LocaleUtils.getDefaultableLocale((Component)((Object)this)));
        if (!(this._menuRelationship instanceof DynamicRelationship)) {
            int type = this._menuRelationship.getRelationshipType();
            String name = null;
            String command = null;
            switch (type) {
                case 0: {
                    name = b.getString("EQUAL");
                    command = "EQUAL";
                    break;
                }
                case 1: {
                    name = b.getString("NOT_EQUAL");
                    command = "NOT_EQUAL";
                    break;
                }
                case 2: {
                    name = b.getString("GREATER");
                    command = "GREATER";
                    break;
                }
                case 3: {
                    name = b.getString("LESS");
                    command = "LESS";
                    break;
                }
                case 5: {
                    name = b.getString("GREATER_OR_EQUAL");
                    command = "GREATER_OR_EQUAL";
                    break;
                }
                case 4: {
                    name = b.getString("LESS_OR_EQUAL");
                    command = "LESS_OR_EQUAL";
                }
            }
            if (name != null) {
                JMenuItem item = new JMenuItem(name);
                item.setActionCommand(command);
                item.addActionListener(this._listener);
                this._menu.add(item);
            }
        } else {
            JMenuItem item = new JMenuItem(b.getString("EQUAL"));
            item.setActionCommand("EQUAL");
            item.addActionListener(this._listener);
            this._menu.add(item);
            item = new JMenuItem(b.getString("NOT_EQUAL"));
            item.setActionCommand("NOT_EQUAL");
            item.addActionListener(this._listener);
            this._menu.add(item);
            item = new JMenuItem(b.getString("GREATER"));
            item.setActionCommand("GREATER");
            item.addActionListener(this._listener);
            this._menu.add(item);
            item = new JMenuItem(b.getString("LESS"));
            item.setActionCommand("LESS");
            item.addActionListener(this._listener);
            this._menu.add(item);
            item = new JMenuItem(b.getString("GREATER_OR_EQUAL"));
            item.setActionCommand("GREATER_OR_EQUAL");
            item.addActionListener(this._listener);
            this._menu.add(item);
            item = new JMenuItem(b.getString("LESS_OR_EQUAL"));
            item.setActionCommand("LESS_OR_EQUAL");
            item.addActionListener(this._listener);
            this._menu.add(item);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean _updateIncludedJoins(Table table) {
        TableInfo info = this._getTableInfo(table);
        if (info == null) {
            return false;
        }
        ViewBuilderLink[] links = this._getLinks(info);
        if (links == null) {
            return false;
        }
        this.freezeRepaints();
        boolean countChanged = false;
        try {
            for (int i = 0; i < links.length; ++i) {
                boolean included;
                RelationshipLink rLink;
                ViewBuilderLink link = links[i];
                if (!(link instanceof RelationshipLink) || (rLink = (RelationshipLink)link).isUserDoubleClick()) continue;
                ViewBuilderComponent parent = link.getSourcePort(0).getViewBuilderComponent();
                ViewBuilderComponent child = link.getDestinationPort(0).getViewBuilderComponent();
                TableInfo parentInfo = this._getTableInfo(parent);
                TableInfo childInfo = this._getTableInfo(child);
                boolean bl = included = parentInfo.getTableComponent().getSelectedColumnCount() != 0 && childInfo.getTableComponent().getSelectedColumnCount() != 0;
                if (included == rLink.isIncluded()) continue;
                countChanged = true;
                rLink.setIncluded(included);
            }
        }
        finally {
            this.unfreezeRepaints();
        }
        return countChanged;
    }

    private void _customizeTable(Table table, TableComponent comp, TableViewBuilderComponent component, String type) {
        comp.freezeRepaints();
        ViewBuilderCustomizer custom = this.getCustomizer();
        Locale locale = LocaleUtils.getDefaultableLocale((Component)((Object)this));
        boolean all = _ALL.equals(type);
        boolean name = "name".equals(type) || "displayName".equals(type);
        boolean columns = _COLUMNS.equals(type);
        if (all || name) {
            component.setTitle(table.getDisplayName(locale));
        }
        JMenuBar menuBar = null;
        if (all) {
            component.setMenuBar(null);
            menuBar = this.getDefaultMenuBar(table, locale);
        }
        if (custom != null) {
            if (all || columns) {
                custom.customizeTableComponent(comp, table);
            }
            if (all) {
                custom.customizeViewBuilderComponent(component, table);
                custom.customizeMenuBar(menuBar, table, locale);
            }
        }
        if (all && menuBar != null && menuBar.getMenuCount() != 0) {
            component.setMenuBar(menuBar);
        }
        comp.unfreezeRepaints();
    }

    private void _removeCustomLinks(ViewBuilderComponent c) {
        ViewBuilderLink[] links = this.getLinks(c);
        int count = links == null ? 0 : links.length;
        for (int i = 0; i < count; ++i) {
            this.removeViewBuilderLink(links[i]);
        }
    }

    private int _indexOf(ViewBuilderLink link) {
        int count = this._links.size();
        for (int i = 0; i < count; ++i) {
            if (this._links.elementAt(i) != link) continue;
            return i;
        }
        return -1;
    }

    private Column _getColumn(String targetColumnName) {
        Column toReturn = null;
        int firstIndex = targetColumnName.indexOf(".");
        int secondIndex = targetColumnName.indexOf(".", firstIndex + 1);
        String schemaName = targetColumnName.substring(0, firstIndex);
        String tableName = targetColumnName.substring(firstIndex + 1, secondIndex);
        String columnName = targetColumnName.substring(secondIndex + 1);
        Table[] tables = this.getTables();
        Object toColumn = null;
        block0: for (int i = 0; i < tables.length; ++i) {
            Table table = tables[i];
            if (!tableName.equals(table.getName()) || !schemaName.equals(table.getSchema().getName())) continue;
            for (int j = 0; j < table.getColumnCount(); ++j) {
                Column temp = table.getColumn(j);
                if (!columnName.equals(temp.getName())) continue;
                toReturn = temp;
                break block0;
            }
            break;
        }
        return toReturn;
    }

    private void _addLink(Column fromColumn, String toColumnName) {
        Column toColumn = this._getColumn(toColumnName);
        if (toColumn != null) {
            this._createRelationship(fromColumn, toColumn);
        }
    }

    private void _deleteLink(Column fromColumn, String toColumnName) {
        Column toColumn = this._getColumn(toColumnName);
        if (toColumn != null) {
            this._deleteRelationship(fromColumn, toColumn);
        }
    }

    private int _indexOf(OuterJoin outerJoin) {
        int index = this._outerJoins.indexOf(outerJoin);
        if (index != -1) {
            return index;
        }
        int count = this._outerJoins.size();
        for (int i = 0; i < count; ++i) {
            OuterJoin join = (OuterJoin)this._outerJoins.elementAt(i);
            if (!this._tablesEqual(join.getSource(), outerJoin.getSource()) || !this._tablesEqual(join.getDestination(), outerJoin.getDestination())) continue;
            return i;
        }
        return -1;
    }

    private OuterJoin[] _getOuterJoins(Table source) {
        if (this._outerJoins == null) {
            return null;
        }
        Vector<OuterJoin> v = new Vector<OuterJoin>();
        for (int i = 0; i < this._outerJoins.size(); ++i) {
            OuterJoin join = (OuterJoin)this._outerJoins.elementAt(i);
            if (!this._tablesEqual(join.getSource(), source)) continue;
            v.addElement(join);
        }
        if (v.size() == 0) {
            return null;
        }
        Object[] joins = new OuterJoin[v.size()];
        v.copyInto(joins);
        return joins;
    }

    private Table _getTable(String fullTableName) {
        Table[] tables = this.getTables();
        int index = fullTableName.indexOf(".");
        String schemaName = fullTableName.substring(0, index);
        String tableName = fullTableName.substring(index + 1);
        for (int i = 0; i < tables.length; ++i) {
            if (!tables[i].getName().equals(tableName) || !tables[i].getSchema().getName().equals(schemaName)) continue;
            return tables[i];
        }
        return null;
    }

    private OuterJoin _getOuterJoin(Table source, Table destination) {
        if (this._outerJoins == null) {
            return null;
        }
        for (int i = 0; i < this._outerJoins.size(); ++i) {
            OuterJoin join = (OuterJoin)this._outerJoins.elementAt(i);
            if (!this._tablesEqual(join.getSource(), source) || !this._tablesEqual(join.getDestination(), destination)) continue;
            return join;
        }
        return null;
    }

    private void _checkForOuterJoin(RelationshipLink link, TableInfo source, TableInfo destination) {
        OuterJoin[] joins = this.getOuterJoins();
        if (joins == null) {
            return;
        }
        for (int i = 0; i < joins.length; ++i) {
            OuterJoin join = joins[i];
            if (this._tablesEqual(join.getSource(), source.getTable()) && this._tablesEqual(join.getDestination(), destination.getTable())) {
                link.setSourceOuterJoin(true);
                continue;
            }
            if (!this._tablesEqual(join.getSource(), destination.getTable()) || !this._tablesEqual(join.getDestination(), source.getTable())) continue;
            link.setDestinationOuterJoin(true);
        }
    }

    void __firePropertyChange(String name, Object oldValue, Object newValue) {
        this.firePropertyChange(name, oldValue, newValue);
    }

    private class TableInfo {
        private TableViewBuilderComponent _viewBuilderComponent;
        private ViewBuilderLink[] _links;

        public TableInfo(Table table, TableComponent tableComponent, TableViewBuilderComponent viewBuilderComponent) {
            this._viewBuilderComponent = viewBuilderComponent;
        }

        public ViewBuilderLink[] getLinks() {
            return this._links;
        }

        public void setLinks(ViewBuilderLink[] links) {
            this._links = links;
        }

        public Table getTable() {
            return this.getTableComponent().getTable();
        }

        public TableComponent getTableComponent() {
            return this.getViewBuilderComponent().getTableComponent();
        }

        public TableViewBuilderComponent getViewBuilderComponent() {
            return this._viewBuilderComponent;
        }

        public void clear() {
            this.setLinks(null);
            this._viewBuilderComponent = null;
        }
    }

    private class TableAction
    implements PopupMenuListener,
    ActionListener,
    Task {
        private Table _table;
        private String _cmd;

        public TableAction(Table table) {
            this._table = table;
        }

        public void actionPerformed(ActionEvent e) {
            String c = e.getActionCommand();
            if (ViewBuilder.TABLES_COMMAND.equals(c) || ViewBuilder.HIDE_TABLES_COMMAND.equals(c)) {
                this._cmd = c;
                DBUILookAndFeel.getTaskScheduler().schedule((Task)this, 0);
            } else if (c != null) {
                if (c.startsWith(ViewBuilder.COMMAND_CREATE_OUTER_JOIN)) {
                    String tableName = c.substring(ViewBuilder.COMMAND_CREATE_OUTER_JOIN.length());
                    Table table = ViewBuilder.this._getTable(tableName);
                    OuterJoin outerJoin = ViewBuilder.this.createOuterJoin(this._table, table);
                } else if (c.startsWith(ViewBuilder.COMMAND_DELETE_OUTER_JOIN)) {
                    String tableName = c.substring(ViewBuilder.COMMAND_DELETE_OUTER_JOIN.length());
                    Table table = ViewBuilder.this._getTable(tableName);
                    OuterJoin join = ViewBuilder.this._getOuterJoin(this._table, table);
                    ViewBuilder.this.removeOuterJoin(join);
                }
            }
        }

        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
        }

        public void popupMenuCanceled(PopupMenuEvent e) {
        }

        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            JPopupMenu popup = (JPopupMenu)e.getSource();
            OuterJoin[] joins = ViewBuilder.this._getOuterJoins(this._table);
            JPopupMenu content = popup;
            Locale locale = LocaleUtils.getDefaultableLocale((Component)((Object)ViewBuilder.this));
            for (int i = 0; i < content.getComponentCount(); ++i) {
                Component c = content.getComponent(i);
                if (!(c instanceof JMenu)) continue;
                JMenu menu = (JMenu)c;
                String cmd = menu.getActionCommand();
                if (ViewBuilder.COMMAND_CREATE_OUTER_JOIN.equals(cmd)) {
                    Table[] tables = ViewBuilder.this.getTables();
                    int count = tables.length;
                    menu.setEnabled(count > 1);
                    if (count <= 0) continue;
                    this._addCreateOuterJoinMenu(menu, this._table, tables, joins, locale);
                    continue;
                }
                if (!ViewBuilder.COMMAND_DELETE_OUTER_JOIN.equals(cmd)) continue;
                menu.setEnabled(joins != null);
                if (joins == null) continue;
                this._addDeleteOuterJoinMenu(menu, this._table, joins, locale);
            }
        }

        private void _addCreateOuterJoinMenu(JMenu menu, Table source, Table[] tables, OuterJoin[] joins, Locale locale) {
            JPopupMenu subMenu = menu.getPopupMenu();
            if (subMenu != null) {
                this._removeListeners(subMenu);
            }
            menu.removeAll();
            int joinCount = joins == null ? 0 : joins.length;
            for (int i = 0; i < tables.length; ++i) {
                Table table = tables[i];
                if (ViewBuilder.this._tablesEqual(table, source)) continue;
                boolean joinCreated = false;
                for (int j = 0; j < joinCount; ++j) {
                    if (!ViewBuilder.this._tablesEqual(joins[j].getDestination(), table)) continue;
                    joinCreated = true;
                    break;
                }
                if (joinCreated) continue;
                JMenuItem item = new JMenuItem(table.getDisplayName(locale));
                item.setActionCommand(ViewBuilder.COMMAND_CREATE_OUTER_JOIN + table.getSchema().getName() + "." + table.getName());
                item.addActionListener(this);
                menu.add(item);
            }
            menu.setEnabled(menu.isEnabled() & menu.getMenuComponentCount() > 0);
        }

        private void _addDeleteOuterJoinMenu(JMenu menu, Table source, OuterJoin[] joins, Locale locale) {
            JPopupMenu subMenu = menu.getPopupMenu();
            if (subMenu != null) {
                this._removeListeners(subMenu);
            }
            menu.removeAll();
            for (int i = 0; i < joins.length; ++i) {
                Table table = joins[i].getDestination();
                JMenuItem item = new JMenuItem(table.getDisplayName(locale));
                item.setActionCommand(ViewBuilder.COMMAND_DELETE_OUTER_JOIN + table.getSchema().getName() + "." + table.getName());
                item.addActionListener(this);
                menu.add(item);
            }
        }

        private void _removeListeners(JPopupMenu popup) {
            JPopupMenu content = popup;
            for (int i = 0; i < content.getComponentCount(); ++i) {
                Component c = content.getComponent(i);
                if (!(c instanceof JMenuItem)) continue;
                ((JMenuItem)c).removeActionListener(this);
            }
        }

        public void runTask(TaskEvent evt) {
            DBUILookAndFeel.getLookAndFeel().setCursor((Component)((Object)ViewBuilder.this), true);
            if (ViewBuilder.TABLES_COMMAND.equals(this._cmd)) {
                ViewBuilder.this._addRelatedTables(this._table, true);
            } else if (ViewBuilder.HIDE_TABLES_COMMAND.equals(this._cmd)) {
                ViewBuilder.this._hideRelatedTables(this._table);
            }
            DBUILookAndFeel.getLookAndFeel().setCursor((Component)((Object)ViewBuilder.this), false);
        }
    }

    private class Listener
    extends DynamicTableAdapter
    implements DynamicRelationshipListener,
    PropertyChangeListener,
    VetoableChangeListener,
    ActionListener {
        private Listener() {
        }

        public void propertyChange(PropertyChangeEvent e) {
            String name = e.getPropertyName();
            if ("relationshipType".equals(name)) {
                ViewBuilder.this._updateRelationship((Relationship)e.getSource());
            } else if (ViewBuilder.PROPERTY_SELECTED_COLUMNS.equals(name)) {
                TableComponent comp = (TableComponent)e.getSource();
                ViewBuilder.this._selectionChanged(comp.getTable(), e.getOldValue(), e.getNewValue());
            } else if ("closed".equals(name)) {
                ViewBuilderComponent source = (ViewBuilderComponent)e.getSource();
                ViewBuilder.this._closeComponent(source);
            } else if ("componentSelected".equals(name)) {
                ViewBuilderComponent source = (ViewBuilderComponent)e.getSource();
                ViewBuilder.this._activateJoins(source, (Boolean)e.getNewValue());
            } else if (e.getSource() instanceof Table) {
                Table table = (Table)e.getSource();
                ViewBuilder.this._customizeTable(table, name);
            }
        }

        public void vetoableChange(PropertyChangeEvent e) throws PropertyVetoException {
            String name = e.getPropertyName();
            if ("closed".equals(name) && !ViewBuilder.this._tryClose((ViewBuilderComponent)e.getSource())) {
                throw new PropertyVetoException("The client canceled the close", e);
            }
        }

        public void columnAdded(DynamicRelationshipEvent e) {
            ViewBuilder.this._updateRelationship(e.getRelationship());
        }

        public void columnRemoved(DynamicRelationshipEvent e) {
            ViewBuilder.this._updateRelationship(e.getRelationship());
        }

        public void columnAdded(DynamicTableEvent e) {
            ViewBuilder.this._customizeTable(e.getTable(), ViewBuilder._COLUMNS);
        }

        public void columnRemoved(DynamicTableEvent e) {
            ViewBuilder.this._customizeTable(e.getTable(), ViewBuilder._COLUMNS);
            ViewBuilder.this._updateRelationships(e.getTable(), e.getColumn());
        }

        public void foreignKeyAdded(DynamicTableEvent e) {
            ViewBuilder.this._updateRelationships(e.getTable(), e.getForeignKey(), true);
        }

        public void foreignKeyRemoved(DynamicTableEvent e) {
            ViewBuilder.this._updateRelationships(e.getTable(), e.getForeignKey(), false);
        }

        public void actionPerformed(ActionEvent e) {
            String cmd = e.getActionCommand();
            int type = -1;
            if ("EQUAL".equals(cmd)) {
                type = 0;
            } else if ("NOT_EQUAL".equals(cmd)) {
                type = 1;
            } else if ("GREATER".equals(cmd)) {
                type = 2;
            } else if ("LESS".equals(cmd)) {
                type = 3;
            } else if ("GREATER_OR_EQUAL".equals(cmd)) {
                type = 5;
            } else if ("LESS_OR_EQUAL".equals(cmd)) {
                type = 4;
            } else if (cmd != null) {
                String columnName;
                int index = -1;
                int linkCount = ViewBuilder.this._links.size();
                ViewBuilderLink[] links = ViewBuilder.this.getSelectedLinks();
                if (ViewBuilder.COMMAND_LEFT.equals(cmd)) {
                    if (linkCount != 0) {
                        if (links.length == 0) {
                            index = linkCount - 1;
                        } else {
                            index = ViewBuilder.this._indexOf(links[0]) - 1;
                            if (index < 0) {
                                index = linkCount - 1;
                            }
                        }
                    }
                } else if (ViewBuilder.COMMAND_RIGHT.equals(cmd)) {
                    if (linkCount != 0) {
                        index = links.length == 0 ? 0 : (ViewBuilder.this._indexOf(links[0]) + 1) % linkCount;
                    }
                } else if (ViewBuilder.COMMAND_SELECT.equals(cmd)) {
                    if (links.length != 0) {
                        ViewBuilder.this._includeLinks(links);
                    }
                } else if (ViewBuilder.COMMAND_DELETE.equals(cmd)) {
                    if (links.length != 0 && ViewBuilder.this.isLinkDeletionAllowed()) {
                        ViewBuilder.this._deleteLinks(links);
                        if (ViewBuilder.this._links.size() != 0) {
                            index = 0;
                        }
                    } else {
                        ViewBuilder.this._deleteSelectedComponents();
                    }
                } else if (cmd.startsWith(ViewBuilder.COMMAND_LINK)) {
                    columnName = cmd.substring(ViewBuilder.COMMAND_LINK.length());
                    ViewBuilder.this._addLink(ViewBuilder.this._menuColumn, columnName);
                } else if (cmd.startsWith(ViewBuilder.COMMAND_DELETE_LINK)) {
                    columnName = cmd.substring(ViewBuilder.COMMAND_DELETE_LINK.length());
                    ViewBuilder.this._deleteLink(ViewBuilder.this._menuColumn, columnName);
                }
                if (index != -1) {
                    ViewBuilderLink link = (ViewBuilderLink)ViewBuilder.this._links.elementAt(index);
                    ViewBuilder.this.setAllLinksSelected(false);
                    ViewBuilder.this.setLinkSelected(link, true);
                    if (link instanceof RelationshipLink) {
                        ViewBuilder.this.__firePropertyChange(ViewBuilder.PROPERTY_SELECTED_RELATIONSHIPS, null, ViewBuilder.this.getSelectedRelationships());
                    }
                }
            }
            if (type != -1) {
                ViewBuilder.this._setMenuJoinType(type);
            }
        }
    }

    private class AccessibleViewBuilder
    extends JComponent.AccessibleJComponent {
        public AccessibleViewBuilder() {
            super((JComponent)((Object)ViewBuilder.this));
            AccessibleContext ac = ViewBuilder.this.getCanvas().getAccessibleContext();
            ac.setAccessibleParent(ViewBuilder.this);
        }

        public String getAccessibleName() {
            Relationship[] r;
            String name = super.getAccessibleName();
            if ((name == null || name == "") && (r = ViewBuilder.this.getSelectedRelationships()).length != 0) {
                name = this._getRelationshipName(r[0]);
            }
            if (name == null || name == "") {
                name = this._getAccessibleString(ViewBuilder._KEY_CANVAS_NAME);
            }
            return name;
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.PANEL;
        }

        public int getAccessibleChildrenCount() {
            return 1;
        }

        public Accessible getAccessibleChild(int i) {
            if (i < 0 || i >= this.getAccessibleChildrenCount()) {
                return null;
            }
            return ViewBuilder.this.getCanvas();
        }

        private String _getAccessibleString(String key) {
            ResourceBundle b = ResourceBundle.getBundle("oracle.bali.dbUI.resource.AccessibleBundle", this.getLocale());
            return b.getString(key);
        }

        private String _getTypeName(int type) {
            String key = null;
            switch (type) {
                case 1: {
                    key = ViewBuilder._KEY_NOT_EQUAL;
                    break;
                }
                case 2: {
                    key = ViewBuilder._KEY_GREATER;
                    break;
                }
                case 3: {
                    key = ViewBuilder._KEY_LESS;
                    break;
                }
                case 4: {
                    key = ViewBuilder._KEY_LESSEQUAL;
                    break;
                }
                case 5: {
                    key = ViewBuilder._KEY_GREATEREQUAL;
                    break;
                }
                default: {
                    key = ViewBuilder._KEY_EQUAL;
                }
            }
            return this._getAccessibleString(key);
        }

        private String _getRelationshipName(Relationship r) {
            int count = r.getColumnCount();
            String name = r.getDisplayName(this.getLocale());
            String type = this._getTypeName(r.getRelationshipType());
            for (int i = 0; i < count; ++i) {
                Column c1 = r.getColumn(i);
                Column c2 = r.getReferencedColumn(i);
                name = name + " " + c1.getTable().getName() + "." + c1.getName() + " " + type + " " + c2.getTable().getName() + "." + c2.getName() + " ";
            }
            return name;
        }
    }
}

