/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.dbUI.viewBuilder;

import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import oracle.bali.dbUI.db.Column;
import oracle.bali.dbUI.tableComponent.TableComponent;
import oracle.bali.dbUI.viewBuilder.TableViewBuilderComponent;
import oracle.bali.dbUI.viewBuilder.ViewBuilder;
import oracle.bali.dbUI.viewBuilder.ViewBuilderLinkPort;
import oracle.bali.ewt.grid.CellInputHandler;
import oracle.bali.ewt.grid.Grid;
import oracle.bali.ewt.grid.NullInputHandler;
import oracle.bali.ewt.grid.ProxyInputHandler;

class JoinMaker
extends ProxyInputHandler {
    private boolean _creatingJoin;
    private TableViewBuilderComponent _component;
    private ViewBuilder _builder;
    private CellInputHandler _handler;

    public JoinMaker(ViewBuilder builder, TableViewBuilderComponent component) {
        this._component = component;
        this._builder = builder;
        TableComponent table = component.getTableComponent();
        Grid grid = table.getSpreadTable().getGrid();
        this._handler = grid.getColumnCellInputHandler(1);
        grid.setColumnCellInputHandler(1, (CellInputHandler)this);
    }

    public CellInputHandler getCellInputHandler(Grid grid, int column, int row) {
        if (column == 1) {
            return this._handler;
        }
        return NullInputHandler.getCellInputHandler();
    }

    public void mousePressed(MouseEvent e, Grid grid, int column, int row) {
        if (e.isPopupTrigger()) {
            this._showMenu(grid, column, row, e.getX(), e.getY());
            e.consume();
            return;
        }
        super.mousePressed(e, grid, column, row);
        if (column == 1) {
            return;
        }
        TableComponent component = this._component.getTableComponent();
        int count = e.getClickCount();
        if (count == 1 && this._builder.isLinkCreationAllowed()) {
            this._creatingJoin = true;
            ViewBuilderLinkPort port = this._component.getLinkPort(row);
            Point p = this._translatePoint(grid, column, row, e.getX(), e.getY());
            this._builder.startLinkCreation(port, p.x, p.y);
        } else if (count == 2) {
            e.consume();
            Column realColumn = component.getColumn(row);
            boolean selected = !this._builder.isColumnSelected(realColumn);
            this._builder.setColumnSelected(realColumn, selected);
        }
    }

    public void mouseDragged(MouseEvent e, Grid grid, int column, int row) {
        super.mouseDragged(e, grid, column, row);
        if (this._creatingJoin) {
            e.consume();
            Point p = this._translatePoint(grid, column, row, e.getX(), e.getY());
            this._builder.continueLinkCreation(p.x, p.y);
        }
    }

    public void mouseReleased(MouseEvent e, Grid grid, int column, int row) {
        if (e.isPopupTrigger()) {
            this._showMenu(grid, column, row, e.getX(), e.getY());
            e.consume();
        }
        super.mouseReleased(e, grid, column, row);
        if (this._creatingJoin) {
            e.consume();
            Point p = this._translatePoint(grid, column, row, e.getX(), e.getY());
            this._builder.finishLinkCreation(p.x, p.y);
        }
        this._creatingJoin = false;
    }

    public void keyPressed(KeyEvent e, Grid grid, int column, int row) {
        super.keyPressed(e, grid, column, row);
        if (!e.isConsumed() && grid.isEnabled() && e.getKeyCode() == 121 && e.getModifiers() == 1) {
            this._showMenu(grid, column, row, grid.getSize().width / 2, grid.getRowHeight(row) * 2 / 3);
        }
    }

    public void keyReleased(KeyEvent e, Grid grid, int column, int row) {
        if (e.getKeyCode() == 121 && e.getModifiers() == 1) {
            e.consume();
        }
        super.keyReleased(e, grid, column, row);
    }

    private void _showMenu(Grid grid, int column, int row, int x, int y) {
        Point p = this._translatePoint(grid, column, row, x, y);
        TableComponent table = this._component.getTableComponent();
        this._builder.displayPopupForColumn(table.getColumn(row), p.x, p.y);
    }

    private Point _translatePoint(Grid grid, int column, int row, int x, int y) {
        x += grid.getColumnPosition(column);
        y += grid.getRowPosition(row);
        for (Object parent = grid; parent != null && parent != this._builder; parent = parent.getParent()) {
            Point p = parent.getLocation();
            x += p.x;
            y += p.y;
        }
        return new Point(x, y);
    }
}

