/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.dbUI.tableComponent;

import java.awt.event.KeyEvent;
import java.util.Locale;
import oracle.bali.dbUI.tableComponent.TableComponent;
import oracle.bali.ewt.grid.BooleanInputHandler;
import oracle.bali.ewt.grid.Grid;
import oracle.bali.ewt.selection.TwoDSelection;

class ColumnSelectInputHandler
extends BooleanInputHandler {
    private static final long _KEY_TIME = 750L;
    private long _currentTime;
    private TableComponent _parent;
    private StringBuffer _buffer;

    public ColumnSelectInputHandler(TableComponent parent) {
        this._parent = parent;
    }

    public void keyTyped(KeyEvent e, Grid grid, int column, int row) {
        super.keyTyped(e, grid, column, row);
        if (this._checkTime(750L)) {
            this._buffer = null;
        }
        StringBuffer buffer = this._getBuffer();
        buffer.append(e.getKeyChar());
        TwoDSelection gs = grid.getSelection();
        int oldIndex = gs.getSingleRow();
        int newIndex = oldIndex == -1 ? 0 : oldIndex;
        newIndex = this._findItem(newIndex, buffer.toString());
        if (newIndex != -1 && newIndex != oldIndex) {
            this._parent.selectRow(newIndex, e);
        }
        this._storeTime();
    }

    private void _storeTime() {
        this._currentTime = System.currentTimeMillis();
    }

    private boolean _checkTime(long checkTime) {
        long time = System.currentTimeMillis();
        return time - this._currentTime > checkTime;
    }

    private StringBuffer _getBuffer() {
        if (this._buffer == null) {
            this._buffer = new StringBuffer();
        }
        return this._buffer;
    }

    private int _findItem(int startIndex, String prefixString) {
        String item;
        int i;
        int count = this._parent.getTable().getColumnCount();
        Locale locale = this._parent.getLocale();
        prefixString = prefixString.toUpperCase(locale);
        for (i = startIndex; i < count; ++i) {
            item = this._parent.getColumn(i).getDisplayName(locale).toUpperCase(locale);
            if (!item.startsWith(prefixString)) continue;
            return i;
        }
        for (i = 0; i < startIndex; ++i) {
            item = this._parent.getColumn(i).getDisplayName(locale).toUpperCase(locale);
            if (!item.startsWith(prefixString)) continue;
            return i;
        }
        return -1;
    }
}

