/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.dbUI.propertyTable;

import java.awt.FontMetrics;
import java.beans.PropertyDescriptor;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.Collator;
import java.text.DateFormat;
import java.text.Format;
import java.util.Locale;
import javax.swing.UIManager;
import oracle.bali.ewt.grid.BooleanInputHandler;
import oracle.bali.ewt.grid.CellInputHandler;
import oracle.bali.ewt.grid.CheckPainter;
import oracle.bali.ewt.grid.DateInputHandler;
import oracle.bali.ewt.grid.NullInputHandler;
import oracle.bali.ewt.grid.NumberInputHandler;
import oracle.bali.ewt.grid.TextFieldInputHandler;
import oracle.bali.ewt.painter.FormatPainter;
import oracle.bali.ewt.painter.Painter;
import oracle.bali.share.sort.BooleanComparator;
import oracle.bali.share.sort.Comparator;
import oracle.bali.share.sort.DateComparator;
import oracle.bali.share.sort.NumberComparator;
import oracle.bali.share.sort.StringComparator;

public class PropertyTableCustomizer {
    private static PropertyTableCustomizer _sCustomizer;

    public static PropertyTableCustomizer getPropertyTableCustomizer() {
        if (_sCustomizer == null) {
            _sCustomizer = new PropertyTableCustomizer();
        }
        return _sCustomizer;
    }

    public String getDisplayName(PropertyDescriptor desc, Locale locale) {
        return desc.getDisplayName();
    }

    public boolean displayProperty(PropertyDescriptor desc) {
        return desc.getPropertyType() != Class.class;
    }

    public Painter getPainter(PropertyDescriptor desc) {
        Class<?> type = desc.getPropertyType();
        return this.getPainter(type);
    }

    public Painter getPainter(Class type) {
        Painter p = (Painter)UIManager.get("Grid.DefaultCellPainter");
        if (type == Boolean.TYPE || type == Boolean.class) {
            p = CheckPainter.getPainter();
        } else if (type == Date.class) {
            DateFormat f = DateFormat.getDateInstance(3);
            p = new FormatPainter((Format)f);
        } else if (type == Time.class) {
            DateFormat f = DateFormat.getTimeInstance(3);
            p = new FormatPainter((Format)f);
        } else if (type == Timestamp.class) {
            DateFormat f = DateFormat.getDateTimeInstance(3, 3);
            p = new FormatPainter((Format)f);
        } else if (type == java.util.Date.class) {
            p = new FormatPainter((Format)DateFormat.getDateInstance());
        }
        return p;
    }

    public CellInputHandler getCellInputHandler(PropertyDescriptor desc) {
        CellInputHandler h = NullInputHandler.getCellInputHandler();
        if (desc.getWriteMethod() == null) {
            return h;
        }
        Class<?> type = desc.getPropertyType();
        return this.getCellInputHandler(type);
    }

    public CellInputHandler getCellInputHandler(Class dataType) {
        CellInputHandler h = NullInputHandler.getCellInputHandler();
        if (dataType == Boolean.TYPE || dataType == Boolean.class) {
            h = BooleanInputHandler.getCellInputHandler();
        } else if (dataType == Character.TYPE || dataType == Character.class) {
            h = TextFieldInputHandler.getCellInputHandler();
        } else if (dataType == String.class) {
            h = TextFieldInputHandler.getCellInputHandler();
        } else if (dataType == Byte.TYPE || dataType == Byte.class || dataType == Short.TYPE || dataType == Short.class || dataType == Integer.TYPE || dataType == Integer.class || dataType == Long.TYPE || dataType == Long.class || dataType == Float.TYPE || dataType == Float.class || dataType == BigDecimal.class || dataType == BigInteger.class || dataType == Double.TYPE || dataType == Double.class) {
            NumberInputHandler nh = new NumberInputHandler();
            nh.getNumberTextField().setDataType(dataType);
            h = nh;
        } else if (dataType == Date.class) {
            DateFormat f = DateFormat.getDateInstance(3);
            h = new DateInputHandler(f);
        } else if (dataType == Time.class) {
            DateFormat f = DateFormat.getTimeInstance(3);
            h = new DateInputHandler(f);
        } else if (dataType == Timestamp.class) {
            DateFormat f = DateFormat.getDateTimeInstance(3, 3);
            h = new DateInputHandler(f);
        } else if (dataType == java.util.Date.class) {
            h = new DateInputHandler(DateFormat.getDateInstance());
        }
        return h;
    }

    public int getColumnWidth(PropertyDescriptor desc, FontMetrics metrics) {
        return this.getColumnWidth(desc, metrics, Locale.getDefault());
    }

    public int getColumnWidth(PropertyDescriptor desc, FontMetrics metrics, Locale locale) {
        String name = this.getDisplayName(desc, locale);
        return metrics.stringWidth(name);
    }

    public Comparator getComparator(PropertyDescriptor desc) {
        Comparator c = null;
        Class<?> type = desc.getPropertyType();
        if (type == Boolean.TYPE || type == Boolean.class) {
            c = BooleanComparator.getComparator();
        } else if (type == Byte.TYPE || type == Byte.class) {
            c = NumberComparator.getComparator();
        } else if (type == Short.TYPE || type == Short.class) {
            c = NumberComparator.getComparator();
        } else if (type == Integer.TYPE || type == Integer.class) {
            c = NumberComparator.getComparator();
        } else if (type == Long.TYPE || type == Long.class) {
            c = NumberComparator.getComparator();
        } else if (type == Float.TYPE || type == Float.class) {
            c = NumberComparator.getComparator();
        } else if (type == Double.TYPE || type == Double.class) {
            c = NumberComparator.getComparator();
        } else if (type == Character.TYPE || type == Character.class) {
            c = new StringComparator(Collator.getInstance());
        } else if (type == String.class) {
            c = new StringComparator(Collator.getInstance());
        } else if (type == java.util.Date.class || type == Date.class || type == Time.class || type == Timestamp.class) {
            c = DateComparator.getComparator();
        }
        return c;
    }

    protected PropertyTableCustomizer() {
    }
}

