/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.dbUI.constraintBuilder;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import javax.accessibility.AccessibleContext;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.UIManager;
import oracle.bali.dbUI.constraintBuilder.GroupComponent;
import oracle.bali.ewt.LWComponent;

class GroupPainterComponent
extends LWComponent
implements GroupComponent {
    static final int HINSET = 25;
    private static final String[] _STRINGS = new String[]{"AND", "OR", "NOT AND", "NOT OR"};
    private JComboBox _choice;

    public GroupPainterComponent() {
        this(0);
    }

    public GroupPainterComponent(int whichGroup) {
        this.setBackground(UIManager.getColor("control"));
        this._choice = new Choice();
        this.setLayout(new BorderLayout());
        this.add("Center", this._choice);
        this.setGroup(whichGroup);
    }

    public int getGroup() {
        return this._choice.getSelectedIndex();
    }

    public void setGroup(int whichGroup) {
        if (this.getGroup() != whichGroup) {
            this._choice.setSelectedIndex(whichGroup);
            this.invalidate();
        }
    }

    public LWComponent getComponent() {
        return this;
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new JComponent.AccessibleJComponent(){};
        }
        return this.accessibleContext;
    }

    private class Choice
    extends JComboBox {
        public Choice() {
            super(_STRINGS);
            this.setEditable(false);
        }

        public Dimension getPreferredSize() {
            Dimension d = super.getPreferredSize();
            Font f = this.getFont();
            if (f != null) {
                FontMetrics fm = this.getFontMetrics(f);
                d.width = fm.stringWidth("NOT AND") + 25;
            }
            return d;
        }
    }
}

