/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.dbUI.constraint;

import java.util.Enumeration;
import java.util.EventListener;
import oracle.bali.dbUI.constraint.Constrainable;
import oracle.bali.dbUI.constraint.DataConstraint;
import oracle.bali.dbUI.constraint.ObjectTest;
import oracle.bali.dbUI.constraint.ObjectTestGenerator;
import oracle.bali.dbUI.constraint.ObjectTestRowImpl;
import oracle.bali.dbUI.db.DataDescriptorProvider;
import oracle.bali.ewt.model.TwoDModel;
import oracle.bali.ewt.model.TwoDModelEvent;
import oracle.bali.ewt.model.TwoDModelListener;
import oracle.bali.share.event.ListenerManager;

public class ConstrainableModel
implements Constrainable,
TwoDModel {
    public static final int ROW_NOT_IN_CONSTRAINT = -1;
    private TwoDModelListener _listener;
    private ObjectTestGenerator _parser;
    private DataConstraint _dataConstraint;
    private int _filteredRowCount;
    private int[] _filteredToUnfiltered;
    private ListenerManager _listeners;
    private TwoDModel _ds;
    private DataDescriptorProvider _provider;

    public ConstrainableModel(TwoDModel model, DataDescriptorProvider provider) {
        int count;
        this._ds = model;
        if (this._ds != null) {
            this._ds.addModelListener(this._getListener());
        }
        this._provider = provider;
        this._filteredRowCount = count = this._ds == null ? 0 : this._ds.getRowCount();
    }

    public int getColumnCount() {
        return this._ds == null ? 0 : this._ds.getColumnCount();
    }

    public int getRowCount() {
        return this._filteredRowCount;
    }

    public Object getData(int column, int row) {
        if (this._filteredToUnfiltered != null) {
            row = this._filteredToUnfiltered[row];
        }
        return this._ds == null ? null : this._ds.getData(column, row);
    }

    public void setData(int column, int row, Object data) {
        if (this._filteredToUnfiltered != null) {
            row = this._filteredToUnfiltered[row];
        }
        if (this._ds != null) {
            this._ds.setData(column, row, data);
            this._sendCellInvalidEvent(column, row);
        }
    }

    public void addModelListener(TwoDModelListener listener) {
        if (this._listeners == null) {
            this._listeners = new ListenerManager();
        }
        this._listeners.addListener((EventListener)listener);
    }

    public void removeModelListener(TwoDModelListener listener) {
        if (this._listeners != null) {
            this._listeners.removeListener((EventListener)listener);
        }
    }

    public DataDescriptorProvider getDescriptorProvider() {
        return this._provider;
    }

    public void setDescriptorProvider(DataDescriptorProvider provider) {
        this._provider = provider;
        this._dataConstraint = null;
        this._applyConstraints();
    }

    public TwoDModel getModel() {
        return this._ds;
    }

    public void setModel(TwoDModel model) {
        if (this._ds != null) {
            this._ds.removeModelListener(this._getListener());
        }
        this._ds = model;
        if (this._ds != null) {
            this._ds.addModelListener(this._getListener());
        }
        this._dataConstraint = null;
        this._applyConstraints();
    }

    public void setDataConstraint(DataConstraint constraint) {
        this._dataConstraint = constraint;
        this._applyConstraints();
    }

    public DataConstraint getDataConstraint() {
        return this._dataConstraint;
    }

    public int getConstrainedIndex(int rowIndex) {
        if (this._filteredToUnfiltered == null) {
            return rowIndex;
        }
        return 0;
    }

    protected void processTwoDModelEvent(TwoDModelEvent event) {
        ListenerManager listeners = this._listeners;
        if (this._listeners == null) {
            return;
        }
        Enumeration enumer = listeners.getListeners();
        if (enumer == null) {
            return;
        }
        block9: while (enumer.hasMoreElements()) {
            TwoDModelListener listener = (TwoDModelListener)enumer.nextElement();
            switch (event.getID()) {
                case 2004: {
                    listener.rowsAdded(event);
                    continue block9;
                }
                case 2005: {
                    listener.rowsRemoved(event);
                    continue block9;
                }
                case 2007: {
                    listener.invalidateCells(event);
                    continue block9;
                }
                case 2006: {
                    listener.invalidateRows(event);
                    continue block9;
                }
                case 2001: {
                    listener.columnsAdded(event);
                    continue block9;
                }
                case 2002: {
                    listener.columnsRemoved(event);
                    continue block9;
                }
                case 2003: {
                    listener.invalidateColumns(event);
                    continue block9;
                }
            }
        }
    }

    void _applyConstraints() {
        int count = 0;
        TwoDModel ds = this.getModel();
        int rowCount = ds.getRowCount();
        if (this._dataConstraint == null) {
            count = rowCount;
            this._filteredToUnfiltered = null;
        } else {
            if (this._filteredToUnfiltered == null) {
                this._filteredToUnfiltered = new int[ds.getRowCount()];
            }
            if (this._parser == null) {
                this._parser = new ObjectTestGenerator(this.getDescriptorProvider());
            }
            ObjectTest tester = this._parser.getObjectTest(this._dataConstraint);
            int columnCount = this.getColumnCount();
            ObjectTestRowImpl row = new ObjectTestRowImpl(columnCount);
            for (int i = 0; i < rowCount; ++i) {
                for (int j = 0; j < columnCount; ++j) {
                    row.setObject(j, ds.getData(j, i));
                }
                if (!tester.test(row)) continue;
                this._filteredToUnfiltered[count] = i;
                ++count;
            }
        }
        int diff = count - this._filteredRowCount;
        this._filteredRowCount = count;
        if (diff < 0) {
            this._sendRowsRemovedEvent(-diff);
        } else if (diff > 0) {
            this._sendRowsAddedEvent(diff);
        }
    }

    private void _sendRowsRemovedEvent(int count) {
        TwoDModelEvent event = new TwoDModelEvent((Object)this, 2005, 0, count);
        this.processTwoDModelEvent(event);
        event = new TwoDModelEvent((Object)this, 2006, 0, this.getRowCount());
        this.processTwoDModelEvent(event);
    }

    private void _sendRowsAddedEvent(int count) {
        TwoDModelEvent event = new TwoDModelEvent((Object)this, 2004, 0, count);
        this.processTwoDModelEvent(event);
        event = new TwoDModelEvent((Object)this, 2006, 0, this.getRowCount());
        this.processTwoDModelEvent(event);
    }

    private void _sendCellInvalidEvent(int column, int row) {
        TwoDModelEvent event = new TwoDModelEvent((Object)this, 2007, column, 1, row, 1);
        this.processTwoDModelEvent(event);
    }

    private TwoDModelListener _getListener() {
        if (this._listener == null) {
            this._listener = new Update();
        }
        return this._listener;
    }

    private class Update
    implements TwoDModelListener {
        private Update() {
        }

        public void rowsAdded(TwoDModelEvent e) {
            ConstrainableModel.this._applyConstraints();
        }

        public void rowsRemoved(TwoDModelEvent e) {
            ConstrainableModel.this._applyConstraints();
        }

        public void invalidateRows(TwoDModelEvent e) {
            TwoDModelEvent newEvent = new TwoDModelEvent((Object)this, 2006, 0, ConstrainableModel.this.getRowCount());
            ConstrainableModel.this.processTwoDModelEvent(newEvent);
        }

        public void columnsAdded(TwoDModelEvent e) {
            TwoDModelEvent newEvent = new TwoDModelEvent((Object)this, 2001, e.getColumnStartIndex(), e.getColumnCount());
            ConstrainableModel.this.processTwoDModelEvent(newEvent);
            ConstrainableModel.this._applyConstraints();
        }

        public void columnsRemoved(TwoDModelEvent e) {
            TwoDModelEvent newEvent = new TwoDModelEvent((Object)this, 2002, e.getColumnStartIndex(), e.getColumnCount());
            ConstrainableModel.this.processTwoDModelEvent(newEvent);
            ConstrainableModel.this._applyConstraints();
        }

        public void invalidateColumns(TwoDModelEvent e) {
            TwoDModelEvent newEvent = new TwoDModelEvent((Object)this, 2003, e.getColumnStartIndex(), e.getColumnCount());
            ConstrainableModel.this.processTwoDModelEvent(newEvent);
        }

        public void invalidateCells(TwoDModelEvent e) {
            TwoDModelEvent newEvent = new TwoDModelEvent((Object)this, 2007, 0, ConstrainableModel.this.getColumnCount(), 0, ConstrainableModel.this.getRowCount());
            ConstrainableModel.this.processTwoDModelEvent(newEvent);
        }
    }
}

