/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.handler.classpath;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URL;
import javax.swing.Icon;
import oracle.ide.model.Project;
import oracle.ide.model.SingletonProvider;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFileSystemHelper;
import oracle.ide.net.URLFilter;
import oracle.jdeveloper.handler.classpath.ClasspathSingleton;

public class ClasspathURLFileSystemHelper
extends URLFileSystemHelper {
    public URL canonicalize(URL url) {
        URL resolved = this.resolve(url);
        return resolved == null ? url : URLFileSystem.canonicalize((URL)resolved);
    }

    public boolean canRead(URL url) {
        URL resolved = this.resolve(url);
        return resolved == null ? false : URLFileSystem.canRead((URL)resolved);
    }

    public boolean canWrite(URL url) {
        URL resolved = this.resolve(url);
        return resolved == null ? false : URLFileSystem.canWrite((URL)resolved);
    }

    public boolean canCreate(URL url) {
        URL resolved = this.resolve(url);
        return resolved == null ? false : URLFileSystem.canCreate((URL)resolved);
    }

    public boolean canDelete(URL url) {
        URL resolved = this.resolve(url);
        return resolved == null ? false : URLFileSystem.canDelete((URL)resolved);
    }

    public boolean isValid(URL url) {
        URL resolved = this.resolve(url);
        return resolved == null ? false : URLFileSystem.isValid((URL)resolved);
    }

    public void delete(URL url) throws IOException {
        URLFileSystem.deleteEx((URL)this.resolve(url));
    }

    public boolean equals(URL url1, URL url2) {
        return URLFileSystem.equals((URL)this.resolve(url1), (URL)this.resolve(url2));
    }

    public int hashCode(URL url) {
        return URLFileSystem.hashCode((URL)this.resolve(url));
    }

    public boolean exists(URL url) {
        return URLFileSystem.exists((URL)this.resolve(url));
    }

    public Icon getDefaultIcon(URL url) {
        return URLFileSystem.getDefaultIcon((URL)this.resolve(url));
    }

    public String getFileName(URL url) {
        return super.getFileName(url);
    }

    public long getLength(URL url) {
        URL resolved = this.resolve(url);
        return resolved == null ? -1L : URLFileSystem.getLength((URL)resolved);
    }

    public String getName(URL url) {
        return super.getName(url);
    }

    public URL getParent(URL url) {
        return super.getParent(url);
    }

    public String getPath(URL url) {
        return super.getPath(url);
    }

    public String getPathNoExt(URL url) {
        return super.getPathNoExt(url);
    }

    public String getPlatformPathName(URL url) {
        return super.getPlatformPathName(url);
    }

    public boolean isBaseURLFor(URL url1, URL url2) {
        return URLFileSystem.isBaseURLFor((URL)this.resolve(url1), (URL)this.resolve(url2));
    }

    public boolean isDirectory(URL url) {
        return URLFileSystem.isDirectory((URL)this.resolve(url));
    }

    public boolean isDirectoryPath(URL url) {
        return URLFileSystem.isDirectoryPath((URL)this.resolve(url));
    }

    public boolean isHidden(URL url) {
        return URLFileSystem.isHidden((URL)this.resolve(url));
    }

    public boolean isReadOnly(URL url) {
        return URLFileSystem.isReadOnly((URL)this.resolve(url));
    }

    public boolean isRegularFile(URL url) {
        return URLFileSystem.isRegularFile((URL)this.resolve(url));
    }

    public boolean isLocal(URL url) {
        return true;
    }

    public long lastModified(URL url) {
        URL resolved = this.resolve(url);
        return resolved == null ? -1L : URLFileSystem.lastModified((URL)resolved);
    }

    public URL[] list(URL url) {
        return URLFileSystem.list((URL)this.resolve(url));
    }

    public URL[] list(URL url, URLFilter filter) {
        return URLFileSystem.list((URL)this.resolve(url), (URLFilter)filter);
    }

    public boolean mkdir(URL url) {
        return URLFileSystem.mkdir((URL)this.resolve(url));
    }

    public boolean mkdirs(URL url) {
        return URLFileSystem.mkdirs((URL)this.resolve(url));
    }

    public InputStream openInputStream(URL url) throws IOException {
        URL resolved = this.resolve(url);
        if (resolved == null) {
            throw new IOException("Unable to resolve classpath URL " + url.toString());
        }
        return URLFileSystem.openInputStream((URL)resolved);
    }

    public OutputStream openOutputStream(URL url) throws IOException {
        URL resolved = this.resolve(url);
        if (resolved == null) {
            throw new IOException("Unable to resolve classpath URL " + url.toString());
        }
        return URLFileSystem.openOutputStream((URL)resolved);
    }

    public void rename(URL oldURL, URL newURL) throws IOException {
        URLFileSystem.renameEx((URL)this.resolve(oldURL), (URL)this.resolve(newURL));
    }

    public boolean setLastModified(URL url, long time) {
        return URLFileSystem.setLastModified((URL)this.resolve(url), (long)time);
    }

    public boolean setReadOnly(URL url, boolean readOnly) {
        return URLFileSystem.setReadOnly((URL)this.resolve(url), (boolean)readOnly);
    }

    public String toDisplayString(URL url) {
        return URLFileSystem.toDisplayString((URL)this.resolve(url));
    }

    public URL getBaseParent(URL url, String relativeSpec) {
        URL resolved = this.resolve(url);
        if (resolved == null) {
            return URLFileSystem.getBaseParent((URL)resolved, (String)relativeSpec);
        }
        return super.getBaseParent(url, relativeSpec);
    }

    public Reader createReader(URL url, String encoding) throws IOException {
        URL resolved = this.resolve(url);
        if (resolved == null) {
            throw new IOException("Unable to resolve classpath URL " + url.toString());
        }
        return URLFileSystem.createReader((URL)resolved, (String)encoding);
    }

    private URL resolve(URL url) {
        Project context;
        ClasspathSingleton find = (ClasspathSingleton)SingletonProvider.find(ClasspathSingleton.class);
        if (find != null && (context = find.getContextProject()) != null) {
            return find.resolveClasspathURL(context, url);
        }
        return null;
    }
}

