/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.insight.completion.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.GeneralPath;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import net.miginfocom.swing.MigLayout;
import oracle.ide.Ide;
import oracle.ide.config.Preferences;
import oracle.ide.controller.IdeAction;
import oracle.ide.insight.InsightActionListener;
import oracle.ide.insight.InsightBundle;
import oracle.ide.insight.InsightController;
import oracle.ide.insight.InsightItem;
import oracle.ide.insight.InsightModel;
import oracle.ide.insight.completion.CompletionContext;
import oracle.ide.insight.completion.CompletionModel;
import oracle.ide.insight.completion.CompletionMultiProvider;
import oracle.ide.insight.completion.CompletionProvider;
import oracle.ide.insight.completion.CompletionSupport;
import oracle.ide.insight.completion.ui.DetailPopup;
import oracle.ide.insight.completion.ui.InsightView;
import oracle.ide.insight.completion.ui.PopupController;
import oracle.ide.insight.options.InsightOptions;
import oracle.ide.keyboard.KeyStrokeContext;
import oracle.ide.keyboard.KeyStrokeContextRegistry;
import oracle.ide.keyboard.KeyStrokeMap;
import oracle.ide.keyboard.KeyStrokeOptions;
import oracle.ide.keyboard.KeyUtil;
import oracle.javatools.buffer.GuardedException;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.editor.EditorProperties;
import oracle.javatools.ui.popup.PopupWindow;
import oracle.javatools.ui.popup.PopupWindowListener;
import oracle.javatools.ui.popup.PopupWindowManager;

public final class InsightPopup {
    private static final Color STATUS_BAR_COLOR = new Color(255, 255, 255, 80);
    private PopupWindow insightWindow;
    private InsightView insightView;
    private CompletionContext<CompletionSupport> insightContext;
    private CompletionModel insightModel;
    private final InsightActionL insightActionL = new InsightActionL();
    private final PopupWindowL popupWindowL = new PopupWindowL();
    static final Font OPTIONS_FONT = UIManager.getFont("Label.font").deriveFont(9.0f);
    private static final Color STATUS_DIVIDER_COLOR = new Color(125, 125, 125, 125);
    private InsightController.State state = InsightController.State.HIDDEN;
    private JPanel optionsPanel;
    private JPanel filterByPanel;
    private JLabel statusLabel;
    private final List<PropertyChangeListener> propertyChangeListeners = new CopyOnWriteArrayList<PropertyChangeListener>();
    private final DetailPopup detailPopup = new DetailPopup(this);

    InsightView getInsightView() {
        return this.insightView;
    }

    CompletionContext getInsightContext() {
        return this.insightContext;
    }

    PopupWindow getInsightWindow() {
        return this.insightWindow;
    }

    private JComponent createPopupContent(CompletionContext insightContext) {
        JComponent statusComponent = this.createStatusComponent();
        JComponent gui = this.insightView.getGui(insightContext);
        JPanel contentPanel = new JPanel(new BorderLayout());
        contentPanel.setBackground(gui.getBackground());
        gui.validate();
        contentPanel.setBorder(UIManager.getBorder("ToolTip.border"));
        contentPanel.add((Component)gui, "Center");
        if (statusComponent != null) {
            contentPanel.add((Component)statusComponent, "South");
        }
        return contentPanel;
    }

    private JComponent createStatusComponent() {
        JPanel p = null;
        this.statusLabel = new JLabel("");
        this.statusLabel.setFont(OPTIONS_FONT);
        this.statusLabel.setHorizontalAlignment(10);
        this.statusLabel.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 6));
        final OptionsButton optionsButton = new OptionsButton();
        optionsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InsightPopup.this.optionsPanel.setVisible(!InsightPopup.this.optionsPanel.isVisible());
                InsightPopup.this.optionsPanel.revalidate();
                if (InsightPopup.this.insightWindow != null && InsightPopup.this.insightWindow.getWindow() != null) {
                    InsightPopup.this.insightWindow.getWindow().pack();
                }
            }
        });
        this.optionsPanel = new JPanel((LayoutManager)new MigLayout("ins 1 2 0 2, gapy 0, nogrid, fill, hidemode 3")){

            @Override
            public void paintComponent(Graphics g) {
                super.paintComponent(g);
                if (InsightPopup.this.statusLabel.getWidth() > 1) {
                    g = g.create();
                    g.setColor(STATUS_DIVIDER_COLOR);
                    g.drawLine(0, 0, this.getWidth() - optionsButton.getWidth() - 1, 0);
                    g.dispose();
                }
            }
        };
        this.optionsPanel.setOpaque(false);
        this.optionsPanel.setVisible(false);
        this.detailPopup.addOptions(this.optionsPanel);
        InsightOptions options = InsightOptions.getInstance((PropertyStorage)Preferences.getPreferences());
        final JRadioButton startsWithFilterButton = new JRadioButton(InsightBundle.get("POPUP_USE_STARTS_WITH_FILTER"), !options.isFilterByContains());
        startsWithFilterButton.setFont(OPTIONS_FONT);
        startsWithFilterButton.setOpaque(false);
        startsWithFilterButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InsightOptions options = InsightOptions.getInstance((PropertyStorage)Preferences.getPreferences());
                options.setFilterByContains(!startsWithFilterButton.isSelected());
                InsightPopup.this.insightContext.updateInsight();
            }
        });
        final JRadioButton containsFilterButton = new JRadioButton(InsightBundle.get("POPUP_USE_CONTAINS_FILTER"), options.isFilterByContains());
        containsFilterButton.setFont(OPTIONS_FONT);
        containsFilterButton.setOpaque(false);
        containsFilterButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InsightOptions options = InsightOptions.getInstance((PropertyStorage)Preferences.getPreferences());
                options.setFilterByContains(containsFilterButton.isSelected());
                InsightPopup.this.insightContext.updateInsight();
            }
        });
        InsightOptions insightOptions = InsightOptions.getInstance((PropertyStorage)Preferences.getPreferences());
        final JCheckBox filterButton = new JCheckBox(InsightBundle.get("POPUP_USE_FILTER"), insightOptions.isCompleteFiltered());
        filterButton.setFont(OPTIONS_FONT);
        filterButton.setOpaque(false);
        filterButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InsightOptions insightOptions = InsightOptions.getInstance((PropertyStorage)Preferences.getPreferences());
                insightOptions.setCompleteFiltered(filterButton.isSelected());
                containsFilterButton.setEnabled(filterButton.isSelected());
                startsWithFilterButton.setEnabled(filterButton.isSelected());
                EditorProperties properties = EditorProperties.getProperties();
                properties.putBooleanProperty("insight-filter-matching", filterButton.isSelected());
                InsightPopup.this.insightContext.updateInsight();
            }
        });
        containsFilterButton.setEnabled(filterButton.isSelected());
        startsWithFilterButton.setEnabled(filterButton.isSelected());
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(startsWithFilterButton);
        buttonGroup.add(containsFilterButton);
        this.filterByPanel = new JPanel((LayoutManager)new MigLayout("fillx"));
        this.filterByPanel.setOpaque(false);
        this.filterByPanel.add((Component)filterButton, "");
        this.filterByPanel.add((Component)startsWithFilterButton, "gapx 4");
        this.filterByPanel.add((Component)containsFilterButton, "gapx 8");
        this.optionsPanel.add((Component)this.filterByPanel, "newline, span");
        p = new JPanel((LayoutManager)new MigLayout("ins 0, hidemode 3, fill, gap 0")){

            @Override
            protected void paintComponent(Graphics g) {
                g.setColor(STATUS_BAR_COLOR);
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
                super.paintComponent(g);
            }
        };
        p.add((Component)this.statusLabel, "growx 100");
        p.add((Component)this.optionsPanel, "dock south");
        p.add((Component)optionsButton, "dock east");
        p.setOpaque(false);
        return p;
    }

    private void updateStatus() {
        this.filterByPanel.setVisible(this.insightView.getCustomizer().isShowFilterByOption());
        CompletionMultiProvider multiController = this.insightContext.getMultiProvider();
        String status = "";
        CompletionProvider currentProvider = multiController.getCurrentProvider();
        CompletionProvider nextProvider = multiController.getNextProvider();
        IdeAction action = IdeAction.find((String)"completion-insight");
        KeyStrokeOptions kso = Ide.getSettings().getKeyStrokeOptions();
        KeyStrokeContextRegistry kscr = Ide.getKeyStrokeContextRegistry();
        KeyStrokeContext ksc = kscr.getContext("oracle/ide/ceditor/keymap/accelerators.xml");
        String acc = "Completion";
        if (ksc != null) {
            KeyStrokeMap ksm = kso.getLocalKeyMap(ksc);
            acc = KeyUtil.getAcceleratorTooltip((KeyStrokeMap)ksm, (int)action.getCommandId());
        }
        if (nextProvider != currentProvider) {
            Object[] fields = new Object[]{currentProvider.getDisplayName(), acc, nextProvider.getDisplayName()};
            status = MessageFormat.format(InsightBundle.get("POPUP_INSTRUCTION"), fields);
        } else {
            status = currentProvider.getDisplayName();
        }
        this.statusLabel.setText(status);
    }

    private void setState(InsightController.State newState) {
        InsightController.State oldState = this.state;
        this.state = newState;
        this.firePropertyChangeEvent(new PropertyChangeEvent(this, "state", (Object)oldState, (Object)newState));
    }

    public InsightController.State getState() {
        return this.state;
    }

    public void show(CompletionContext insightContext) {
        try {
            if (this.state == InsightController.State.SHOWING) {
                return;
            }
            if (!((Component)insightContext.getAdapter().getTextComponent()).isShowing()) {
                return;
            }
            this.insightWindow = null;
            this.insightContext = insightContext;
            this.insightModel = insightContext.getModel();
            insightContext.getAdapter().addInsightActionListener(this.insightActionL);
            this.insightView = this.createInsightView(this.insightModel);
            Object textComponent = insightContext.getAdapter().getTextComponent();
            for (PopupWindow w : new ArrayList(PopupWindowManager.getPopupWindows(textComponent))) {
                if (w.getWindow() == null || !w.getWindow().isShowing() || w.getClientProperty((Object)"popup-key-insight") != Boolean.TRUE) continue;
                PopupWindowManager.dismissPopup((PopupWindow)w);
            }
            Rectangle caretRect = ((JTextComponent)textComponent).modelToView(((JTextComponent)textComponent).getCaretPosition());
            JComponent content = this.createPopupContent(insightContext);
            this.updateStatus();
            this.insightWindow = PopupWindowManager.showPopup(textComponent, (JComponent)content, (boolean)false, (Rectangle)caretRect, (int[])this.insightView.getCustomizer().getRelativeLocation().getLocations(), (boolean)true);
            this.insightWindow.putClientProperty((Object)"popup-key-insight", (Object)Boolean.TRUE);
            this.insightWindow.addPopupWindowListener((PopupWindowListener)this.popupWindowL);
            this.insightView.setSelectedItem(this.insightModel.getDefaultItem());
            this.setState(InsightController.State.SHOWING);
        }
        catch (BadLocationException e) {
            this.dismissPopup();
            this.popupClosed();
            Logger.getLogger("global").log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
        catch (RuntimeException e) {
            this.dismissPopup();
            this.popupClosed();
            Logger.getLogger("global").log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
    }

    public void update(CompletionContext insightContext, CompletionModel model) {
        try {
            this.insightContext = insightContext;
            this.insightModel = model;
            InsightOptions options = InsightOptions.getInstance((PropertyStorage)Preferences.getPreferences());
            if (options.isCompleteFiltered() && !model.getMatchingItems().isEmpty()) {
                this.insightView.setItems(model.getMatchingItems());
            } else {
                this.insightView.setItems(model.getItems());
            }
            this.insightView.setSelectedItem(model.getDefaultItem());
            this.insightWindow.getContent().revalidate();
            this.insightWindow.getWindow().pack();
            this.insightWindow.getContent().revalidate();
            this.insightWindow.getWindow().pack();
        }
        catch (Exception e) {
            if (this.state == InsightController.State.SHOWING) {
                this.hide();
            }
            this.dismissPopup();
            this.popupClosed();
        }
    }

    private void popupClosed() {
        if (this.insightContext != null) {
            this.insightContext.getAdapter().removeInsightActionListener(this.insightActionL);
        }
        this.setState(InsightController.State.HIDDEN);
        this.insightContext = null;
        this.insightModel = null;
        this.insightView = null;
        this.insightWindow = null;
    }

    public InsightItem getSelectedItem() {
        return this.insightView.getSelectedItem();
    }

    private InsightView createInsightView(InsightModel model) {
        InsightView view = new InsightView(new PopupController(this));
        InsightOptions options = InsightOptions.getInstance((PropertyStorage)Preferences.getPreferences());
        if (options.isCompleteFiltered() && !model.getMatchingItems().isEmpty()) {
            view.setItems(model.getMatchingItems());
        } else {
            view.setItems(model.getItems());
        }
        view.setSelectedItem(model.getDefaultItem());
        return view;
    }

    public void hide() {
        if (this.state != InsightController.State.SHOWING) {
            return;
        }
        assert (this.insightWindow != null);
        this.dismissPopup();
    }

    private void dismissPopup() {
        CompletionContext<CompletionSupport> currentInsightContext = this.insightContext;
        final PopupWindow currentInsightWindow = this.insightWindow;
        if (currentInsightContext != null && currentInsightWindow != null) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    PopupWindowManager.dismissPopup((PopupWindow)InsightPopup.this.insightWindow);
                    currentInsightWindow.removePopupWindowListener((PopupWindowListener)InsightPopup.this.popupWindowL);
                    InsightPopup.this.insightModel = null;
                    InsightPopup.this.insightWindow = null;
                    InsightPopup.this.insightContext = null;
                    InsightPopup.this.insightView = null;
                    InsightPopup.this.statusLabel = null;
                    InsightPopup.this.optionsPanel.removeAll();
                    InsightPopup.this.optionsPanel = null;
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                runnable.run();
            } else {
                SwingUtilities.invokeLater(runnable);
            }
        }
    }

    void addOptionsComponent(JComponent optionsComponent) {
        this.optionsPanel.add((Component)optionsComponent, "newline, grow");
    }

    private boolean handleEditorAction(InsightActionListener.Action action) {
        if (action == InsightActionListener.Action.CANCEL) {
            this.hide();
            return true;
        }
        if (action == InsightActionListener.Action.ENTER) {
            this.complete();
            return true;
        }
        if (action == InsightActionListener.Action.TAB && InsightOptions.getInstance((PropertyStorage)Preferences.getPreferences()).isCompleteSinglePartial()) {
            this.partialComplete();
            return true;
        }
        if (action == InsightActionListener.Action.INVOKE && ((CompletionSupport)this.insightContext.getSupport()).isShowOnShortcut() && this.insightContext instanceof CompletionContext) {
            CompletionMultiProvider multiController = this.insightContext.getMultiProvider();
            CompletionProvider provider = multiController.getNextProvider();
            multiController.setProvider(provider);
            return true;
        }
        return this.insightView.handleInsightAction(action);
    }

    void complete() {
        CompletionContext<CompletionSupport> localContext = this.insightContext;
        Object textComp = localContext.getAdapter().getTextComponent();
        Object item = this.insightView.getSelectedItem();
        CompletionModel model = this.insightModel;
        localContext.getAdapter().makeEditable();
        if (((JTextComponent)textComp).isEditable()) {
            InsightModel.Result result = null;
            try {
                result = model.complete(item);
            }
            catch (GuardedException ge) {
                this.hide();
                return;
            }
            CompletionContext<CompletionSupport> retriggerContext = null;
            if (result == InsightModel.Result.RETRIGGER) {
                retriggerContext = new CompletionContext<CompletionSupport>((CompletionSupport)localContext.getSupport(), CompletionContext.Invoked.AUTO, localContext.getMultiProvider());
            }
            this.hide();
            if (localContext.getSupport() != null && !((CompletionSupport)localContext.getSupport()).isDisposed()) {
                localContext.triggerToolTipInsight();
                if (result == InsightModel.Result.RETRIGGER && InsightOptions.getInstance((PropertyStorage)Preferences.getPreferences()).isCompletePopupEnabled()) {
                    Object support = retriggerContext.getSupport();
                    support.getInsightController().show(retriggerContext);
                }
            }
        }
    }

    void partialComplete() {
        this.insightContext.getAdapter().makeEditable();
        if (this.insightContext.getAdapter().isEditable()) {
            this.insightModel.partialComplete();
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeListeners.add(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeListeners.remove(listener);
    }

    private void firePropertyChangeEvent(PropertyChangeEvent event) {
        for (PropertyChangeListener l : this.propertyChangeListeners) {
            l.propertyChange(event);
        }
    }

    private class OptionsButton
    extends JToggleButton {
        private OptionsButton() {
            super(InsightBundle.get("POPUP_OPTIONS_BUTTON"), OptionsIcon.upIcon);
            this.setRolloverEnabled(true);
            this.setFont(this.getFont().deriveFont(9.0f));
            this.setMargin(new Insets(0, 0, 0, 0));
            this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 1, 0, 0, STATUS_DIVIDER_COLOR), BorderFactory.createEmptyBorder(1, 2, 1, 1)));
            this.setContentAreaFilled(false);
            this.setSelectedIcon(OptionsIcon.downIcon);
            this.setIconTextGap(2);
            this.setHorizontalTextPosition(10);
            this.setSelected(false);
        }

        @Override
        public void paintComponent(Graphics g) {
            if (this.getModel().isRollover()) {
                Graphics2D g2 = (Graphics2D)g.create();
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2.setColor(this.getBackground().brighter());
                g2.fillRoundRect(0, 1, this.getWidth() - 2, this.getHeight() - 3, 4, 4);
                g2.setColor(this.getBackground().darker());
                g2.drawRoundRect(0, 1, this.getWidth() - 2, this.getHeight() - 3, 4, 4);
            }
            super.paintComponent(g);
        }
    }

    private static class OptionsIcon
    implements Icon {
        static OptionsIcon upIcon = new OptionsIcon(true);
        static OptionsIcon downIcon = new OptionsIcon(false);
        boolean up;

        private OptionsIcon(boolean up) {
            this.up = up;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            Graphics2D g2 = (Graphics2D)g.create();
            g2.translate(x, y + 1);
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            int yGap = this.getIconHeight() / 4;
            GeneralPath triangle = new GeneralPath();
            g2.setColor(UIManager.getColor("Label.foreground"));
            int shapeWidth = this.getIconWidth() - 3;
            if (this.up) {
                triangle.moveTo(1.0f, yGap);
                triangle.lineTo(shapeWidth + 1, yGap);
                triangle.lineTo(shapeWidth / 2 + 1, this.getIconHeight() - yGap);
            } else {
                triangle.moveTo(1.0f, this.getIconHeight() - yGap - 1);
                triangle.lineTo(shapeWidth + 1, this.getIconHeight() - yGap - 1);
                triangle.lineTo(shapeWidth / 2 + 1, yGap - 1);
            }
            g2.fill(triangle);
        }

        @Override
        public int getIconWidth() {
            return 9;
        }

        @Override
        public int getIconHeight() {
            return 9;
        }
    }

    private class InsightActionL
    implements InsightActionListener {
        private InsightActionL() {
        }

        public boolean insightActionPerformed(InsightActionListener.Action action, JTextComponent textComponent) {
            return InsightPopup.this.handleEditorAction(action);
        }
    }

    private class PopupWindowL
    implements PopupWindowListener {
        private PopupWindowL() {
        }

        public void popupClosed(PopupWindow popupWindow, int how) {
            InsightPopup.this.popupClosed();
        }

        public void parentFocusGained(PopupWindow popupWindow) {
        }

        public void parentFocusLost(PopupWindow popupWindow, boolean isTemporary) {
            InsightPopup.this.hide();
        }
    }
}

