/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.insight.completion.ui;

import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.JTextComponent;
import oracle.ide.config.Preferences;
import oracle.ide.insight.InsightActionListener;
import oracle.ide.insight.InsightBundle;
import oracle.ide.insight.InsightController;
import oracle.ide.insight.completion.ui.DetailView;
import oracle.ide.insight.completion.ui.InsightPopup;
import oracle.javatools.ui.WindowTiler;

final class DetailPopup {
    private final InsightPopup insightPopup;
    private final Listener listener = new Listener();
    private DetailView detailView;
    private JCheckBox detailButton;
    private JWindow detailWindow;
    private String visibilityPrefKey = "DetailWindowVisibility";

    DetailPopup(InsightPopup insightPopup) {
        this.insightPopup = insightPopup;
        insightPopup.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("state")) {
                    if (evt.getNewValue() == InsightController.State.SHOWING) {
                        DetailPopup.this.activate();
                    } else if (evt.getNewValue() == InsightController.State.HIDDEN) {
                        DetailPopup.this.hide();
                        DetailPopup.this.dispose();
                    }
                }
            }
        });
    }

    private void activate() {
        this.detailView = this.insightPopup.getInsightView().getCustomizer().getDetailView();
        this.detailButton.setEnabled(this.detailView != null);
        if (this.detailView == null) {
            return;
        }
        this.insightPopup.getInsightContext().getAdapter().addInsightActionListener(this.listener);
        if (this.isInitiallyVisible()) {
            this.show();
        }
    }

    private void hide() {
        this.listener.timer.stop();
        if (this.insightPopup.getInsightView() != null) {
            this.insightPopup.getInsightView().removeChangeListener(this.listener);
        }
        if (this.detailWindow != null) {
            this.detailWindow.setVisible(false);
            this.detailWindow.dispose();
        }
        if (this.detailView != null) {
            this.detailView.hidden(this.insightPopup.getInsightContext());
        }
    }

    private void dispose() {
        if (this.insightPopup != null && this.insightPopup.getInsightContext() != null) {
            this.insightPopup.getInsightContext().getAdapter().removeInsightActionListener(this.listener);
        }
        this.detailWindow = null;
        this.detailView = null;
    }

    private void show() {
        if (this.detailView == null) {
            return;
        }
        JComponent detail = this.detailView.getDetailComponent();
        this.detailView.itemSelected(this.insightPopup.getInsightContext(), this.insightPopup.getSelectedItem());
        Object textComponent = this.insightPopup.getInsightContext().getAdapter().getTextComponent();
        Window parentWindow = SwingUtilities.getWindowAncestor(textComponent);
        this.detailWindow = new JWindow(parentWindow);
        this.detailWindow.setFocusableWindowState(false);
        this.detailWindow.getRootPane().setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, UIManager.getColor("controlDkShadow")));
        this.detailWindow.add(detail);
        this.detailWindow.pack();
        this.detailWindow.pack();
        this.insightPopup.getInsightView().addChangeListener(this.listener);
        WindowTiler tiler = new WindowTiler((Component)this.insightPopup.getInsightWindow().getWindow(), (Window)this.detailWindow);
        ArrayList<WindowTiler.Alignment> alignments = new ArrayList<WindowTiler.Alignment>();
        alignments.add(WindowTiler.Alignment.RIGHT);
        alignments.add(WindowTiler.Alignment.LEFT);
        alignments.add(WindowTiler.Alignment.BOTTOM);
        tiler.setAlignment(alignments);
        this.detailWindow.setVisible(true);
        this.detailView.shown(this.insightPopup.getInsightContext());
    }

    private boolean isInitiallyVisible() {
        Preferences preferences = Preferences.getPreferences();
        return preferences.getProperties().getBoolean(this.visibilityPrefKey, true);
    }

    private void setVisibility(boolean visible) {
        Preferences preferences = Preferences.getPreferences();
        preferences.getProperties().putBoolean(this.visibilityPrefKey, visible);
    }

    void addOptions(JComponent optionsPanel) {
        this.detailButton = new JCheckBox(InsightBundle.get("INSIGHT_DOC_POPUP_BUTTON"), this.isInitiallyVisible());
        this.detailButton.setFont(InsightPopup.OPTIONS_FONT);
        this.detailButton.setOpaque(false);
        this.detailButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DetailPopup.this.setVisibility(DetailPopup.this.detailButton.isSelected());
                if (DetailPopup.this.detailButton.isSelected()) {
                    DetailPopup.this.show();
                } else {
                    DetailPopup.this.hide();
                }
            }
        });
        optionsPanel.add(this.detailButton);
    }

    private class Listener
    implements InsightActionListener,
    ChangeListener,
    ActionListener {
        private Timer timer = new Timer(200, this);

        private Listener() {
            this.timer.setRepeats(false);
        }

        public boolean insightActionPerformed(InsightActionListener.Action action, JTextComponent textComponent) {
            if (action == InsightActionListener.Action.SHOW_DOC) {
                if (DetailPopup.this.detailWindow == null || !DetailPopup.this.detailWindow.isVisible()) {
                    DetailPopup.this.show();
                } else {
                    DetailPopup.this.hide();
                }
                return true;
            }
            return false;
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.timer.restart();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (DetailPopup.this.detailWindow != null) {
                DetailPopup.this.detailView.itemSelected(DetailPopup.this.insightPopup.getInsightContext(), DetailPopup.this.insightPopup.getSelectedItem());
                DetailPopup.this.detailWindow.pack();
            }
        }
    }
}

