/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.insight;

import javax.swing.Icon;

public abstract class InsightItem {
    public static final int GROUP_NORMAL = 100;
    public static final int GROUP_OVERRIDES = 90;
    public static final int GROUP_PREFERRED = 50;
    public static final int GROUP_METHOD_PARAMETERS = 20;
    private boolean isFilterable = true;
    private int group = 100;
    private float weight = 0.0f;

    public abstract Icon getIcon();

    public abstract Object getDisplayValue();

    public abstract String getName();

    public int getGroup() {
        return this.group;
    }

    public void setGroup(int group) {
        this.group = group;
    }

    public float getWeight() {
        return this.weight;
    }

    public void setWeight(float weight) {
        this.weight = weight;
    }

    public int compareTo(Object object) {
        InsightItem item2 = (InsightItem)object;
        if (this.getGroup() != item2.getGroup()) {
            return this.getGroup() < item2.getGroup() ? -1 : 1;
        }
        String name1 = this.getName();
        String name2 = item2.getName();
        return InsightItem.compareInsensitive(name1, name2);
    }

    public static int compareInsensitive(String name1, String name2) {
        int result = name1.compareToIgnoreCase(name2);
        if (result == 0) {
            result = name1.compareTo(name2);
        }
        return result;
    }

    public static int compareSensitive(String name1, String name2) {
        return name1.compareTo(name2);
    }

    public String getAccessibleText() {
        return this.getDisplayValue().toString();
    }

    public void setFilterable(boolean isFilterable) {
        this.isFilterable = isFilterable;
    }

    public boolean isFilterable() {
        return this.isFilterable;
    }
}

