/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.wizard;

import oracle.ide.panels.CommitListener;
import oracle.ide.panels.CommitNotifier;
import oracle.ide.panels.MetaTraversable;
import oracle.ide.panels.Traversable;

public class Step
extends MetaTraversable {
    private String _pageTitle;
    private String _stepLabel;
    private transient boolean _expectedTransitionSet;
    private transient Object _expectedTransition;

    Step(String traversableClass) {
        super(traversableClass);
    }

    public Step(Class traversableClass) {
        this(null, traversableClass);
    }

    public Step(String title, Class traversableClass) {
        this(title, traversableClass, null, null, null);
    }

    public Step(String title, Class traversableClass, String helpID) {
        this(title, traversableClass, null, null, helpID);
    }

    public Step(Class traversableClass, Class[] constructorArgTypes, Object[] constructorArgs) {
        this(null, traversableClass, constructorArgTypes, constructorArgs, null);
    }

    public Step(String title, Class traversableClass, Class[] constructorArgTypes, Object[] constructorArgs, String helpID) {
        super(traversableClass, constructorArgTypes, constructorArgs);
        this._pageTitle = title;
        this.setHelpID(helpID);
    }

    protected Step() {
    }

    public static Step[] newSteps(String[] traversableClasses) {
        if (traversableClasses == null) {
            return null;
        }
        int n = traversableClasses.length;
        Step[] steps = new Step[n];
        for (int i = n - 1; i >= 0; --i) {
            steps[i] = new Step(traversableClasses[i]);
        }
        return steps;
    }

    public String getPageTitle() {
        return this._pageTitle;
    }

    public void setPageTitle(String pageTitle) {
        this._pageTitle = pageTitle;
    }

    public String getStepLabel() {
        return this._stepLabel;
    }

    public void setStepLabel(String stepLabel) {
        this._stepLabel = stepLabel;
    }

    public final Traversable newTraversable(CommitNotifier commitNotifier) {
        Traversable newTraversable = this.newTraversable();
        if (commitNotifier != null && newTraversable instanceof CommitListener) {
            commitNotifier.addCommitListener((CommitListener)((Object)newTraversable));
        }
        return newTraversable;
    }

    @Override
    public Object copyTo(Object target) {
        Step copy = target != null ? (Step)target : new Step();
        this.copyToImpl(copy);
        return copy;
    }

    protected final void copyToImpl(Step copy) {
        super.copyToImpl(copy);
    }

    Object getExpectedTransition() {
        return this._expectedTransition;
    }

    void setExpectedTransition(Object expectedTransition) {
        this._expectedTransition = expectedTransition;
        this._expectedTransitionSet = true;
    }

    boolean isExpectedTransitionSet() {
        return this._expectedTransitionSet;
    }
}

