/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.marshal.xml;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class ClassLoaderHelper {
    public static final String CLASSLOADER_MAP_KEY = "classloader-map";
    private static List<ClassLoaderProvider> s_classloaderProvders = new ArrayList<ClassLoaderProvider>();
    private static HashMap<String, String> s_className2classLoader = new HashMap();

    private ClassLoaderHelper() {
    }

    public static void addClassLoaderProvider(ClassLoaderProvider provider) {
        s_classloaderProvders.add(provider);
    }

    public static void populateClassLoaders(Object key, Object value) {
        if (CLASSLOADER_MAP_KEY.equals(key) && value instanceof Map) {
            s_className2classLoader.putAll((Map)value);
        }
    }

    public static void addClassnameToClassloaderIdMapping(String className, String classloaderId) {
        s_className2classLoader.put(className, classloaderId);
    }

    public static ClassLoader getClassLoader(String classname) {
        String classLoaderId = null;
        if (s_className2classLoader.containsKey(classname)) {
            classLoaderId = s_className2classLoader.get(classname);
            for (ClassLoaderProvider clProvider : s_classloaderProvders) {
                ClassLoader classloader = clProvider.getClassLoader(classLoaderId);
                if (classloader == null) continue;
                return classloader;
            }
        }
        return null;
    }

    public static boolean containsKey(String classname) {
        return s_className2classLoader.containsKey(classname);
    }

    public static interface ClassLoaderProvider {
        public ClassLoader getClassLoader(String var1);
    }
}

