/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.ceditor.text;

import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.text.AttributedString;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import oracle.ide.ceditor.text.CodeRendererUtils;
import oracle.ide.ceditor.text.SourceColorizer;
import oracle.javatools.util.Pair;

public class CodeTreeCellRenderer
extends DefaultTreeCellRenderer {
    private final CodeRendererUtils.PaintContext paintContext = new CodeRendererUtils.PaintContext();
    private final Color _inactiveBackgroundSelectionColor;

    public CodeTreeCellRenderer() {
        this.paintContext.component = this;
        Color c = UIManager.getColor("oracle.ide.explorer.TreeExplorer.inactiveSelectionBackground");
        this._inactiveBackgroundSelectionColor = c == null ? this.backgroundSelectionColor : c;
        this.paintContext.borderColor = this.getBorderSelectionColor();
    }

    public static AttributedString[] getCodeTreeNodes(String code, int[] startOffsets, int[] endOffsets, String language) {
        return SourceColorizer.toAttributedString(language, code, startOffsets, endOffsets);
    }

    @Override
    public synchronized Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        this.paintContext.aString = null;
        this.paintContext.isSelected = sel;
        this.paintContext.hasFocus = hasFocus;
        if (sel) {
            this.paintContext.foreground = this.getTextSelectionColor();
            this.paintContext.background = hasFocus ? this.getBackgroundSelectionColor() : this._inactiveBackgroundSelectionColor;
        } else {
            this.paintContext.foreground = this.getTextNonSelectionColor();
            this.paintContext.background = this.getBackgroundNonSelectionColor();
        }
        if (value instanceof DefaultMutableTreeNode) {
            Pair pair;
            Object first;
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)value;
            Object userObject = defaultMutableTreeNode.getUserObject();
            if (userObject instanceof AttributedString) {
                this.paintContext.aString = (AttributedString)userObject;
            } else if (userObject instanceof Pair && (first = (pair = (Pair)userObject).getFirst()) instanceof AttributedString) {
                this.paintContext.aString = (AttributedString)first;
            }
        } else if (value instanceof AttributedString) {
            this.paintContext.aString = (AttributedString)value;
        }
        if (this.paintContext.aString != null) {
            CodeRendererUtils.configureRenderer(this, this.paintContext.aString);
            return this;
        }
        if (EventQueue.isDispatchThread()) {
            this.setPreferredSize(null);
        }
        return super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
    }

    @Override
    public synchronized void paint(Graphics g) {
        if (this.paintContext.aString == null) {
            super.paint(g);
        } else {
            CodeRendererUtils.paint(g, this.paintContext);
        }
    }
}

