/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.ceditor.text;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.font.TextAttribute;
import java.text.AttributedString;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;
import oracle.ide.ceditor.text.CodeRendererUtils;

public abstract class CodeListCellRenderer<T>
extends DefaultListCellRenderer {
    private final CodeRendererUtils.PaintContext paintContext = new CodeRendererUtils.PaintContext();

    public CodeListCellRenderer() {
        this.paintContext.component = this;
    }

    public abstract AttributedString getAttributedStringForItem(T var1);

    @Override
    public synchronized Component getListCellRendererComponent(JList list, Object value, int index, boolean sel, boolean hasFocus) {
        JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, sel, hasFocus);
        this.paintContext.aString = null;
        this.paintContext.isSelected = sel;
        this.paintContext.hasFocus = hasFocus;
        this.paintContext.foreground = label.getForeground();
        this.paintContext.background = label.getBackground();
        this.paintContext.aString = this.getAttributedStringForItem(value);
        if (sel && this.paintContext.aString != null && !CodeListCellRenderer.isZeroLength(this.paintContext.aString)) {
            this.paintContext.aString = new AttributedString(this.paintContext.aString.getIterator());
            this.paintContext.aString.addAttribute(TextAttribute.FOREGROUND, this.paintContext.foreground);
        }
        if (this.paintContext.aString != null && !CodeListCellRenderer.isZeroLength(this.paintContext.aString)) {
            CodeRendererUtils.configureRenderer(this, this.paintContext.aString);
        } else if (EventQueue.isDispatchThread()) {
            this.setPreferredSize(null);
        }
        return label;
    }

    @Override
    public synchronized void paint(Graphics g) {
        if (this.paintContext.aString == null || CodeListCellRenderer.isZeroLength(this.paintContext.aString)) {
            super.paint(g);
        } else {
            CodeRendererUtils.paint(g, this.paintContext);
        }
    }

    private static boolean isZeroLength(AttributedString as) {
        return as.getIterator().getEndIndex() == 0;
    }
}

