/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.jdevimpl.runner.ExtensionResources;
import oracle.jdevimpl.runner.RunItemController;

public class RunItemActions {
    private static final String TOOLBAR_RUNCONFIG_PROJECT_COMMAND_PREFIX = "ToolbarRunConfigurationProjectCommand";
    private static RunItemActions instance;
    private static RunItemController controller;
    private static IdeAction actionEmpty;
    private static IdeAction actionMruDebug;
    private static IdeAction actionMruRun;
    private static IdeAction actionRunProject;
    private static IdeAction actionDebugProject;
    private static IdeAction actionManageRunConfigurations;
    private static IdeAction actionDebugSuspendAllBreakpoints;
    private static int actionMruRunCommandId;
    private static int actionMruDebugCommandId;
    private static Set<Integer> actionRunConfigurationCommandIds;
    private static IdeAction actionContextMenuRun;
    private static IdeAction actionRunSelection;
    private static IdeAction actionContextMenuDebug;
    private static IdeAction actionDebugSelection;
    private static IdeAction actionCodeEditorToggleBreakpoint;
    private static IdeAction actionCodeEditorToggleWatchpoint;
    private static IdeAction actionCodeEditorEnableBreakpoint;
    private static IdeAction actionCodeEditorDisableBreakpoint;
    private static IdeAction actionCodeEditorEditBreakpoint;

    private RunItemActions() {
        controller = RunItemController.getInstance();
        actionRunConfigurationCommandIds = new HashSet<Integer>();
    }

    public static RunItemActions getInstance() {
        if (instance == null) {
            instance = new RunItemActions();
        }
        return instance;
    }

    List<IdeAction> makeActions(List<String> runConfigNames, String translatedCategory, String category) {
        ArrayList<IdeAction> actions = new ArrayList<IdeAction>();
        String fullPrefix = TOOLBAR_RUNCONFIG_PROJECT_COMMAND_PREFIX + category;
        for (int i = 0; i < runConfigNames.size(); ++i) {
            String runConfigName = runConfigNames.get(i);
            int cmdId = Ide.findOrCreateCmdID((String)(fullPrefix + i));
            actionRunConfigurationCommandIds.add(cmdId);
            IdeAction action = IdeAction.findOrCreate((int)cmdId, null, (String)runConfigName, (String)translatedCategory, null, null, null, (boolean)true);
            action.putValue("Name", (Object)runConfigName);
            action.putValue("Radio", (Object)Boolean.TRUE);
            action.putValue("RunItemCategory", (Object)category);
            action.putValue("UserData", (Object)("RunConfigurationName:" + runConfigName));
            action.addController((Controller)controller);
            actions.add(action);
        }
        return actions;
    }

    public boolean isRunConfigurationAction(IdeAction action) {
        return actionRunConfigurationCommandIds.contains(action.getCommandId());
    }

    public boolean isMruAction(IdeAction action) {
        return action.getCommandId() == this.getActionMruRunCmdId() || action.getCommandId() == this.getActionMruDebugCmdId();
    }

    IdeAction getActionEmpty() {
        if (actionEmpty == null) {
            String category = "";
            int EMPTY_ACTION_CMD_ID = Ide.findOrCreateCmdID((String)"ToolbarRunDebugProjectCommandEmpty");
            actionEmpty = IdeAction.findOrCreate((int)EMPTY_ACTION_CMD_ID, null, (String)ExtensionResources.get("EMPTY_RUN_CONFIGURATION_MENUITEM"), (String)"", null, null, null, (boolean)false);
        }
        return actionEmpty;
    }

    public IdeAction getActionMruDebug() {
        if (actionMruDebug == null) {
            actionMruDebug = IdeAction.findOrCreate((int)this.getActionMruDebugCmdId(), null, (String)ExtensionResources.get("EMPTY_RUN_CONFIGURATION_MENUITEM"), (String)ExtensionResources.get("ACTION_CATEGORY_DEBUG"), null, null, null, null, (boolean)false);
            actionMruDebug.putValue("NoCtxName", (Object)ExtensionResources.get("DEBUG_PROJECT"));
            String mnemonic = ExtensionResources.get("DEBUG_PROJECT_MNEMONIC");
            if (mnemonic != null && mnemonic.length() > 0) {
                char c = mnemonic.charAt(0);
                actionMruDebug.putValue("MnemonicKey", (Object)new Integer(c));
            }
            actionMruDebug.putValue("Radio", (Object)Boolean.TRUE);
            actionMruDebug.putValue("RunItemCategory", (Object)"debugger");
            actionMruDebug.addController((Controller)controller);
        }
        return actionMruDebug;
    }

    int getActionMruDebugCmdId() {
        if (actionMruDebugCommandId == 0) {
            actionMruDebugCommandId = Ide.findOrCreateCmdID((String)"DebugMruProjectCommand");
        }
        return actionMruDebugCommandId;
    }

    public IdeAction getActionMruRun() {
        if (actionMruRun == null) {
            actionMruRun = IdeAction.findOrCreate((int)this.getActionMruRunCmdId(), null, (String)ExtensionResources.get("EMPTY_RUN_CONFIGURATION_MENUITEM"), (String)ExtensionResources.get("ACTION_CATEGORY_RUN"), null, null, null, null, (boolean)false);
            actionMruRun.putValue("NoCtxName", (Object)ExtensionResources.get("RUN_PROJECT"));
            String mnemonic = ExtensionResources.get("RUN_PROJECT_MNEMONIC");
            if (mnemonic != null && mnemonic.length() > 0) {
                char c = mnemonic.charAt(0);
                actionMruRun.putValue("MnemonicKey", (Object)new Integer(c));
            }
            actionMruRun.putValue("Radio", (Object)Boolean.TRUE);
            actionMruRun.putValue("RunItemCategory", (Object)"runner");
            actionMruRun.addController((Controller)controller);
        }
        return actionMruRun;
    }

    int getActionMruRunCmdId() {
        if (actionMruRunCommandId == 0) {
            actionMruRunCommandId = Ide.findOrCreateCmdID((String)"RunMruProjectCommand");
        }
        return actionMruRunCommandId;
    }

    IdeAction getActionManageRunConfiguration() {
        if (actionManageRunConfigurations == null) {
            actionManageRunConfigurations = IdeAction.find((String)"ManageRunConfigurations");
        }
        return actionManageRunConfigurations;
    }

    static IdeAction getActionRunProject() {
        if (actionRunProject == null) {
            actionRunProject = IdeAction.find((String)"RunProjectCommand");
        }
        return actionRunProject;
    }

    static IdeAction getActionDebugProject() {
        if (actionDebugProject == null) {
            actionDebugProject = IdeAction.find((String)"DebugProjectCommand");
        }
        return actionDebugProject;
    }

    static IdeAction getActionContextMenuRun() {
        if (actionContextMenuRun == null) {
            actionContextMenuRun = IdeAction.find((String)"ContextMenuRunCommand");
        }
        return actionContextMenuRun;
    }

    static IdeAction getActionRunSelection() {
        if (actionRunSelection == null) {
            actionRunSelection = IdeAction.find((String)"RunSelectionCommand");
        }
        return actionRunSelection;
    }

    public static IdeAction getActionContextMenuDebug() {
        if (actionContextMenuDebug == null) {
            actionContextMenuDebug = IdeAction.find((String)"ContextMenuDebugCommand");
        }
        return actionContextMenuDebug;
    }

    public static IdeAction getActionDebugSelection() {
        if (actionDebugSelection == null) {
            actionDebugSelection = IdeAction.find((String)"DebugSelectionCommand");
        }
        return actionDebugSelection;
    }

    public static IdeAction getActionCodeEditorToggleBreakpoint() {
        if (actionCodeEditorToggleBreakpoint == null) {
            actionCodeEditorToggleBreakpoint = IdeAction.find((String)"DebugCodeEditorToggleBreakpointCommand");
        }
        return actionCodeEditorToggleBreakpoint;
    }

    public static IdeAction getActionCodeEditorToggleWatchpoint() {
        if (actionCodeEditorToggleWatchpoint == null) {
            actionCodeEditorToggleWatchpoint = IdeAction.find((String)"DebugCodeEditorToggleWatchpointCommand");
        }
        return actionCodeEditorToggleWatchpoint;
    }

    public static IdeAction getActionCodeEditorEnableBreakpoint() {
        if (actionCodeEditorEnableBreakpoint == null) {
            actionCodeEditorEnableBreakpoint = IdeAction.find((String)"DebugCodeEditorEnableBreakpointCommand");
        }
        return actionCodeEditorEnableBreakpoint;
    }

    public static IdeAction getActionCodeEditorDisableBreakpoint() {
        if (actionCodeEditorDisableBreakpoint == null) {
            actionCodeEditorDisableBreakpoint = IdeAction.find((String)"DebugCodeEditorDisableBreakpointCommand");
        }
        return actionCodeEditorDisableBreakpoint;
    }

    public static IdeAction getActionDebugSuspendAllBreakpoints() {
        if (actionDebugSuspendAllBreakpoints == null) {
            actionDebugSuspendAllBreakpoints = IdeAction.find((String)"DebugSuspendAllBreakpointsCommand");
            actionDebugSuspendAllBreakpoints.addController((Controller)controller);
        }
        return actionDebugSuspendAllBreakpoints;
    }

    public static IdeAction getActionCodeEditorEditBreakpoint() {
        if (actionCodeEditorEditBreakpoint == null) {
            actionCodeEditorEditBreakpoint = IdeAction.find((String)"DebugCodeEditorEditBreakpointCommand");
        }
        return actionCodeEditorEditBreakpoint;
    }

    void updateRunDebugActions() {
        Context[] context = new Context[]{Ide.getMainWindow().getLastActiveView().getContext()};
        controller.update(RunItemActions.getActionRunProject(), context[0]);
        controller.update(RunItemActions.getActionRunSelection(), context[0]);
        controller.update(RunItemActions.getActionDebugProject(), context[0]);
        controller.update(RunItemActions.getActionDebugSelection(), context[0]);
    }
}

