/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import oracle.ide.ExtensionRegistry;
import oracle.ide.marshal.xml.HashStructureIO;
import oracle.ide.marshal.xml.Object2Dom;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.xml.XMLUtil;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.ListStructure;
import oracle.jdevimpl.debugger.BreakpointSettings;

public final class SavedBreakpoints {
    public static final String FILENAME = "breakpoints.xml";
    public static final String HS_FILENAME = "hs_breakpoints.xml";
    public static final String NAMESPACE_URI = XMLUtil.toNamespaceURI((String)"breakpoints");
    public static final String ROOT_TAG = "breakpoints";
    private static final String BREAKPOINT_LIST = "breakpoint_list";
    private ArrayList _breakpoints = new ArrayList();

    SavedBreakpoints() {
    }

    ArrayList getBreakpoints() {
        return this._breakpoints;
    }

    boolean save() {
        boolean success = false;
        try {
            HashStructure hash = this.storeBreakpoints();
            HashStructureIO io = new HashStructureIO(NAMESPACE_URI, ROOT_TAG);
            io.save(SavedBreakpoints.getHsURL(), (Object)hash);
            success = true;
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        return success;
    }

    private HashStructure storeBreakpoints() {
        HashStructure hash = HashStructure.newInstance();
        ListStructure list = ListStructure.newInstance();
        for (Object object : this._breakpoints) {
            if (!(object instanceof BreakpointSettings)) continue;
            BreakpointSettings bs = (BreakpointSettings)object;
            list.add((Object)bs.getHash());
        }
        hash.putListStructure(BREAKPOINT_LIST, list);
        return hash;
    }

    private boolean loadBreakpoints(Object object) {
        HashStructure hash;
        ListStructure list;
        if (object instanceof HashStructure && (list = (hash = (HashStructure)object).getListStructure(BREAKPOINT_LIST)) != null) {
            this._breakpoints.clear();
            for (int x = 0; x < list.size(); ++x) {
                Object bpObject = list.get(x);
                if (!(bpObject instanceof HashStructure)) continue;
                HashStructure bpHash = (HashStructure)bpObject;
                this._breakpoints.add(new BreakpointSettings(bpHash));
            }
            return true;
        }
        return false;
    }

    boolean load() {
        boolean success = false;
        try {
            URL hsUrl = SavedBreakpoints.getHsURL();
            if (URLFileSystem.exists((URL)hsUrl)) {
                HashStructureIO io = new HashStructureIO(NAMESPACE_URI, ROOT_TAG);
                Object object = io.load(hsUrl);
                return this.loadBreakpoints(object);
            }
            URL xmlUrl = SavedBreakpoints.getXMLURL();
            boolean xmlUrlExists = URLFileSystem.exists((URL)xmlUrl);
            if (xmlUrlExists) {
                this.migrateClassNames(xmlUrl);
                Object2Dom o2d = Object2Dom.newInstance();
                ArrayList breakpoints = (ArrayList)o2d.toObject(xmlUrl, this.getClass().getClassLoader());
                this._breakpoints.clear();
                if (breakpoints != null) {
                    for (int i = 0; i < breakpoints.size(); ++i) {
                        Object breakpoint = breakpoints.get(i);
                        if (breakpoint == null) continue;
                        this._breakpoints.add(breakpoint);
                        this.migrate(breakpoint);
                    }
                }
                success = true;
            }
        }
        catch (FileNotFoundException ex) {
            return false;
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            this._breakpoints.clear();
        }
        return success;
    }

    public static URL getXMLURL() {
        ExtensionRegistry er = ExtensionRegistry.getExtensionRegistry();
        URL url = er.getSystemDirectory("oracle.jdeveloper.runner.core");
        return URLFactory.newURL((URL)url, (String)FILENAME);
    }

    private static URL getHsURL() {
        ExtensionRegistry er = ExtensionRegistry.getExtensionRegistry();
        URL url = er.getSystemDirectory("oracle.jdeveloper.runner.core");
        return URLFactory.newURL((URL)url, (String)HS_FILENAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void migrateClassNames(URL xmlUrl) {
        BufferedReader reader = null;
        BufferedWriter writer = null;
        try {
            String line;
            reader = new BufferedReader(new InputStreamReader(xmlUrl.openStream()));
            ArrayList<String> buffer = new ArrayList<String>();
            while ((line = reader.readLine()) != null) {
                line = line.replace("oracle.jdevimpl.runner.debug.BreakpointSettings", "oracle.jdevimpl.debugger.BreakpointSettings");
                buffer.add(line);
            }
            reader.close();
            reader = null;
            writer = new BufferedWriter(new FileWriter(xmlUrl.getFile()));
            for (String line2 : buffer) {
                writer.write(line2);
                writer.newLine();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    private void migrate(Object breakpoint) {
        BreakpointSettings bpSettings;
        String fileName;
        if (breakpoint instanceof BreakpointSettings && (fileName = (bpSettings = (BreakpointSettings)breakpoint).getFile()) != null && (fileName.endsWith(".jsp") || fileName.endsWith(".jspx") || fileName.endsWith(".jsff")) && (bpSettings.getPkg() == null || bpSettings.getPkg().trim().length() == 0)) {
            bpSettings.setPkg("jsp_servlet");
        }
    }
}

