/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import oracle.ide.migration.Migrator;

public class BreakpointsMigrator
implements Migrator {
    private File o2dFile;
    private File hsFile;

    public int[] getMigrationCategories() {
        return new int[]{0};
    }

    public String getDescription(int category) {
        return null;
    }

    public boolean canMigrate(int category, File sourceDir) {
        this.hsFile = new File(sourceDir, "hs_breakpoints.xml");
        if (this.hsFile.exists()) {
            return true;
        }
        this.hsFile = null;
        this.o2dFile = new File(sourceDir, "breakpoints.xml");
        if (this.o2dFile.exists()) {
            return true;
        }
        this.o2dFile = null;
        String sourceDirName = sourceDir.getName();
        File rootDir = sourceDir;
        if (!sourceDirName.toLowerCase().startsWith("system") && (rootDir = sourceDir.getParentFile()) == null) {
            return false;
        }
        File[] dirs = rootDir.listFiles();
        if (dirs != null) {
            for (File dir : dirs) {
                File[] files = dir.listFiles(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        return name.equals("breakpoints.xml");
                    }
                });
                if (files == null || files.length <= 0) continue;
                this.o2dFile = files[0];
                return true;
            }
        }
        this.o2dFile = null;
        return false;
    }

    public void setSelected(int category, boolean selected) {
    }

    public boolean isSelected(int category) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] migrate(File sourceDir, File destDir) {
        File writeFile = null;
        File readFile = null;
        if (this.hsFile != null) {
            readFile = this.hsFile;
            writeFile = new File(destDir, "hs_breakpoints.xml");
        } else if (this.o2dFile != null) {
            readFile = this.o2dFile;
            writeFile = new File(destDir, "breakpoints.xml");
        }
        if (readFile != null && writeFile != null) {
            BufferedReader reader = null;
            BufferedWriter writer = null;
            try {
                String line;
                reader = new BufferedReader(new FileReader(readFile));
                writer = new BufferedWriter(new FileWriter(writeFile));
                while ((line = reader.readLine()) != null) {
                    writer.write(line);
                    writer.newLine();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            finally {
                try {
                    if (writer != null) {
                        writer.close();
                    }
                }
                catch (Exception exception) {}
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        return new String[0];
    }
}

