/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.dbTarget.db.changemgr.emo.xdiffer;

import java.io.OutputStream;
import java.util.HashMap;
import java.util.HashSet;
import oracle.sysman.dbTarget.db.changemgr.emo.docaccess.CMXMLUtils;
import oracle.sysman.dbTarget.db.changemgr.emo.docaccess.XMLPartitionsAccessor;
import oracle.sysman.dbTarget.db.changemgr.emo.xdiffer.CMDiff;
import oracle.sysman.dbTarget.db.changemgr.emo.xdiffer.CMDomHash;
import oracle.sysman.dbTarget.db.changemgr.emo.xdiffer.CMXSLParamNames;
import oracle.sysman.dbTarget.db.changemgr.emo.xdiffer.DeletedDiffTreeNode;
import oracle.sysman.dbTarget.db.changemgr.emo.xdiffer.DiffTreeNode;
import oracle.sysman.dbTarget.db.changemgr.emo.xdiffer.InsertedDiffTreeNode;
import oracle.sysman.dbTarget.db.changemgr.emo.xdiffer.ModifiedDiffTreeNode;
import oracle.sysman.dbTarget.db.changemgr.emo.xdiffer.SameDiffTreeNode;
import oracle.sysman.dbTarget.db.changemgr.emo.xdiffer.VxxString;
import oracle.xml.parser.v2.NSResolver;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.parser.v2.XMLText;
import org.apache.log4j.Category;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

class CMXMLDiff
implements CMXSLParamNames {
    private static Category s_log = Category.getInstance(CMXMLDiff.class);
    private DiffTreeNode m_diffRoot1;
    private DiffTreeNode m_diffRoot2;
    private CMDiff m_diff;
    private int m_diffs_found = 0;
    private boolean m_ignoredDiffExists = false;
    private int XML_TYPE = 0;
    private static final String CHECK_CONSTRAINT_LIST_ITEM = "CHECK_CONSTRAINT_LIST_ITEM";
    private static HashSet s_partSet = null;
    private static final int T_UNKNOWN = -1;
    private static final int T_RANGE = 1;
    private static final int T_HASH = 2;
    private static final int T_LIST = 3;
    private static final int T_RANGE_HASH = 4;
    private static final int T_RANGE_LIST = 5;
    private static final int T_GLOBAL_RANGE = 6;
    private static final int T_GLOBAL_HASH = 7;
    private static final int T_LOCAL_RANGE = 8;
    private static final int T_LOCAL_HASH = 9;
    private static final int T_LOCAL_LIST = 10;
    private static final int T_LOCAL_RANGE_HASH = 11;
    private static final int T_LOCAL_RANGE_LIST = 12;
    private static final int T_LOCAL_SXML = 13;
    private static final int CXML = 1;
    private static final int SXML = 2;
    public String PARTCOLS;
    public String PARTCOLS_ITEM;
    public String PART_LIST;
    public String PART_LIST_ITEM;
    public String HIBOUNDVAL;
    public String X_PART_LIST_ITEM;
    public String X_COMP_BASE;
    public String RANGE_PARTITIONING;
    public String CONDITION;
    public String GLOBAL_PARTITIONING;
    public String HASHPARTTS_LIST;
    public String HASH_PARTITIONING;
    public String HASH_SUBPARTITIONING;
    public String LIST_PARTITIONING;
    public String LIST_SUBPARTITIONING;
    public String LOCAL_PARTITIONING;
    public String PARTTYPE;
    public String QUERY;
    public String SUBQUERY;
    public String SOURCE;
    public String TEXT;
    public String TRIGGER_BODY;
    public String SEQUENCE;
    public String START_WITH;
    public String COL_LIST_ITEM;
    public String DEFAULT;
    public String QHASH_SUBPARTITIONING;
    public String QHASH_PARTITIONING;
    public String QLIST_PARTITIONING;
    public String QLIST_SUBPARTITIONING;
    public String QRANGE_PARTITIONING;
    public static NSResolver s_resolver = null;

    public CMXMLDiff(Node tree1, Node tree2, CMDiff cmdiff, boolean usingSXML) {
        this.initialize(tree1, tree2, cmdiff, usingSXML);
    }

    public CMXMLDiff(Node tree1, Node tree2, CMDiff cmdiff) {
        this.initialize(tree1, tree2, cmdiff, false);
    }

    private void initialize(Node tree1, Node tree2, CMDiff cmdiff, boolean usingSXML) {
        block3: {
            this.setUseSXML(usingSXML);
            if (s_partSet == null) {
                s_partSet = new HashSet(5);
                s_partSet.add(this.RANGE_PARTITIONING);
                s_partSet.add(this.HASH_PARTITIONING);
                s_partSet.add(this.LIST_PARTITIONING);
                s_partSet.add(this.GLOBAL_PARTITIONING);
                s_partSet.add(this.LOCAL_PARTITIONING);
            }
            this.setDiffCount(0);
            this.m_diff = cmdiff;
            try {
                this.m_diffRoot1 = new SameDiffTreeNode(tree1);
                this.compare(tree1, tree2, this.m_diffRoot1, this.m_diffRoot2);
            }
            catch (Exception e) {
                if (!s_log.isDebugEnabled()) break block3;
                e.printStackTrace();
            }
        }
    }

    public void setUseSXML(boolean usingSXML) {
        s_resolver = CMXMLUtils.getSXMLResolver();
        if (usingSXML) {
            this.PARTCOLS = "sxml:COL_LIST";
            this.PARTCOLS_ITEM = "sxml:COL_LIST_ITEM";
            this.PART_LIST = "sxml:PARTITION_LIST";
            this.PART_LIST_ITEM = "sxml:PARTITION_LIST_ITEM";
            this.HIBOUNDVAL = "sxml:VALUES";
            this.X_PART_LIST_ITEM = XMLPartitionsAccessor.SX_PART_LIST_ITEM;
            this.X_COMP_BASE = XMLPartitionsAccessor.SX_COMP_BASE;
            this.RANGE_PARTITIONING = "RANGE_PARTITIONING";
            this.CONDITION = "CONDITION";
            this.GLOBAL_PARTITIONING = "GLOBAL_PARTITIONING";
            this.HASHPARTTS_LIST = "sxml:PARTITION_LIST";
            this.HASH_PARTITIONING = "HASH_PARTITIONING";
            this.HASH_SUBPARTITIONING = "HASH_SUBPARTITIONING";
            this.LIST_PARTITIONING = "LIST_PARTITIONING";
            this.LIST_SUBPARTITIONING = "LIST_SUBPARTITIONING";
            this.LOCAL_PARTITIONING = "LOCAL_PARTITIONING";
            this.PARTTYPE = "LOCAL_PARTITIONING";
            this.QUERY = "SUBQUERY";
            this.SUBQUERY = "SUBQUERY";
            this.SOURCE = "WHEN_CONDITION";
            this.TEXT = "CALL_PROCEDURE";
            this.TRIGGER_BODY = "PLSQL_BLOCK";
            this.XML_TYPE = 2;
            this.QRANGE_PARTITIONING = "sxml:RANGE_PARTITIONING";
            this.QHASH_PARTITIONING = "sxml:HASH_PARTITIONING";
            this.QHASH_SUBPARTITIONING = "sxml:HASH_SUBPARTITIONING";
            this.QLIST_PARTITIONING = "sxml:LIST_PARTITIONING";
            this.QLIST_SUBPARTITIONING = "sxml:LIST_SUBPARTITIONING";
            this.SEQUENCE = "SEQUENCE";
            this.START_WITH = "START_WITH";
            this.COL_LIST_ITEM = "COL_LIST_ITEM";
            this.DEFAULT = "DEFAULT";
        } else {
            this.PARTCOLS = "PARTCOLS";
            this.PARTCOLS_ITEM = "PARTCOLS_ITEM";
            this.PART_LIST = "PART_LIST";
            this.PART_LIST_ITEM = "PART_LIST_ITEM";
            this.HIBOUNDVAL = "HIBOUNDVAL";
            this.X_PART_LIST_ITEM = XMLPartitionsAccessor.X_PART_LIST_ITEM;
            this.X_COMP_BASE = XMLPartitionsAccessor.X_COMP_BASE;
            this.RANGE_PARTITIONING = "RANGE_PARTITIONING";
            this.CONDITION = "CONDITION";
            this.GLOBAL_PARTITIONING = "GLOBAL_PARTITIONING";
            this.HASHPARTTS_LIST = "HASHPARTTS_LIST";
            this.HASH_PARTITIONING = "HASH_PARTITIONING";
            this.HASH_SUBPARTITIONING = "HASH_SUBPARTITIONING";
            this.LIST_PARTITIONING = "LIST_PARTITIONING";
            this.LIST_SUBPARTITIONING = "LIST_SUBPARTITIONING";
            this.LOCAL_PARTITIONING = "LOCAL_PARTITIONING";
            this.PARTTYPE = "PARTTYPE";
            this.QUERY = "QUERY";
            this.SUBQUERY = "SUBQUERY";
            this.SOURCE = "SOURCE";
            this.TEXT = "TEXT";
            this.TRIGGER_BODY = "TRIGGER_BODY";
            this.QRANGE_PARTITIONING = "RANGE_PARTITIONING";
            this.QHASH_PARTITIONING = "HASH_PARTITIONING";
            this.QHASH_SUBPARTITIONING = "HASH_SUBPARTITIONING";
            this.QLIST_PARTITIONING = "LIST_PARTITIONING";
            this.QLIST_SUBPARTITIONING = "LIST_SUBPARTITIONING";
            this.SEQUENCE = "SEQUENCE";
            this.START_WITH = "START_WITH";
            this.COL_LIST_ITEM = "COL_LIST_ITEM";
            this.DEFAULT = "DEFAULT";
        }
    }

    public DiffTreeNode getCMDiffTree(int fileNo) {
        return fileNo == 1 ? this.m_diffRoot1 : this.m_diffRoot2;
    }

    private void compare(Node root1, Node root2, DiffTreeNode diffRoot1, DiffTreeNode diffRoot2) throws Exception {
        this.compare(root1, root2, diffRoot1, diffRoot2, false);
    }

    private void compare(Node root1, Node root2, DiffTreeNode diffRoot1, DiffTreeNode diffRoot2, boolean skipDef) throws Exception {
        this.compare(root1, root2, diffRoot1, diffRoot2, skipDef, root2);
    }

    private void compare(Node root1, Node root2, DiffTreeNode diffRoot1, DiffTreeNode diffRoot2, boolean skipDef, Node destNode) throws Exception {
        if (diffRoot1 == null) {
            throw new NullPointerException();
        }
        DiffTreeNode diffChild1 = null;
        if (root1 == null && root2 == null) {
            return;
        }
        if (root1 == null) {
            if (root2.getNodeType() == 3 && "UNAVAILABLE".equals(((XMLText)root2).getNodeValue())) {
                return;
            }
            diffChild1 = new DeletedDiffTreeNode(root2);
            diffRoot1.add(diffChild1);
            diffChild1.setParentDiffDesc();
            this.incrDiffCount();
            return;
        }
        if (root2 == null) {
            if (root1.getNodeType() == 3 && "UNAVAILABLE".equals(((XMLText)root1).getNodeValue())) {
                return;
            }
            diffChild1 = new InsertedDiffTreeNode(root1, destNode);
            diffRoot1.add(diffChild1);
            diffChild1.setParentDiffDesc();
            this.incrDiffCount();
            return;
        }
        if (!skipDef && CMXMLDiff.comparingPartitioning(root1, root2)) {
            if (this.getIgnoreAllPartitioning()) {
                return;
            }
            this.comparePartitioning((XMLElement)root1, (XMLElement)root2, diffRoot1, diffRoot2, destNode);
            return;
        }
        NodeList childrenList1 = root1.getChildNodes();
        NodeList childrenList2 = root2.getChildNodes();
        int length1 = 0;
        int length2 = 0;
        if (childrenList1 != null) {
            length1 = childrenList1.getLength();
        }
        if (childrenList2 != null) {
            length2 = childrenList2.getLength();
        }
        if (length1 == 0 && length2 == 0) {
            boolean leafMatched = false;
            leafMatched = root1.getNodeType() == 3 && root2.getNodeType() == 3 ? (this.getLogicalCompare() && this.isSourceTypeNodes(root1.getParentNode(), root2.getParentNode()) ? this.logicalSQLTextNodeMatched((XMLText)root1, (XMLText)root2) : (this.getLogicalCompare() && this.isColumnDefaultNull(root1.getParentNode()) && this.isColumnDefaultNull(root2.getParentNode()) ? true : (this.isSequenceStartWithNodes(root1.getParentNode(), root2.getParentNode()) ? true : this.textNodeMatched((XMLText)root1, (XMLText)root2)))) : this.m_diff.equals(root1, root2);
            if (leafMatched) {
                diffChild1 = new SameDiffTreeNode(root1);
                diffRoot1.add(diffChild1);
            } else {
                boolean countTheDiff = true;
                if (!this.m_diff.getCountStatDiffs() && root1.getParentNode() != null && root1.getParentNode().getParentNode() != null && root1.getParentNode().getParentNode().getNodeName().equals("STATISTICS")) {
                    countTheDiff = false;
                } else if (this.getIgnoreHighValues() && this.isPartitionHighValuesNodes(root1.getParentNode(), root2.getParentNode())) {
                    countTheDiff = false;
                } else if ("1".equals(((XMLElement)root1.getParentNode()).getAttribute("no_diff"))) {
                    countTheDiff = false;
                }
                if (countTheDiff) {
                    this.incrDiffCount();
                } else {
                    this.m_ignoredDiffExists = true;
                }
                diffChild1 = new ModifiedDiffTreeNode(root1);
                ((ModifiedDiffTreeNode)diffChild1).setModifiedNode(new ModifiedDiffTreeNode(root2));
                diffRoot1.add(diffChild1);
                diffChild1.setParentDiffDesc();
            }
            return;
        }
        diffChild1 = new SameDiffTreeNode(root1);
        diffRoot1.add(diffChild1);
        Node n1 = null;
        Node n2 = null;
        DiffTreeNode diffChild = null;
        boolean loopcount = false;
        int i = 0;
        int j = 0;
        while (i < length1 || j < length2) {
            n1 = null;
            n2 = null;
            if (i < length1) {
                n1 = childrenList1.item(i);
            }
            if (j < length2) {
                n2 = childrenList2.item(j);
            }
            if (n1 != null && n2 != null) {
                short t1 = n1.getNodeType();
                short t2 = n2.getNodeType();
                if (t1 == 1 && t2 == 1) {
                    Node insNode;
                    if (i == 0 && j == 0 && length1 == 1 && length2 == 1 && this.isUnnamedPK((XMLElement)n1) && this.isUnnamedPK((XMLElement)n2)) {
                        this.compare(n1, n2, diffChild1, null, skipDef, root2);
                        return;
                    }
                    int newj = 0;
                    boolean mbd = false;
                    while (i < length1 && j < length2) {
                        n1 = childrenList1.item(i);
                        if (n1.getNodeType() != 1) {
                            mbd = true;
                            break;
                        }
                        try {
                            newj = this.findMatch((XMLElement)n1, childrenList2, length2, j);
                        }
                        catch (ClassCastException cce) {
                            System.out.println("ClassCastException: ");
                            System.out.println(" root1: ");
                            ((XMLNode)root1).print((OutputStream)System.out);
                            System.out.println(" n1: ");
                            ((XMLNode)n1).print((OutputStream)System.out);
                            System.out.println(" length1 = " + length1);
                            System.out.println(" i = " + i);
                            System.out.println(" root2: ");
                            ((XMLNode)root2).print((OutputStream)System.out);
                            System.out.println(" length2 = " + length2);
                            System.out.println(" j = " + j);
                            System.out.println("Contents of childrenList1:");
                            this.printNodeList(childrenList1, length1);
                            System.out.println("Contents of childrenList2:");
                            this.printNodeList(childrenList2, length2);
                        }
                        if (newj >= j) {
                            if (newj > j) {
                                while (j < newj) {
                                    insNode = childrenList2.item(j);
                                    if (!(this.getLogicalCompare() && this.isColumnDefaultNull(insNode) || CMXMLDiff.isOmittable(insNode.getNodeName()))) {
                                        diffChild = new DeletedDiffTreeNode(insNode);
                                        diffChild1.add(diffChild);
                                        diffChild.setParentDiffDesc();
                                        this.incrDiffCount();
                                    }
                                    ++j;
                                }
                            }
                            if (this.matchByDefinition((XMLElement)n1, (XMLElement)(n2 = childrenList2.item(j)))) {
                                boolean reportNameDiff = this.reportNameDiff((XMLElement)n1, (XMLElement)n2);
                                this.compareMatchByDefinition(childrenList1, childrenList2, length1, length2, diffChild1, null, reportNameDiff, n1);
                                return;
                            }
                            if (skipDef && this.bothDefinitionNodes((XMLElement)n1, (XMLElement)n2)) {
                                ++i;
                                ++j;
                                continue;
                            }
                            if (((XMLElement)n1).getTagName().equals("NAME") && this.matchByDefinition((XMLElement)root1, (XMLElement)root2) && !this.reportNameDiff((XMLElement)root1, (XMLElement)root2)) {
                                ++i;
                                ++j;
                                continue;
                            }
                            this.compare(n1, n2, diffChild1, null, skipDef, root2);
                            ++i;
                            ++j;
                            continue;
                        }
                        if (!(this.getLogicalCompare() && this.isColumnDefaultNull(n1) || CMXMLDiff.isOmittable(n1.getNodeName()))) {
                            diffChild = new InsertedDiffTreeNode(n1, root2);
                            diffChild1.add(diffChild);
                            diffChild.setParentDiffDesc();
                            this.incrDiffCount();
                        }
                        ++i;
                    }
                    if (mbd) continue;
                    while (i < length1) {
                        insNode = childrenList1.item(i);
                        if (!(this.getLogicalCompare() && this.isColumnDefaultNull(insNode) || CMXMLDiff.isOmittable(insNode.getNodeName()))) {
                            diffChild = new InsertedDiffTreeNode(insNode, root2);
                            diffChild1.add(diffChild);
                            diffChild.setParentDiffDesc();
                            if (this.m_diff.getCountStatDiffs() || !insNode.getNodeName().equals("STATISTICS")) {
                                this.incrDiffCount();
                            }
                        }
                        ++i;
                    }
                    while (j < length2) {
                        insNode = childrenList2.item(j);
                        if (!(this.getLogicalCompare() && this.isColumnDefaultNull(insNode) || CMXMLDiff.isOmittable(insNode.getNodeName()))) {
                            diffChild = new DeletedDiffTreeNode(insNode);
                            diffChild1.add(diffChild);
                            diffChild.setParentDiffDesc();
                            if (this.m_diff.getCountStatDiffs() || !insNode.getNodeName().equals("STATISTICS")) {
                                this.incrDiffCount();
                            }
                        }
                        ++j;
                    }
                    continue;
                }
                if (t1 == 3 && t2 != 3) {
                    if (!"".equals(((Text)n1).getNodeValue().trim())) continue;
                    ++i;
                    continue;
                }
                if (t1 != 3 && t2 == 3) {
                    if (!"".equals(((Text)n2).getNodeValue().trim())) continue;
                    ++j;
                    continue;
                }
                this.compare(n1, n2, diffChild1, null, skipDef, root2);
                ++i;
                ++j;
                continue;
            }
            if (n1 != null) {
                if (!CMXMLDiff.isOmittable(n1.getNodeName())) {
                    diffChild = new InsertedDiffTreeNode(n1, root2);
                    diffChild1.add(diffChild);
                    diffChild.setParentDiffDesc();
                    this.incrDiffCount();
                }
                ++i;
            }
            if (n2 == null) continue;
            if (!CMXMLDiff.isOmittable(n2.getNodeName())) {
                diffChild = new DeletedDiffTreeNode(n2);
                diffChild1.add(diffChild);
                diffChild.setParentDiffDesc();
                this.incrDiffCount();
            }
            ++j;
        }
    }

    private void printNodeList(NodeList list, int count) {
        for (int i = 0; i < count; ++i) {
            Node node = list.item(i);
            StringBuffer sb = new StringBuffer(i + ": ");
            switch (node.getNodeType()) {
                case 1: {
                    sb.append("Element node, named ").append(node.getNodeName());
                    break;
                }
                case 2: {
                    sb.append("Attribute node, named ").append(node.getNodeName());
                    break;
                }
                case 3: {
                    sb.append("Text node, value >>").append(node.getNodeValue()).append("<<");
                    break;
                }
                default: {
                    sb.append("Other node of type ").append(node.getNodeType());
                }
            }
            System.out.println(sb);
        }
    }

    protected int getDiffCount() {
        return this.m_diffs_found;
    }

    boolean getIgnoredDiffExists() {
        return this.m_ignoredDiffExists;
    }

    private void setDiffCount(int diffs) {
        this.m_diffs_found = diffs;
    }

    private void incrDiffCount() {
        ++this.m_diffs_found;
    }

    private void decrDiffCount() {
        --this.m_diffs_found;
    }

    private boolean getChildLogicalCompare(Node n) {
        return this.getLogicalCompare() && n != null && n.getNodeType() == 1 && CHECK_CONSTRAINT_LIST_ITEM.equals(((XMLElement)n).getTagName());
    }

    private static boolean isOmittable(String tagName) {
        return tagName != null && (tagName.equals("COL_NUM") || tagName.equals("SEGMENT_ATTRIBUTES") || tagName.equals("STORAGE") || tagName.equals("TABLESPACE") || tagName.equals("COMPRESS") || tagName.equals("COMMENTS") || tagName.equals("PHYSICAL_PROPERTIES"));
    }

    private void compareMatchByDefinition(NodeList list1, NodeList list2, int length1, int length2, DiffTreeNode diffRoot1, DiffTreeNode diffRoot2, boolean reportNameDiff, Node destNode) {
        Node n1;
        Node n2;
        boolean[] matched1 = new boolean[length1];
        boolean[] matched2 = new boolean[length2];
        byte[][] hashes2 = new byte[length2][];
        HashMap<Integer, Integer> attrDiffHash = new HashMap<Integer, Integer>(length1);
        CMDomHash dh = this.m_diff.m_dh;
        for (int j = 0; j < length2; ++j) {
            n2 = list2.item(j);
            dh.setLogicalCompare(this.getChildLogicalCompare(n2));
            hashes2[j] = dh.getDOMHash(n2, true, this.m_diff.getSchemaMap());
        }
        block3: for (int i = 0; i < length1; ++i) {
            n1 = list1.item(i);
            dh.setLogicalCompare(this.getChildLogicalCompare(n1));
            byte[] hash1 = dh.getDOMHash(n1, true, this.m_diff.getSchemaMap());
            for (int j = 0; j < length2; ++j) {
                if (matched2[j] || !CMDomHash.hashValueEquals(hash1, hashes2[j])) continue;
                matched1[i] = true;
                matched2[j] = true;
                attrDiffHash.put(new Integer(i), new Integer(j));
                continue block3;
            }
        }
        DiffTreeNode diffChild = null;
        for (int i = 0; i < length1; ++i) {
            if (matched1[i]) {
                n1 = list1.item(i);
                Integer I = new Integer(i);
                int index = (Integer)attrDiffHash.get(I);
                n2 = list2.item(index);
                boolean nameDiff = false;
                if (n1.getNodeType() == 1 && n2.getNodeType() == 1) {
                    String s1 = ((XMLElement)n1).getAttribute("NAME");
                    String s2 = ((XMLElement)n2).getAttribute("NAME");
                    if (s1 != null && s2 != null && !s1.trim().equals(s2.trim())) {
                        if (reportNameDiff) {
                            nameDiff = true;
                        }
                        ((XMLElement)n2).setAttribute("TARGET_NAME", s1);
                        diffChild = new ModifiedDiffTreeNode(n1);
                        ((ModifiedDiffTreeNode)diffChild).setModifiedNode(new ModifiedDiffTreeNode(n2));
                    }
                }
                if (!nameDiff) {
                    diffChild = new SameDiffTreeNode(n1);
                }
                diffRoot1.add(diffChild);
                if (nameDiff) {
                    diffChild.setParentDiffDesc();
                    this.incrDiffCount();
                }
                try {
                    this.compare(n1, n2, diffRoot1, null, true, destNode);
                }
                catch (Exception e) {
                    if (!s_log.isDebugEnabled()) continue;
                    e.printStackTrace();
                }
                continue;
            }
            diffChild = new InsertedDiffTreeNode(list1.item(i), list2.item(0).getParentNode());
            diffRoot1.add(diffChild);
            diffChild.setParentDiffDesc();
            this.incrDiffCount();
        }
        for (int j = 0; j < length2; ++j) {
            if (matched2[j]) continue;
            diffChild = new DeletedDiffTreeNode(list2.item(j));
            diffRoot1.add(diffChild);
            diffChild.setParentDiffDesc();
            this.incrDiffCount();
        }
    }

    private void comparePartitioning(XMLElement root1, XMLElement root2, DiffTreeNode diffRoot1, DiffTreeNode diffRoot2, Node destNode) throws Exception {
        boolean partTypeEqual;
        int partType = this.getPartitioningType(root1);
        boolean bl = partTypeEqual = partType != -1 && partType == this.getPartitioningType(root2);
        if (!partTypeEqual || !this.partColsEqual(root1, root2, partType) && partType != 13 || (partType == 2 || partType == 7) && !this.hashPartTSListEquals(root1, root2, partType)) {
            InsertedDiffTreeNode diffChild1 = new InsertedDiffTreeNode((Node)root1, destNode);
            diffRoot1.add(diffChild1);
            diffChild1.setParentDiffDesc();
            this.incrDiffCount();
            DeletedDiffTreeNode diffChild2 = new DeletedDiffTreeNode((Node)root2);
            diffRoot1.add(diffChild2);
            diffChild2.setParentDiffDesc();
            this.incrDiffCount();
            return;
        }
        if (this.getIgnoreHighValues() && (this.isRangePartType(partType) || this.isListPartType(partType)) || partType == 13) {
            this.compare((Node)root1, (Node)root2, diffRoot1, diffRoot2, true, destNode);
            return;
        }
        if (partType == 2 || partType == 7 || partType == 9) {
            this.compare((Node)root1, (Node)root2, diffRoot1, diffRoot2, true, destNode);
        } else if (partType == 1 || partType == 8 || partType == 3 || partType == 10) {
            this.comparePartMatchByHiboundVal(root1, root2, diffRoot1, diffRoot2, this.X_PART_LIST_ITEM, destNode);
        } else if (partType == 6) {
            this.comparePartMatchByHiboundVal(root1, root2, diffRoot1, diffRoot2, this.QRANGE_PARTITIONING + "/" + this.X_PART_LIST_ITEM, destNode);
        } else if (partType == 5 || partType == 4 || partType == 12 || partType == 11) {
            this.compareCompPartMatchByHiboundVal(root1, root2, diffRoot1, diffRoot2, partType, destNode);
        }
    }

    private void compareCompPartMatchByHiboundVal(XMLElement p1, XMLElement p2, DiffTreeNode diffRoot1, DiffTreeNode diffRoot2, int type, Node destNode) {
        String xpath = null;
        if (type == 4 || type == 11) {
            xpath = this.QHASH_SUBPARTITIONING;
        } else if (type == 5 || type == 12) {
            xpath = this.QLIST_SUBPARTITIONING;
        }
        if (xpath != null) {
            xpath = xpath + "/" + this.X_COMP_BASE;
            this.comparePartMatchByHiboundVal(p1, p2, diffRoot1, diffRoot2, xpath, destNode);
        }
    }

    private void comparePartMatchByHiboundVal(XMLElement p1, XMLElement p2, DiffTreeNode diffRoot1, DiffTreeNode diffRoot2, String xpath, Node destNode) {
        Node n1;
        Node n2;
        NodeList list2;
        NodeList list1;
        block16: {
            list1 = null;
            list2 = null;
            try {
                list1 = p1.selectNodes(xpath, s_resolver);
                list2 = p2.selectNodes(xpath, s_resolver);
            }
            catch (Exception e) {
                if (!s_log.isDebugEnabled()) break block16;
                s_log.debug((Object)e.getMessage());
            }
        }
        int length1 = 0;
        if (list1 != null) {
            length1 = list1.getLength();
        }
        int length2 = 0;
        if (list2 != null) {
            length2 = list2.getLength();
        }
        boolean[] matched1 = new boolean[length1];
        boolean[] matched2 = new boolean[length2];
        String[] hibounds1 = new String[length1];
        String[] hibounds2 = new String[length2];
        HashMap<Integer, Integer> attrDiffHash = new HashMap<Integer, Integer>(length1);
        for (int j = 0; j < length2; ++j) {
            n2 = list2.item(j);
            try {
                hibounds2[j] = CMXMLUtils.selectTextValue((XMLNode)((XMLElement)n2), this.HIBOUNDVAL);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        block9: for (int i = 0; i < length1; ++i) {
            n1 = list1.item(i);
            try {
                hibounds1[i] = CMXMLUtils.selectTextValue((XMLNode)((XMLElement)n1), this.HIBOUNDVAL);
            }
            catch (Exception e) {
                // empty catch block
            }
            for (int j = 0; j < length2; ++j) {
                if (matched2[j] || this.compareStrings(hibounds1[i], hibounds2[j]) != 0) continue;
                matched1[i] = true;
                matched2[j] = true;
                attrDiffHash.put(new Integer(i), new Integer(j));
                continue block9;
            }
        }
        DiffTreeNode diffChild = null;
        for (int i = 0; i < length1; ++i) {
            if (matched1[i]) {
                n1 = list1.item(i);
                int index = (Integer)attrDiffHash.get(new Integer(i));
                n2 = list2.item(index);
                diffRoot1.add(new SameDiffTreeNode(n1));
                try {
                    this.compare(n1, n2, diffRoot1, null, true, destNode);
                }
                catch (Exception e) {
                    if (!s_log.isDebugEnabled()) continue;
                    e.printStackTrace();
                }
                continue;
            }
            diffChild = new InsertedDiffTreeNode(list1.item(i), list2.item(0).getParentNode());
            diffRoot1.add(diffChild);
            diffChild.setParentDiffDesc();
            this.incrDiffCount();
        }
        for (int j = 0; j < length2; ++j) {
            if (matched2[j]) continue;
            diffChild = new DeletedDiffTreeNode(list2.item(j));
            diffRoot1.add(diffChild);
            diffChild.setParentDiffDesc();
            this.incrDiffCount();
        }
    }

    private boolean partColsEqual(XMLElement p1, XMLElement p2, int partType) {
        boolean equal;
        block11: {
            if (this.isLocalPartType(partType)) {
                return true;
            }
            equal = false;
            try {
                String prefix = this.PARTCOLS;
                if (partType == 7) {
                    prefix = this.QHASH_PARTITIONING + "/" + this.PARTCOLS;
                }
                if (partType == 6) {
                    prefix = this.QRANGE_PARTITIONING + "/" + this.PARTCOLS;
                }
                Node partCols1 = p1.selectSingleNode(prefix, s_resolver);
                Node partCols2 = p2.selectSingleNode(prefix, s_resolver);
                if (partCols1 != null && partCols2 != null) {
                    equal = this.m_diff.equals(partCols1, partCols2);
                }
                if (equal) {
                    String xpath = null;
                    if (partType == 5 || partType == 12) {
                        xpath = this.QLIST_SUBPARTITIONING;
                    } else if (partType == 4 || partType == 11) {
                        xpath = this.QHASH_SUBPARTITIONING;
                    }
                    if (xpath != null) {
                        xpath = xpath + "/" + this.PARTCOLS;
                        partCols1 = p1.selectSingleNode(xpath, s_resolver);
                        partCols2 = p2.selectSingleNode(xpath, s_resolver);
                        equal = this.m_diff.equals(partCols1, partCols2);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
                if (!s_log.isDebugEnabled()) break block11;
                s_log.debug((Object)e.getMessage());
            }
        }
        return equal;
    }

    private boolean hashPartTSListEquals(XMLElement p1, XMLElement p2, int type) {
        try {
            String xpath = null;
            String ts1 = null;
            String ts2 = null;
            if (type == 2 || type == 7) {
                xpath = this.HASHPARTTS_LIST;
                xpath = "sxml:PARTITION_LIST/sxml:PARTITION_LIST_ITEM/sxml:SEGMENT_ATTRIBUTES";
            }
            XMLNode pliNode1 = CMXMLUtils.getNode((XMLNode)p1, xpath);
            XMLNode pliNode2 = CMXMLUtils.getNode((XMLNode)p2, xpath);
            if (pliNode1 != null && pliNode2 != null) {
                ts1 = CMXMLUtils.selectTextValue(pliNode1, "sxml:TABLESPACE");
                ts2 = CMXMLUtils.selectTextValue(pliNode2, "sxml:TABLESPACE");
            }
            if (ts1 == null && ts2 == null) {
                return true;
            }
            return ts1 != null && ts2 != null && ts1.equals(ts2);
        }
        catch (Exception e) {
            System.out.println("Some exception caught in hashpartTs" + e.getMessage());
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)e.getMessage());
            }
            return false;
        }
    }

    private static boolean comparingPartitioning(Node n1, Node n2) {
        if (n1.getNodeType() == 1 && n2.getNodeType() == 1) {
            String tag1 = ((XMLElement)n1).getTagName();
            String tag2 = ((XMLElement)n2).getTagName();
            return s_partSet.contains(tag1) && s_partSet.contains(tag2);
        }
        return false;
    }

    private int getPartitioningType(XMLElement n) {
        String t = n.getTagName();
        int type = -1;
        if (this.RANGE_PARTITIONING.equals(t)) {
            type = 1;
            try {
                if (n.selectSingleNode("//" + this.QHASH_SUBPARTITIONING, s_resolver) != null) {
                    type = 4;
                } else if (n.selectSingleNode("//" + this.QLIST_SUBPARTITIONING, s_resolver) != null) {
                    type = 5;
                }
            }
            catch (Throwable e) {}
        } else if (this.HASH_PARTITIONING.equals(t)) {
            type = 2;
        } else if (this.LIST_PARTITIONING.equals(t)) {
            type = 3;
        } else if (this.GLOBAL_PARTITIONING.equals(t)) {
            try {
                if (n.selectSingleNode("//" + this.QRANGE_PARTITIONING, s_resolver) != null) {
                    type = 6;
                } else if (n.selectSingleNode("//" + this.QHASH_PARTITIONING, s_resolver) != null) {
                    type = 7;
                }
            }
            catch (Throwable e) {}
        } else if (this.LOCAL_PARTITIONING.equals(t)) {
            if (this.XML_TYPE == 2) {
                type = 13;
            } else {
                String pType = null;
                try {
                    pType = CMXMLUtils.selectTextValue((XMLNode)n, this.PARTTYPE);
                }
                catch (Throwable e) {
                    // empty catch block
                }
                if (this.HASH_PARTITIONING.equals(pType)) {
                    type = 9;
                } else if (this.LIST_PARTITIONING.equals(pType)) {
                    type = 10;
                } else if (this.RANGE_PARTITIONING.equals(pType)) {
                    type = 8;
                    try {
                        if (n.selectSingleNode("//" + this.QHASH_SUBPARTITIONING, s_resolver) != null) {
                            type = 11;
                        } else if (n.selectSingleNode("//" + this.QLIST_SUBPARTITIONING, s_resolver) != null) {
                            type = 12;
                        }
                    }
                    catch (Throwable e) {
                        // empty catch block
                    }
                }
            }
        }
        return type;
    }

    private boolean isListPartType(int partType) {
        return partType == 3 || partType == 10;
    }

    private boolean isRangePartType(int partType) {
        return partType == 1 || partType == 5 || partType == 4 || partType == 6 || partType == 8 || partType == 12 || partType == 11;
    }

    private boolean isLocalPartType(int partType) {
        return partType == 8 || partType == 12 || partType == 11 || partType == 13;
    }

    private boolean reportNameDiff(XMLElement n1, XMLElement n2) {
        return this.bothHaveAttribute(n1, n2, "IGNORE_NAME_DIFFERENCES") && "0".equals(n1.getAttribute("IGNORE_NAME_DIFFERENCES"));
    }

    private boolean matchByDefinition(XMLElement n1, XMLElement n2) {
        int tagMatch = this.compareStrings(n1.getTagName(), n2.getTagName());
        if (tagMatch != 0) {
            return false;
        }
        return this.bothHaveAttribute(n1, n2, "MATCH_CONSTR_BY_DEFINITION") && !"0".equals(n1.getAttribute("MATCH_CONSTR_BY_DEFINITION"));
    }

    private boolean bothDefinitionNodes(XMLElement n1, XMLElement n2) {
        if (n1 == null || n2 == null) {
            return false;
        }
        if (n1.getTagName().equals("REFERENCES") && "TRUE".equals(n1.getAttribute("COMPUTE_CONSTR_DEF"))) {
            return false;
        }
        return "TRUE".equals(n1.getAttribute("COMPUTE_CONSTR_DEF")) && "TRUE".equals(n2.getAttribute("COMPUTE_CONSTR_DEF"));
    }

    private int compareElementNodes(XMLElement n1, XMLElement n2) {
        int tagMatch = this.compareStrings(n1.getTagName(), n2.getTagName());
        if (tagMatch == 0 && this.bothHaveAttribute(n1, n2, "NAME") && !"1".equals(n1.getAttribute("MATCH_CONSTR_BY_DEFINITION"))) {
            return this.compareStrings(n1.getAttribute("NAME"), n2.getAttribute("NAME"));
        }
        return tagMatch;
    }

    private boolean isSourceTypeNodes(Node n1, Node n2) {
        if (n1 == null || n2 == null || n1.getNodeType() != 1 || n2.getNodeType() != 1) {
            return false;
        }
        String tag1 = ((XMLElement)n1).getTagName();
        String tag2 = ((XMLElement)n2).getTagName();
        return this.SOURCE.equals(tag1) && this.SOURCE.equals(tag2) || this.TEXT.equals(tag1) && this.TEXT.equals(tag2) || this.TRIGGER_BODY.equals(tag1) && this.TRIGGER_BODY.equals(tag2) || this.QUERY.equals(tag1) && this.QUERY.equals(tag2) || this.CONDITION.equals(tag1) && this.CONDITION.equals(tag2) || this.SUBQUERY.equals(tag1) && this.SUBQUERY.equals(tag2);
    }

    private boolean isColumnDefaultNull(Node n) {
        if (n == null || n.getNodeType() != 1) {
            return false;
        }
        if (!((XMLElement)n).getTagName().equals(this.DEFAULT) || !((XMLElement)n.getParentNode()).getTagName().equals(this.COL_LIST_ITEM)) {
            return false;
        }
        String defValue = CMXMLUtils.selectTextValue((XMLNode)n, ".");
        return defValue != null && (defValue.trim().toUpperCase().equals("NULL") || "(NULL)".equals(VxxString.getLogicalSQLString(defValue)));
    }

    private boolean isSequenceStartWithNodes(Node n1, Node n2) {
        if (n1 == null || n2 == null || n1.getNodeType() != 1 || n2.getNodeType() != 1) {
            return false;
        }
        String tag1 = ((XMLElement)n1).getTagName();
        String tag2 = ((XMLElement)n2).getTagName();
        if (this.START_WITH.equals(tag1) && this.START_WITH.equals(tag2)) {
            Node p1 = n1.getParentNode();
            Node p2 = n2.getParentNode();
            tag1 = ((XMLElement)p1).getTagName();
            tag2 = ((XMLElement)p2).getTagName();
            if (this.SEQUENCE.equals(tag1) && this.SEQUENCE.equals(tag2)) {
                return true;
            }
        }
        return false;
    }

    private boolean isPartitionHighValuesNodes(Node n1, Node n2) {
        if (n1 == null || n2 == null || n1.getNodeType() != 1 || n2.getNodeType() != 1) {
            return false;
        }
        String tag1 = ((XMLElement)n1).getTagName();
        String tag2 = ((XMLElement)n2).getTagName();
        if ("VALUES".equals(tag1) && "VALUES".equals(tag2)) {
            Node p1 = n1.getParentNode();
            Node p2 = n2.getParentNode();
            tag1 = ((XMLElement)p1).getTagName();
            tag2 = ((XMLElement)p2).getTagName();
            if ("PARTITION_LIST_ITEM".equals(tag1) && "PARTITION_LIST_ITEM".equals(tag2)) {
                return true;
            }
        }
        return false;
    }

    private boolean isUnnamedPK(XMLElement e) {
        boolean ret = false;
        String tagName = e.getTagName();
        if ("PRIMARY_KEY_CONSTRAINT_LIST_ITEM".equals(tagName) && e.hasAttribute("MATCH_CONSTR_BY_DEFINITION") && "0".equals(e.getAttribute("MATCH_CONSTR_BY_DEFINITION")) && !CMXMLUtils.nodeExists((XMLNode)e, "sxml:NAME")) {
            ret = true;
        }
        return ret;
    }

    private boolean logicalSQLTextNodeMatched(XMLText node1, XMLText node2) {
        String s2;
        String s1 = node1.getNodeValue().trim();
        boolean matched = VxxString.logicalSQLStringsEqual(s1, s2 = node2.getNodeValue().trim());
        if (!matched && this.eitherUnavailable(s1, s2)) {
            return true;
        }
        return matched;
    }

    private boolean textNodeMatched(XMLText node1, XMLText node2) {
        String s2;
        String s1 = node1.getNodeValue().trim();
        if (s1.equals(s2 = node2.getNodeValue().trim())) {
            return true;
        }
        return this.eitherUnavailable(s1, s2);
    }

    private boolean eitherUnavailable(String s1, String s2) {
        return s1.equals("UNAVAILABLE") || s2.equals("UNAVAILABLE");
    }

    private boolean getLogicalCompare() {
        return this.m_diff != null && this.m_diff.getLogicalCompare();
    }

    private boolean getIgnoreHighValues() {
        return this.m_diff != null && this.m_diff.getIgnoreHighValues();
    }

    private boolean getIgnoreAllPartitioning() {
        return this.m_diff != null && this.m_diff.getIgnoreAllPartitioning();
    }

    private int compareStrings(String s1, String s2) {
        return s1.trim().compareTo(s2.trim());
    }

    private boolean bothHaveAttribute(XMLElement n1, XMLElement n2, String aname) {
        return n1 != null && n2 != null && n1.hasAttribute(aname) && n2.hasAttribute(aname);
    }

    private int findMatch(XMLElement node, NodeList list, int listLength, int startIndex) {
        int matchIndex = -1;
        for (int i = startIndex; i < listLength; ++i) {
            XMLElement listNode = (XMLElement)list.item(i);
            if (this.compareElementNodes(node, listNode) != 0) continue;
            matchIndex = i;
            break;
        }
        return matchIndex;
    }
}

