/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.dbTarget.db.changemgr.emo.cpapi;

import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.pool.OracleDataSource;
import oracle.sysman.dbTarget.db.changemgr.emo.docaccess.CMConnection;
import oracle.sysman.dbTarget.db.changemgr.emo.docaccess.XMLAccessor;
import oracle.sysman.dbTarget.db.changemgr.emo.docaccess.XMLAccessorClient;
import oracle.sysman.dbTarget.db.changemgr.emo.docaccess.XMLAccessorException;
import oracle.sysman.dbTarget.db.changemgr.emo.docaccess.XMLAccessorSettings;
import oracle.xml.parser.v2.XMLDocument;

public class VerifyEmapi {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] args) {
        if (args.length < 5) {
            VerifyEmapi.usage();
            System.exit(0);
        }
        String hps = args[0];
        String sysmanUser = args[1];
        String sysmanPwd = args[2];
        String systemUser = args[3];
        String systemPwd = args[4];
        String cString = VerifyEmapi.getURL(hps);
        if (cString == null) {
            System.err.println("No URL generated, args[0]: " + args[0]);
            VerifyEmapi.usage();
            System.exit(0);
        }
        CMConnection cmConn = null;
        Statement dmlStmt = null;
        String srcSchema = "EMAPI_1";
        String destSchema = "EMAPI_2";
        try {
            OracleDataSource ods = new OracleDataSource();
            ods.setURL(cString);
            ods.setUser(systemUser);
            ods.setPassword(systemPwd);
            OracleConnection conn = (OracleConnection)ods.getConnection();
            cmConn = new CMConnection(conn);
            dmlStmt = cmConn.createStatement();
            VerifyEmapi.safeDDL(dmlStmt, "drop user " + srcSchema + " cascade");
            VerifyEmapi.safeDDL(dmlStmt, "drop user " + destSchema + " cascade");
            String ddl = null;
            try {
                ddl = "create user " + srcSchema + " identified by " + srcSchema;
                dmlStmt.execute(ddl);
                ddl = "grant connect, resource, unlimited tablespace to " + srcSchema;
                dmlStmt.execute(ddl);
                ddl = "create user " + destSchema + " identified by " + destSchema;
                dmlStmt.execute(ddl);
                ddl = "grant connect, resource, unlimited tablespace to " + destSchema;
                dmlStmt.execute(ddl);
                ddl = "create table " + srcSchema + ".t (c0 number, c1 number, " + "c2 number, " + "constraint t_pk primary key (c1, c2), " + "constraint t_uq unique (c0))";
                dmlStmt.execute(ddl);
                ddl = "comment on column " + srcSchema + ".t.c1 is 'Standalone column comment - " + srcSchema + "'";
                dmlStmt.execute(ddl);
                ddl = "create table " + srcSchema + ".t2 (c1 number, c2 number," + "constraint t2_fk foreign key (c1, c2) " + "references " + srcSchema + ".t (c1, c2))";
                dmlStmt.execute(ddl);
                ddl = "comment on table " + srcSchema + ".t2 is 'Table com''ment - " + srcSchema + ".'";
                dmlStmt.execute(ddl);
                ddl = "comment on column " + srcSchema + ".t2.c1 is 'Non-stand''alone column com'';ment - " + srcSchema + "'";
                dmlStmt.execute(ddl);
                ddl = "create table " + srcSchema + ".t_same (c0 number," + "constraint t_same_fk foreign key (c0) " + "references " + srcSchema + ".t (c0))";
                dmlStmt.execute(ddl);
                ddl = "create table " + srcSchema + ".t_dropcol (c0 number, c1 number)";
                dmlStmt.execute(ddl);
                ddl = "create table " + destSchema + ".t (c0 number,  c1 number, " + "constraint t_pk primary key (c1), " + "constraint t_uq unique (c0))";
                dmlStmt.execute(ddl);
                ddl = "comment on column " + destSchema + ".t.c1 is 'Standalone column comment - " + destSchema + "'";
                dmlStmt.execute(ddl);
                ddl = "create table " + destSchema + ".t2 (c1 number, " + "constraint t2_fk foreign key (c1) " + "references " + destSchema + ".t (c1))";
                dmlStmt.execute(ddl);
                ddl = "comment on table " + destSchema + ".t2 is 'Table comment - " + destSchema + "'";
                dmlStmt.execute(ddl);
                ddl = "comment on column " + destSchema + ".t2.c1 is 'Non-standalone column comment - " + destSchema + "'";
                dmlStmt.execute(ddl);
                ddl = "create table " + destSchema + ".t_same (c0 number," + "constraint t_same_fk foreign key (c0) " + "references " + destSchema + ".t (c0))";
                dmlStmt.execute(ddl);
                ddl = "create table " + destSchema + ".t_dropcol (c0 number, c_extra number, c1 number)";
                dmlStmt.execute(ddl);
                ddl = "create table " + srcSchema + "." + srcSchema + "_only (c0 number," + "constraint " + srcSchema + "_only_fk foreign key (c0) " + "references " + srcSchema + ".t (c0))";
                dmlStmt.execute(ddl);
                ddl = "create table " + destSchema + "." + destSchema + "_only (c0 number," + "constraint " + destSchema + "_only_fk foreign key (c0) " + "references " + destSchema + ".t (c0))";
                dmlStmt.execute(ddl);
                ddl = "create or replace procedure " + srcSchema + ".proc as \n" + " begin \n" + "  null; -- Procedure in " + srcSchema + " \n" + " end;\n";
                dmlStmt.execute(ddl);
                ddl = "create or replace procedure " + destSchema + ".proc as \n" + " begin \n" + "  null; -- Procedure in " + destSchema + " \n" + " end;\n";
                dmlStmt.execute(ddl);
                ddl = "create or replace procedure " + srcSchema + ".proc_same as \n" + " begin \n" + "  null; -- Procedure in both\n" + " end;\n";
                dmlStmt.execute(ddl);
                ddl = "create or replace procedure " + destSchema + ".proc_same as \n" + " begin \n" + "  null; -- Procedure in both\n" + " end;\n";
                dmlStmt.execute(ddl);
                ddl = "create or replace procedure " + srcSchema + ".proc_" + srcSchema + "_only as \n" + " begin \n" + "  null; -- Procedure in " + srcSchema + " only \n" + " end;\n";
                dmlStmt.execute(ddl);
                ddl = "create or replace procedure " + destSchema + ".proc_" + destSchema + "_only as \n" + " begin \n" + "  null; -- Procedure in " + destSchema + " only \n" + " end;\n";
                dmlStmt.execute(ddl);
                ddl = "create or replace trigger " + srcSchema + ".t2_trig before update on " + srcSchema + ".t2 \n" + " begin \n" + "  null;\n " + " end;\n";
                dmlStmt.execute(ddl);
                ddl = "create or replace trigger " + destSchema + ".t2_trig before insert on " + destSchema + ".t2 \n" + " begin \n" + "  null;\n " + " end;\n";
                dmlStmt.execute(ddl);
                ddl = "create or replace synonym " + srcSchema + ".buggy_syn " + "for hr.employees";
                dmlStmt.execute(ddl);
                ddl = "create or replace synonym " + destSchema + ".buggy_syn " + "for hr.departments";
                dmlStmt.execute(ddl);
                ddl = "create or replace view " + srcSchema + ".t_v as select c0, c2 from " + srcSchema + ".t";
                dmlStmt.execute(ddl);
                ddl = "create or replace view " + destSchema + ".t_v as select c0, c1 from " + destSchema + ".t";
                dmlStmt.execute(ddl);
            }
            catch (SQLException se) {
                throw new XMLAccessorException("Error executing DDL: " + ddl, se);
            }
            XMLAccessorSettings xacImpl = new XMLAccessorSettings();
            xacImpl.setIgnoreTablespace(true);
            xacImpl.setIgnorePhysicalAttributes(true);
            HashMap<String, String> sMap = new HashMap<String, String>();
            sMap.put(srcSchema, destSchema);
            VerifyEmapi.compare(cmConn, xacImpl, 0, srcSchema, destSchema, sMap, "T", false);
            VerifyEmapi.compare(cmConn, xacImpl, 0, srcSchema, destSchema, sMap, "T2", true);
            VerifyEmapi.compare(cmConn, xacImpl, 1, srcSchema, destSchema, sMap, "T_PK", false);
            VerifyEmapi.compare(cmConn, xacImpl, 0, srcSchema, destSchema, sMap, "T_SAME", false);
            VerifyEmapi.compare(cmConn, xacImpl, 7, srcSchema, destSchema, sMap, "PROC", true);
            VerifyEmapi.compare(cmConn, xacImpl, 7, srcSchema, destSchema, sMap, "PROC_SAME", false);
            VerifyEmapi.compare(cmConn, xacImpl, 7, srcSchema, null, sMap, "PROC_" + srcSchema + "_ONLY", true);
            VerifyEmapi.compare(cmConn, xacImpl, 7, null, destSchema, sMap, "PROC_" + destSchema + "_ONLY", false);
            VerifyEmapi.compare(cmConn, xacImpl, 3, srcSchema, destSchema, sMap, "T2_TRIG", true);
            VerifyEmapi.compare(cmConn, xacImpl, 4, srcSchema, destSchema, sMap, "BUGGY_SYN", false);
            xacImpl.setIgnoreTableColumnPosition(false);
            VerifyEmapi.compare(cmConn, xacImpl, 0, srcSchema, destSchema, sMap, "T_DROPCOL", false);
            xacImpl.setIgnoreTableColumnPosition(true);
            VerifyEmapi.compare(cmConn, xacImpl, 0, srcSchema, destSchema, sMap, "T_DROPCOL", false);
            VerifyEmapi.compare(cmConn, xacImpl, 2, srcSchema, destSchema, sMap, "T_V", true);
            VerifyEmapi.safeDDL(dmlStmt, "drop user " + srcSchema + " cascade");
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            return;
        }
        VerifyEmapi.safeDDL(dmlStmt, "drop user " + destSchema + " cascade");
        try {
            if (dmlStmt != null) {
                dmlStmt.close();
            }
            if (cmConn == null) return;
            cmConn.close();
            return;
        }
        catch (SQLException se) {
            return;
        }
        finally {
            VerifyEmapi.safeDDL(dmlStmt, "drop user " + srcSchema + " cascade");
            VerifyEmapi.safeDDL(dmlStmt, "drop user " + destSchema + " cascade");
            try {
                if (dmlStmt != null) {
                    dmlStmt.close();
                }
                if (cmConn != null) {
                    cmConn.close();
                }
            }
            catch (SQLException se) {}
        }
    }

    private static void compare(CMConnection cmConn, XMLAccessorClient xacImpl, int objType, String srcSchema, String destSchema, HashMap sMap, String objName, boolean forExecution) throws SQLException, XMLAccessorException {
        XMLAccessor srcXA = null;
        XMLAccessor destXA = null;
        if (srcSchema != null) {
            srcXA = XMLAccessor.getXMLAccessorForType(objType, xacImpl);
            srcXA.initFromDatabase(cmConn, srcSchema, objName, true);
        }
        if (destSchema != null) {
            destXA = XMLAccessor.getXMLAccessorForType(objType, xacImpl);
            destXA.initFromDatabase(cmConn, destSchema, objName, true);
        }
        if (srcSchema != null && destSchema != null) {
            XMLDocument sourceDoc = srcXA.getDocument();
            if (destXA.compareDefinition(sourceDoc, sMap)) {
                System.out.println("Objects are different");
            } else {
                System.out.println("Objects are the same");
            }
            String testDDL = destXA.getDDL(2);
            System.out.println("Source DDL:\n " + testDDL);
            if (forExecution) {
                testDDL = destXA.getDDLForExecution(2);
                System.out.println("Source DDL ForExecution:\n " + testDDL);
            }
            testDDL = destXA.getDDL(1);
            System.out.println("Destination DDL:\n " + testDDL);
            if (forExecution) {
                testDDL = destXA.getDDLForExecution(1);
                System.out.println("Destination DDL ForExecution:\n " + testDDL);
            }
            testDDL = destXA.getDDL(3);
            System.out.println("Alter DDL:\n " + testDDL);
            if (forExecution) {
                testDDL = destXA.getDDLForExecution(3);
                System.out.println("Alter DDL ForExecution:\n " + testDDL);
            }
        } else {
            XMLAccessor oneSideXA = srcXA != null ? srcXA : destXA;
            String testDDL = oneSideXA.getDDL(2, sMap);
            System.out.println("Source DDL:\n " + testDDL);
            if (forExecution) {
                testDDL = oneSideXA.getDDLForExecution(2, sMap);
                System.out.println("Source DDL ForExecution:\n " + testDDL);
            }
            testDDL = oneSideXA.getDDL(1, sMap);
            System.out.println("Destination DDL:\n " + testDDL);
            if (forExecution) {
                testDDL = oneSideXA.getDDLForExecution(1, sMap);
                System.out.println("Destination DDL ForExecution:\n " + testDDL);
            }
            testDDL = oneSideXA.getDDL(3, sMap);
            System.out.println("Alter DDL:\n " + testDDL);
            if (forExecution) {
                testDDL = oneSideXA.getDDLForExecution(3, sMap);
                System.out.println("Alter DDL ForExecution:\n " + testDDL);
            }
        }
        System.out.println("-------------------------------------------");
    }

    private static void safeDDL(Statement dmlStmt, String ddl) {
        if (dmlStmt != null && ddl != null) {
            try {
                dmlStmt.execute(ddl);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    private static String getURL(String hps) {
        String url = null;
        if (hps != null) {
            int colon1 = hps.indexOf(":");
            int colon2 = hps.indexOf(":", colon1 + 1);
            int colon3 = hps.indexOf(":", colon2 + 1);
            if (colon1 > 0 && colon2 > colon1) {
                String host = hps.substring(0, colon1);
                String port = hps.substring(colon1 + 1, colon2);
                String sid = colon3 > colon2 ? hps.substring(colon2 + 1, colon3) : hps.substring(colon2 + 1);
                url = "jdbc:oracle:thin:@" + host + ":" + port + ":" + sid;
            }
        }
        return url;
    }

    private static void usage() {
        System.out.println("Usage: VerifyEmapi host:port:sid sysman sysman-pwd system system-pwd");
    }
}

