/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.status.editor;

import java.util.List;
import javax.swing.Action;
import oracle.javatools.buffer.LineMap;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.status.Severity;
import oracle.javatools.util.NullArgumentException;
import oracle.jdeveloper.audit.AuditManager;
import oracle.jdeveloper.audit.analyzer.Rule;
import oracle.jdeveloper.audit.model.ContainerModelAdapter;
import oracle.jdeveloper.audit.model.Location;
import oracle.jdeveloper.audit.model.ModelAccessError;
import oracle.jdeveloper.audit.model.ModelAdapter;
import oracle.jdeveloper.audit.service.Suppression;
import oracle.jdeveloper.audit.service.Transformer;
import oracle.jdeveloper.audit.service.Violation;
import oracle.jdeveloper.audit.transform.Transform;

final class EditorIssue
implements Violation,
Comparable<Violation> {
    private static int lastSerialNumber;
    private final Rule rule;
    private final String variation;
    private final Location location;
    private final int serialNumber;
    private final Object[] objects;
    private final int parameterCount;
    private final int transformCount;
    private final int suppressionCount;
    private final boolean hasTransforms;
    private final boolean errorAndStandardTransforms;
    private Location focusLocation;
    private int highlightStart;
    private int highlightLength;
    private int focusLine;
    private int focusLineCount;

    public EditorIssue(Violation issue, boolean hasTransforms, boolean errorAndStandardTransforms) {
        int i;
        this.rule = issue.getRule();
        if (this.rule == null) {
            throw new NullArgumentException("null rule in " + issue.getClass());
        }
        this.variation = issue.getVariation();
        this.location = issue.getLocation();
        Location focusLocation = issue.getFocusLocation();
        this.focusLocation = focusLocation != null ? focusLocation : this.location;
        this.serialNumber = ++lastSerialNumber;
        this.parameterCount = issue.getParameterCount();
        this.transformCount = issue.getTransformCount();
        this.suppressionCount = issue.getSuppressionCount();
        this.objects = new Object[this.parameterCount * 2 + this.transformCount + this.suppressionCount];
        int o = 0;
        for (i = 0; i < this.parameterCount; ++i) {
            this.objects[o++] = issue.getParameterName(i);
            this.objects[o++] = issue.getParameterValue(i);
        }
        for (i = 0; i < this.transformCount; ++i) {
            this.objects[o++] = issue.getTransform(i);
        }
        for (i = 0; i < this.suppressionCount; ++i) {
            this.objects[o++] = issue.getSuppression(i);
        }
        assert (this.parameterCount == this.getParameterCount());
        assert (this.transformCount == this.getTransformCount());
        this.hasTransforms = hasTransforms;
        this.errorAndStandardTransforms = errorAndStandardTransforms;
    }

    void adjustFocusLocation(BasicDocument document, ModelAdapter innerModel) {
        if (this.focusLocation.getModel() instanceof ContainerModelAdapter) {
            this.highlightStart = 0;
            this.highlightLength = 0;
            this.focusLocation = innerModel.getLocation(this.highlightStart, this.highlightLength);
            this.focusLine = 0;
            this.focusLineCount = 1;
        } else {
            int bufferLength = document.getLength();
            this.highlightStart = Math.min(Math.max(0, this.focusLocation.getOffset()), bufferLength);
            this.highlightLength = Math.min(Math.max(0, this.focusLocation.getLength()), bufferLength - this.highlightStart);
            assert (this.highlightLength >= 0);
            LineMap lineMap = document.getLineMap();
            this.focusLine = lineMap.getLineFromOffset(this.highlightStart);
            if (this.highlightLength == 0) {
                this.focusLineCount = 1;
            } else {
                int highlightEnd = this.highlightStart + this.highlightLength;
                assert (this.highlightStart < highlightEnd);
                int endFocusLine = lineMap.getLineFromOffset(highlightEnd);
                int lineEnd = lineMap.getLineEndOffset(this.focusLine);
                TextBuffer buffer = document.getTextBuffer();
                this.focusLineCount = endFocusLine - this.focusLine + 1;
                if (this.focusLineCount == 1) {
                    assert (highlightEnd <= lineEnd);
                    if (highlightEnd == lineEnd && buffer.getChar(highlightEnd - 1) == '\n') {
                        --this.highlightLength;
                        while (this.highlightLength > 0 && Character.isWhitespace(buffer.getChar(this.highlightStart + this.highlightLength - 1))) {
                            --this.highlightLength;
                        }
                    }
                } else {
                    assert (highlightEnd >= lineEnd);
                    this.highlightLength = lineEnd - this.highlightStart;
                    assert (this.highlightLength >= 0);
                    while (this.highlightLength > 0 && Character.isWhitespace(buffer.getChar(this.highlightStart + this.highlightLength - 1))) {
                        --this.highlightLength;
                    }
                }
            }
        }
        assert (this.highlightLength >= 0);
    }

    public Location getLocation() {
        return this.location;
    }

    public Location getFocusLocation() {
        return this.focusLocation;
    }

    public Rule getRule() {
        return this.rule;
    }

    public String getVariation() {
        return this.variation;
    }

    public int getParameterCount() {
        return this.parameterCount;
    }

    public String getParameterName(int index) {
        return (String)this.objects[index *= 2];
    }

    public Object getParameterValue(int index) {
        index = index * 2 + 1;
        return this.objects[index];
    }

    public Object getParameterValue(String name) {
        int i = this.getParameterCount();
        while (i-- > 0) {
            if (!name.equals(this.getParameterName(i))) continue;
            return this.getParameterValue(i);
        }
        return null;
    }

    public Transform getDefaultTransform() {
        throw new UnsupportedOperationException("default transform not supported");
    }

    public int getTransformCount() {
        return this.transformCount;
    }

    public Transform getTransform(int index) {
        return (Transform)this.objects[this.parameterCount * 2 + index];
    }

    public int getSerialNumber() {
        return this.serialNumber;
    }

    public int getSuppressionCount() {
        return this.suppressionCount;
    }

    public Suppression getSuppression(int index) {
        return index < this.suppressionCount ? (Suppression)this.objects[this.parameterCount * 2 + this.transformCount + index] : null;
    }

    @Override
    public int compareTo(Violation that) {
        int comparison = this.focusLocation.compareTo(that.getFocusLocation());
        if (comparison == 0) {
            comparison = this.serialNumber - that.getSerialNumber();
        }
        return comparison;
    }

    public int getFocusLine() {
        return this.focusLine;
    }

    public int getFocusLineCount() {
        return this.focusLineCount;
    }

    public boolean isErrorAndHasStandardTransforms() {
        return this.errorAndStandardTransforms;
    }

    public int getHighlightStart() {
        return this.highlightStart;
    }

    public int getHighlightLength() {
        return this.highlightLength;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("issue ");
        buffer.append(" ");
        buffer.append(this.rule.id());
        buffer.append('[');
        int count = this.getParameterCount();
        for (int i = 0; i < count; ++i) {
            if (i > 0) {
                buffer.append(',');
            }
            buffer.append(this.getParameterName(i));
            buffer.append('=');
            buffer.append(this.getParameterValue(i));
        }
        buffer.append(']');
        buffer.append(this.getFocusLocation());
        return buffer.toString();
    }

    public String getMessage() {
        return this.getRule().message((Violation)this);
    }

    public String getHtmlMessage() {
        return this.getRule().htmlMessage((Violation)this);
    }

    public Severity getSeverity() {
        return this.getRule().getSeverity().getIssueSeverity();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getConstruct() {
        ModelAdapter model = this.location.getModel();
        boolean locked = false;
        try {
            model.beginRead();
            locked = true;
            Object object = model.getConstruct(this.location);
            return object;
        }
        catch (ModelAccessError e) {
            Object var4_6 = null;
            return var4_6;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            Object var4_7 = null;
            return var4_7;
        }
        finally {
            if (locked) {
                model.endRead();
            }
        }
    }

    public int getOffset() {
        return this.getFocusLocation().getOffset();
    }

    public int getEndOffset() {
        return this.getFocusLocation().getEndOffset();
    }

    public int getLength() {
        return this.getFocusLocation().getLength();
    }

    public boolean hasTransforms() {
        return this.getTransformCount() > 0;
    }

    public List<? extends Action> getTransforms() {
        Transformer transformer = AuditManager.getAuditManager().createTransformer();
        return transformer.createTransformActions((Violation)this, null, null);
    }
}

