/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.util.credential;

import java.sql.Connection;
import java.util.Hashtable;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.RaptorGroupLoader;
import oracle.javatools.db.DBException;
import org.antlr.stringtemplate.StringTemplate;
import org.antlr.stringtemplate.StringTemplateGroup;
import org.antlr.stringtemplate.StringTemplateGroupLoader;
import org.antlr.stringtemplate.language.AngleBracketTemplateLexer;

public class CredentialCodeGenerator {
    private static volatile CredentialCodeGenerator _instance;
    public static final String CREDENTIAL_UPDATE = "CREDENTIAL_UPDATE";
    private Map<String, StringTemplateGroup> templateGroups = new Hashtable<String, StringTemplateGroup>();

    private CredentialCodeGenerator() {
        this.initGroupLoader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CredentialCodeGenerator getInstance() {
        if (_instance != null) return _instance;
        Class<CredentialCodeGenerator> clazz = CredentialCodeGenerator.class;
        synchronized (CredentialCodeGenerator.class) {
            if (_instance != null) return _instance;
            _instance = new CredentialCodeGenerator();
            // ** MonitorExit[var0] (shouldn't be in output)
            return _instance;
        }
    }

    private void initGroupLoader() {
        try {
            RaptorGroupLoader raptorGroupLoader = new RaptorGroupLoader("oracle/dbtools/util/credential/templates", this.getClass().getClassLoader());
            StringTemplateGroup.registerGroupLoader((StringTemplateGroupLoader)raptorGroupLoader);
            StringTemplateGroup.registerDefaultLexer(AngleBracketTemplateLexer.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StringTemplateGroup getTemplateGroup(String string) {
        if (string == null || string.length() == 0) {
            StringTemplateGroup stringTemplateGroup = this.fetchTemplateGroup("");
            return stringTemplateGroup;
        }
        StringTemplateGroup stringTemplateGroup = this.templateGroups.get(string);
        if (stringTemplateGroup == null) {
            Map<String, StringTemplateGroup> map = this.templateGroups;
            synchronized (map) {
                stringTemplateGroup = this.templateGroups.get(string);
                if (stringTemplateGroup == null) {
                    String[] stringArray = string.split("\\.");
                    for (int i = stringArray.length; i > 0; --i) {
                        String string2 = "_";
                        String string3 = "";
                        for (int j = 0; j < i; ++j) {
                            string3 = string3 + string2 + stringArray[j];
                            string2 = "_";
                        }
                        stringTemplateGroup = this.fetchTemplateGroup(string3);
                        if (stringTemplateGroup != null) break;
                    }
                    if (stringTemplateGroup == null) {
                        stringTemplateGroup = this.fetchTemplateGroup("");
                    }
                }
                if (stringTemplateGroup != null) {
                    this.templateGroups.put(string, stringTemplateGroup);
                }
            }
        }
        return stringTemplateGroup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StringTemplateGroup fetchTemplateGroup(String string) {
        StringTemplateGroup stringTemplateGroup = this.templateGroups.get(string);
        if (stringTemplateGroup == null) {
            Map<String, StringTemplateGroup> map = this.templateGroups;
            synchronized (map) {
                stringTemplateGroup = this.templateGroups.get(string);
                if (stringTemplateGroup == null) {
                    stringTemplateGroup = StringTemplateGroup.loadGroup((String)("CREDENTIAL" + string));
                    if (stringTemplateGroup == null) {
                        return null;
                    }
                    this.templateGroups.put(string, stringTemplateGroup);
                }
            }
        }
        return stringTemplateGroup;
    }

    public StringTemplate getTemplate(String string, String string2) {
        try {
            StringTemplateGroup stringTemplateGroup = this.getTemplateGroup(string);
            if (stringTemplateGroup != null) {
                StringTemplate stringTemplate = stringTemplateGroup.lookupTemplate(string2);
                if (stringTemplate != null) {
                    stringTemplate.reset();
                }
                return stringTemplate;
            }
        }
        catch (Throwable throwable) {
            Logger.getLogger(CredentialCodeGenerator.class.getName()).log(Level.SEVERE, throwable.getLocalizedMessage(), throwable);
        }
        return null;
    }

    public String generateForConnection(String string, String string2, Map<String, Object> map) {
        try {
            return this.generate(Connections.getInstance().getConnection(string), string2, map);
        }
        catch (DBException dBException) {
            return null;
        }
    }

    public String generate(Connection connection, String string, Map<String, Object> map) {
        String string2 = DBUtil.getDbVersion((Connection)connection).toCanonicalString();
        return this.generate(string2, string, map);
    }

    public String generate(String string, String string2, Map<String, Object> map) {
        String string3 = null;
        try {
            StringTemplate stringTemplate = this.getTemplate(string, string2);
            if (stringTemplate != null) {
                stringTemplate.reset();
                if (map != null) {
                    stringTemplate.setAttributes(map);
                }
                string3 = stringTemplate.toString();
                if (string.startsWith("10")) {
                    string3 = string3.replaceAll("\r\n", "\n");
                }
            }
        }
        catch (Throwable throwable) {
            Logger.getLogger(CredentialCodeGenerator.class.getName()).log(Level.SEVERE, throwable.getLocalizedMessage(), throwable);
        }
        return string3;
    }

    public String getQuery(String string, String string2) {
        StringTemplateGroup stringTemplateGroup = this.getTemplateGroup(string2);
        StringTemplate stringTemplate = stringTemplateGroup.lookupTemplate(string);
        if (stringTemplate == null) {
            return null;
        }
        return stringTemplate.toString();
    }
}

