/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.utils;

import java.io.Closeable;
import java.io.FilterInputStream;
import java.io.Flushable;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import oracle.sql.BFILE;
import oracle.sql.BLOB;

public abstract class Closeables {
    public static <T> void close(T t) {
        if (t instanceof Flushable) {
            try {
                ((Flushable)t).flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (t instanceof Closeable) {
            try {
                ((Closeable)t).close();
            }
            catch (Throwable throwable) {}
        } else if (t instanceof ResultSet) {
            try {
                ResultSet resultSet = (ResultSet)t;
                resultSet.close();
            }
            catch (SQLException sQLException) {}
        } else if (t instanceof Statement) {
            try {
                Statement statement = (Statement)t;
                statement.close();
            }
            catch (SQLException sQLException) {}
        } else if (t instanceof Connection) {
            try {
                Connection connection = (Connection)t;
                connection.close();
            }
            catch (SQLException sQLException) {}
        } else if (t instanceof BLOB) {
            try {
                BLOB bLOB = (BLOB)t;
                bLOB.close();
            }
            catch (SQLException sQLException) {}
        } else if (t instanceof BFILE) {
            try {
                BFILE bFILE = (BFILE)t;
                bFILE.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public static <T> void close(T ... TArray) {
        for (T t : TArray) {
            Closeables.close(t);
        }
    }

    public static InputStream alsoClose(InputStream inputStream, final Object ... objectArray) {
        return new FilterInputStream(inputStream){

            @Override
            public void close() throws IOException {
                Closeables.close(objectArray);
            }
        };
    }
}

