/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.usage;

import oracle.dbtools.raptor.oviewer.base.ViewerNode;
import oracle.dbtools.raptor.usage.DBUsageTracker;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.ide.Context;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorListener;
import oracle.ide.model.Node;

public class EditorTracker
implements EditorListener {
    private static final String EDITOR_ACTIVATED = "ACTIVATE_EDITOR";

    EditorTracker() {
    }

    public void editorActivated(Editor editor) {
        this.reportUsage(editor, EDITOR_ACTIVATED);
    }

    public void editorDeactivated(Editor editor) {
    }

    public void editorOpened(Editor editor) {
    }

    public void editorClosed(Editor editor) {
    }

    private void reportUsage(Editor editor, String string) {
        DBUsageTracker dBUsageTracker = new DBUsageTracker("connection", "open");
        Context context = editor.getContext();
        if (context != null) {
            Node node = context.getNode();
            if (node instanceof ViewerNode) {
                DBObject dBObject = ((ViewerNode)node).getDBObject();
                dBUsageTracker.addProperty("object-type", dBObject.getObjectType());
                dBUsageTracker.addProperty("editor-tab", editor.getTabLabel());
            }
            if (node != null) {
                dBUsageTracker.addProperty("node-class", node.getClass().getName());
            }
        }
        dBUsageTracker.track();
    }
}

