/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.ui.wizard.summary;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.HashSet;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import oracle.dbtools.raptor.ui.wizard.summary.SummaryCategory;
import oracle.dbtools.raptor.ui.wizard.summary.SummaryHelper;
import oracle.dbtools.raptor.ui.wizard.summary.SummaryProvider;
import oracle.dbtools.raptor.ui.wizard.summary.SummaryTreeTable;
import oracle.dbtools.raptor.ui.wizard.summary.SummaryTreeTableModel;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;

public class SummaryWizardPage
extends DefaultTraversablePanel {
    private SummaryCategory m_rootSummaryCategory;
    private SummaryTreeTable m_summaryTreeTable;
    private HashSet<String> expTp = new HashSet();

    public SummaryWizardPage() {
        this.initGUI();
    }

    public void onEntry(TraversableContext traversableContext) {
        SummaryTreeTableModel summaryTreeTableModel = this.createModel();
        this.m_summaryTreeTable.getTree().setModel((TreeModel)((Object)summaryTreeTableModel));
        this.expandTree(this.m_summaryTreeTable.getTree());
        this.m_summaryTreeTable.revalidate();
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
    }

    protected void expandTree(JTree jTree) {
        TreePath treePath = null;
        for (int i = 0; i < jTree.getRowCount(); ++i) {
            treePath = jTree.getPathForRow(i);
            int n = treePath.getPathCount();
            if (n >= 3 && !this.expTp.contains(treePath.toString())) continue;
            jTree.expandRow(i);
        }
    }

    private void initGUI() {
        this.setLayout(new BorderLayout());
        SummaryTreeTableModel summaryTreeTableModel = this.createBaseModel();
        this.m_summaryTreeTable = new SummaryTreeTable(summaryTreeTableModel);
        JTree jTree = this.m_summaryTreeTable.getTree();
        jTree.addTreeExpansionListener(new TreeExpansionListener(){

            @Override
            public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
                SummaryWizardPage.this.expTp.add(treeExpansionEvent.getPath().toString());
            }

            @Override
            public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
                SummaryWizardPage.this.expTp.remove(treeExpansionEvent.getPath().toString());
            }
        });
        JScrollPane jScrollPane = new JScrollPane((Component)((Object)this.m_summaryTreeTable));
        jScrollPane.getViewport().setBackground(this.m_summaryTreeTable.getBackground());
        this.add(jScrollPane);
    }

    protected SummaryTreeTableModel createBaseModel() {
        this.m_rootSummaryCategory = new SummaryCategory("root", null);
        SummaryTreeTableModel summaryTreeTableModel = new SummaryTreeTableModel(this.m_rootSummaryCategory);
        return summaryTreeTableModel;
    }

    protected SummaryTreeTableModel createModel() {
        this.m_rootSummaryCategory = new SummaryCategory("root", null);
        for (String string : SummaryHelper.getAllSummaryProvidersList()) {
            this.m_rootSummaryCategory.addChild(this.addSummaryCategory(string));
        }
        Object object = new SummaryTreeTableModel(this.m_rootSummaryCategory);
        return object;
    }

    protected SummaryCategory addSummaryCategory(String string) {
        SummaryCategory summaryCategory = null;
        SummaryProvider summaryProvider = SummaryHelper.getSummaryProvider(string);
        summaryCategory = (SummaryCategory)summaryProvider.getSummary(null);
        return summaryCategory;
    }
}

