/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.ui.panels;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.ItemSelectable;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.dbtools.raptor.ui.LayoutControl;
import oracle.dbtools.raptor.ui.panels.ValidatablePanel;
import oracle.dbtools.raptor.ui.panels.ValidatablePanelException;
import oracle.javatools.util.ModelUtil;

public class CardLayoutPanel<V extends Component>
extends JPanel
implements ItemSelectable,
LayoutControl,
ValidatablePanel {
    private static final long serialVersionUID = 1L;
    private static final String NULL_PANEL_SELECTOR = "$NULL$";
    private JPanel _nullPanel;
    private JComboBox _selector;
    private JPanel _container;
    private CardLayout _cardLayout;
    private Map<?, ? extends V> _cardMap;
    private Object _currentSelectorKey;
    private boolean _validateOnChange;

    public CardLayoutPanel(Map<?, ? extends V> map, String string, Type type) {
        this.jbInit(map, string, type);
    }

    private void jbInit(Map<?, ? extends V> map, String string, Type type) {
        this._cardMap = map;
        this._cardLayout = new CardLayout(0, 0);
        this._nullPanel = new JPanel();
        this._container = new JPanel(this._cardLayout);
        this._container.add((Component)this._nullPanel, NULL_PANEL_SELECTOR);
        for (Object object : map.keySet()) {
            this._container.add((Component)map.get(object), object.toString());
        }
        this._container.add((Component)this._nullPanel, NULL_PANEL_SELECTOR);
        this._selector = new JComboBox(map.keySet().toArray()){

            @Override
            protected void selectedItemChanged() {
                this.fireItemStateChanged(new ItemEvent(this, 701, this.selectedItemReminder, 2));
                this.selectedItemReminder = this.dataModel.getSelectedItem();
                this.fireItemStateChanged(new ItemEvent(this, 701, this.selectedItemReminder, 1));
            }
        };
        this.show(this.getSelectedItem());
        this._selector.setName(string + "_ComboBox");
        this._selector.setEditable(false);
        this._selector.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                Object object;
                Object object2;
                if (1 == itemEvent.getStateChange() && ModelUtil.areDifferent((Object)(object2 = itemEvent.getItem()), (Object)(object = CardLayoutPanel.this.getCurrentSelectorKey()))) {
                    if (CardLayoutPanel.this.isValidateOnChange()) {
                        try {
                            CardLayoutPanel.this.validatePanel();
                        }
                        catch (ValidatablePanelException validatablePanelException) {
                            validatablePanelException.showMessageDialog(CardLayoutPanel.this.getCurrentCard());
                            CardLayoutPanel.this.setSelectedItem(object);
                            return;
                        }
                    }
                    CardLayoutPanel.this.show(object2);
                }
            }
        });
        this.setLayout(new GridBagLayout());
        switch (type) {
            case TITLE_BORDER: {
                this.setBorder(BorderFactory.createTitledBorder(string));
                JPanel jPanel = LayoutControl.GBC.createPanel();
                jPanel.add((Component)this._selector, LayoutControl.GBC.gbc(0, 0, 1, 1, LayoutControl.GBC.Inset.FIRST_LINE_START_COMP));
                jPanel.add((Component)this._container, LayoutControl.GBC.gbc(0, 1, 1, 1, LayoutControl.GBC.Inset.LINE_START_COMP, LayoutControl.GBC.Fill.XY, LayoutControl.GBC.Spring.XY));
                this.add((Component)jPanel, LayoutControl.GBC.TITLED_SUB_PANEL);
                break;
            }
            case PLAIN: {
                Object object;
                object = LayoutControl.GBC.createPanel();
                if (string != null) {
                    JLabel jLabel = new JLabel(string);
                    jLabel.setLabelFor(this._selector);
                    ((Container)object).add((Component)jLabel, LayoutControl.GBC.gbc(0, 0, 1, 1, LayoutControl.GBC.Inset.FIRST_LINE_START_COMP));
                    ((Container)object).add((Component)this._selector, LayoutControl.GBC.gbc(1, 0, 1, 1, LayoutControl.GBC.Inset.FIRST_LINE_LABEL2CONTROL_COMP));
                } else {
                    ((Container)object).add((Component)this._selector, LayoutControl.GBC.gbc(0, 0, 1, 1, LayoutControl.GBC.Inset.FIRST_LINE_START_COMP));
                }
                ((Container)object).add(Box.createGlue(), LayoutControl.GBC.gbc(2, 0, 1, 1, LayoutControl.GBC.Inset.NONE, LayoutControl.GBC.Fill.X, LayoutControl.GBC.Spring.X));
                this.add((Component)object, LayoutControl.GBC.gbc(0, 0, 1, 1, LayoutControl.GBC.Inset.FIRST_LINE_START_COMP));
                this.add((Component)this._container, LayoutControl.GBC.gbc(0, 1, 1, 1, LayoutControl.GBC.Inset.LINE_START_COMP, LayoutControl.GBC.Fill.XY, LayoutControl.GBC.Spring.XY));
            }
        }
    }

    private void show(Object object) {
        String string = object != null ? object.toString() : NULL_PANEL_SELECTOR;
        this._cardLayout.show(this._container, string);
        this.setCurrentSelectorKey(object);
    }

    private void setCurrentSelectorKey(Object object) {
        this._currentSelectorKey = object;
    }

    private Object getCurrentSelectorKey() {
        return this._currentSelectorKey;
    }

    private Component getCurrentCard() {
        Component[] componentArray;
        for (Component component : componentArray = this._container.getComponents()) {
            if (!component.isVisible()) continue;
            return component;
        }
        return null;
    }

    public void setValidateOnChange(boolean bl) {
        this._validateOnChange = bl;
    }

    public boolean isValidateOnChange() {
        return this._validateOnChange;
    }

    public void setSelectedItem(Object object) {
        this._selector.setSelectedItem(object);
    }

    @Override
    public void setEnabled(boolean bl) {
        this._selector.setEnabled(bl);
        super.setEnabled(bl);
    }

    public Object getSelectedItem() {
        return this._selector.getSelectedItem();
    }

    @Override
    public void addItemListener(ItemListener itemListener) {
        this._selector.addItemListener(itemListener);
    }

    @Override
    public void removeItemListener(ItemListener itemListener) {
        this._selector.removeItemListener(itemListener);
    }

    @Override
    public Object[] getSelectedObjects() {
        return this._selector.getSelectedObjects();
    }

    @Override
    public void validatePanel() throws ValidatablePanelException {
        Component component = this.getCurrentCard();
        if (component instanceof ValidatablePanel) {
            ((ValidatablePanel)((Object)component)).validatePanel();
        }
    }

    public static enum Type {
        PLAIN,
        TITLE_BORDER;

    }
}

