/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.ui.controls;

import java.util.List;
import javax.swing.SwingUtilities;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.backgroundTask.utils.DatabaseQueryTask;
import oracle.dbtools.raptor.ui.controls.DelayedLoadingComboBox;
import oracle.dbtools.util.Logger;

public abstract class DelayedLoadingComboBoxLoader {
    private LoaderTask _loaderTask;
    private boolean _taskStarted;

    public abstract List<Object> getComboContents() throws TaskException;

    public String getConnectionName() {
        return null;
    }

    void init(DelayedLoadingComboBox delayedLoadingComboBox, Object object) {
        this._loaderTask = new LoaderTask(delayedLoadingComboBox, object);
        this._taskStarted = false;
    }

    public void start() {
        if (!this._taskStarted) {
            RaptorTaskManager.getInstance().addTask((RaptorTask)this._loaderTask);
            this._taskStarted = true;
        }
    }

    public void addListener(IRaptorTaskListener iRaptorTaskListener) {
        this._loaderTask.getDescriptor().addListener(iRaptorTaskListener);
    }

    private class LoaderTask
    extends DatabaseQueryTask<List<Object>> {
        private static final String NAME_SFX = " DelayedLoadingComboBox.Loader";
        private DelayedLoadingComboBox _combo;
        private Object _value;

        public LoaderTask(DelayedLoadingComboBox delayedLoadingComboBox, Object object) {
            super(delayedLoadingComboBox.getName() + NAME_SFX, IRaptorTaskRunMode.TASKVIEWER, false, true, true);
            this.getDescriptor().addListener((IRaptorTaskListener)new WaitOver());
            this._combo = delayedLoadingComboBox;
            this._value = object;
        }

        @Override
        public String getConnectionName() {
            return DelayedLoadingComboBoxLoader.this.getConnectionName();
        }

        @Override
        public String getQuery() {
            return this.getDescriptor().getName();
        }

        protected List<Object> doWork() throws TaskException {
            try {
                return DelayedLoadingComboBoxLoader.this.getComboContents();
            }
            catch (TaskException taskException) {
                throw taskException;
            }
            catch (Exception exception) {
                Logger.warn(((Object)((Object)this)).getClass(), (Throwable)exception);
                throw new TaskException((Throwable)exception);
            }
        }

        protected void invokeLater() {
            try {
                this._combo.populate((List)this.getResult(), this._value);
            }
            catch (Exception exception) {
                Logger.warn(((Object)((Object)this)).getClass(), (Throwable)exception);
            }
        }

        private class WaitOver
        extends RaptorTaskAdapter {
            private WaitOver() {
            }

            public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        LoaderTask.this.invokeLater();
                    }
                };
                SwingUtilities.invokeLater(runnable);
            }
        }
    }
}

