/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.ui.controls;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import oracle.dbtools.raptor.ui.actions.ActionControl;

public class ComboBoxActionControl
extends ActionControl {
    private JComboBox _combo;
    private String _defaultValue;

    protected ComboBoxActionControl(String string, String string2, String string3, JComboBox jComboBox) {
        super(string, string2);
        this._defaultValue = string3;
        this._combo = jComboBox;
        this.addListener();
    }

    public ComboBoxActionControl(String string, String string2, String[] stringArray) {
        this(string, string2, stringArray, null);
    }

    public ComboBoxActionControl(String string, String string2, String[] stringArray, String string3) {
        super(string, string2);
        this._defaultValue = string3;
        this._combo = new JComboBox<String>(stringArray);
        this._combo.setName(string);
        this._combo.getEditor().getEditorComponent().setName(string + "_Editor");
        this.reset();
        this.addListener();
    }

    public ComboBoxActionControl(String string, String string2, String[] stringArray, String string3, boolean bl) {
        super(string, string2);
        this._defaultValue = string3;
        this._combo = new JComboBox<String>(stringArray);
        this._combo.setName(string);
        this._combo.getEditor().getEditorComponent().setName(string + "_Editor");
        this.reset();
        if (bl) {
            this.addNamedListener(string);
        } else {
            this.addListener();
        }
    }

    private void addListener() {
        this._combo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ComboBoxActionControl.this.firePropertyChangeListeners();
            }
        });
    }

    private void addNamedListener(final String string) {
        this._combo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ComboBoxActionControl.this.firePropertyChangeListeners(string);
            }
        });
    }

    @Override
    public ActionControl.Value getValue() {
        ActionControl.Value value = new ActionControl.Value();
        Object object = this._combo.getModel().getSelectedItem();
        value.set(object != null ? object.toString() : null);
        return value;
    }

    @Override
    public Component getUI() {
        return this._combo;
    }

    public void set(String string) {
        this._combo.setSelectedItem(string);
    }

    @Override
    public void reset() {
        if (this._defaultValue != null) {
            this._combo.setSelectedItem(this._defaultValue);
        } else if (this._combo.getItemCount() > 0) {
            this._combo.setSelectedIndex(0);
        }
    }

    public int getNumSelections() {
        return this._combo.getItemCount();
    }

    public void reset(String string) {
        if (string != null) {
            this._combo.setSelectedItem(string);
        } else if (this._combo.getItemCount() > 0) {
            this._combo.setSelectedIndex(0);
        }
    }

    public void reset(String[] stringArray) {
        this.reset(stringArray, null);
    }

    public void reset(String[] stringArray, String string) {
        this._combo.removeAllItems();
        this._combo.setModel(new DefaultComboBoxModel<String>(stringArray));
        this.reset(string);
    }

    @Override
    public void setEditable(boolean bl) {
        this._combo.setEnabled(bl);
    }

    public void enableEditBox() {
        this._combo.setEditable(true);
    }
}

