/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.ui.actions;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.dbtools.raptor.ui.actions.ActionControl;
import oracle.dbtools.raptor.ui.actions.ActionValuesLookup;

public class ActionValuesLookupImpl
implements ActionValuesLookup {
    private HashMap<String, String> _valueMap = new HashMap();
    private HashMap<String, List<String>> _listMap = new HashMap();

    public ActionValuesLookupImpl(List<ActionControl> list) {
        if (list != null) {
            this.addControls(list);
        }
    }

    protected void addControls(List<ActionControl> list) {
        if (list != null) {
            StringBuilder stringBuilder = new StringBuilder();
            for (ActionControl actionControl : list) {
                this.addControl(actionControl, stringBuilder);
                stringBuilder.setLength(0);
            }
        }
    }

    protected void addControl(ActionControl actionControl, StringBuilder stringBuilder) {
        Map<String, ActionControl.Value> map = new HashMap<String, ActionControl.Value>();
        map = actionControl.getNamedValue(map, stringBuilder, true);
        for (Map.Entry<String, ActionControl.Value> entry : map.entrySet()) {
            this.addControl(entry.getKey(), entry.getValue());
        }
    }

    protected void addControl(String string, ActionControl.Value value) {
        if (string != null && value != null) {
            String string2 = value.get();
            if (string2 != null) {
                this._valueMap.put(string, string2);
            }
            if (value.getNames().size() > 0) {
                for (String string3 : value.getNames()) {
                    this._valueMap.put(string + '/' + string3, value.get(string3));
                }
            }
            if (value.getListNames().size() > 0) {
                for (String string3 : value.getListNames()) {
                    this._listMap.put(string + '/' + string3, value.getList(string3));
                }
            }
        }
    }

    @Override
    public String get(String string) {
        return this._valueMap.get(string);
    }

    @Override
    public String get(String string, String string2) {
        return this.get(string + '/' + string2);
    }

    public List<String> getList(String string) {
        return this._listMap.get(string);
    }

    @Override
    public List<String> getList(String string, String string2) {
        return this.getList(string + '/' + string2);
    }

    @Override
    public Set<String> getNames() {
        return this._valueMap.keySet();
    }

    @Override
    public Set<String> getListNames() {
        return this._listMap.keySet();
    }
}

