/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.plsql;

import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.plsql.Item;
import oracle.dbtools.parser.plsql.LazyNode;
import oracle.dbtools.parser.plsql.StackParser;
import oracle.dbtools.raptor.navigator.plsql.PlSqlNode;
import oracle.dbtools.raptor.plsql.ParserEventListener;
import oracle.dbtools.raptor.plsql.structure.OutlinePanel;
import oracle.dbtools.raptor.utils.NamedSwingWorker;
import oracle.ide.db.model.BaseDBObjectTextNode;
import oracle.ide.db.model.DBObjectNodeUtil;
import oracle.ideimpl.db.model.SQLDevParserHelper;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.buffer.TextBufferListener;
import oracle.javatools.db.CancelledException;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.language.NumberRange;
import oracle.javatools.editor.plugins.EditorPlugin;
import oracle.javatools.util.Log;

public class BackgroundParser
implements TextBufferListener,
EditorPlugin {
    public LazyNode output = null;
    public List<LexerToken> src = null;
    public String text = null;
    public ArrayList<NumberRange> increments = new ArrayList();
    private TextBuffer buffer = null;
    long lastUpdate = -1L;
    public BasicEditorPane editor;
    boolean quit = false;
    public boolean isInsertion = false;
    public boolean isSingleChar = false;
    private List<ParserEventListener> listeners = new ArrayList<ParserEventListener>();
    private static final String KEYWORD_FUNCTION = "FUNCTION";
    private static final String KEYWORD_PROCEDURE = "PROCEDURE";
    private static final String KEYWORD_PACKAGE = "PACKAGE";
    private static final String KEYWORD_BODY = "BODY";
    private static final String KEYWORD_TYPE = "TYPE";
    private static final String KEYWORD_TRIGGER = "TRIGGER";

    public void attributeUpdate(TextBuffer textBuffer, int n) {
    }

    public void insertUpdate(TextBuffer textBuffer, int n, int n2, char[] cArray) {
        this.buffer = textBuffer;
        this.increments.add(new NumberRange(n, n + n2));
        this.lastUpdate = System.currentTimeMillis();
    }

    public void removeUpdate(TextBuffer textBuffer, int n, int n2, char[] cArray) {
        this.buffer = textBuffer;
        this.increments.add(new NumberRange(n, n - n2));
        this.lastUpdate = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean extractText() {
        block18: {
            boolean bl;
            if (!this.buffer.tryReadLock()) {
                return false;
            }
            try {
                if (this.buffer.getLength() > 5000000) {
                    this.quit = true;
                    Logger.getLogger(this.getClass().getName()).warning("Mem exceeded");
                    boolean bl2 = false;
                    return bl2;
                }
                this.text = this.buffer.getString(0, this.buffer.getLength());
                if (this.text != null) break block18;
                bl = false;
            }
            catch (Exception exception) {
                boolean bl3 = false;
                return bl3;
            }
            finally {
                try {
                    this.buffer.readUnlock();
                }
                catch (Throwable throwable) {}
            }
            return bl;
        }
        return true;
    }

    public void deinstall(BasicEditorPane basicEditorPane) {
        this.quit = true;
        if (this.buffer != null) {
            this.buffer.removeTextBufferListener((TextBufferListener)this);
        }
    }

    private void cleanup() {
        this.editor = null;
        this.text = null;
        this.output = null;
        this.buffer = null;
    }

    public void install(BasicEditorPane basicEditorPane) {
        this.editor = basicEditorPane;
        BasicDocument basicDocument = (BasicDocument)basicEditorPane.getDocument();
        this.buffer = basicDocument.getTextBuffer();
        this.buffer.addTextBufferListener((TextBufferListener)this);
        if (this.text == null) {
            this.extractText();
        }
        this.init();
    }

    private void init() {
        this.src = null;
        try {
            NamedSwingWorker namedSwingWorker = new NamedSwingWorker("Background Parser"){

                @Override
                public Object construct() {
                    BackgroundParser.this.quit = false;
                    while (!BackgroundParser.this.quit) {
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        if (BackgroundParser.this.src != null && System.currentTimeMillis() - BackgroundParser.this.lastUpdate < 250L || BackgroundParser.this.src != null && BackgroundParser.this.increments.size() == 0) continue;
                        BackgroundParser.this.isInsertion = BackgroundParser.this.isInsertion();
                        BackgroundParser.this.isSingleChar = BackgroundParser.this.isSingleChar();
                        if (!BackgroundParser.this.extractText()) continue;
                        try {
                            BackgroundParser.this.parse();
                        }
                        catch (Throwable throwable) {
                            throwable.printStackTrace();
                        }
                    }
                    BackgroundParser.this.cleanup();
                    return null;
                }
            };
            namedSwingWorker.start();
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse() {
        this.increments = new ArrayList();
        long l = System.currentTimeMillis();
        if (this.text == null) {
            return;
        }
        if (this.editor != null) {
            BaseDBObjectTextNode baseDBObjectTextNode = DBObjectNodeUtil.getNodeFromEditorPane((BasicEditorPane)this.editor);
            if (baseDBObjectTextNode != null) {
                try {
                    this.output = SQLDevParserHelper.getParseTreeRoot((BaseDBObjectTextNode)baseDBObjectTextNode);
                    if (this.output == null) {
                        return;
                    }
                    this.src = this.output.getSrcFragment();
                    if (this.src.size() < this.output.to) {
                        System.out.println("src.size() < output.to");
                    }
                }
                catch (CancelledException cancelledException) {}
            } else {
                if (baseDBObjectTextNode instanceof PlSqlNode) {
                    Log.error((String)"failed to get tokens and parse tree from JDev API");
                }
                List list = LexerToken.parse((String)this.text);
                this.output = StackParser.getInstance().parse(list);
                this.src = list;
            }
        } else {
            this.src = LexerToken.parse((String)this.text);
            this.output = StackParser.getInstance().parse(this.src);
        }
        long l2 = System.currentTimeMillis();
        LinkedList<ParserEventListener> linkedList = new LinkedList<ParserEventListener>();
        List<ParserEventListener> list = this.listeners;
        synchronized (list) {
            for (ParserEventListener parserEventListener : this.listeners) {
                linkedList.add(parserEventListener);
            }
        }
        for (ParserEventListener parserEventListener : linkedList) {
            try {
                if (0 < this.increments.size()) {
                    return;
                }
                parserEventListener.stateChanged(this);
            }
            catch (Throwable throwable) {
                throwable.fillInStackTrace();
            }
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addParserEventListener(ParserEventListener parserEventListener) {
        List<ParserEventListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(parserEventListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeParserEventListener(ParserEventListener parserEventListener) {
        List<ParserEventListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(parserEventListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replaceOutlineListener(OutlinePanel outlinePanel) {
        LinkedList<ParserEventListener> linkedList = new LinkedList<ParserEventListener>();
        for (ParserEventListener parserEventListener : this.listeners) {
            if (!(parserEventListener instanceof OutlinePanel)) continue;
            linkedList.add(parserEventListener);
        }
        List<ParserEventListener> list = this.listeners;
        synchronized (list) {
            this.listeners.removeAll(linkedList);
            this.listeners.add(outlinePanel);
        }
    }

    public int recalculatePosition(int n) {
        int n2 = this.recalcPos(n);
        while (n2 != n) {
            n = n2;
            n2 = this.recalcPos(n2);
        }
        return n2;
    }

    private int recalcPos(int n) {
        for (NumberRange numberRange : this.increments) {
            if (numberRange.end != n) continue;
            return numberRange.start;
        }
        return n;
    }

    private boolean isInsertion() {
        boolean bl = false;
        for (NumberRange numberRange : this.increments) {
            if (numberRange.start < numberRange.end) {
                bl = true;
                continue;
            }
            if (numberRange.start <= numberRange.end) continue;
            bl = false;
            break;
        }
        return bl;
    }

    private boolean isSingleChar() {
        if (this.increments.size() != 1) {
            return false;
        }
        for (NumberRange numberRange : this.increments) {
            if (numberRange.start + 1 == numberRange.end) continue;
            return false;
        }
        return true;
    }

    public Item parseNameTypeOwner(PlSqlNode plSqlNode) {
        String string = null;
        String string2 = null;
        String string3 = null;
        if (this.src == null) {
            if (this.text == null) {
                this.text = plSqlNode.getSource();
            }
            this.src = LexerToken.parse((String)this.text);
        }
        String string4 = null;
        for (int i = 0; i < this.src.size() && i < 10; ++i) {
            LexerToken lexerToken = this.src.get(i);
            if ("(".equalsIgnoreCase(lexerToken.content) || "RETURN".equalsIgnoreCase(lexerToken.content) || "IS".equalsIgnoreCase(lexerToken.content) || "AS".equalsIgnoreCase(lexerToken.content) || "BEFORE".equalsIgnoreCase(lexerToken.content) || "AFTER".equalsIgnoreCase(lexerToken.content)) break;
            if (string4 == null && KEYWORD_PACKAGE.equalsIgnoreCase(lexerToken.content)) {
                string4 = lexerToken.content.toUpperCase();
                continue;
            }
            if (string4 == null && KEYWORD_PROCEDURE.equalsIgnoreCase(lexerToken.content)) {
                string4 = lexerToken.content.toUpperCase();
                continue;
            }
            if (string4 == null && KEYWORD_FUNCTION.equalsIgnoreCase(lexerToken.content)) {
                string4 = lexerToken.content.toUpperCase();
                continue;
            }
            if (string4 == null && KEYWORD_TRIGGER.equalsIgnoreCase(lexerToken.content)) {
                string4 = lexerToken.content.toUpperCase();
                continue;
            }
            if (string4 == null && KEYWORD_TYPE.equalsIgnoreCase(lexerToken.content)) {
                string4 = lexerToken.content.toUpperCase();
                continue;
            }
            if (string4 != null && KEYWORD_BODY.equalsIgnoreCase(lexerToken.content)) {
                string4 = string4 + " " + lexerToken.content.toUpperCase();
                continue;
            }
            if (string4 != null && !KEYWORD_BODY.equalsIgnoreCase(lexerToken.content) && string == null) {
                string = lexerToken.content;
                if (string == null) continue;
                if (string.startsWith("\"") && string.endsWith("\"")) {
                    string = string.substring(1, string.length() - 1);
                    continue;
                }
                string = string.toUpperCase();
                continue;
            }
            if (!".".equalsIgnoreCase(lexerToken.content)) continue;
            string3 = string;
            string = null;
        }
        if (string2 == null) {
            string2 = string4;
        }
        return new Item(null, string, null, string2, string3, null, -1, -1);
    }
}

