/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.phighlight;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.font.TextAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import net.miginfocom.swing.MigLayout;
import oracle.dbtools.raptor.phighlight.StarAdvice;
import oracle.dbtools.raptor.plsql.Messages;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.SuperLabel;
import oracle.javatools.ui.UIBundle;
import oracle.javatools.ui.infotip.InfoTipHover;
import oracle.javatools.ui.infotip.InfoTipStyles;
import oracle.javatools.ui.infotip.templates.BasicTemplate;
import oracle.javatools.ui.infotip.templates.ItemTemplate;
import oracle.javatools.ui.infotip.templates.TemplateUtils;
import oracle.javatools.ui.plaf.IconicButtonUI;

public class StarTemplate
extends BasicTemplate
implements ItemTemplate {
    private static int MAX_VISIBLE_ROWS = 32;
    public static final String CONFIGURE = "Configure";
    private SuperLabel title = new SuperLabel();
    private JTextArea desc;
    private JScrollPane sp = TemplateUtils.createScrollPane();
    private JButton expandButton = new JButton();
    private static int PREFERRED_WIDTH = 400;
    private boolean expanded = false;
    private List<JComponent> expansionComponenets = new ArrayList<JComponent>();

    public StarTemplate(final StarAdvice starAdvice, final InfoTipStyles infoTipStyles, final BasicEditorPane basicEditorPane, int n, int n2) {
        super((JComponent)new JPanel((LayoutManager)new MigLayout("ins 0, gapx 2, gapy 0, hidemode 3, fill, nogrid")));
        this.title.setLabelOverride(true);
        this.content.setOpaque(false);
        this.sp.setVisible(this.expanded);
        this.expandButton.setFocusable(false);
        this.expandButton.setOpaque(false);
        this.expandButton.setContentAreaFilled(false);
        this.expandButton.setIcon(null);
        this.expandButton.setText(UIBundle.get((String)"INFO_TIP_MORE"));
        this.expandButton.setFont(this.expandButton.getFont().deriveFont(9.0f));
        this.expandButton.setBorder(null);
        this.expandButton.setVerticalAlignment(3);
        this.expandButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StarTemplate.this.expandButton.getParent().remove(StarTemplate.this.expandButton);
                StarTemplate.this.toggleExpansion();
            }
        });
        int n3 = (int)basicEditorPane.getVisibleRect().getWidth();
        this.title.setPreferredWrapWidth(Math.max(PREFERRED_WIDTH, n3));
        this.expandButton.setForeground(infoTipStyles.getMoreTextColor());
        this.desc = TemplateUtils.createDescriptionArea((InfoTipStyles)infoTipStyles);
        this.sp.setViewportView(this.desc);
        Icon icon = infoTipStyles.scaleIcon(OracleIcons.getIcon((String)"incompletestatus.png"));
        Icon icon2 = infoTipStyles.scaleIcon(OracleIcons.getIcon((String)"fix.png"));
        this.title.setForeground(infoTipStyles.getItemTextColor());
        this.title.setFont(infoTipStyles.getItemTitleFont());
        this.title.setText(Messages.getString("ExpandColumns"));
        JLabel jLabel = new JLabel();
        jLabel.setVerticalAlignment(1);
        jLabel.setIcon(icon);
        if (0 < starAdvice.replacement.length()) {
            this.content.add((Component)jLabel, "alignx left, grow 0, aligny baseline");
            this.content.add((Component)this.title, "alignx left, w 100%, growy, aligny baseline");
            this.content.add(Box.createVerticalStrut(infoTipStyles.getItemTitleInsets().bottom), "newline");
        }
        int n4 = jLabel.getIcon().getIconWidth() + 2;
        final SuperLabel superLabel = new SuperLabel(starAdvice.replacement);
        JButton jButton = new JButton();
        jButton.setToolTipText(UIBundle.get((String)"INFO_TIP_CONFIGURE"));
        jButton.setIcon(OracleIcons.getIcon((String)"refresh.png"));
        IconicButtonUI.install((AbstractButton)jButton);
        jButton.setVisible(true);
        jButton.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        jButton.setOpaque(false);
        int n5 = Math.max(superLabel.getPreferredSize().height, jButton.getPreferredSize().height);
        this.content.add((Component)jButton, "grow 0, align right, gapleft 0, height " + n5);
        jButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                starAdvice.clearCache();
                starAdvice.init();
                StarTemplate.this.fireActionPerformed("closeInfotipCommand");
            }
        });
        if (0 < starAdvice.replacement.length()) {
            superLabel.setLabelOverride(true);
            superLabel.setPreferredWrapWidth(Math.max(PREFERRED_WIDTH, n3));
            final Font font = superLabel.getFont();
            Map<TextAttribute, ?> map = font.getAttributes();
            map.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
            final Font font2 = font.deriveFont(map);
            superLabel.setBackground(null);
            superLabel.setOpaque(false);
            superLabel.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
            superLabel.setForeground(infoTipStyles.getHyperLinkTextColor(false));
            superLabel.setEnabled(true);
            JLabel jLabel2 = new JLabel(icon2);
            this.content.add((Component)superLabel, "grow, gapbottom 2, gapleft " + (n4 - 1) + ", height " + n5);
            MouseAdapter mouseAdapter = new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent mouseEvent) {
                    superLabel.setFont(font2);
                    superLabel.setForeground(infoTipStyles.getHyperLinkTextColor(true));
                }

                @Override
                public void mouseExited(MouseEvent mouseEvent) {
                    superLabel.setFont(font);
                    superLabel.setForeground(infoTipStyles.getHyperLinkTextColor(false));
                }

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    starAdvice.doFix(basicEditorPane);
                }
            };
            jLabel2.addMouseListener(mouseAdapter);
            superLabel.addMouseListener((MouseListener)mouseAdapter);
        }
    }

    private void toggleExpansion() {
        this.expanded = !this.expanded;
        for (JComponent jComponent : this.expansionComponenets) {
            jComponent.setVisible(this.expanded);
        }
        this.fireActionPerformed("sizeChangedCommand");
    }

    public void setHover(InfoTipHover infoTipHover) {
    }

    public int getPreferredWidth() {
        return this.title.getPreferredSize().width;
    }

    public void setPreferredWidth(int n) {
        this.desc.setSize(n, 99999999);
        Dimension dimension = this.desc.getPreferredSize();
        this.desc.setPreferredSize(dimension);
        int n2 = this.desc.getFontMetrics(this.desc.getFont()).getHeight();
        int n3 = Math.min(n2 * MAX_VISIBLE_ROWS, this.desc.getPreferredSize().height);
        Insets insets = this.sp.getInsets();
        this.sp.setPreferredSize(new Dimension(n, n3 + insets.top + insets.bottom));
    }
}

