/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.oviewer.recent;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.URL;
import java.util.Collection;
import java.util.EventObject;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.backgroundTask.utils.DatabaseQueryTask;
import oracle.dbtools.raptor.controls.ControlsArb;
import oracle.dbtools.raptor.controls.search.BaseSearchPanel;
import oracle.dbtools.raptor.controls.search.URLListRenderer;
import oracle.dbtools.raptor.dialogs.BasicObjectModifier;
import oracle.dbtools.raptor.format.ui.ExportContextMenuListener;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.oviewer.recent.RecentObjectsAddin;
import oracle.dbtools.raptor.oviewer.recent.Tracker;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.Context;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.help.HelpSystem;
import oracle.ide.model.Observer;
import oracle.ide.model.UpdateMessage;
import oracle.javatools.util.Pair;

class RecentObjectsPanel
extends BaseSearchPanel {
    private static final long serialVersionUID = 1L;
    private DefaultListModel _model;
    private JList _list;
    protected MouseListener onClick = new MouseAdapter(){

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() == 2) {
                return;
            }
            JList jList = (JList)mouseEvent.getSource();
            int n = jList.locationToIndex(mouseEvent.getPoint());
            jList.setSelectedIndex(n);
            if (mouseEvent.getButton() == 3 || mouseEvent.getButton() == 2) {
                Context context = Context.newIdeContext();
                context.setEvent((EventObject)mouseEvent);
                RecentObjectsPanel.this.updateContext(context);
                if (context.getNode() == null) {
                    return;
                }
                ContextMenu contextMenu = new ContextMenu();
                contextMenu.addContextMenuListener((ContextMenuListener)new BasicObjectModifier());
                contextMenu.addContextMenuListener((ContextMenuListener)ExportContextMenuListener.getInstance());
                contextMenu.show(context);
                return;
            }
            if (mouseEvent.getButton() == 1) {
                final URL uRL = RecentObjectsPanel.this.getSelectedURL();
                if (uRL == null) {
                    return;
                }
                DatabaseQueryTask<Void> databaseQueryTask = new DatabaseQueryTask<Void>(ControlsArb.getString("URLListRenderer.0") + DBURLFormatHelper.getName(uRL), IRaptorTaskRunMode.TASKVIEWER, false, false){

                    protected Void doWork() throws TaskException {
                        Runnable runnable = new Runnable(){

                            @Override
                            public void run() {
                                BaseSearchPanel.goTo(uRL);
                            }
                        };
                        SwingUtilities.invokeLater(runnable);
                        return null;
                    }

                    @Override
                    public String getQuery() {
                        return "";
                    }

                    @Override
                    public String getConnectionName() {
                        return DBURLFormatHelper.getConnectionName(uRL);
                    }
                };
                RaptorTaskManager.getInstance().addTask((RaptorTask)databaseQueryTask);
            }
        }
    };

    public RecentObjectsPanel() {
        super(new GridBagLayout());
        this.init();
    }

    @Override
    public URL getSelectedURL() {
        if (this._list.getSelectedIndex() > -1) {
            return (URL)((DefaultListModel)this._list.getModel()).getElementAt(this._list.getSelectedIndex());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        this._model = new DefaultListModel();
        this._list = new JList(this._model);
        this._list.setCellRenderer(new URLListRenderer());
        this.attachOnClick(this._list);
        this.add((Component)new JScrollPane(this._list), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(1, 1, 0, 0), 0, 0));
        HelpSystem.getHelpSystem().registerTopic((JComponent)this, "f1_finddbrecent_html");
        Tracker tracker = RecentObjectsAddin.getTracker();
        Collection<URL> collection = null;
        Tracker tracker2 = tracker;
        synchronized (tracker2) {
            collection = tracker.getRecentURLs();
            tracker.attach(new Observer(){

                public void update(Object object, UpdateMessage updateMessage) {
                    int n = updateMessage.getMessageID();
                    if (n == Tracker.URL_ADDED_MESSAGE) {
                        RecentObjectsPanel.this.addURLs(updateMessage.getAddObjects());
                    } else if (n == Tracker.URL_REMOVED_MESSAGE) {
                        RecentObjectsPanel.this.removeURLs(updateMessage.getRemoveObjects());
                    } else if (n == Tracker.URL_CHANGED_MESSAGE) {
                        RecentObjectsPanel.this.updateURLs(updateMessage.getModifyObjects());
                    }
                }
            });
        }
        this.addURLs(collection);
    }

    private void addURLs(Collection<URL> collection) {
        for (URL uRL : collection) {
            if (!DBURLFormatHelper.isDBURL(uRL) || DBURLFormatHelper.getName(uRL) == null) continue;
            String string = DBURLFormatHelper.getConnectionName(uRL);
            if (!Connections.getInstance().isOracle(string)) continue;
            URL uRL2 = null;
            boolean bl = true;
            for (int i = 0; i < this._model.getSize(); ++i) {
                uRL2 = (URL)this._model.get(i);
                if (!uRL2.equals(uRL)) continue;
                bl = false;
            }
            if (!bl) continue;
            this._model.add(0, uRL);
            this._list.setSelectedIndex(0);
        }
    }

    private void removeURLs(Collection<URL> collection) {
        for (URL uRL : collection) {
            this._model.removeElement(uRL);
            URLListRenderer.removeIcon(uRL);
        }
    }

    private void updateURLs(Collection<Pair<URL, URL>> collection) {
        for (Pair<URL, URL> pair : collection) {
            int n = this._model.indexOf(pair.first);
            if (n == -1) continue;
            this._model.remove(n);
            this._model.add(n, pair.second);
        }
    }

    protected void attachOnClick(JList jList) {
        jList.addMouseListener(this.onClick);
    }
}

