/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.oviewer.base;

import java.awt.Component;
import java.awt.EventQueue;
import java.io.IOException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import oracle.dbtools.raptor.navigator.IViewerNode;
import oracle.dbtools.raptor.oviewer.Messages;
import oracle.dbtools.raptor.oviewer.base.net.ViewerURLFileSystemHelper;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controls.WaitCursor;
import oracle.ide.editor.EditorManager;
import oracle.ide.editor.OpenEditorOptions;
import oracle.ide.model.Element;
import oracle.ide.model.ElementAttributes;
import oracle.ide.model.Node;
import oracle.ide.model.Observer;
import oracle.ide.model.Subject;
import oracle.ide.model.TextNode;
import oracle.ide.model.UpdateMessage;
import oracle.ide.resource.IdeArb;
import oracle.javatools.db.Database;
import oracle.javatools.dialogs.MessageDialog;

public class ViewerNode
extends Node
implements IViewerNode,
Observer {
    public static final int RELATION_NODE_CHANGED_MESSAGE_ID = UpdateMessage.newMessageID((String)(ViewerNode.class.getName() + ".relationNodeChanged"));
    public static final int RELATION_NODE_MODIFIED_MESSAGE_ID = UpdateMessage.newMessageID((String)(ViewerNode.class.getName() + ".relationNodeModified"));
    private static ViewerNode INSTANCE;
    private static ViewerNode TEST_INSTANCE;
    private static int _nodeId;
    private boolean _pinned = true;
    private DBObject _dbObject;
    private Database _database;
    private List<DirtyComponent> _dirtyComponents = new ArrayList<DirtyComponent>();
    private static List<ViewerNode> _instances;
    private String m_id = "ViewerNode" + _nodeId++;
    private String _altName;
    private static final String ALT_NAME_FORMAT = "{0}@{1}";

    static List<ViewerNode> listInstances() {
        return Collections.unmodifiableList(_instances);
    }

    public static ViewerNode getTestInstance() {
        if (TEST_INSTANCE == null) {
            TEST_INSTANCE = new ViewerNode();
        }
        return TEST_INSTANCE;
    }

    public static ViewerNode createInstance() {
        INSTANCE = new ViewerNode();
        _instances.add(INSTANCE);
        return INSTANCE;
    }

    static synchronized ViewerNode getInstanceNoCreate() {
        return INSTANCE;
    }

    public static synchronized ViewerNode getInstance() {
        if (INSTANCE == null) {
            INSTANCE = ViewerNode.createInstance();
        }
        return INSTANCE;
    }

    public static ViewerNode getUnpinnedInstance() {
        if (!ViewerNode.getInstance().getPinned() && ViewerNode.getInstance().isOpen()) {
            return ViewerNode.getInstance();
        }
        for (int i = 0; i < _instances.size(); ++i) {
            ViewerNode viewerNode = _instances.get(i);
            if (viewerNode.getPinned()) continue;
            INSTANCE = viewerNode;
            return viewerNode;
        }
        return ViewerNode.createInstance();
    }

    public ViewerNode() {
        URL uRL = ViewerURLFileSystemHelper.wrapURL(this.m_id, null);
        this.setURL(uRL);
        this.setPinned(false);
        this.getAttributes().set(ElementAttributes.SAVEABLE | ElementAttributes.CLOSEABLE);
    }

    public String getShortLabel() {
        return this.getShortLabel(true);
    }

    public String getShortLabel(boolean bl) {
        if (bl && this._altName != null) {
            return this._altName;
        }
        String string = "";
        if (this._database != null) {
            String string2;
            Element element = this._dbObject.getElement();
            string = string2 = element.getShortLabel();
        } else if (this._dbObject != null && this._dbObject.getNode() != null) {
            string = this._dbObject.getNode().getShortLabel();
        }
        return string;
    }

    public Icon getIcon() {
        return this._dbObject.getElement().getIcon();
    }

    public String getLongLabel() {
        return this._dbObject != null ? this._dbObject.getElement().getLongLabel() : Messages.getString("ViewerNode.7");
    }

    public void setPinned(boolean bl) {
        if (this._pinned != bl) {
            this._pinned = bl;
        }
    }

    public boolean getPinned() {
        return this._pinned;
    }

    public void setViewedObject(DBObject dBObject) {
        if (this.checkCanChange()) {
            if (this._dbObject != null && this._dbObject.getElement() instanceof Subject) {
                ((Subject)this._dbObject.getElement()).detach((Observer)this);
            }
            this._database = dBObject.getDatabase();
            this._dbObject = dBObject;
            this._altName = null;
            if (this._dbObject.getElement() instanceof Subject) {
                ((Subject)this._dbObject.getElement()).attach((Observer)this);
            }
            if (this != ViewerNode.getTestInstance()) {
                String string = this.getShortLabel();
                for (int i = 0; i < _instances.size(); ++i) {
                    ViewerNode viewerNode = _instances.get(i);
                    if (viewerNode == this || !string.equals(viewerNode.getShortLabel(false))) continue;
                    String string2 = Connections.getConnectionName(viewerNode.getDBObject().getConnectionName());
                    viewerNode._altName = MessageFormat.format(ALT_NAME_FORMAT, string, string2);
                    viewerNode.notifyObservers(viewerNode, new UpdateMessage(UpdateMessage.OBJECT_RENAMED, (Object)viewerNode));
                    string2 = Connections.getConnectionName(this._dbObject.getConnectionName());
                    this._altName = MessageFormat.format(ALT_NAME_FORMAT, string, string2);
                }
            }
            this.setURL(ViewerURLFileSystemHelper.wrapURL(this.m_id, this._dbObject.getURL()));
            this.notifyObservers(this, new UpdateMessage(RELATION_NODE_CHANGED_MESSAGE_ID, (Object)this));
            this.notifyObservers(this, new UpdateMessage(UpdateMessage.OBJECT_RENAMED, (Object)this));
            this.setOpen(this._dbObject.getElement() != null);
        }
    }

    protected void closeImpl() throws IOException {
        _instances.remove(this);
        this.markDirty(false);
    }

    private boolean checkCanChange() {
        boolean bl = true;
        if (this.isDirty()) {
            try {
                String string = MessageFormat.format(IdeArb.getString((int)216), this.getLongLabel());
                int n = MessageDialog.confirmOrCancel((Component)Ide.getMainWindow(), (Object)string, (String)this.getLongLabel(), null);
                switch (n) {
                    case 1: {
                        this.save();
                        break;
                    }
                    case 0: {
                        this.revert();
                        break;
                    }
                    default: {
                        bl = false;
                        break;
                    }
                }
            }
            catch (IOException iOException) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
                bl = false;
            }
        }
        return bl;
    }

    @Override
    public Node getBaseNode() {
        return this._dbObject != null ? this._dbObject.getNode() : null;
    }

    public Database getDatabase() {
        return this._database;
    }

    @Override
    public DBObject getDBObject() {
        return this._dbObject;
    }

    public void addDirtyComponent(DirtyComponent dirtyComponent) {
        if (!this._dirtyComponents.contains(dirtyComponent)) {
            this._dirtyComponents.add(dirtyComponent);
            this.markDirty(true);
        }
    }

    public void removeDirtyComponent(DirtyComponent dirtyComponent) {
        if (this._dirtyComponents.remove(dirtyComponent) && this._dirtyComponents.isEmpty()) {
            this.markDirty(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(Object object, UpdateMessage updateMessage) {
        int n = updateMessage.getMessageID();
        if (n == UpdateMessage.OBJECT_RENAMED) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        ViewerNode.this.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            });
        }
        if (n == UpdateMessage.CONTENT_MODIFIED || n == UpdateMessage.STRUCTURE_CHANGED) {
            this.notifyObservers(object, new UpdateMessage(RELATION_NODE_MODIFIED_MESSAGE_ID, (Object)this));
        } else if (n == UpdateMessage.OBJECT_RELOADED && object == this.getBaseNode() && this.getBaseNode() instanceof TextNode) {
            Context context = Context.newIdeContext((Element)this.getBaseNode());
            OpenEditorOptions openEditorOptions = new OpenEditorOptions(context);
            openEditorOptions.setFlags(1);
            WaitCursor waitCursor = Ide.getWaitCursor();
            context.setProject(Ide.getDefaultProject());
            try {
                waitCursor.show();
                EditorManager.getEditorManager().openEditor(openEditorOptions);
            }
            finally {
                waitCursor.hide();
            }
        }
    }

    protected void openImpl() throws IOException {
        INSTANCE = this;
    }

    protected void revertImpl() throws IOException {
        this._dirtyComponents.clear();
    }

    protected void saveImpl() throws IOException {
        DirtyComponent[] dirtyComponentArray;
        for (DirtyComponent dirtyComponent : dirtyComponentArray = this._dirtyComponents.toArray(new DirtyComponent[0])) {
            dirtyComponent.save(this);
        }
        this._dirtyComponents.clear();
    }

    static {
        _nodeId = 0;
        _instances = new ArrayList<ViewerNode>(1);
    }

    public static interface DirtyComponent {
        public void save(ViewerNode var1) throws IOException;
    }
}

