/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.onsd.iterator;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.raptor.onsd.iterator.AbstractOnsdIterator;
import oracle.kv.table.FieldDef;
import oracle.kv.table.FieldValue;
import oracle.kv.table.Table;

public class OnsdTableColumnIterator
extends AbstractOnsdIterator<Object> {
    protected Table table;
    protected List<List<Object>> properties;
    protected Iterator<List<Object>> propertyIter;

    public OnsdTableColumnIterator(Table table) {
        this.table = table;
        this.properties = null;
        this.propertyIter = null;
    }

    public Class<?> getFieldClass(int n) {
        switch (n) {
            case 0: {
                return String.class;
            }
            case 1: {
                return FieldDef.Type.class;
            }
            case 2: {
                return Boolean.class;
            }
            case 3: {
                return String.class;
            }
            case 4: {
                return Integer.class;
            }
            case 5: {
                return String.class;
            }
        }
        return Object.class;
    }

    public int getFieldCount() {
        return 6;
    }

    public Object getFieldMetadata(int n) {
        return null;
    }

    public String getFieldName(int n) {
        switch (n) {
            case 0: {
                return OnsdTableColumnIterator.getFieldLabel("COLUMN_NAME_LABLE");
            }
            case 1: {
                return OnsdTableColumnIterator.getFieldLabel("DATA_TYPE_LABEL");
            }
            case 2: {
                return OnsdTableColumnIterator.getFieldLabel("NULLABLE_LABEL");
            }
            case 3: {
                return OnsdTableColumnIterator.getFieldLabel("DEFAULT_VALUE_LABEL");
            }
            case 4: {
                return OnsdTableColumnIterator.getFieldLabel("COLUMN_ID_LABEL");
            }
            case 5: {
                return OnsdTableColumnIterator.getFieldLabel("COMMENT_LABEL");
            }
        }
        return null;
    }

    public boolean hasNext() {
        if (this.propertyIter == null) {
            this.propertyIter = this.getPropertyIterator();
        }
        if (this.propertyIter != null) {
            return this.propertyIter.hasNext();
        }
        return false;
    }

    public Iterable<Object> next() {
        return this.propertyIter.next();
    }

    private Iterator<List<Object>> getPropertyIterator() {
        try {
            this.properties = new ArrayList<List<Object>>();
            List list = this.table.getFields();
            int n = 1;
            for (String string : list) {
                FieldDef fieldDef = this.table.getField(string);
                ArrayList<Object> arrayList = new ArrayList<Object>();
                arrayList.add(string);
                arrayList.add(fieldDef.getType());
                arrayList.add(this.table.isNullable(string));
                FieldValue fieldValue = this.table.getDefaultValue(string);
                arrayList.add(fieldValue != null && !fieldValue.isNull() ? fieldValue : null);
                arrayList.add(n);
                String string2 = fieldDef.getDescription();
                arrayList.add(string2);
                this.properties.add(arrayList);
                ++n;
            }
            return this.properties.iterator();
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public void close() throws IOException {
        this.propertyIter = null;
    }
}

