/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator.folders.dnd;

import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.net.URL;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import oracle.dbtools.raptor.controls.RaptorDnD;
import oracle.dbtools.raptor.navigator.Databases;
import oracle.dbtools.raptor.navigator.ObjectFactory;
import oracle.dbtools.raptor.navigator.db.DatabaseConnection;
import oracle.dbtools.raptor.navigator.db.model.DBObjectInstance;
import oracle.dbtools.raptor.navigator.folders.dnd.ConnectionDragHelper;
import oracle.dbtools.raptor.navigator.impl.DatabaseNode;
import oracle.dbtools.raptor.navigator.impl.ObjectFolder;
import oracle.dbtools.raptor.navigator.impl.ObjectNode;
import oracle.dbtools.raptor.navigator.model.NavigatorTreeNode;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.navigator.plsql.PlSqlNode;
import oracle.dbtools.raptor.schemacopy.CopyAPI;
import oracle.dbtools.raptor.schemacopy.IAutoRefresh;
import oracle.dbtools.raptor.standalone.ExtrasArb;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.NLSUtils;
import oracle.dbtools.util.Logger;
import oracle.ide.Ide;
import oracle.ide.model.Element;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.ide.util.dnd.DropHelper;
import oracle.ide.util.dnd.TransferableTreeNode;
import oracle.ide.util.dnd.TransferablesList;
import oracle.ideimpl.explorer.dnd.MultiTransferable;
import oracle.javatools.dialogs.MessageDialog;

public class OracleConnectionDropHelper
implements DropHelper,
IAutoRefresh {
    private NavigatorTreeNode _refreshParent = null;
    private Element[] _selNodes = null;
    public static final DataFlavor CONN_NODE_FLAVOR = new DataFlavor("application/x-java-jvm-local-objectref; class=" + ConnectionDragHelper.class.getName(), "Connection Node");

    public boolean canTransferData(Object object, DataFlavor[] dataFlavorArray, int n) {
        DatabaseConnection databaseConnection = null;
        Element element = null;
        element = ((NavigatorTreeNode)object).getElement();
        if (element instanceof DatabaseConnection) {
            databaseConnection = (DatabaseConnection)element;
        }
        try {
            if (n == 1 && (Arrays.asList(dataFlavorArray).contains(ConnectionDragHelper.CONN_NODE_FLAVOR) ? databaseConnection != null && Connections.getInstance().isConnectionOpen(databaseConnection.getQualifiedConnectionName()) && Connections.getInstance().isOracle((Connection)databaseConnection.getConnection()) : databaseConnection != null && Connections.getInstance().isConnectionOpen(databaseConnection.getQualifiedConnectionName()) && Connections.getInstance().isOracle((Connection)databaseConnection.getConnection()) && (Arrays.asList(dataFlavorArray).contains(TransferablesList.TRANSFERABLE_LIST_FLAVOR) || Arrays.asList(dataFlavorArray).contains(TransferableTreeNode.TREE_NODE_FLAVOR)))) {
                return true;
            }
        }
        catch (Exception exception) {
            Logger.warn(OracleConnectionDropHelper.class, (Throwable)exception);
        }
        return false;
    }

    private boolean isDistinctSourceAndTarget(DatabaseConnection databaseConnection, DatabaseConnection databaseConnection2) throws Exception {
        return true;
    }

    public boolean transferData(Object object, Transferable[] transferableArray, int n) {
        DatabaseConnection databaseConnection = (DatabaseConnection)((NavigatorTreeNode)object).getElement();
        DatabaseConnection databaseConnection2 = this.getSourceConnection(transferableArray);
        try {
            String string = NLSUtils.getDBCharset((Connection)((Connection)databaseConnection2.getConnection()));
            String string2 = NLSUtils.getDBCharset((Connection)((Connection)databaseConnection.getConnection()));
            if (!string.equals(string2)) {
                MessageDialog.information((Component)Ide.getMainWindow(), (Object)ExtrasArb.getString("DNDCharSet"), (String)ExtrasArb.getString("DNDTitle"), null);
                return false;
            }
            if (databaseConnection != null && Connections.getInstance().isOracle((Connection)databaseConnection.getConnection()) && databaseConnection2 != null && Connections.getInstance().isOracle((Connection)databaseConnection2.getConnection()) && this.isAcceptableNodeType(transferableArray) && this.isDistinctSourceAndTarget(databaseConnection2, databaseConnection)) {
                ArrayList<DatabaseNode> arrayList = null;
                arrayList = this.getSourceObjectNodes(transferableArray);
                if (arrayList != null && arrayList.size() > 0) {
                    CopyAPI copyAPI = new CopyAPI((Connection)databaseConnection2.getConnection(), (Connection)databaseConnection.getConnection(), "DROP");
                    copyAPI.initObjectFilters(arrayList, true);
                    copyAPI.copyWithDialog(this);
                    this._refreshParent = this.getParentFolder(object, transferableArray);
                    this.buildSelectedElements(object, transferableArray);
                    return true;
                }
            }
        }
        catch (Exception exception) {
            Logger.warn(OracleConnectionDropHelper.class, (Throwable)exception);
        }
        return false;
    }

    private void buildSelectedElements(Object object, Transferable[] transferableArray) {
        NavigatorTreeNode navigatorTreeNode = null;
        Element element = null;
        ObjectNode objectNode = null;
        ObjectNode objectNode2 = null;
        PlSqlNode plSqlNode = null;
        PlSqlNode plSqlNode2 = null;
        Object object2 = null;
        DBObjectInstance dBObjectInstance = null;
        ObjectFactory objectFactory = null;
        String string = null;
        URL uRL = null;
        int n = 0;
        DatabaseConnection databaseConnection = (DatabaseConnection)((NavigatorTreeNode)object).getElement();
        try {
            List<Object> list = RaptorDnD.getTransferableNodes(transferableArray);
            this._selNodes = new Element[list.size()];
            if (list.size() > 0) {
                for (Object object3 : list) {
                    if (object3 instanceof MultiTransferable) {
                        navigatorTreeNode = (NavigatorTreeNode)((MultiTransferable)object3).getTransferData(TransferableTreeNode.TREE_NODE_FLAVOR);
                    } else if (object3 instanceof DefaultMutableTreeNode) {
                        navigatorTreeNode = (NavigatorTreeNode)object3;
                    }
                    if ((element = navigatorTreeNode.getElement()) == null || (object2 = element.getData()) == null) continue;
                    if (object2 instanceof ObjectNode) {
                        objectNode = (ObjectNode)object2;
                        string = objectNode.getObjectType();
                    } else if (object2 instanceof PlSqlNode) {
                        plSqlNode = (PlSqlNode)object2;
                        string = plSqlNode.getObjectType();
                    }
                    if ((objectFactory = ObjectFactory.getFactory(databaseConnection.getConnectionName(), (Connection)databaseConnection.getConnection())) == null || string == null) continue;
                    if (objectNode != null) {
                        dBObjectInstance = objectFactory.createNodeInstance(string);
                        uRL = DBURLFormatHelper.getURL("sqldev.nav", Connections.getInstance().getConnectionName((Connection)databaseConnection.getConnection()), ((Connection)databaseConnection.getConnection()).getCatalog(), ((Connection)databaseConnection.getConnection()).getMetaData().getUserName(), string);
                        uRL = DBURLFormatHelper.getURL(uRL, objectNode.getObjectName());
                        objectNode2 = (ObjectNode)NodeFactory.findOrCreate(ObjectNode.class, (URL)uRL);
                        dBObjectInstance.setProperty("NAME", objectNode2.getProperty("INTERNAL_NAME"));
                        dBObjectInstance.setProperty("SCHEMA", objectNode2.getProperty("SCHEMA"));
                        dBObjectInstance.setProperty("TYPE", objectNode2.getProperty("TYPE"));
                        dBObjectInstance.setProperty("ConnectionName", objectNode2.getProperty("ConnectionName"));
                        dBObjectInstance.setProperty("DBObject", objectNode2.getProperty("DBObject"));
                        dBObjectInstance.setProperty("DBObjectProvider", objectNode2.getProperty("DBObjectProvider"));
                        objectNode2.setNodeInstance(dBObjectInstance);
                        this._selNodes[n++] = objectNode2;
                        continue;
                    }
                    if (plSqlNode == null) continue;
                    dBObjectInstance = objectFactory.createNodeInstance(string);
                    uRL = DBURLFormatHelper.getURL("sqldev.nav", Connections.getInstance().getConnectionName((Connection)databaseConnection.getConnection()), ((Connection)databaseConnection.getConnection()).getCatalog(), ((Connection)databaseConnection.getConnection()).getMetaData().getUserName(), string);
                    uRL = DBURLFormatHelper.getURL(uRL, plSqlNode.getObjectName());
                    plSqlNode2 = (PlSqlNode)NodeFactory.findOrCreate(PlSqlNode.class, (URL)uRL);
                    dBObjectInstance.setProperty("NAME", plSqlNode2.getProperty("INTERNAL_NAME"));
                    dBObjectInstance.setProperty("SCHEMA", plSqlNode2.getProperty("SCHEMA"));
                    dBObjectInstance.setProperty("TYPE", plSqlNode2.getProperty("TYPE"));
                    dBObjectInstance.setProperty("ConnectionName", plSqlNode2.getProperty("ConnectionName"));
                    dBObjectInstance.setProperty("DBObject", plSqlNode2.getProperty("DBObject"));
                    dBObjectInstance.setProperty("DBObjectProvider", plSqlNode2.getProperty("DBObjectProvider"));
                    plSqlNode2.setNodeInstance(dBObjectInstance);
                    this._selNodes[n++] = plSqlNode2;
                }
            }
        }
        catch (Exception exception) {
            Logger.warn(OracleConnectionDropHelper.class, (Throwable)exception);
        }
    }

    @Override
    public synchronized void refresh() {
        Element element;
        Element element2 = element = this._refreshParent != null ? this._refreshParent.getElement() : null;
        if (element instanceof ObjectFolder && this._selNodes != null && this._selNodes.length > 0) {
            for (int i = 0; i < this._selNodes.length; ++i) {
                UpdateMessage.fireStructureChanged((Subject)((ObjectFolder)element), Collections.singletonList(this._selNodes[i]));
            }
        } else {
            Logger.warn(OracleConnectionDropHelper.class, (String)("Internal Error: Unexpect Folder type" + element != null ? element.toString() : "(null)"));
        }
    }

    private NavigatorTreeNode getParentFolder(Object object, Transferable[] transferableArray) {
        NavigatorTreeNode navigatorTreeNode;
        block6: {
            navigatorTreeNode = null;
            String string = null;
            Object object2 = null;
            try {
                Iterator<Object> iterator;
                List<Object> list = RaptorDnD.getTransferableNodes(transferableArray);
                if (list.size() <= 0 || !(iterator = list.iterator()).hasNext()) break block6;
                Object object3 = iterator.next();
                object2 = ((DefaultMutableTreeNode)object3).getUserObject();
                if (object2 instanceof ObjectNode) {
                    string = ((ObjectNode)object2).getObjectType();
                } else if (object2 instanceof PlSqlNode) {
                    string = ((PlSqlNode)object2).getObjectType();
                }
                Enumeration enumeration = ((NavigatorTreeNode)object).children();
                while (enumeration != null && enumeration.hasMoreElements()) {
                    NavigatorTreeNode navigatorTreeNode2 = (NavigatorTreeNode)enumeration.nextElement();
                    Object object4 = navigatorTreeNode2.getElement().getData();
                    if (!(object4 instanceof ObjectFolder) || !((ObjectFolder)object4).getObjectType().equals(string)) continue;
                    navigatorTreeNode = navigatorTreeNode2;
                    break;
                }
            }
            catch (Exception exception) {
                Logger.warn(OracleConnectionDropHelper.class, (Throwable)exception);
            }
        }
        return navigatorTreeNode instanceof NavigatorTreeNode ? (NavigatorTreeNode)navigatorTreeNode : null;
    }

    private boolean isAcceptableNodeType(Transferable[] transferableArray) {
        boolean bl = false;
        DefaultMutableTreeNode defaultMutableTreeNode = null;
        Object object = null;
        String string = null;
        try {
            Iterator<Object> iterator;
            List<Object> list = RaptorDnD.getTransferableNodes(transferableArray);
            if (list.size() > 0 && (iterator = list.iterator()).hasNext()) {
                Object object2 = iterator.next();
                if (object2 instanceof MultiTransferable) {
                    defaultMutableTreeNode = (DefaultMutableTreeNode)((MultiTransferable)object2).getTransferData(TransferableTreeNode.TREE_NODE_FLAVOR);
                } else if (object2 instanceof DefaultMutableTreeNode) {
                    defaultMutableTreeNode = (DefaultMutableTreeNode)object2;
                }
                if (defaultMutableTreeNode != null) {
                    object = defaultMutableTreeNode.getUserObject();
                    if (object instanceof DatabaseConnection) {
                        bl = true;
                    } else if (object instanceof DatabaseNode && ("TABLE".equals(string = ((DatabaseNode)object).getObjectType()) || "VIEW".equals(string) || "SEQUENCE".equals(string) || "SYNONYM".equals(string) || "PROCEDURE".equals(string) || "FUNCTION".equals(string) || "PACKAGE".equals(string) || "TRIGGER".equals(string) || "TYPE".equals(string))) {
                        bl = true;
                    }
                }
            }
        }
        catch (Exception exception) {
            Logger.warn(OracleConnectionDropHelper.class, (Throwable)exception);
        }
        return bl;
    }

    private ArrayList<DatabaseNode> getSourceObjectNodes(Transferable[] transferableArray) {
        ArrayList<ObjectNode> arrayList = null;
        DefaultMutableTreeNode defaultMutableTreeNode = null;
        DatabaseNode databaseNode = null;
        try {
            List<Object> list = RaptorDnD.getTransferableNodes(transferableArray);
            if (list.size() > 0) {
                for (Object object : list) {
                    if (object instanceof MultiTransferable) {
                        defaultMutableTreeNode = (DefaultMutableTreeNode)((MultiTransferable)object).getTransferData(TransferableTreeNode.TREE_NODE_FLAVOR);
                    } else if (object instanceof DefaultMutableTreeNode) {
                        defaultMutableTreeNode = (DefaultMutableTreeNode)object;
                    }
                    if (defaultMutableTreeNode.getUserObject() instanceof ObjectNode) {
                        databaseNode = (ObjectNode)defaultMutableTreeNode.getUserObject();
                    } else if (defaultMutableTreeNode.getUserObject() instanceof PlSqlNode) {
                        databaseNode = (PlSqlNode)defaultMutableTreeNode.getUserObject();
                    }
                    if (databaseNode != null && arrayList == null) {
                        arrayList = new ArrayList<ObjectNode>();
                    }
                    if (databaseNode == null) continue;
                    arrayList.add((ObjectNode)databaseNode);
                }
            }
        }
        catch (Exception exception) {
            Logger.warn(OracleConnectionDropHelper.class, (Throwable)exception);
        }
        return arrayList;
    }

    private DatabaseConnection getSourceConnection(Transferable[] transferableArray) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        DefaultMutableTreeNode defaultMutableTreeNode = null;
        ObjectNode objectNode = null;
        PlSqlNode plSqlNode = null;
        String string = null;
        try {
            for (Transferable transferable : transferableArray) {
                if (transferable.isDataFlavorSupported(CONN_NODE_FLAVOR)) {
                    DatabaseConnection databaseConnection = (DatabaseConnection)transferable.getTransferData(ConnectionDragHelper.CONN_NODE_FLAVOR);
                    if (databaseConnection == null || !Connections.getInstance().isOracle((Connection)databaseConnection.getConnection())) continue;
                    return databaseConnection;
                }
                if (transferable.isDataFlavorSupported(TransferablesList.TRANSFERABLE_LIST_FLAVOR)) {
                    arrayList.addAll((Collection<Object>)((TransferablesList)transferable.getTransferData(TransferablesList.TRANSFERABLE_LIST_FLAVOR)));
                    continue;
                }
                if (!transferable.isDataFlavorSupported(TransferableTreeNode.TREE_NODE_FLAVOR)) continue;
                arrayList.add(transferable.getTransferData(TransferableTreeNode.TREE_NODE_FLAVOR));
            }
            if (arrayList.size() > 0) {
                for (Object e : arrayList) {
                    if (e instanceof MultiTransferable) {
                        defaultMutableTreeNode = (DefaultMutableTreeNode)((MultiTransferable)e).getTransferData(TransferableTreeNode.TREE_NODE_FLAVOR);
                    } else if (e instanceof DefaultMutableTreeNode) {
                        defaultMutableTreeNode = (DefaultMutableTreeNode)e;
                    }
                    if (defaultMutableTreeNode.getUserObject() instanceof ObjectNode) {
                        objectNode = (ObjectNode)defaultMutableTreeNode.getUserObject();
                        string = objectNode.getConnectionName();
                    } else if (defaultMutableTreeNode.getUserObject() instanceof PlSqlNode) {
                        plSqlNode = (PlSqlNode)defaultMutableTreeNode.getUserObject();
                        string = plSqlNode.getConnectionName();
                    }
                    if (string == null) continue;
                    return Databases.getConnectionNode(string, true);
                }
            }
        }
        catch (Exception exception) {
            Logger.warn(OracleConnectionDropHelper.class, (Throwable)exception);
        }
        return null;
    }

    public float getWeight() {
        return 10.0f;
    }
}

