/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator.filter;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import oracle.dbtools.raptor.controls.TemporalController;
import oracle.dbtools.raptor.datatypes.objects.OraDATE;
import oracle.dbtools.raptor.datatypes.objects.OraTemporalDatum;
import oracle.dbtools.raptor.navigator.DatabaseNavigatorResources;
import oracle.dbtools.raptor.navigator.db.xml.Predicate;
import oracle.dbtools.raptor.nls.OraDATEFormat;
import oracle.dbtools.raptor.ui.controls.DateTimeEditor;
import oracle.ide.util.ResourceUtils;

public class FilterDateEditPanel
extends JPanel {
    protected DateTimeEditor dateEditor = null;
    protected TemporalController controller = null;
    protected OraDATE datum = null;
    protected JButton setTodayButton = new JButton();
    protected JButton setNullButton = new JButton();
    protected JButton setSysdateButton = new JButton();
    protected JPanel buttonPanel = new JPanel(new GridBagLayout());
    public static final String FORMAT_PATTERN = "YYYY-MM-DD";

    public FilterDateEditPanel(Date date) {
        if (date == null || date.toString().equals("")) {
            date = new Date(new Date().getTime());
        }
        this.initUI(date);
    }

    public void initUI(Date date) {
        this.datum = OraDATE.getInstance((Date)date);
        this.datum.setPrecision(OraTemporalDatum.Precision.DATE);
        this.controller = new TemporalController((OraTemporalDatum)this.datum, true, null);
        this.dateEditor = this.controller.getDateTimeEditor();
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        this.add((Component)((Object)this.dateEditor), gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)this.getButtonPanel(), gridBagConstraints);
    }

    public JComponent getDefaultComponent() {
        return this.dateEditor;
    }

    protected JPanel getButtonPanel() {
        this.buttonPanel.add((Component)this.getSetTodayButton(), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 0, 0, 5), 0, 0));
        return this.buttonPanel;
    }

    protected JButton getSetTodayButton() {
        ResourceUtils.resButton((AbstractButton)this.setTodayButton, (String)DatabaseNavigatorResources.getString("FILTER_DATE_TODAY"));
        this.setTodayButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FilterDateEditPanel.this.datum.setNow();
            }
        });
        this.setTodayButton.setEnabled(true);
        return this.setTodayButton;
    }

    public Date getDate() {
        return this.datum.getTime();
    }

    public String getHelpTopicId() {
        return "f1_filterPanel_date_html";
    }

    public String getValue() {
        try {
            OraDATEFormat oraDATEFormat = Predicate.getGenericDateFormat();
            return oraDATEFormat.format(this.datum.getDatum());
        }
        catch (Exception exception) {
            return null;
        }
    }
}

