/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator.db.xml;

import java.sql.Connection;
import javax.swing.Icon;
import oracle.dbtools.raptor.images.RaptorImagesArb;
import oracle.dbtools.raptor.navigator.db.model.DBItemInstance;
import oracle.dbtools.raptor.navigator.db.xml.ConnectionTypeDetails;
import oracle.dbtools.raptor.nls.DefaultNLSProvider;
import oracle.dbtools.raptor.nls.OracleNLSProvider;

public class OracleConnectionTypeDetails
extends ConnectionTypeDetails {
    @Override
    public boolean isOracle() {
        return true;
    }

    @Override
    public float getWeight() {
        return 1.0f;
    }

    @Override
    public Integer getPreferredFetchSize() {
        return 500;
    }

    @Override
    public String getConnectionPanel() {
        return "oracle.dbtools.raptor.connections.OracleConnectionPanel";
    }

    @Override
    public String getConnectionPanelLabel() {
        return "Oracle";
    }

    @Override
    public boolean isSupportsAutocommit() {
        return true;
    }

    @Override
    public boolean isRowIdSupported() {
        return true;
    }

    @Override
    public boolean isOtherSchemasSupported() {
        return true;
    }

    @Override
    public boolean isSchedulerSupported() {
        return true;
    }

    @Override
    public DefaultNLSProvider getNLSProvider(Connection connection) {
        return new OracleNLSProvider(connection);
    }

    @Override
    public Icon getIcon(DBItemInstance dBItemInstance) {
        String string;
        Icon icon = null;
        String string2 = string = dBItemInstance.getDescriptor() != null ? dBItemInstance.getDescriptor().getType() : "";
        if (string.equals("TABLE")) {
            if (OracleConnectionTypeDetails.checkProperty(dBItemInstance, "PARTITIONED", "YES")) {
                icon = RaptorImagesArb.getIcon("PARTITIONED_TABLE");
            } else if (OracleConnectionTypeDetails.checkProperty(dBItemInstance, "GENERATED", "Y")) {
                icon = RaptorImagesArb.getIcon("GENERATED_TABLE");
            } else if (OracleConnectionTypeDetails.checkProperty(dBItemInstance, "IOT_TYPE", null)) {
                icon = RaptorImagesArb.getIcon("IOT");
            } else if (OracleConnectionTypeDetails.checkProperty(dBItemInstance, "EXTERNAL", "Y")) {
                icon = RaptorImagesArb.getIcon("EXTERNAL_TABLE");
            } else if (OracleConnectionTypeDetails.checkProperty(dBItemInstance, "TEMPORARY", "Y")) {
                icon = RaptorImagesArb.getIcon("TEMPORARY_TABLE");
            }
        } else if (string.equals("TRIGGER") && OracleConnectionTypeDetails.checkProperty(dBItemInstance, "STATUS", "DISABLED")) {
            icon = RaptorImagesArb.getIcon("TRIGGER_DISBALED");
        }
        return icon;
    }

    private static boolean checkProperty(DBItemInstance dBItemInstance, String string, String string2) {
        boolean bl = false;
        Object object = dBItemInstance.getProperty(string);
        if (object != null) {
            bl = string2 == null || string2.equals(object);
        }
        return bl;
    }
}

