/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator.db.impl;

import java.net.URL;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.navigator.ObjectFactory;
import oracle.dbtools.raptor.navigator.db.model.ChildType;
import oracle.dbtools.raptor.navigator.db.model.DBChildInstance;
import oracle.dbtools.raptor.navigator.db.model.DBFolderInstance;
import oracle.dbtools.raptor.navigator.db.model.DBObjectInstance;
import oracle.dbtools.raptor.navigator.db.model.DatabaseFolder;
import oracle.dbtools.raptor.navigator.db.model.DatabaseObject;
import oracle.dbtools.raptor.navigator.db.model.FilterChildProvider;
import oracle.dbtools.raptor.navigator.impl.ChildFolder;
import oracle.dbtools.raptor.navigator.impl.DatabaseNavigatorElementFactory;
import oracle.dbtools.raptor.navigator.impl.DatabaseNode;
import oracle.dbtools.raptor.navigator.model.AbortException;
import oracle.dbtools.raptor.navigator.model.AsynchronousNavigatorTreeNode;
import oracle.dbtools.raptor.navigator.model.NavigatorQueryTask;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.ide.model.Element;

public class DatabaseObjectTreeNode
extends AsynchronousNavigatorTreeNode {
    private List<FilterChildProvider> m_providers = new ArrayList<FilterChildProvider>();

    public DatabaseObjectTreeNode() {
        this.setComparator(null);
    }

    @Override
    protected RaptorTask<Collection<Element>> getLoadingTask() {
        DatabaseNode databaseNode = (DatabaseNode)this.getElement();
        return new LoadTask(databaseNode, (String)databaseNode.getProviderIdentifier());
    }

    private class LoadTask
    extends NavigatorQueryTask {
        private DatabaseNode m_dbNode;

        LoadTask(DatabaseNode databaseNode, String string) {
            super("Loading Children", string, true);
            this.m_dbNode = databaseNode;
        }

        @Override
        protected Collection<Element> doWorkImpl() throws TaskException {
            ArrayList<Element> arrayList = new ArrayList<Element>();
            URL uRL = this.m_dbNode.getURL();
            DBObjectInstance dBObjectInstance = this.m_dbNode.getNodeInstance();
            DatabaseObject databaseObject = (DatabaseObject)dBObjectInstance.getDescriptor();
            try {
                try {
                    for (ChildType childType : databaseObject.getChildTypes()) {
                        Object object;
                        Object object2;
                        this.checkCanProceed();
                        List<Object> list = null;
                        Class<? extends FilterChildProvider> clazz = databaseObject.getChildProvider(childType.getChildType());
                        if (clazz != null) {
                            object2 = null;
                            assert (FilterChildProvider.class.isAssignableFrom(clazz));
                            try {
                                object = clazz.newInstance();
                                DatabaseObjectTreeNode.this.m_providers.add(object);
                                object2 = object.listChildren(this.m_dbNode, childType.getChildType());
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            list = this.createChildElements(uRL, childType, (List<? extends DBChildInstance>)object2);
                        } else if (childType.showAsFolder()) {
                            Object object3;
                            object2 = childType.getNodeType();
                            if (object2 != null) {
                                DatabaseFolder databaseFolder;
                                DBFolderInstance dBFolderInstance;
                                DatabaseFolder[] databaseFolderArray;
                                object = dBObjectInstance.getObjectFactory();
                                object3 = ((ObjectFactory)object).getObjectType((String)object2);
                                if (object3 != null && (databaseFolderArray = object3.getFolders()) != null && databaseFolderArray.length > 0 && (dBFolderInstance = ((ObjectFactory)object).createFolderInstance((String)object2, databaseFolder = databaseFolderArray[0])) != null) {
                                    String string2;
                                    for (String string2 : dBObjectInstance.getPropertyKeys()) {
                                        Object object4 = dBObjectInstance.getProperty(string2);
                                        if ("TYPE".equals(string2)) {
                                            string2 = "PARENT_TYPE";
                                        } else if ("NAME".equals(string2)) {
                                            string2 = "PARENT_NAME";
                                        }
                                        dBFolderInstance.setProperty(string2, object4);
                                    }
                                    URL uRL2 = DBURLFormatHelper.getEnclosedTypeURL(uRL, (String)object2);
                                    string2 = DatabaseNavigatorElementFactory.getTypeFolder(uRL2, dBFolderInstance);
                                    list = Collections.singletonList(string2);
                                }
                            } else {
                                object = DBURLFormatHelper.getChildURL(uRL, childType.getChildType(), null);
                                object3 = new HashMap();
                                object3.put("PARENT_NAME", dBObjectInstance.getProperty("NAME"));
                                object3.put("PARENT_TYPE", dBObjectInstance.getProperty("TYPE"));
                                list = Collections.singletonList(new ChildFolder((URL)object, childType, (Map<String, Object>)object3, this.createChildElements(uRL, childType, dBObjectInstance.listChildren(childType.getChildType()))));
                            }
                        } else {
                            list = this.createChildElements(uRL, childType, dBObjectInstance.listChildren(childType.getChildType()));
                        }
                        if (list == null) continue;
                        arrayList.addAll(list);
                    }
                }
                catch (SQLException sQLException) {
                    this.checkCanProceed();
                    ExceptionHandler.handleException((Throwable)sQLException);
                }
            }
            catch (AbortException abortException) {
                arrayList.clear();
            }
            catch (ExecutionException executionException) {
                arrayList.clear();
            }
            return arrayList;
        }

        protected List<Element> createChildElements(URL uRL, ChildType childType, List<? extends DBChildInstance> list) throws ExecutionException {
            if (list == null) {
                return Collections.emptyList();
            }
            ArrayList<Element> arrayList = new ArrayList<Element>();
            for (DBChildInstance dBChildInstance : list) {
                this.checkCanProceed();
                String string = (String)dBChildInstance.getProperty("NAME");
                if (string == null) continue;
                arrayList.add(DatabaseNavigatorElementFactory.createChildElement(uRL, childType.getChildType(), dBChildInstance));
            }
            return arrayList;
        }
    }
}

