/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator.db;

import java.io.IOException;
import java.net.URL;
import oracle.dbtools.raptor.navigator.impl.ViewableElement;
import oracle.ide.model.DefaultElement;
import oracle.ide.model.IdeSubject;
import oracle.ide.model.Observer;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;

public abstract class BaseConnectionNode<T>
extends DefaultElement
implements ViewableElement,
Subject {
    private URL m_url = null;
    private IdeSubject m_subject = new IdeSubject();
    private Object __LOCK__ = new Object();
    private T m_conn = null;

    protected BaseConnectionNode() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final T getConnection() throws IOException {
        Object object = this.getLock();
        synchronized (object) {
            if (this.m_conn == null) {
                this.m_conn = this.openConnectionImpl();
            }
        }
        return this.m_conn;
    }

    protected boolean openConnection() {
        boolean bl = this.isConnectionOpen();
        if (!bl) {
            try {
                this.getConnection();
                bl = true;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reopenConnection(T t) {
        Object object = this.getLock();
        synchronized (object) {
            if (this.m_conn != null) {
                this.m_conn = t;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeConnection() {
        Object object = this.getLock();
        synchronized (object) {
            if (this.m_conn != null) {
                this.closeConnectionImpl();
                this.m_conn = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void forgetConnection() {
        Object object = this.getLock();
        synchronized (object) {
            this.m_conn = null;
        }
    }

    protected final boolean isConnectionSet() {
        return this.m_conn != null;
    }

    protected abstract T openConnectionImpl() throws IOException;

    protected abstract boolean closeConnectionImpl();

    public boolean isConnectionOpen() {
        return this.m_conn != null;
    }

    protected Object getLock() {
        return this.__LOCK__;
    }

    public abstract String getQualifiedConnectionName();

    public boolean mayHaveChildren() {
        return true;
    }

    public final URL getURL() {
        return this.m_url;
    }

    public void setURL(URL uRL) {
        this.m_url = uRL;
    }

    public final void attach(Observer observer) {
        this.m_subject.attach(observer);
    }

    public final void detach(Observer observer) {
        this.m_subject.detach(observer);
    }

    public final void notifyObservers(Object object, UpdateMessage updateMessage) {
        this.m_subject.notifyObservers(object, updateMessage);
    }
}

