/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.ui;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.LongProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleLongProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableNumberValue;
import javafx.scene.control.TableColumn;
import oracle.dbtools.raptor.metrics.MetricsResources;
import oracle.dbtools.raptor.metrics.engine.DXException;
import oracle.dbtools.raptor.metrics.engine.DXIds;
import oracle.dbtools.raptor.metrics.listener.DXJob;
import oracle.dbtools.raptor.metrics.listener.DXSource;
import oracle.dbtools.raptor.metrics.listener.DXSourceUpdate;
import oracle.dbtools.raptor.metrics.ui.CacheElement;
import oracle.dbtools.raptor.metrics.ui.CacheElementLookup;
import oracle.dbtools.raptor.metrics.ui.JobElement;

class SourceElement
extends CacheElement {
    private final StringProperty pathProperty;
    private final BooleanProperty connectedProperty;
    private final LongProperty minimumIntervalProperty;
    private final StringProperty lastConnectionAttemptExceptionProperty;

    SourceElement(CacheElementLookup cacheElementLookup, URI uRI, DXSource dXSource) {
        super(cacheElementLookup, uRI);
        Map<URI, DXJob> map = dXSource.getJobs();
        for (URI uRI2 : map.keySet()) {
            DXJob dXJob = map.get(uRI2);
            this.addChildElement(new JobElement(cacheElementLookup, uRI2, dXJob));
        }
        this.sortChildren();
        this.pathProperty = new SimpleStringProperty(DXIds.getPath(uRI));
        this.connectedProperty = new SimpleBooleanProperty(dXSource.isConnected());
        this.minimumIntervalProperty = new SimpleLongProperty(dXSource.getMinimumInterval());
        this.lastConnectionAttemptExceptionProperty = new SimpleStringProperty("");
    }

    void update(DXSourceUpdate dXSourceUpdate) {
        this.connectedProperty.set(dXSourceUpdate.isConnected());
        this.minimumIntervalProperty.set(dXSourceUpdate.getMinimumInterval());
    }

    void setSourceDisconnectArgs(DXException dXException) {
        this.lastConnectionAttemptExceptionProperty.set((Object)(dXException != null ? dXException.getLocalizedMessage() : ""));
    }

    StringProperty pathProperty() {
        return this.pathProperty;
    }

    BooleanProperty connectedProperty() {
        return this.connectedProperty;
    }

    LongProperty minimumIntervalProperty() {
        return this.minimumIntervalProperty;
    }

    StringProperty lastConnectionAttemptExceptionProperty() {
        return this.lastConnectionAttemptExceptionProperty;
    }

    @Override
    List<TableColumn<? extends CacheElement, String>> getTableColumns() {
        ArrayList<TableColumn<? extends CacheElement, String>> arrayList = new ArrayList<TableColumn<? extends CacheElement, String>>();
        arrayList.add(this.createTableLeadColumn(MetricsResources.get("METRICS_UI_JOB_PATH"), cellDataFeatures -> ((JobElement)cellDataFeatures.getValue()).pathProperty()));
        arrayList.add(this.createTableColumn(MetricsResources.get("METRICS_UI_DISABLED"), cellDataFeatures -> ((JobElement)cellDataFeatures.getValue()).disabledProperty().asString()));
        arrayList.add(this.createTableColumn(MetricsResources.get("METRICS_UI_PINNED"), cellDataFeatures -> ((JobElement)cellDataFeatures.getValue()).pinnedProperty().asString()));
        arrayList.add(this.createTableColumn(MetricsResources.get("METRICS_UI_RUNNING"), cellDataFeatures -> ((JobElement)cellDataFeatures.getValue()).runningProperty().asString()));
        arrayList.add(this.createTableColumn(MetricsResources.get("METRICS_UI_INTERVAL"), cellDataFeatures -> ((JobElement)cellDataFeatures.getValue()).minimumIntervalProperty().asString()));
        arrayList.add(this.createTableColumn(MetricsResources.get("METRICS_UI_RUN_ELAPSED_TIME"), cellDataFeatures -> Bindings.divide((ObservableNumberValue)((JobElement)cellDataFeatures.getValue()).lastRunElapsedTimeProperty(), (int)1000).asString()));
        arrayList.add(this.createTableColumn(MetricsResources.get("METRICS_UI_RUN_CPU_TIME"), cellDataFeatures -> Bindings.divide((ObservableNumberValue)((JobElement)cellDataFeatures.getValue()).lastRunCPUTimeProperty(), (int)1000).asString()));
        arrayList.add(this.createTableColumn(MetricsResources.get("METRICS_UI_RUN_EXCEPTION"), cellDataFeatures -> ((JobElement)cellDataFeatures.getValue()).lastRunExceptionProperty()));
        return arrayList;
    }

    @Override
    String getIconPath() {
        return "/oracle/dbtools/raptor/images/package.png";
    }

    public String toString() {
        return (String)this.pathProperty.get();
    }
}

