/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.ui;

import java.util.List;
import javafx.collections.ObservableList;
import javafx.event.EventType;
import javafx.scene.Node;
import javafx.scene.control.SplitPane;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.layout.Pane;
import oracle.dbtools.raptor.metrics.engine.DXChannel;
import oracle.dbtools.raptor.metrics.ui.CacheElement;
import oracle.dbtools.raptor.metrics.ui.MonitorCache;

public class MonitorPane
extends SplitPane {
    private final MonitorCache cache;
    private final TreeView<CacheElement> tree = new TreeView();
    private TreeItem<CacheElement> selectedTreeItem;
    private final TableView<CacheElement> detailView;
    private final Pane emptyDetailView;

    public MonitorPane(DXChannel dXChannel) {
        TreeItem treeItem3 = new TreeItem(null);
        this.tree.setRoot(treeItem3);
        this.tree.setShowRoot(false);
        this.tree.getSelectionModel().selectedItemProperty().addListener((observableValue, treeItem, treeItem2) -> this.onSelectItem((TreeItem<CacheElement>)treeItem2));
        EventType eventType = TreeItem.childrenModificationEvent();
        treeItem3.addEventHandler(eventType, treeModificationEvent -> {
            if (treeModificationEvent.wasRemoved()) {
                for (TreeItem treeItem : treeModificationEvent.getRemovedChildren()) {
                    if (treeItem != this.selectedTreeItem) continue;
                    this.onSelectItem(null);
                    break;
                }
            }
        });
        this.emptyDetailView = new Pane();
        this.detailView = new TableView();
        this.setDividerPositions(new double[]{0.2});
        this.getItems().addAll((Object[])new Node[]{this.tree, this.emptyDetailView});
        this.cache = new MonitorCache((TreeItem<CacheElement>)treeItem3, dXChannel);
    }

    private void onSelectItem(TreeItem<CacheElement> treeItem) {
        this.selectedTreeItem = treeItem;
        CacheElement cacheElement = null;
        ObservableList<CacheElement> observableList = null;
        if (this.selectedTreeItem != null) {
            cacheElement = (CacheElement)this.selectedTreeItem.getValue();
            observableList = cacheElement.getTableRows();
        }
        if (observableList != null) {
            this.detailView.setItems(cacheElement.getTableRows());
            this.detailView.getColumns().clear();
            List<TableColumn<? extends CacheElement, String>> list = cacheElement.getTableColumns();
            this.detailView.getColumns().addAll(list);
            this.getItems().set(1, this.detailView);
            this.detailView.getSortOrder().clear();
            this.detailView.getSortOrder().add(0, list.get(0));
        } else {
            this.getItems().set(1, (Object)this.emptyDetailView);
        }
    }
}

