/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.ui;

import java.net.URI;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.scene.control.TreeItem;
import oracle.dbtools.raptor.metrics.engine.DXChannel;
import oracle.dbtools.raptor.metrics.engine.DXException;
import oracle.dbtools.raptor.metrics.engine.DXIds;
import oracle.dbtools.raptor.metrics.listener.DXEngineBind;
import oracle.dbtools.raptor.metrics.listener.DXEngineListener;
import oracle.dbtools.raptor.metrics.listener.DXError;
import oracle.dbtools.raptor.metrics.listener.DXItemUpdate;
import oracle.dbtools.raptor.metrics.listener.DXJobType;
import oracle.dbtools.raptor.metrics.listener.DXJobTypeUpdate;
import oracle.dbtools.raptor.metrics.listener.DXJobUpdate;
import oracle.dbtools.raptor.metrics.listener.DXSource;
import oracle.dbtools.raptor.metrics.listener.DXSourceAdd;
import oracle.dbtools.raptor.metrics.listener.DXSourceType;
import oracle.dbtools.raptor.metrics.listener.DXSourceTypeAdd;
import oracle.dbtools.raptor.metrics.listener.DXSourceTypeMerge;
import oracle.dbtools.raptor.metrics.listener.DXSourceTypeUpdate;
import oracle.dbtools.raptor.metrics.listener.DXSourceUpdate;
import oracle.dbtools.raptor.metrics.listener.DXUnbind;
import oracle.dbtools.raptor.metrics.ui.CacheElement;
import oracle.dbtools.raptor.metrics.ui.CacheElementLookup;
import oracle.dbtools.raptor.metrics.ui.ConnectionElement;
import oracle.dbtools.raptor.metrics.ui.ConnectionTypeElement;
import oracle.dbtools.raptor.metrics.ui.ItemElement;
import oracle.dbtools.raptor.metrics.ui.JobElement;
import oracle.dbtools.raptor.metrics.ui.JobTypeElement;
import oracle.dbtools.raptor.metrics.ui.SourceElement;
import oracle.dbtools.raptor.metrics.ui.SourceTypeElement;

class MonitorCache {
    private final TreeItem rootTreeItem;
    private final CacheElementLookup lookup;

    MonitorCache(TreeItem<CacheElement> treeItem, DXChannel dXChannel) {
        this.rootTreeItem = treeItem;
        this.lookup = new CacheElementLookup();
        dXChannel.addEngineListener(this.createEngineListener());
    }

    private void onEngineBind(DXEngineBind dXEngineBind) {
        Map<URI, DXSourceType> map = dXEngineBind.getSourceTypes();
        for (URI object : map.keySet()) {
            this.onSourceTypeAdd(object, map.get(object));
        }
        Map<URI, DXSource> map2 = dXEngineBind.getSources();
        for (URI uRI : map2.keySet()) {
            this.onSourceAdd(uRI, (DXSource)map2.get(uRI));
        }
    }

    private void onSourceTypeAdd(DXSourceTypeAdd dXSourceTypeAdd) {
        this.onSourceTypeAdd(dXSourceTypeAdd.getId(), dXSourceTypeAdd.getSourceType());
    }

    private void onSourceTypeMerge(DXSourceTypeMerge dXSourceTypeMerge) {
        this.onSourceTypeMerge(dXSourceTypeMerge.getId(), dXSourceTypeMerge.getJobTypes());
    }

    private void onSourceAdd(DXSourceAdd dXSourceAdd) {
        this.onSourceAdd(dXSourceAdd.getId(), dXSourceAdd.getSource());
    }

    private void onSourceTypeAdd(URI uRI, DXSourceType dXSourceType) {
        ConnectionTypeElement connectionTypeElement = this.lookup.findConnectionType(DXIds.getConnectionTypeId(uRI));
        if (connectionTypeElement == null) {
            connectionTypeElement = new ConnectionTypeElement(this.lookup, DXIds.getConnectionTypeId(uRI));
            this.rootTreeItem.getChildren().add(connectionTypeElement.getTreeItem());
            this.lookup.addElement(connectionTypeElement);
        }
        connectionTypeElement.addSourceType(uRI, dXSourceType);
    }

    private void onSourceTypeMerge(URI uRI, Map<URI, DXJobType> map) {
        SourceTypeElement sourceTypeElement = this.lookup.findSourceType(DXIds.getConnectionTypeId(uRI));
        sourceTypeElement.mergeJobTypes(this.lookup, map);
    }

    private void onSourceAdd(URI uRI, DXSource dXSource) {
        URI uRI2 = DXIds.getConnectionId(uRI);
        ConnectionElement connectionElement = this.lookup.findConnection(DXIds.getConnectionId(uRI));
        if (connectionElement == null) {
            ConnectionTypeElement connectionTypeElement = this.lookup.findConnectionType(DXIds.getConnectionTypeId(uRI2));
            connectionTypeElement.addConnection(uRI2, dXSource.getConnectionDisplayName());
            connectionElement = this.lookup.findConnection(DXIds.getConnectionId(uRI));
        }
        connectionElement.addSource(uRI, dXSource);
    }

    private void onSourceTypeDefaultMinimumIntervalChange(DXSourceTypeUpdate dXSourceTypeUpdate) {
        SourceTypeElement sourceTypeElement = this.lookup.findSourceType(dXSourceTypeUpdate.getId());
        sourceTypeElement.update(dXSourceTypeUpdate);
    }

    private void onJobTypeDefaultMinimumIntervalChange(DXJobTypeUpdate dXJobTypeUpdate) {
        JobTypeElement jobTypeElement = this.lookup.findJobType(dXJobTypeUpdate.getId());
        jobTypeElement.update(dXJobTypeUpdate);
    }

    private void onJobTypeDefaultEnable(DXJobTypeUpdate dXJobTypeUpdate) {
        JobTypeElement jobTypeElement = this.lookup.findJobType(dXJobTypeUpdate.getId());
        jobTypeElement.update(dXJobTypeUpdate);
    }

    private void onJobTypeDefaultDisable(DXJobTypeUpdate dXJobTypeUpdate) {
        JobTypeElement jobTypeElement = this.lookup.findJobType(dXJobTypeUpdate.getId());
        jobTypeElement.update(dXJobTypeUpdate);
    }

    private void onSourceMinimumIntervalChange(DXSourceUpdate dXSourceUpdate) {
        SourceElement sourceElement = this.lookup.findSource(dXSourceUpdate.getId());
        sourceElement.update(dXSourceUpdate);
    }

    private void onJobMinimumIntervalChange(DXJobUpdate dXJobUpdate) {
        JobElement jobElement = this.lookup.findJob(dXJobUpdate.getId());
        jobElement.update(dXJobUpdate);
    }

    private void onSourceConnect(DXSourceUpdate dXSourceUpdate) {
        SourceElement sourceElement = this.lookup.findSource(dXSourceUpdate.getId());
        sourceElement.update(dXSourceUpdate);
    }

    private void onSourceDisconnect(DXSourceUpdate dXSourceUpdate, DXException dXException) {
        SourceElement sourceElement = this.lookup.findSource(dXSourceUpdate.getId());
        sourceElement.update(dXSourceUpdate);
        sourceElement.setSourceDisconnectArgs(dXException);
    }

    private void onSourceRemove(DXSourceUpdate dXSourceUpdate) {
        URI uRI = dXSourceUpdate.getId();
        URI uRI2 = DXIds.getConnectionId(uRI);
        ConnectionElement connectionElement = this.lookup.findConnection(uRI2);
        connectionElement.removeChildElement(this.lookup.findSource(uRI));
        if (connectionElement.getTableRows().size() == 0) {
            ConnectionTypeElement connectionTypeElement = this.lookup.findConnectionType(DXIds.getConnectionTypeId(uRI2));
            connectionTypeElement.removeChildElement(connectionElement);
        }
    }

    private void onJobPin(DXJobUpdate dXJobUpdate) {
        JobElement jobElement = this.lookup.findJob(dXJobUpdate.getId());
        jobElement.update(dXJobUpdate);
    }

    private void onJobUnpin(DXJobUpdate dXJobUpdate) {
        JobElement jobElement = this.lookup.findJob(dXJobUpdate.getId());
        jobElement.update(dXJobUpdate);
    }

    private void onJobEnable(DXJobUpdate dXJobUpdate) {
        JobElement jobElement = this.lookup.findJob(dXJobUpdate.getId());
        jobElement.update(dXJobUpdate);
    }

    private void onJobDisable(DXJobUpdate dXJobUpdate) {
        JobElement jobElement = this.lookup.findJob(dXJobUpdate.getId());
        jobElement.update(dXJobUpdate);
    }

    private void onJobRunStart(DXJobUpdate dXJobUpdate) {
        JobElement jobElement = this.lookup.findJob(dXJobUpdate.getId());
        jobElement.update(dXJobUpdate);
    }

    private void onJobRunFinish(DXJobUpdate dXJobUpdate, long l, long l2, DXException dXException) {
        JobElement jobElement = this.lookup.findJob(dXJobUpdate.getId());
        jobElement.update(dXJobUpdate);
        jobElement.setJobRunFinishArgs(l, l2, dXException);
    }

    private void onItemPin(DXItemUpdate dXItemUpdate) {
        ItemElement itemElement = this.lookup.findItem(dXItemUpdate.getId());
        itemElement.update(dXItemUpdate);
    }

    private void onItemUnpin(DXItemUpdate dXItemUpdate) {
        ItemElement itemElement = this.lookup.findItem(dXItemUpdate.getId());
        itemElement.update(dXItemUpdate);
    }

    private void onEngineBindError(DXError dXError) {
        Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "error binding engine listener", dXError.getException());
    }

    private DXEngineListener createEngineListener() {
        return new DXEngineListener(){

            @Override
            public void onBind(DXEngineBind dXEngineBind) {
                Platform.runLater(() -> MonitorCache.this.onEngineBind(dXEngineBind));
            }

            @Override
            public void onAdd(DXSourceTypeAdd dXSourceTypeAdd) {
                Platform.runLater(() -> MonitorCache.this.onSourceTypeAdd(dXSourceTypeAdd));
            }

            @Override
            public void onMerge(DXSourceTypeMerge dXSourceTypeMerge) {
                Platform.runLater(() -> MonitorCache.this.onSourceTypeMerge(dXSourceTypeMerge));
            }

            @Override
            public void onAdd(DXSourceAdd dXSourceAdd) {
                Platform.runLater(() -> MonitorCache.this.onSourceAdd(dXSourceAdd));
            }

            @Override
            public void onDefaultMinimumIntervalChange(DXSourceTypeUpdate dXSourceTypeUpdate) {
                Platform.runLater(() -> MonitorCache.this.onSourceTypeDefaultMinimumIntervalChange(dXSourceTypeUpdate));
            }

            @Override
            public void onDefaultMinimumIntervalChange(DXJobTypeUpdate dXJobTypeUpdate) {
                Platform.runLater(() -> MonitorCache.this.onJobTypeDefaultMinimumIntervalChange(dXJobTypeUpdate));
            }

            @Override
            public void onDefaultEnable(DXJobTypeUpdate dXJobTypeUpdate) {
                Platform.runLater(() -> MonitorCache.this.onJobTypeDefaultEnable(dXJobTypeUpdate));
            }

            @Override
            public void onDefaultDisable(DXJobTypeUpdate dXJobTypeUpdate) {
                Platform.runLater(() -> MonitorCache.this.onJobTypeDefaultDisable(dXJobTypeUpdate));
            }

            @Override
            public void onMinimumIntervalChange(DXSourceUpdate dXSourceUpdate) {
                Platform.runLater(() -> MonitorCache.this.onSourceMinimumIntervalChange(dXSourceUpdate));
            }

            @Override
            public void onMinimumIntervalChange(DXJobUpdate dXJobUpdate) {
                Platform.runLater(() -> MonitorCache.this.onJobMinimumIntervalChange(dXJobUpdate));
            }

            @Override
            public void onConnect(DXSourceUpdate dXSourceUpdate) {
                Platform.runLater(() -> MonitorCache.this.onSourceConnect(dXSourceUpdate));
            }

            @Override
            public void onDisconnect(DXSourceUpdate dXSourceUpdate, DXException dXException) {
                Platform.runLater(() -> MonitorCache.this.onSourceDisconnect(dXSourceUpdate, dXException));
            }

            @Override
            public void onRemove(DXSourceUpdate dXSourceUpdate) {
                Platform.runLater(() -> MonitorCache.this.onSourceRemove(dXSourceUpdate));
            }

            @Override
            public void onPin(DXJobUpdate dXJobUpdate) {
                Platform.runLater(() -> MonitorCache.this.onJobPin(dXJobUpdate));
            }

            @Override
            public void onUnpin(DXJobUpdate dXJobUpdate) {
                Platform.runLater(() -> MonitorCache.this.onJobUnpin(dXJobUpdate));
            }

            @Override
            public void onEnable(DXJobUpdate dXJobUpdate) {
                Platform.runLater(() -> MonitorCache.this.onJobEnable(dXJobUpdate));
            }

            @Override
            public void onDisable(DXJobUpdate dXJobUpdate) {
                Platform.runLater(() -> MonitorCache.this.onJobDisable(dXJobUpdate));
            }

            @Override
            public void onRunStart(DXJobUpdate dXJobUpdate) {
                Platform.runLater(() -> MonitorCache.this.onJobRunStart(dXJobUpdate));
            }

            @Override
            public void onRunFinish(DXJobUpdate dXJobUpdate, long l, long l2, DXException dXException) {
                Platform.runLater(() -> MonitorCache.this.onJobRunFinish(dXJobUpdate, l, l2, dXException));
            }

            @Override
            public void onBindError(DXError dXError) {
                Platform.runLater(() -> MonitorCache.this.onEngineBindError(dXError));
            }

            @Override
            public void onPin(DXItemUpdate dXItemUpdate) {
                Platform.runLater(() -> MonitorCache.this.onItemPin(dXItemUpdate));
            }

            @Override
            public void onUnpin(DXItemUpdate dXItemUpdate) {
                Platform.runLater(() -> MonitorCache.this.onItemUnpin(dXItemUpdate));
            }

            @Override
            public void onUnbind(DXUnbind dXUnbind) {
            }
        };
    }
}

