/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.ui;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.LongProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleLongProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.scene.control.TableColumn;
import oracle.dbtools.raptor.metrics.MetricsResources;
import oracle.dbtools.raptor.metrics.engine.DXIds;
import oracle.dbtools.raptor.metrics.listener.DXItemType;
import oracle.dbtools.raptor.metrics.listener.DXJobType;
import oracle.dbtools.raptor.metrics.listener.DXJobTypeUpdate;
import oracle.dbtools.raptor.metrics.ui.CacheElement;
import oracle.dbtools.raptor.metrics.ui.CacheElementLookup;
import oracle.dbtools.raptor.metrics.ui.ItemTypeElement;

class JobTypeElement
extends CacheElement {
    private final StringProperty pathProperty;
    private final LongProperty defaultMinimumIntervalProperty;
    private final BooleanProperty defaultDisabledProperty;

    JobTypeElement(CacheElementLookup cacheElementLookup, URI uRI, DXJobType dXJobType) {
        super(cacheElementLookup, uRI);
        Map<URI, DXItemType> map = dXJobType.getItemTypes();
        for (URI uRI2 : map.keySet()) {
            DXItemType dXItemType = map.get(uRI2);
            this.addChildElement(new ItemTypeElement(cacheElementLookup, uRI2, dXItemType));
        }
        this.sortChildren();
        this.pathProperty = new SimpleStringProperty(DXIds.getPath(uRI));
        this.defaultMinimumIntervalProperty = new SimpleLongProperty(dXJobType.getDefaultMinimumInterval());
        this.defaultDisabledProperty = new SimpleBooleanProperty(dXJobType.isDefaultDisabled());
    }

    void update(DXJobTypeUpdate dXJobTypeUpdate) {
        this.defaultMinimumIntervalProperty.set(dXJobTypeUpdate.getDefaultMinimumInterval());
        this.defaultDisabledProperty.set(dXJobTypeUpdate.isDefaultDisabled());
    }

    StringProperty pathProperty() {
        return this.pathProperty;
    }

    LongProperty defaultMinimumIntervalProperty() {
        return this.defaultMinimumIntervalProperty;
    }

    BooleanProperty defaultDisabledProperty() {
        return this.defaultDisabledProperty;
    }

    @Override
    List<TableColumn<? extends CacheElement, String>> getTableColumns() {
        ArrayList<TableColumn<? extends CacheElement, String>> arrayList = new ArrayList<TableColumn<? extends CacheElement, String>>();
        arrayList.add(this.createTableLeadColumn(MetricsResources.get("METRICS_UI_ITEM_TYPE_PATH"), cellDataFeatures -> ((ItemTypeElement)cellDataFeatures.getValue()).pathProperty()));
        arrayList.add(this.createTableColumn(MetricsResources.get("METRICS_UI_CHANGE_CLASS"), cellDataFeatures -> ((ItemTypeElement)cellDataFeatures.getValue()).changeClassProperty()));
        return arrayList;
    }

    @Override
    String getIconPath() {
        return "/oracle/dbtools/raptor/images/jobsfolder.png";
    }

    public String toString() {
        return (String)this.pathProperty.get();
    }
}

