/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.ui;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.LongProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleLongProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.scene.control.TableColumn;
import oracle.dbtools.raptor.metrics.MetricsResources;
import oracle.dbtools.raptor.metrics.engine.DXException;
import oracle.dbtools.raptor.metrics.engine.DXIds;
import oracle.dbtools.raptor.metrics.listener.DXItem;
import oracle.dbtools.raptor.metrics.listener.DXJob;
import oracle.dbtools.raptor.metrics.listener.DXJobUpdate;
import oracle.dbtools.raptor.metrics.ui.CacheElement;
import oracle.dbtools.raptor.metrics.ui.CacheElementLookup;
import oracle.dbtools.raptor.metrics.ui.ItemElement;

class JobElement
extends CacheElement {
    private final StringProperty pathProperty;
    private final BooleanProperty disabledProperty;
    private final BooleanProperty pinnedProperty;
    private final BooleanProperty runningProperty;
    private final LongProperty minimumIntervalProperty;
    private final DoubleProperty lastRunElapsedTimeProperty;
    private final DoubleProperty lastRunCPUTimeProperty;
    private final StringProperty lastRunExceptionProperty;

    JobElement(CacheElementLookup cacheElementLookup, URI uRI, DXJob dXJob) {
        super(cacheElementLookup, uRI);
        Map<URI, DXItem> map = dXJob.getItems();
        for (URI uRI2 : map.keySet()) {
            DXItem dXItem = map.get(uRI2);
            this.addChildElement(new ItemElement(cacheElementLookup, uRI2, dXItem));
        }
        this.sortChildren();
        this.pathProperty = new SimpleStringProperty(DXIds.getPath(uRI));
        this.disabledProperty = new SimpleBooleanProperty(dXJob.isDisabled());
        this.pinnedProperty = new SimpleBooleanProperty(dXJob.isPinned());
        this.runningProperty = new SimpleBooleanProperty(dXJob.isRunning());
        this.minimumIntervalProperty = new SimpleLongProperty(dXJob.getMinimumInterval());
        this.lastRunElapsedTimeProperty = new SimpleDoubleProperty(-1000.0);
        this.lastRunCPUTimeProperty = new SimpleDoubleProperty(-1000.0);
        this.lastRunExceptionProperty = new SimpleStringProperty("");
    }

    void update(DXJobUpdate dXJobUpdate) {
        this.disabledProperty.set(dXJobUpdate.isDisabled());
        this.pinnedProperty.set(dXJobUpdate.isPinned());
        this.runningProperty.set(dXJobUpdate.isRunning());
        this.minimumIntervalProperty.set(dXJobUpdate.getMinimumInterval());
    }

    void setJobRunFinishArgs(long l, long l2, DXException dXException) {
        this.lastRunElapsedTimeProperty.set((double)l);
        this.lastRunCPUTimeProperty.set((double)l2);
        this.lastRunExceptionProperty.set((Object)(dXException != null ? dXException.getLocalizedMessage() : ""));
    }

    StringProperty pathProperty() {
        return this.pathProperty;
    }

    BooleanProperty disabledProperty() {
        return this.disabledProperty;
    }

    BooleanProperty pinnedProperty() {
        return this.pinnedProperty;
    }

    BooleanProperty runningProperty() {
        return this.runningProperty;
    }

    LongProperty minimumIntervalProperty() {
        return this.minimumIntervalProperty;
    }

    DoubleProperty lastRunElapsedTimeProperty() {
        return this.lastRunElapsedTimeProperty;
    }

    DoubleProperty lastRunCPUTimeProperty() {
        return this.lastRunCPUTimeProperty;
    }

    StringProperty lastRunExceptionProperty() {
        return this.lastRunExceptionProperty;
    }

    @Override
    List<TableColumn<? extends CacheElement, String>> getTableColumns() {
        ArrayList<TableColumn<? extends CacheElement, String>> arrayList = new ArrayList<TableColumn<? extends CacheElement, String>>();
        arrayList.add(this.createTableLeadColumn(MetricsResources.get("METRICS_UI_ITEM_PATH"), cellDataFeatures -> ((ItemElement)cellDataFeatures.getValue()).pathProperty()));
        arrayList.add(this.createTableColumn(MetricsResources.get("METRICS_UI_PINNED"), cellDataFeatures -> ((ItemElement)cellDataFeatures.getValue()).pinnedProperty().asString()));
        return arrayList;
    }

    @Override
    String getIconPath() {
        return "/oracle/dbtools/raptor/images/job.png";
    }

    public String toString() {
        return (String)this.pathProperty.get();
    }
}

