/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.sqlsource;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import oracle.dbtools.raptor.metrics.engine.Source;
import oracle.dbtools.raptor.metrics.engine.SourceType;
import oracle.dbtools.raptor.metrics.engine.XMLHelper;
import oracle.dbtools.raptor.metrics.sqlsource.SQLJobType;
import oracle.dbtools.raptor.metrics.sqlsource.SQLSource;
import oracle.xml.parser.v2.XMLElement;

public class SQLSourceType
extends SourceType {
    private final Map<String, SQLJobType> jobTypeMap = new HashMap<String, SQLJobType>();

    public SQLSourceType() {
        super(60000L);
    }

    @Override
    public String getConnectionTypeName() {
        return "sql";
    }

    protected Map<String, SQLJobType> jobTypeMap() {
        return this.jobTypeMap;
    }

    @Override
    protected void mergeJobTypes(SourceType sourceType) {
        SQLSourceType sQLSourceType = (SQLSourceType)sourceType;
        this.jobTypeMap.putAll(sQLSourceType.jobTypeMap);
    }

    @Override
    protected void load(XMLHelper xMLHelper, XMLElement xMLElement) {
        super.load(xMLHelper, xMLElement);
        for (XMLElement xMLElement2 : xMLHelper.getChildElements(xMLElement)) {
            SQLJobType sQLJobType = xMLHelper.instantiateTypeObject(SQLJobType.class, xMLElement2.getTagName());
            if (sQLJobType == null) {
                logger.log(Level.SEVERE, "unrecognised job type element encounted for resource ''{0}''", xMLHelper.getResourcePath());
                continue;
            }
            sQLJobType.load(this, xMLHelper, xMLElement2);
            this.jobTypeMap.put(sQLJobType.getJobPath(), sQLJobType);
        }
    }

    @Override
    protected Source createSource(String string) {
        SQLSource sQLSource = new SQLSource(this, string);
        return sQLSource;
    }
}

